/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.modifier.ComponentModifier;
import org.kuali.rice.krad.uif.util.CloneUtils;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;

@BeanTag(name="componentBase-bean", parent="Uif-ComponentBase")
public abstract class ComponentBase
extends UifDictionaryBeanBase
implements Component {
    private static final long serialVersionUID = -4449335748129894350L;
    private String id;
    private String baseId;
    private String template;
    private String templateName;
    private String title;
    private boolean render = true;
    private boolean retrieveViaAjax;
    @KeepExpression
    private String progressiveRender;
    private boolean progressiveRenderViaAJAX = false;
    private boolean progressiveRenderAndRefresh = false;
    private List<String> progressiveDisclosureControlNames;
    private String progressiveDisclosureConditionJs;
    @KeepExpression
    private String conditionalRefresh;
    private String conditionalRefreshConditionJs;
    private List<String> conditionalRefreshControlNames;
    private List<String> refreshWhenChangedPropertyNames;
    private List<String> additionalComponentsToRefresh;
    private String additionalComponentsToRefreshJs;
    private boolean refreshedByAction = false;
    private boolean disclosedByAction;
    private int refreshTimer;
    private boolean resetDataOnRefresh = false;
    private String methodToCallOnRefresh;
    private boolean hidden;
    private boolean readOnly;
    private Boolean required;
    private String align;
    private String valign;
    private String width;
    private int colSpan = 1;
    private int rowSpan = 1;
    private List<String> cellCssClasses;
    private String cellStyle;
    private String cellWidth;
    private String style;
    private List<String> libraryCssClasses;
    private List<String> cssClasses;
    private List<String> additionalCssClasses;
    private Tooltip toolTip;
    private int order = 0;
    private boolean skipInTabOrder;
    private String finalizeMethodToCall;
    private List<Object> finalizeMethodAdditionalArguments;
    private MethodInvokerConfig finalizeMethodInvoker;
    private boolean selfRendered = false;
    private String renderedHtmlOutput;
    private boolean disableSessionPersistence = false;
    private boolean forceSessionPersistence = false;
    private ComponentSecurity componentSecurity = ObjectUtils.newInstance(this.getComponentSecurityClass());
    private String onLoadScript;
    private String onUnloadScript;
    private String onCloseScript;
    private String onBlurScript;
    private String onChangeScript;
    private String onClickScript;
    private String onDblClickScript;
    private String onFocusScript;
    private String onSubmitScript;
    private String onKeyPressScript;
    private String onKeyUpScript;
    private String onKeyDownScript;
    private String onMouseOverScript;
    private String onMouseOutScript;
    private String onMouseUpScript;
    private String onMouseDownScript;
    private String onMouseMoveScript;
    private String onDocumentReadyScript;
    private List<ComponentModifier> componentModifiers;
    private Map<String, String> templateOptions;
    private String templateOptionsJSString;
    @ReferenceCopy(newCollectionInstance=true)
    private transient Map<String, Object> context = Collections.emptyMap();
    @ReferenceCopy
    private transient Map<String, Object> unmodifiableContext = this.context;
    private List<PropertyReplacer> propertyReplacers;
    private Map<String, String> dataAttributes;
    private String preRenderContent;
    private String postRenderContent;

    @Override
    public void performInitialization(View view, Object model) {
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        if (this.render && StringUtils.isNotEmpty((String)this.progressiveRender)) {
            ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
            String adjustedProgressiveRender = expressionEvaluator.replaceBindingPrefixes(view, this, this.progressiveRender);
            Boolean progRenderEval = (Boolean)expressionEvaluator.evaluateExpression(this.unmodifiableContext, adjustedProgressiveRender);
            this.setRender(progRenderEval);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        if (StringUtils.isNotEmpty((String)this.progressiveRender)) {
            this.progressiveRender = expressionEvaluator.replaceBindingPrefixes(view, this, this.progressiveRender);
            this.progressiveDisclosureControlNames = new ArrayList<String>();
            this.progressiveDisclosureConditionJs = ExpressionUtils.parseExpression(this.progressiveRender, this.progressiveDisclosureControlNames);
        }
        if (StringUtils.isNotEmpty((String)this.conditionalRefresh)) {
            this.conditionalRefresh = expressionEvaluator.replaceBindingPrefixes(view, this, this.conditionalRefresh);
            this.conditionalRefreshControlNames = new ArrayList<String>();
            this.conditionalRefreshConditionJs = ExpressionUtils.parseExpression(this.conditionalRefresh, this.conditionalRefreshControlNames);
        }
        if (this.refreshWhenChangedPropertyNames != null) {
            ArrayList<String> adjustedRefreshPropertyNames = new ArrayList<String>(this.refreshWhenChangedPropertyNames.size());
            for (String refreshPropertyName : this.refreshWhenChangedPropertyNames) {
                adjustedRefreshPropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, refreshPropertyName));
            }
            this.refreshWhenChangedPropertyNames = adjustedRefreshPropertyNames;
        }
        if (this.retrieveViaAjax) {
            this.forceSessionPersistence = true;
        }
        if (StringUtils.isNotBlank((String)this.getAlign()) && !StringUtils.contains((String)this.getStyle(), (String)"text-align: ")) {
            this.appendToStyle("text-align: " + this.getAlign() + ";");
        }
        if (StringUtils.isNotBlank((String)this.getValign()) && !StringUtils.contains((String)this.getStyle(), (String)"vertical-align: ")) {
            this.appendToStyle("vertical-align: " + this.getValign() + ";");
        }
        if (StringUtils.isNotBlank((String)this.getWidth()) && !StringUtils.contains((String)this.getStyle(), (String)"width: ")) {
            this.appendToStyle("width: " + this.getWidth() + ";");
        }
        if (this.skipInTabOrder) {
            for (Component component : this.getComponentsForLifecycle()) {
                if (component == null || !(component instanceof ComponentBase)) continue;
                ((ComponentBase)component).setSkipInTabOrder(this.skipInTabOrder);
                if (!(component instanceof ControlBase)) continue;
                ((ControlBase)component).setTabIndex(-1);
            }
        }
        boolean hide = false;
        if (!this.render && !this.progressiveRenderViaAJAX && !this.progressiveRenderAndRefresh && StringUtils.isNotBlank((String)this.progressiveRender)) {
            hide = true;
        } else if (this.isHidden()) {
            hide = true;
        }
        if (hide) {
            if (StringUtils.isNotBlank((String)this.getStyle())) {
                if (this.getStyle().endsWith(";")) {
                    this.setStyle(this.getStyle() + " display: none;");
                } else {
                    this.setStyle(this.getStyle() + "; display: none;");
                }
            } else {
                this.setStyle("display: none;");
            }
        }
        if (this.refreshTimer > 0) {
            String timerScript = this.getOnDocumentReadyScript();
            if (StringUtils.isBlank((String)this.methodToCallOnRefresh)) {
                this.methodToCallOnRefresh = "refresh";
            }
            timerScript = null == timerScript ? "" : timerScript;
            timerScript = "refreshComponentUsingTimer('" + this.id + "','" + this.methodToCallOnRefresh + "'," + this.refreshTimer + ");" + timerScript;
            this.setOnDocumentReadyScript(timerScript);
        }
        ArrayList<String> finalCssClasses = new ArrayList<String>();
        if (this.libraryCssClasses != null && view.isUseLibraryCssClasses()) {
            finalCssClasses.addAll(this.libraryCssClasses);
        }
        if (this.cssClasses != null) {
            finalCssClasses.addAll(this.cssClasses);
        }
        if (this.additionalCssClasses != null) {
            finalCssClasses.addAll(this.additionalCssClasses);
        }
        this.cssClasses = finalCssClasses;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.toolTip);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> propertyReplacerComponents;
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.componentModifiers != null) {
            for (ComponentModifier modifier : this.componentModifiers) {
                components.addAll(modifier.getComponentPrototypes());
            }
        }
        if ((propertyReplacerComponents = this.getPropertyReplacerComponents()) != null) {
            components.addAll(propertyReplacerComponents);
        }
        return components;
    }

    @Override
    public List<Component> getPropertyReplacerComponents() {
        if (this.propertyReplacers == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (PropertyReplacer replacer : this.propertyReplacers) {
            components.addAll(replacer.getNestedComponents());
        }
        return components;
    }

    @Override
    @BeanTagAttribute(name="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getBaseId() {
        return this.baseId;
    }

    @Override
    public void setBaseId(String baseId) {
        this.baseId = baseId;
    }

    @Override
    @BeanTagAttribute(name="template")
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    @BeanTagAttribute(name="templateName")
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    @BeanTagAttribute(name="title")
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @BeanTagAttribute(name="hidden")
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    @BeanTagAttribute(name="readOnly")
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    @BeanTagAttribute(name="required")
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    @BeanTagAttribute(name="render")
    public boolean isRender() {
        return this.render;
    }

    @Override
    public void setRender(boolean render) {
        this.render = render;
    }

    @Override
    @BeanTagAttribute(name="retrieveViaAjax")
    public boolean isRetrieveViaAjax() {
        return this.retrieveViaAjax;
    }

    @Override
    public void setRetrieveViaAjax(boolean retrieveViaAjax) {
        this.retrieveViaAjax = retrieveViaAjax;
    }

    @Override
    @BeanTagAttribute(name="ColSpan")
    public int getColSpan() {
        return this.colSpan;
    }

    @Override
    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    @Override
    @BeanTagAttribute(name="rowSpan")
    public int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    @Override
    public List<String> getCellCssClasses() {
        return this.cellCssClasses;
    }

    @Override
    public void setCellCssClasses(List<String> cellCssClasses) {
        this.cellCssClasses = cellCssClasses;
    }

    @Override
    public void addCellCssClass(String cssClass) {
        if (this.cellCssClasses == null) {
            this.cellCssClasses = new ArrayList<String>();
        }
        if (cssClass != null) {
            this.cellCssClasses.add(cssClass);
        }
    }

    public String getCellStyleClassesAsString() {
        if (this.cellCssClasses != null) {
            return StringUtils.join(this.cellCssClasses, (String)" ");
        }
        return "";
    }

    @Override
    public String getCellStyle() {
        return this.cellStyle;
    }

    @Override
    public void setCellStyle(String cellStyle) {
        this.cellStyle = cellStyle;
    }

    @Override
    public String getCellWidth() {
        return this.cellWidth;
    }

    @Override
    public void setCellWidth(String cellWidth) {
        this.cellWidth = cellWidth;
    }

    @Override
    @BeanTagAttribute(name="align")
    public String getAlign() {
        return this.align;
    }

    @Override
    public void setAlign(String align) {
        this.align = align;
    }

    @Override
    @BeanTagAttribute(name="valign")
    public String getValign() {
        return this.valign;
    }

    @Override
    public void setValign(String valign) {
        this.valign = valign;
    }

    @Override
    @BeanTagAttribute(name="width")
    public String getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(String width) {
        this.width = width;
    }

    @Override
    @BeanTagAttribute(name="style")
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public List<String> getLibraryCssClasses() {
        return this.libraryCssClasses;
    }

    @Override
    public void setLibraryCssClasses(List<String> libraryCssClasses) {
        this.libraryCssClasses = libraryCssClasses;
    }

    @Override
    @BeanTagAttribute(name="cssClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getCssClasses() {
        return this.cssClasses;
    }

    @Override
    public void setCssClasses(List<String> cssClasses) {
        this.cssClasses = cssClasses;
    }

    @Override
    @BeanTagAttribute(name="additionalCssClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalCssClasses() {
        return this.additionalCssClasses;
    }

    @Override
    public void setAdditionalCssClasses(List<String> additionalCssClasses) {
        this.additionalCssClasses = additionalCssClasses;
    }

    public String getStyleClassesAsString() {
        if (this.cssClasses != null) {
            return StringUtils.join(this.cssClasses, (String)" ");
        }
        return "";
    }

    @Override
    public void addStyleClass(String styleClass) {
        if (this.cssClasses == null) {
            this.cssClasses = new LinkedList<String>();
        }
        if (!this.cssClasses.contains(styleClass)) {
            this.cssClasses.add(styleClass);
        }
    }

    @Override
    public void appendToStyle(String styleRules) {
        if (this.style == null) {
            this.style = "";
        }
        this.style = this.style + styleRules;
    }

    @Override
    @BeanTagAttribute(name="finalizeMethodToCall")
    public String getFinalizeMethodToCall() {
        return this.finalizeMethodToCall;
    }

    public void setFinalizeMethodToCall(String finalizeMethodToCall) {
        this.finalizeMethodToCall = finalizeMethodToCall;
    }

    @Override
    @BeanTagAttribute(name="finalizeMethodAdditionalArguments", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Object> getFinalizeMethodAdditionalArguments() {
        return this.finalizeMethodAdditionalArguments;
    }

    public void setFinalizeMethodAdditionalArguments(List<Object> finalizeMethodAdditionalArguments) {
        this.finalizeMethodAdditionalArguments = finalizeMethodAdditionalArguments;
    }

    @Override
    @BeanTagAttribute(name="finalizeMethodInvoker", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public MethodInvokerConfig getFinalizeMethodInvoker() {
        return this.finalizeMethodInvoker;
    }

    public void setFinalizeMethodInvoker(MethodInvokerConfig finalizeMethodInvoker) {
        this.finalizeMethodInvoker = finalizeMethodInvoker;
    }

    @Override
    @BeanTagAttribute(name="selfRendered")
    public boolean isSelfRendered() {
        return this.selfRendered;
    }

    @Override
    public void setSelfRendered(boolean selfRendered) {
        this.selfRendered = selfRendered;
    }

    @Override
    @BeanTagAttribute(name="renderedHtmlOutput")
    public String getRenderedHtmlOutput() {
        return this.renderedHtmlOutput;
    }

    @Override
    public void setRenderedHtmlOutput(String renderedHtmlOutput) {
        this.renderedHtmlOutput = renderedHtmlOutput;
    }

    @Override
    @BeanTagAttribute(name="disableSessionPersistence")
    public boolean isDisableSessionPersistence() {
        return this.disableSessionPersistence;
    }

    @Override
    public void setDisableSessionPersistence(boolean disableSessionPersistence) {
        this.disableSessionPersistence = disableSessionPersistence;
    }

    @Override
    @BeanTagAttribute(name="forceSessionPersistence")
    public boolean isForceSessionPersistence() {
        return this.forceSessionPersistence;
    }

    @Override
    public void setForceSessionPersistence(boolean forceSessionPersistence) {
        this.forceSessionPersistence = forceSessionPersistence;
    }

    @Override
    @BeanTagAttribute(name="componentSecurity", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ComponentSecurity getComponentSecurity() {
        return this.componentSecurity;
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        this.componentSecurity = componentSecurity;
    }

    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return ComponentSecurity.class;
    }

    @Override
    @BeanTagAttribute(name="componentModifiers", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<ComponentModifier> getComponentModifiers() {
        return this.componentModifiers;
    }

    @Override
    public void setComponentModifiers(List<ComponentModifier> componentModifiers) {
        this.componentModifiers = componentModifiers;
    }

    @Override
    @BeanTagAttribute(name="context", type=BeanTagAttribute.AttributeType.MAPBEAN)
    public Map<String, Object> getContext() {
        return this.unmodifiableContext;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        if (context == null || context.isEmpty()) {
            this.context = Collections.emptyMap();
            this.unmodifiableContext = this.context;
        } else {
            this.context = context;
            this.unmodifiableContext = Collections.unmodifiableMap(this.context);
        }
    }

    @Override
    public void pushObjectToContext(String objectName, Object object) {
        if (this.context.isEmpty()) {
            this.context = new HashMap<String, Object>();
            this.unmodifiableContext = Collections.unmodifiableMap(this.context);
        }
        this.pushToPropertyReplacerContext(objectName, object);
        this.context.put(objectName, object);
    }

    protected void pushToPropertyReplacerContext(String objectName, Object object) {
        List<Component> propertyReplacerComponents = this.getPropertyReplacerComponents();
        if (propertyReplacerComponents != null) {
            for (Component replacerComponent : propertyReplacerComponents) {
                replacerComponent.pushObjectToContext(objectName, object);
            }
        }
    }

    @Override
    public void pushAllToContext(Map<String, Object> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        if (this.context.isEmpty()) {
            this.context = new HashMap<String, Object>();
            this.unmodifiableContext = Collections.unmodifiableMap(this.context);
        }
        this.context.putAll(objects);
        List<Component> propertyReplacerComponents = this.getPropertyReplacerComponents();
        if (propertyReplacerComponents != null) {
            for (Component replacerComponent : propertyReplacerComponents) {
                replacerComponent.pushAllToContext(objects);
            }
        }
    }

    @Override
    @BeanTagAttribute(name="propertyReplacers", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<PropertyReplacer> getPropertyReplacers() {
        return this.propertyReplacers;
    }

    @Override
    public void setPropertyReplacers(List<PropertyReplacer> propertyReplacers) {
        this.propertyReplacers = propertyReplacers;
    }

    @Override
    @BeanTagAttribute(name="order")
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    @BeanTagAttribute(name="toolTip", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Tooltip getToolTip() {
        return this.toolTip;
    }

    @Override
    public void setToolTip(Tooltip toolTip) {
        this.toolTip = toolTip;
    }

    @Override
    public String getEventHandlerScript() {
        StringBuffer sb = new StringBuffer();
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "load", this.getOnLoadScript()));
        if (StringUtils.isNotBlank((String)this.getOnDocumentReadyScript())) {
            sb.append("jQuery(document).ready(function(e) {");
            sb.append(this.getOnDocumentReadyScript());
            sb.append("});");
        }
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "unload", this.getOnUnloadScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "blur", this.getOnBlurScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "change", this.getOnChangeScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "click", this.getOnClickScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "dblclick", this.getOnDblClickScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "focus", this.getOnFocusScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "keypress", this.getOnKeyPressScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "keyup", this.getOnKeyUpScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "keydown", this.getOnKeyDownScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mouseover", this.getOnMouseOverScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mouseout", this.getOnMouseOutScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mouseup", this.getOnMouseUpScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mousedown", this.getOnMouseDownScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mousemove", this.getOnMouseMoveScript()));
        return sb.toString();
    }

    @Override
    @BeanTagAttribute(name="onLoadScript")
    public String getOnLoadScript() {
        return this.onLoadScript;
    }

    @Override
    public void setOnLoadScript(String onLoadScript) {
        this.onLoadScript = onLoadScript;
    }

    @Override
    @BeanTagAttribute(name="onDocumentReadyScript")
    public String getOnDocumentReadyScript() {
        return this.onDocumentReadyScript;
    }

    @Override
    public void setOnDocumentReadyScript(String onDocumentReadyScript) {
        this.onDocumentReadyScript = onDocumentReadyScript;
    }

    @Override
    @BeanTagAttribute(name="onUnloadScript")
    public String getOnUnloadScript() {
        return this.onUnloadScript;
    }

    @Override
    public void setOnUnloadScript(String onUnloadScript) {
        this.onUnloadScript = onUnloadScript;
    }

    @Override
    @BeanTagAttribute(name="onCloseScript")
    public String getOnCloseScript() {
        return this.onCloseScript;
    }

    @Override
    public void setOnCloseScript(String onCloseScript) {
        this.onCloseScript = onCloseScript;
    }

    @Override
    @BeanTagAttribute(name="onBlurScript")
    public String getOnBlurScript() {
        return this.onBlurScript;
    }

    @Override
    public void setOnBlurScript(String onBlurScript) {
        this.onBlurScript = onBlurScript;
    }

    @Override
    @BeanTagAttribute(name="onChangeScript")
    public String getOnChangeScript() {
        return this.onChangeScript;
    }

    @Override
    public void setOnChangeScript(String onChangeScript) {
        this.onChangeScript = onChangeScript;
    }

    @Override
    @BeanTagAttribute(name="onClickScript")
    public String getOnClickScript() {
        return this.onClickScript;
    }

    @Override
    public void setOnClickScript(String onClickScript) {
        this.onClickScript = onClickScript;
    }

    @Override
    @BeanTagAttribute(name="onDblClickScript")
    public String getOnDblClickScript() {
        return this.onDblClickScript;
    }

    @Override
    public void setOnDblClickScript(String onDblClickScript) {
        this.onDblClickScript = onDblClickScript;
    }

    @Override
    @BeanTagAttribute(name="onFocusScript")
    public String getOnFocusScript() {
        return this.onFocusScript;
    }

    @Override
    public void setOnFocusScript(String onFocusScript) {
        this.onFocusScript = onFocusScript;
    }

    @Override
    @BeanTagAttribute(name="onSubmitScript")
    public String getOnSubmitScript() {
        return this.onSubmitScript;
    }

    @Override
    public void setOnSubmitScript(String onSubmitScript) {
        this.onSubmitScript = onSubmitScript;
    }

    @Override
    @BeanTagAttribute(name="onKeyPressScript")
    public String getOnKeyPressScript() {
        return this.onKeyPressScript;
    }

    @Override
    public void setOnKeyPressScript(String onKeyPressScript) {
        this.onKeyPressScript = onKeyPressScript;
    }

    @Override
    @BeanTagAttribute(name="onKeyUpScript")
    public String getOnKeyUpScript() {
        return this.onKeyUpScript;
    }

    @Override
    public void setOnKeyUpScript(String onKeyUpScript) {
        this.onKeyUpScript = onKeyUpScript;
    }

    @Override
    @BeanTagAttribute(name="onKeyDownScript")
    public String getOnKeyDownScript() {
        return this.onKeyDownScript;
    }

    @Override
    public void setOnKeyDownScript(String onKeyDownScript) {
        this.onKeyDownScript = onKeyDownScript;
    }

    @Override
    @BeanTagAttribute(name="onMouseOverScript")
    public String getOnMouseOverScript() {
        return this.onMouseOverScript;
    }

    @Override
    public void setOnMouseOverScript(String onMouseOverScript) {
        this.onMouseOverScript = onMouseOverScript;
    }

    @Override
    @BeanTagAttribute(name="onMouseOutScript")
    public String getOnMouseOutScript() {
        return this.onMouseOutScript;
    }

    @Override
    public void setOnMouseOutScript(String onMouseOutScript) {
        this.onMouseOutScript = onMouseOutScript;
    }

    @Override
    @BeanTagAttribute(name="onMouseUpScript")
    public String getOnMouseUpScript() {
        return this.onMouseUpScript;
    }

    @Override
    public void setOnMouseUpScript(String onMouseUpScript) {
        this.onMouseUpScript = onMouseUpScript;
    }

    @Override
    @BeanTagAttribute(name="onMouseDownScript")
    public String getOnMouseDownScript() {
        return this.onMouseDownScript;
    }

    @Override
    public void setOnMouseDownScript(String onMouseDownScript) {
        this.onMouseDownScript = onMouseDownScript;
    }

    @Override
    @BeanTagAttribute(name="onMouseMoveScript")
    public String getOnMouseMoveScript() {
        return this.onMouseMoveScript;
    }

    @Override
    public void setOnMouseMoveScript(String onMouseMoveScript) {
        this.onMouseMoveScript = onMouseMoveScript;
    }

    @Override
    @BeanTagAttribute(name="templateOptions", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getTemplateOptions() {
        return this.templateOptions;
    }

    @Override
    public void setTemplateOptions(Map<String, String> templateOptions) {
        this.templateOptions = templateOptions;
    }

    @Override
    @BeanTagAttribute(name="templateOptionsJSString")
    public String getTemplateOptionsJSString() {
        if (this.templateOptionsJSString != null) {
            return this.templateOptionsJSString;
        }
        if (this.templateOptions == null) {
            this.templateOptions = new HashMap<String, String>();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String optionKey : this.templateOptions.keySet()) {
            String optionValue = this.templateOptions.get(optionKey);
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(optionKey);
            sb.append(":");
            sb.append(ScriptUtils.convertToJsValue(optionValue));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setTemplateOptionsJSString(String templateOptionsJSString) {
        this.templateOptionsJSString = templateOptionsJSString;
    }

    @Override
    @BeanTagAttribute(name="progressiveRender")
    public String getProgressiveRender() {
        return this.progressiveRender;
    }

    @Override
    public void setProgressiveRender(String progressiveRender) {
        this.progressiveRender = progressiveRender;
    }

    @Override
    @BeanTagAttribute(name="conditionalRefresh")
    public String getConditionalRefresh() {
        return this.conditionalRefresh;
    }

    @Override
    public void setConditionalRefresh(String conditionalRefresh) {
        this.conditionalRefresh = conditionalRefresh;
    }

    @Override
    public List<String> getProgressiveDisclosureControlNames() {
        return this.progressiveDisclosureControlNames;
    }

    @Override
    public String getProgressiveDisclosureConditionJs() {
        return this.progressiveDisclosureConditionJs;
    }

    @Override
    public String getConditionalRefreshConditionJs() {
        return this.conditionalRefreshConditionJs;
    }

    @Override
    public List<String> getConditionalRefreshControlNames() {
        return this.conditionalRefreshControlNames;
    }

    @Override
    @BeanTagAttribute(name="progressiveRenderViaAJAX")
    public boolean isProgressiveRenderViaAJAX() {
        return this.progressiveRenderViaAJAX;
    }

    @Override
    public void setProgressiveRenderViaAJAX(boolean progressiveRenderViaAJAX) {
        this.progressiveRenderViaAJAX = progressiveRenderViaAJAX;
    }

    @Override
    @BeanTagAttribute(name="progressiveRenderAndRefresh")
    public boolean isProgressiveRenderAndRefresh() {
        return this.progressiveRenderAndRefresh;
    }

    @Override
    public void setProgressiveRenderAndRefresh(boolean progressiveRenderAndRefresh) {
        this.progressiveRenderAndRefresh = progressiveRenderAndRefresh;
    }

    @Override
    @BeanTagAttribute(name="refreshWhenChangedPropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getRefreshWhenChangedPropertyNames() {
        return this.refreshWhenChangedPropertyNames;
    }

    @Override
    public void setRefreshWhenChangedPropertyNames(List<String> refreshWhenChangedPropertyNames) {
        this.refreshWhenChangedPropertyNames = refreshWhenChangedPropertyNames;
    }

    @Override
    @BeanTagAttribute(name="additionalComponentsToRefresh", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalComponentsToRefresh() {
        return this.additionalComponentsToRefresh;
    }

    @Override
    public void setAdditionalComponentsToRefresh(List<String> additionalComponentsToRefresh) {
        this.additionalComponentsToRefresh = additionalComponentsToRefresh;
    }

    @Override
    public String getAdditionalComponentsToRefreshJs() {
        if (this.additionalComponentsToRefresh != null && !this.additionalComponentsToRefresh.isEmpty()) {
            this.additionalComponentsToRefreshJs = ScriptUtils.convertStringListToJsArray(this.getAdditionalComponentsToRefresh());
        }
        return this.additionalComponentsToRefreshJs;
    }

    @Override
    public boolean isRefreshedByAction() {
        return this.refreshedByAction;
    }

    @Override
    public void setRefreshedByAction(boolean refreshedByAction) {
        this.refreshedByAction = refreshedByAction;
    }

    @Override
    public boolean isDisclosedByAction() {
        return this.disclosedByAction;
    }

    @Override
    public void setDisclosedByAction(boolean disclosedByAction) {
        this.disclosedByAction = disclosedByAction;
    }

    @Override
    @BeanTagAttribute(name="refreshTimer")
    public int getRefreshTimer() {
        return this.refreshTimer;
    }

    @Override
    public void setRefreshTimer(int refreshTimer) {
        this.refreshTimer = refreshTimer;
    }

    @Override
    @BeanTagAttribute(name="resetDataOnRefresh")
    public boolean isResetDataOnRefresh() {
        return this.resetDataOnRefresh;
    }

    @Override
    public void setResetDataOnRefresh(boolean resetDataOnRefresh) {
        this.resetDataOnRefresh = resetDataOnRefresh;
    }

    @BeanTagAttribute(name="methodToCallOnRefresh")
    public String getMethodToCallOnRefresh() {
        return this.methodToCallOnRefresh;
    }

    public void setMethodToCallOnRefresh(String methodToCallOnRefresh) {
        this.methodToCallOnRefresh = methodToCallOnRefresh;
    }

    public void setSkipInTabOrder(boolean skipInTabOrder) {
        this.skipInTabOrder = skipInTabOrder;
    }

    @BeanTagAttribute(name="skipInTabOrder")
    public boolean isSkipInTabOrder() {
        return this.skipInTabOrder;
    }

    @Override
    @BeanTagAttribute(name="dataAttributes", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getDataAttributes() {
        return this.dataAttributes;
    }

    @Override
    public void setDataAttributes(Map<String, String> dataAttributes) {
        this.dataAttributes = dataAttributes;
    }

    @Override
    public void addDataAttribute(String key, String value) {
        if (this.dataAttributes == null) {
            this.dataAttributes = new HashMap<String, String>();
        }
        this.dataAttributes.put(key, value);
    }

    public void addDataAttributeIfNonEmpty(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.addDataAttribute(key, value);
        }
    }

    @Override
    public String getSimpleDataAttributes() {
        String attributes = "";
        if (this.getDataAttributes() == null) {
            return attributes;
        }
        for (Map.Entry<String, String> data : this.getDataAttributes().entrySet()) {
            if (data == null || data.getValue() == null) continue;
            attributes = attributes + " " + "data-" + data.getKey() + "=\"" + KRADUtils.convertToHTMLAttributeSafeString(data.getValue()) + "\"";
        }
        return attributes;
    }

    @Override
    @BeanTagAttribute(name="preRenderContent")
    public String getPreRenderContent() {
        return this.preRenderContent;
    }

    @Override
    public void setPreRenderContent(String preRenderContent) {
        this.preRenderContent = preRenderContent;
    }

    @Override
    @BeanTagAttribute(name="postRenderContent")
    public String getPostRenderContent() {
        return this.postRenderContent;
    }

    @Override
    public void setPostRenderContent(String postRenderContent) {
        this.postRenderContent = postRenderContent;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getId() != null && (this.getId().contains("'") || this.getId().contains("\"") || this.getId().contains("[]") || this.getId().contains(".") || this.getId().contains("#"))) {
            currentValues = new String[]{"id = " + this.getId()};
            tracer.createError("Id contains invalid characters", currentValues);
        }
        if (tracer.getValidationStage() == 1 && (this.isProgressiveRenderViaAJAX() || this.isProgressiveRenderAndRefresh()) && this.getProgressiveRender() == null) {
            currentValues = new String[]{"progressiveRenderViaAJAX = " + this.isProgressiveRenderViaAJAX(), "progressiveRenderAndRefresh = " + this.isProgressiveRenderAndRefresh(), "progressiveRender = " + this.getProgressiveRender()};
            tracer.createError("ProgressiveRender must be set if progressiveRenderViaAJAX or progressiveRenderAndRefresh are true", currentValues);
        }
        if (this.isSelfRendered() && this.getRenderedHtmlOutput() == null) {
            currentValues = new String[]{"selfRendered = " + this.isSelfRendered(), "renderedHtmlOutput = " + this.getRenderedHtmlOutput()};
            tracer.createError("RenderedHtmlOutput must be set if selfRendered is true", currentValues);
        }
        if (this.isDisableSessionPersistence() && this.isForceSessionPersistence()) {
            currentValues = new String[]{"disableSessionPersistence = " + this.isDisableSessionPersistence(), "forceSessionPersistence = " + this.isForceSessionPersistence()};
            tracer.createWarning("DisableSessionPersistence and forceSessionPersistence cannot be both true", currentValues);
        }
        if (!(this.getMethodToCallOnRefresh() == null && !this.isResetDataOnRefresh() || this.isProgressiveRenderAndRefresh() || this.isRefreshedByAction() || this.isProgressiveRenderViaAJAX() || StringUtils.isNotEmpty((String)this.conditionalRefresh) || this.refreshTimer > 0)) {
            currentValues = new String[]{"methodToCallONRefresh = " + this.getMethodToCallOnRefresh(), "resetDataONRefresh = " + this.isResetDataOnRefresh(), "progressiveRenderAndRefresh = " + this.isProgressiveRenderAndRefresh(), "refreshedByAction = " + this.isRefreshedByAction(), "progressiveRenderViaAJAX = " + this.isProgressiveRenderViaAJAX(), "conditionalRefresh = " + this.getConditionalRefresh(), "refreshTimer = " + this.getRefreshTimer()};
            tracer.createWarning("MethodToCallONRefresh and resetDataONRefresh should only be set when a trigger event is set", currentValues);
        }
        if (StringUtils.isNotEmpty((String)this.getProgressiveRender()) && StringUtils.isNotEmpty((String)this.conditionalRefresh)) {
            currentValues = new String[]{"progressiveRender = " + this.getProgressiveRender(), "conditionalRefresh = " + this.getConditionalRefresh()};
            tracer.createWarning("DO NOT use progressiveRender and conditionalRefresh on the same component unless it is known that the component will always be visible in all cases when a conditionalRefresh happens (ie conditionalRefresh has progressiveRender's condition anded with its own condition). If a component should be refreshed every time it is shown, use the progressiveRenderAndRefresh option with this property instead.", currentValues);
        }
        if (!Validator.validateSpringEL(this.getProgressiveRender())) {
            currentValues = new String[]{"progressiveRender =" + this.getProgressiveRender()};
            tracer.createError("ProgressiveRender must follow the Spring EL @{} format", currentValues);
        }
        if (!Validator.validateSpringEL(this.getConditionalRefresh())) {
            currentValues = new String[]{"conditionalRefresh =" + this.getConditionalRefresh()};
            tracer.createError("conditionalRefresh must follow the Spring EL @{} format", currentValues);
        }
    }

    public ComponentBase copy() {
        ComponentBase copiedClass = null;
        try {
            copiedClass = (ComponentBase)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        this.copyProperties(copiedClass);
        return copiedClass;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        ComponentBase componentCopy = (ComponentBase)component;
        componentCopy.setId(this.id);
        componentCopy.setBaseId(this.baseId);
        List<String> copyAdditionalComponentsToRefresh = this.getAdditionalComponentsToRefresh();
        if (copyAdditionalComponentsToRefresh != null) {
            componentCopy.setAdditionalComponentsToRefresh(new ArrayList<String>(copyAdditionalComponentsToRefresh));
        }
        if (this.additionalCssClasses != null) {
            componentCopy.setAdditionalCssClasses(new ArrayList<String>(this.additionalCssClasses));
        }
        componentCopy.setAlign(this.align);
        if (this.cellCssClasses != null) {
            componentCopy.setCellCssClasses(new ArrayList<String>(this.cellCssClasses));
        }
        componentCopy.setCellStyle(this.cellStyle);
        componentCopy.setCellWidth(this.cellWidth);
        componentCopy.setColSpan(this.colSpan);
        componentCopy.setConditionalRefresh(this.conditionalRefresh);
        if (this.libraryCssClasses != null) {
            componentCopy.setLibraryCssClasses(new ArrayList<String>(this.libraryCssClasses));
        }
        if (this.cssClasses != null) {
            componentCopy.setCssClasses(new ArrayList<String>(this.cssClasses));
        }
        if (this.dataAttributes != null) {
            componentCopy.setDataAttributes(new HashMap<String, String>(this.dataAttributes));
        }
        componentCopy.setDisableSessionPersistence(this.disableSessionPersistence);
        componentCopy.setDisclosedByAction(this.disclosedByAction);
        componentCopy.setFinalizeMethodToCall(this.finalizeMethodToCall);
        componentCopy.setFinalizeMethodAdditionalArguments(this.finalizeMethodAdditionalArguments);
        componentCopy.setFinalizeMethodInvoker(CloneUtils.deepClone(this.finalizeMethodInvoker));
        componentCopy.setForceSessionPersistence(this.forceSessionPersistence);
        componentCopy.setHidden(this.hidden);
        componentCopy.setMethodToCallOnRefresh(this.methodToCallOnRefresh);
        componentCopy.setOnBlurScript(this.onBlurScript);
        componentCopy.setOnChangeScript(this.onChangeScript);
        componentCopy.setOnClickScript(this.onClickScript);
        componentCopy.setOnCloseScript(this.onCloseScript);
        componentCopy.setOnDblClickScript(this.onDblClickScript);
        componentCopy.setOnDocumentReadyScript(this.onDocumentReadyScript);
        componentCopy.setOnFocusScript(this.onFocusScript);
        componentCopy.setOnKeyDownScript(this.onKeyDownScript);
        componentCopy.setOnKeyPressScript(this.onKeyPressScript);
        componentCopy.setOnKeyUpScript(this.onKeyUpScript);
        componentCopy.setOnLoadScript(this.onLoadScript);
        componentCopy.setOnMouseDownScript(this.onMouseDownScript);
        componentCopy.setOnMouseMoveScript(this.onMouseMoveScript);
        componentCopy.setOnMouseOutScript(this.onMouseOutScript);
        componentCopy.setOnMouseOverScript(this.onMouseOverScript);
        componentCopy.setOnMouseUpScript(this.onMouseUpScript);
        componentCopy.setOnSubmitScript(this.onSubmitScript);
        componentCopy.setOnUnloadScript(this.onUnloadScript);
        componentCopy.setOrder(this.order);
        componentCopy.setPostRenderContent(this.postRenderContent);
        componentCopy.setPreRenderContent(this.preRenderContent);
        componentCopy.setProgressiveRender(this.progressiveRender);
        componentCopy.setProgressiveRenderViaAJAX(this.progressiveRenderViaAJAX);
        componentCopy.setReadOnly(this.readOnly);
        componentCopy.setRefreshedByAction(this.refreshedByAction);
        componentCopy.setRefreshTimer(this.refreshTimer);
        if (this.refreshWhenChangedPropertyNames != null) {
            componentCopy.setRefreshWhenChangedPropertyNames(new ArrayList<String>(this.refreshWhenChangedPropertyNames));
        }
        componentCopy.setRender(this.render);
        componentCopy.setRetrieveViaAjax(this.retrieveViaAjax);
        componentCopy.setRenderedHtmlOutput(this.renderedHtmlOutput);
        componentCopy.setRequired(this.required);
        componentCopy.setResetDataOnRefresh(this.resetDataOnRefresh);
        componentCopy.setRowSpan(this.rowSpan);
        componentCopy.setSelfRendered(this.selfRendered);
        componentCopy.setSkipInTabOrder(this.skipInTabOrder);
        componentCopy.setStyle(this.style);
        componentCopy.setTemplate(this.template);
        componentCopy.setTemplateName(this.templateName);
        if (this.templateOptions != null) {
            componentCopy.setTemplateOptions(new HashMap<String, String>(this.templateOptions));
        }
        componentCopy.setTemplateOptionsJSString(this.templateOptionsJSString);
        componentCopy.setTitle(this.title);
        componentCopy.setValign(this.valign);
        componentCopy.setWidth(this.width);
        if (this.componentModifiers != null) {
            ArrayList<ComponentModifier> componentModifiersCopy = new ArrayList<ComponentModifier>();
            for (ComponentModifier componentModifer : this.componentModifiers) {
                componentModifiersCopy.add((ComponentModifier)componentModifer.copy());
            }
            componentCopy.setComponentModifiers(componentModifiersCopy);
        }
        if (this.componentSecurity != null) {
            componentCopy.setComponentSecurity((ComponentSecurity)this.componentSecurity.copy());
        }
        if (this.toolTip != null) {
            componentCopy.setToolTip((Tooltip)this.toolTip.copy());
        }
        if (!this.context.isEmpty()) {
            HashMap<String, Object> contextCopy = new HashMap<String, Object>(this.context);
            componentCopy.setContext(contextCopy);
        }
        if (this.propertyReplacers != null) {
            ArrayList<PropertyReplacer> propertyReplacersCopy = new ArrayList<PropertyReplacer>();
            for (PropertyReplacer propertyReplacer : this.propertyReplacers) {
                propertyReplacersCopy.add((PropertyReplacer)propertyReplacer.copy());
            }
            componentCopy.setPropertyReplacers(propertyReplacersCopy);
        }
        componentCopy.setComponentSecurity(this.getComponentSecurity());
    }
}

