/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.uif.widget.RichTable;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="lightTableGroup-bean", parent="Uif-LightTableGroup"), @BeanTag(name="lightTableSection-bean", parent="Uif-LightTableSection"), @BeanTag(name="lightTableSubSection-bean", parent="Uif-LightTableSubSection")})
public class LightTable
extends Group
implements DataBinding {
    private static final long serialVersionUID = -8930885219866835711L;
    private static final String VALUE_TOKEN = "@v@";
    private static final String EXPRESSION_TOKEN = "@e@";
    private static final String RENDER = "render";
    private static final String ID_TOKEN = "@id@";
    private static final String A_TOKEN = "@";
    private static final String ROW_CLASS = "@rowClass@";
    private static final String SORT_VALUE = "@sortVal";
    private static final String SEPARATOR = "@@@";
    private String propertyName;
    private BindingInfo bindingInfo;
    private List<Label> headerLabels;
    private RichTable richTable;
    private Map<String, String> conditionalRowCssClasses;
    private Map<String, String> expressionConversionMap = new HashMap<String, String>();
    private List<String> initialComponentIds = new ArrayList<String>();
    private Map<String, String> renderIdExpressionMap = new HashMap<String, String>();
    private boolean emptyTable;
    private String currentColumnValue;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        this.richTable.setForceLocalJsonData(true);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
        for (Component component : this.getItems()) {
            this.initialComponentIds.add(component.getId());
            if (component instanceof DataField) {
                ((DataField)component).setForcedValue(VALUE_TOKEN + component.getId() + VALUE_TOKEN);
            }
            this.expressionConversionMap = this.buildExpressionMap(component, this.expressionConversionMap);
        }
    }

    protected Map<String, String> buildExpressionMap(Component item, Map<String, String> expressionMap) {
        if (item == null) {
            return expressionMap;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        if (item.getExpressionGraph() != null && !item.getExpressionGraph().isEmpty()) {
            for (String name : item.getExpressionGraph().keySet()) {
                this.processExpression(name, item, expressionMap, toRemove);
            }
        }
        item.setId(ID_TOKEN + item.getId() + ID_TOKEN);
        if (item instanceof Group) {
            ((Group)item).getLayoutManager().setId(ID_TOKEN + ((Group)item).getLayoutManager().getId() + ID_TOKEN);
        }
        expressionMap = this.addChildExpressions(item.getComponentsForLifecycle(), expressionMap);
        for (String name : toRemove) {
            item.getExpressionGraph().remove(name);
        }
        return expressionMap;
    }

    public void processExpression(String name, Component item, Map<String, String> expressionMap, List<String> toRemove) {
        Class<Object> clazz = ObjectPropertyUtils.getPropertyType(item, name);
        if (clazz == null) {
            return;
        }
        if (clazz.isAssignableFrom(String.class)) {
            expressionMap.put(name + SEPARATOR + item.getId(), item.getExpressionGraph().get(name));
            toRemove.add(name);
            ObjectPropertyUtils.setPropertyValue(item, name, EXPRESSION_TOKEN + name + SEPARATOR + item.getId() + EXPRESSION_TOKEN);
        } else if (name.endsWith(RENDER) && clazz.isAssignableFrom(Boolean.TYPE)) {
            Component renderComponent = item;
            if (!name.equals(RENDER)) {
                renderComponent = (Component)ObjectPropertyUtils.getPropertyValue(item, StringUtils.removeEnd((String)name, (String)".render"));
            }
            this.renderIdExpressionMap.put(renderComponent.getId(), item.getExpressionGraph().get(name));
            toRemove.add(name);
            String renderMarker = "@render@" + renderComponent.getId() + A_TOKEN;
            String pre = renderComponent.getPreRenderContent() == null ? "" : renderComponent.getPreRenderContent();
            renderComponent.setPreRenderContent(renderMarker + pre);
            String post = renderComponent.getPostRenderContent() == null ? "" : renderComponent.getPostRenderContent();
            renderComponent.setPostRenderContent(post + renderMarker);
            ObjectPropertyUtils.setPropertyValue(item, name, true);
        }
    }

    protected Map<String, String> addChildExpressions(List<? extends Component> components, Map<String, String> expressionMap) {
        for (Component component : components) {
            if (component == null || !(component instanceof Action) && !(component instanceof Image) && !(component instanceof Message) && !(component instanceof Link) && !(component instanceof Inquiry) && !(component instanceof Group) && !(component instanceof Tooltip) && !(component instanceof InputField) && !(component instanceof CheckboxControl) && !(component instanceof TextControl) && !(component instanceof SelectControl)) continue;
            expressionMap = this.buildExpressionMap(component, expressionMap);
        }
        return expressionMap;
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        this.headerLabels = new ArrayList<Label>();
        for (Component component : this.getItems()) {
            if (component instanceof Field) {
                this.headerLabels.add(ComponentUtils.copy(((Field)component).getFieldLabel()));
                ((Field)component).getFieldLabel().setRender(false);
            } else {
                this.headerLabels.add(null);
            }
            if (component instanceof FieldGroup) {
                ((FieldGroup)component).getGroup().setValidationMessages(null);
            }
            if (!(component instanceof DataField)) continue;
            ((DataField)component).getBindingInfo().setBindByNamePrefix(this.getBindingInfo().getBindingPath() + "[0]");
        }
        Object collectionValue = ObjectPropertyUtils.getPropertyValue(model, this.bindingInfo.getBindingPath());
        if (collectionValue == null || !(collectionValue instanceof Collection) || ((Collection)collectionValue).isEmpty()) {
            this.emptyTable = true;
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.richTable);
        return components;
    }

    public void buildRows(View view, String rowTemplate, UifFormBase model) {
        if (StringUtils.isBlank((String)rowTemplate)) {
            return;
        }
        rowTemplate = StringUtils.removeEnd((String)rowTemplate, (String)",");
        rowTemplate = rowTemplate.replace("\n", "");
        rowTemplate = rowTemplate.replace("\r", "");
        StringBuffer rows = new StringBuffer();
        List collectionObjects = (List)ObjectPropertyUtils.getPropertyValue(model, this.bindingInfo.getBindingPath());
        rowTemplate = rowTemplate.replace("checked=\"checked\"", "");
        Pattern idPattern = Pattern.compile("@id@(.*?)@id@");
        Pattern expressionPattern = Pattern.compile("@e@(.*?)@e@");
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        expressionEvaluator.initializeEvaluationContext(model);
        int lineIndex = 0;
        for (Object obj : collectionObjects) {
            String row = idPattern.matcher(rowTemplate).replaceAll("$1_line" + lineIndex);
            HashMap<String, Object> expandedContext = new HashMap<String, Object>();
            expandedContext.put("line", obj);
            expandedContext.put("index", lineIndex);
            expandedContext.put("view", view);
            this.currentColumnValue = "";
            int itemIndex = 0;
            for (Component component : this.getItems()) {
                String originalId = this.initialComponentIds.get(itemIndex);
                row = this.handleDataFieldInRow(component, obj, row, lineIndex, originalId);
                row = this.handleInputFieldInRow(component, obj, row, lineIndex, originalId);
                if (component.getContext() != null) {
                    expandedContext.putAll(component.getContext());
                }
                row = this.evaluateAndReplaceExpressionValues(row, lineIndex, model, expandedContext, expressionPattern, expressionEvaluator);
                if (this.currentColumnValue == null) {
                    this.currentColumnValue = "";
                }
                row = row.replace(SORT_VALUE + itemIndex + A_TOKEN, this.currentColumnValue);
                ++itemIndex;
            }
            boolean isOdd = lineIndex % 2 == 0;
            String string = KRADUtils.generateRowCssClassString(this.conditionalRowCssClasses, lineIndex, isOdd, expandedContext, expressionEvaluator);
            row = row.replace("\"", "\\\"");
            row = row.replace(ROW_CLASS, string);
            row = "{" + row + "},";
            row = this.evaluateRenderExpressions(row, lineIndex, model, expandedContext, expressionEvaluator);
            rows.append(row);
            ++lineIndex;
        }
        StringBuffer tableToolsColumnOptions = new StringBuffer("[");
        for (int index = 0; index < this.getItems().size(); ++index) {
            String colOptions = this.richTable.constructTableColumnOptions(index, true, false, String.class, null);
            tableToolsColumnOptions.append(colOptions + " , ");
        }
        String aoColumnDefs = StringUtils.removeEnd((String)tableToolsColumnOptions.toString(), (String)" , ") + "]";
        Map<String, String> rtTemplateOptions = this.richTable.getTemplateOptions();
        if (rtTemplateOptions == null) {
            rtTemplateOptions = new HashMap<String, String>();
            this.richTable.setTemplateOptions(rtTemplateOptions);
        }
        rtTemplateOptions.put("aoColumnDefs", aoColumnDefs);
        String aaData = StringUtils.removeEnd((String)rows.toString(), (String)",");
        aaData = "[" + aaData + "]";
        aaData = aaData.replace("@quot@", "\"");
        rtTemplateOptions.put("aaData", aaData);
        rtTemplateOptions.put("bDeferRender", "true");
    }

    protected String evaluateAndReplaceExpressionValues(String row, int index, Object model, Map<String, Object> expandedContext, Pattern expressionPattern, ExpressionEvaluator expressionEvaluator) {
        Matcher matcher = expressionPattern.matcher(row);
        while (matcher.find()) {
            String matchingGroup = matcher.group(1);
            String expression = this.expressionConversionMap.get(matchingGroup);
            String value = expressionEvaluator.evaluateExpressionTemplate(expandedContext, expression = expression.replace("#lp.", this.getBindingInfo().getBindingPath() + "[" + index + "]."));
            if (value != null) {
                row = row.replace(matcher.group(), value.toString());
                continue;
            }
            row = row.replace(matcher.group(), "");
        }
        return row;
    }

    protected String evaluateRenderExpressions(String row, int index, Object model, Map<String, Object> expandedContext, ExpressionEvaluator expressionEvaluator) {
        for (String id : this.renderIdExpressionMap.keySet()) {
            String expression = this.renderIdExpressionMap.get(id);
            expression = expression.replace("#lp.", this.getBindingInfo().getBindingPath() + "[" + index + "].");
            String value = expressionEvaluator.evaluateExpressionTemplate(expandedContext, expression);
            String wrap = "@render@" + id + A_TOKEN;
            if (value != null && value instanceof String && !Boolean.parseBoolean(value)) {
                row = row.replaceAll(wrap + "(.|\\s)*?" + wrap, "");
                continue;
            }
            row = row.replaceAll(wrap, "");
        }
        return row;
    }

    protected String handleDataFieldInRow(Component item, Object obj, String row, int index, String originalId) {
        if (!(item instanceof DataField)) {
            return row;
        }
        Object currentValue = ObjectPropertyUtils.getPropertyValue(obj, ((DataField)item).getPropertyName());
        if (currentValue == null) {
            currentValue = "";
        }
        row = row.replaceAll(VALUE_TOKEN + originalId + VALUE_TOKEN, currentValue.toString());
        this.currentColumnValue = currentValue.toString();
        if (((DataField)item).getInquiry() != null && ((DataField)item).getInquiry().getInquiryParameters() != null && ((DataField)item).getInquiry().getInquiryLink() != null) {
            String inquiryLinkId = ((DataField)item).getInquiry().getInquiryLink().getBaseId().replace(ID_TOKEN, "") + "_line" + index;
            for (String key : ((DataField)item).getInquiry().getInquiryParameters().keySet()) {
                String name = ((DataField)item).getInquiry().getInquiryParameters().get(key);
                if (!ObjectPropertyUtils.isReadableProperty(obj, key = key.replace(((DataField)item).getBindingInfo().getBindByNamePrefix() + ".", ""))) continue;
                String value = (String)ObjectPropertyUtils.getPropertyValue(obj, key);
                row = row.replaceFirst("(" + inquiryLinkId + "(.|\\s)*?" + name + ")=.*?([&|\"])", "$1=" + value + "$3");
            }
        }
        return row;
    }

    protected String handleInputFieldInRow(Component item, Object obj, String row, int index, String originalId) {
        if (!(item instanceof InputField) || ((InputField)item).getControl() == null) {
            return row;
        }
        Control control = ((InputField)item).getControl();
        row = row.replace("name=\"" + ((InputField)item).getBindingInfo().getBindingPath() + "\"", "name=\"" + this.getBindingInfo().getBindingPath() + "[" + index + "]." + ((InputField)item).getPropertyName() + "\"");
        Object value = ObjectPropertyUtils.getPropertyValue(obj, ((InputField)item).getPropertyName());
        String stringValue = "";
        if (value == null) {
            stringValue = "";
        } else if (value.getClass().isAssignableFrom(Boolean.TYPE)) {
            stringValue = "" + value;
        } else if (!(value instanceof Collection)) {
            stringValue = value.toString();
        }
        String controlId = originalId + "_line" + index + "_control";
        if (control instanceof CheckboxControl && stringValue.equalsIgnoreCase("true")) {
            row = row.replaceAll("(id(\\s)*?=(\\s)*?\"" + controlId + "\")", "$1 checked=\"checked\" ");
        } else if (control instanceof TextControl) {
            row = row.replaceAll("(id(\\s)*?=(\\s)*?\"" + controlId + "\"(.|\\s)*?value=\")(.|\\s)*?\"", "$1" + stringValue + "\"");
        } else if (control instanceof SelectControl && !((SelectControl)control).isMultiple()) {
            Pattern pattern = Pattern.compile("<select(\\s)*?id(\\s)*?=(\\s)*?\"" + controlId + "\"(.|\\s)*?</select>");
            Matcher matcher = pattern.matcher(row);
            String replacement = "";
            if (matcher.find()) {
                String selected = "selected=\"selected\"";
                replacement = matcher.group().replace(selected, "");
                String selectedValue = "value=\"" + stringValue + "\"";
                replacement = replacement.replace(selectedValue, selectedValue + " " + selected);
            }
            if (StringUtils.isNotBlank((String)replacement)) {
                row = matcher.replaceAll(replacement);
            }
        }
        this.currentColumnValue = stringValue;
        return row;
    }

    @Override
    @BeanTagAttribute(name="propertyName")
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    @BeanTagAttribute(name="bindingInfo", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public List<Label> getHeaderLabels() {
        return this.headerLabels;
    }

    @BeanTagAttribute(name="richTable", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public RichTable getRichTable() {
        return this.richTable;
    }

    public void setRichTable(RichTable richTable) {
        this.richTable = richTable;
    }

    @BeanTagAttribute(name="conditionalRowCssClasses", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getConditionalRowCssClasses() {
        return this.conditionalRowCssClasses;
    }

    public void setConditionalRowCssClasses(Map<String, String> conditionalRowCssClasses) {
        this.conditionalRowCssClasses = conditionalRowCssClasses;
    }

    public boolean isEmptyTable() {
        return this.emptyTable;
    }

    public void setHeaderLabels(List<Label> headerLabels) {
        this.headerLabels = headerLabels;
    }

    public void setExpressionConversionMap(Map<String, String> expressionConversionMap) {
        this.expressionConversionMap = expressionConversionMap;
    }

    public Map<String, String> getExpressionConversionMap() {
        return this.expressionConversionMap;
    }

    public List<String> getInitialComponentIds() {
        return this.initialComponentIds;
    }

    public Map<String, String> getRenderIdExpressionMap() {
        return this.renderIdExpressionMap;
    }

    public void setInitialComponentIds(List<String> initialComponentIds) {
        this.initialComponentIds = initialComponentIds;
    }

    public void setRenderIdExpressionMap(Map<String, String> renderIdExpressionMap) {
        this.renderIdExpressionMap = renderIdExpressionMap;
    }

    public void setEmptyTable(boolean emptyTable) {
        this.emptyTable = emptyTable;
    }

    @BeanTagAttribute(name="currentColumnValue")
    protected String getCurrentColumnValue() {
        return this.currentColumnValue;
    }

    protected void setCurrentColumnValue(String currentColumnValue) {
        this.currentColumnValue = currentColumnValue;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        LightTable lightTableCopy = (LightTable)component;
        lightTableCopy.setPropertyName(this.getPropertyName());
        if (this.bindingInfo != null) {
            lightTableCopy.setBindingInfo((BindingInfo)this.getBindingInfo().copy());
        }
        if (this.headerLabels != null) {
            ArrayList<Label> headerLabelsCopy = new ArrayList<Label>();
            for (Label label : this.headerLabels) {
                if (label == null) continue;
                headerLabelsCopy.add((Label)label.copy());
            }
            lightTableCopy.setHeaderLabels(headerLabelsCopy);
        }
        if (this.getRichTable() != null) {
            lightTableCopy.setRichTable((RichTable)this.getRichTable().copy());
        }
        if (this.expressionConversionMap != null) {
            HashMap<String, String> expressionConversionMapCopy = new HashMap<String, String>();
            for (Map.Entry entry : this.expressionConversionMap.entrySet()) {
                expressionConversionMapCopy.put(entry.getKey().toString(), entry.getValue().toString());
            }
            lightTableCopy.setExpressionConversionMap(expressionConversionMapCopy);
        }
        if (this.renderIdExpressionMap != null) {
            HashMap<String, String> renderIdExpressionMapCopy = new HashMap<String, String>();
            for (Map.Entry entry : this.renderIdExpressionMap.entrySet()) {
                renderIdExpressionMapCopy.put(entry.getKey().toString(), entry.getValue().toString());
            }
            lightTableCopy.setRenderIdExpressionMap(renderIdExpressionMapCopy);
        }
        if (this.initialComponentIds != null) {
            lightTableCopy.setInitialComponentIds(new ArrayList<String>(this.initialComponentIds));
        }
        if (this.conditionalRowCssClasses != null) {
            lightTableCopy.setConditionalRowCssClasses(new HashMap<String, String>(this.conditionalRowCssClasses));
        }
        lightTableCopy.setEmptyTable(this.isEmptyTable());
        lightTableCopy.setCurrentColumnValue(this.currentColumnValue);
    }
}

