/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.QuickFinder;

@BeanTag(name="kimGroupControl-bean", parent="Uif-KimGroupControl")
public class GroupControl
extends TextControl
implements FilterableLookupCriteriaControl {
    private static final long serialVersionUID = 5598459655735440981L;
    private String namespaceCodePropertyName;
    private String groupIdPropertyName;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (!(parent instanceof InputField)) {
            return;
        }
        InputField field = (InputField)parent;
        if (StringUtils.isNotBlank((String)this.groupIdPropertyName)) {
            field.getAdditionalHiddenPropertyNames().add(this.groupIdPropertyName);
        }
        this.buildGroupQuickfinder(view, model, field);
    }

    protected void buildGroupQuickfinder(View view, Object model, InputField field) {
        QuickFinder quickFinder = field.getQuickfinder();
        if (quickFinder != null && !quickFinder.isRender()) {
            return;
        }
        boolean quickfinderCreated = false;
        if (quickFinder == null) {
            quickFinder = ComponentFactory.getQuickFinder();
            view.assignComponentIds(quickFinder);
            field.setQuickfinder(quickFinder);
            quickfinderCreated = true;
        }
        if (field.getQuickfinder() != null) {
            if (StringUtils.isBlank((String)field.getQuickfinder().getDataObjectClassName())) {
                field.getQuickfinder().setDataObjectClassName("org.kuali.rice.kim.impl.group.GroupBo");
            }
            if (field.getQuickfinder().getFieldConversions().isEmpty()) {
                if (StringUtils.isNotBlank((String)this.groupIdPropertyName)) {
                    field.getQuickfinder().getFieldConversions().put("id", this.groupIdPropertyName);
                }
                field.getQuickfinder().getFieldConversions().put("name", field.getPropertyName());
                if (StringUtils.isNotBlank((String)this.namespaceCodePropertyName)) {
                    field.getQuickfinder().getFieldConversions().put("namespaceCode", this.namespaceCodePropertyName);
                }
            }
            if (field.getQuickfinder().getLookupParameters().isEmpty() && StringUtils.isNotBlank((String)this.namespaceCodePropertyName)) {
                field.getQuickfinder().getLookupParameters().put(this.namespaceCodePropertyName, "namespaceCode");
            }
        }
        if (quickfinderCreated) {
            view.getViewHelperService().spawnSubLifecyle(view, model, quickFinder, field, "INITIALIZE", "APPLY_MODEL");
        }
    }

    @BeanTagAttribute(name="namespaceCodePropertyName")
    public String getNamespaceCodePropertyName() {
        return this.namespaceCodePropertyName;
    }

    public void setNamespaceCodePropertyName(String namespaceCodePropertyName) {
        this.namespaceCodePropertyName = namespaceCodePropertyName;
    }

    @BeanTagAttribute(name="groupIdPropertyName")
    public String getGroupIdPropertyName() {
        return this.groupIdPropertyName;
    }

    public void setGroupIdPropertyName(String groupIdPropertyName) {
        this.groupIdPropertyName = groupIdPropertyName;
    }

    @Override
    public Map<String, String> filterSearchCriteria(String propertyName, Map<String, String> searchCriteria) {
        HashMap<String, String> filteredSearchCriteria = new HashMap<String, String>(searchCriteria);
        String groupName = searchCriteria.get(propertyName);
        String groupNamespaceCd = searchCriteria.get(this.namespaceCodePropertyName);
        if (StringUtils.isNotBlank((String)groupName) && StringUtils.isNotBlank((String)groupNamespaceCd)) {
            Group group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(groupNamespaceCd, groupName);
            if (group == null) {
                return null;
            }
            filteredSearchCriteria.put(this.groupIdPropertyName, group.getId());
        }
        filteredSearchCriteria.remove(propertyName);
        filteredSearchCriteria.remove(this.namespaceCodePropertyName);
        return filteredSearchCriteria;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        GroupControl groupControlCopy = (GroupControl)component;
        groupControlCopy.setNamespaceCodePropertyName(this.namespaceCodePropertyName);
        groupControlCopy.setGroupIdPropertyName(this.groupIdPropertyName);
    }
}

