/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.util.KeyMessage;
import org.kuali.rice.krad.uif.util.UifKeyValueLocation;
import org.kuali.rice.krad.uif.util.UrlInfo;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

public abstract class MultiValueControlBase
extends ControlBase
implements MultiValueControl {
    private static final long serialVersionUID = -8691367056245775455L;
    private List<KeyValue> options;
    private List<KeyMessage> richOptions;
    private List<Component> inlineComponents;
    private boolean locationSelect = false;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.options != null && this.richOptions == null) {
            this.richOptions = new ArrayList<KeyMessage>();
            for (KeyValue option : this.options) {
                Message message = ComponentFactory.getMessage();
                view.assignComponentIds(message);
                message.setMessageText(option.getValue());
                message.setInlineComponents(this.inlineComponents);
                message.setGenerateSpan(false);
                view.getViewHelperService().performComponentInitialization(view, model, message);
                this.richOptions.add(new KeyMessage(option.getKey(), option.getValue(), message));
            }
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        if (this.options != null && !this.options.isEmpty()) {
            for (KeyValue option : this.options) {
                if (!(option instanceof UifKeyValueLocation)) continue;
                this.locationSelect = true;
                UrlInfo url = ((UifKeyValueLocation)option).getLocation();
                ExpressionUtils.populatePropertyExpressionsFromGraph(url, false);
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, url, view.getContext());
            }
        }
        if (this.richOptions == null || this.richOptions.isEmpty()) {
            return;
        }
        for (KeyMessage richOption : this.richOptions) {
            List<Component> components = richOption.getMessage().getMessageComponentStructure();
            if (components == null || components.isEmpty()) continue;
            for (Component c : components) {
                if (!(c instanceof Container) && !(c instanceof InputField)) continue;
                c.addDataAttribute("parent", parent.getId());
            }
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        if (this.richOptions != null) {
            for (KeyMessage richOption : this.richOptions) {
                components.add(richOption.getMessage());
            }
        }
        return components;
    }

    @Override
    @BeanTagAttribute(name="options", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<KeyValue> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(List<KeyValue> options) {
        this.options = options;
    }

    @BeanTagAttribute(name="inlineComponents", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public List<KeyMessage> getRichOptions() {
        return this.richOptions;
    }

    public void setRichOptions(List<KeyMessage> richOptions) {
        this.richOptions = richOptions;
    }

    public boolean isLocationSelect() {
        return this.locationSelect;
    }

    protected void setLocationSelect(boolean locationSelect) {
        this.locationSelect = locationSelect;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        MultiValueControlBase multiValueControlBaseCopy = (MultiValueControlBase)component;
        try {
            if (this.options != null) {
                ArrayList<KeyValue> optionsCopy = new ArrayList<KeyValue>();
                for (KeyValue option : this.options) {
                    KeyValue keyValue = null;
                    if (option != null) {
                        Class<?> optionClass = option.getClass();
                        keyValue = (KeyValue)optionClass.getDeclaredConstructor(String.class, String.class).newInstance(option.getKey(), option.getValue());
                        if (keyValue instanceof UifKeyValueLocation) {
                            ((UifKeyValueLocation)keyValue).setLocation((UrlInfo)((UifKeyValueLocation)option).getLocation().copy());
                        }
                    }
                    optionsCopy.add(keyValue);
                }
                multiValueControlBaseCopy.setOptions(optionsCopy);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy options in MultiValueControlBase", e);
        }
        if (this.richOptions != null) {
            ArrayList<KeyMessage> richOptionsCopy = new ArrayList<KeyMessage>();
            for (KeyMessage richOption : this.richOptions) {
                KeyMessage keyMessage = new KeyMessage(richOption.getKey(), richOption.getValue(), richOption.getMessage());
                richOptionsCopy.add(keyMessage);
            }
            multiValueControlBaseCopy.setRichOptions(richOptionsCopy);
        }
        if (this.inlineComponents != null) {
            ArrayList<Component> inlineComponentsCopy = new ArrayList<Component>();
            for (Component inlineComponent : this.inlineComponents) {
                inlineComponentsCopy.add((Component)inlineComponent.copy());
            }
            multiValueControlBaseCopy.setInlineComponents(inlineComponentsCopy);
        }
        multiValueControlBaseCopy.setLocationSelect(this.locationSelect);
    }
}

