/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="textAreaControl-bean", parent="Uif-TextAreaControl"), @BeanTag(name="smallTextAreaControl-bean", parent="Uif-SmallTextAreaControl"), @BeanTag(name="mediumTextAreaControl-bean", parent="Uif-MediumTextAreaControl"), @BeanTag(name="largeTextAreaControl-bean", parent="Uif-LargeTextAreaControl")})
public class TextAreaControl
extends ControlBase {
    private static final long serialVersionUID = -4664558047325456844L;
    private int rows;
    private int cols;
    private Integer maxLength;
    private Integer minLength;
    private boolean textExpand;
    private String watermarkText = "";

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (parent instanceof InputField) {
            InputField field = (InputField)parent;
            if (this.getMaxLength() == null) {
                this.setMaxLength(field.getMaxLength());
            }
            if (this.getMinLength() == null) {
                this.setMinLength(field.getMinLength());
            }
        }
    }

    @BeanTagAttribute(name="rows")
    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    @BeanTagAttribute(name="cols")
    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    @BeanTagAttribute(name="maxLength")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @BeanTagAttribute(name="minLength")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    @BeanTagAttribute(name="watermarkText")
    public String getWatermarkText() {
        return this.watermarkText;
    }

    public void setWatermarkText(String watermarkText) {
        if (StringUtils.isNotEmpty((String)watermarkText)) {
            watermarkText = watermarkText + "   ";
        }
        this.watermarkText = watermarkText;
    }

    @BeanTagAttribute(name="textExpand")
    public boolean isTextExpand() {
        return this.textExpand;
    }

    public void setTextExpand(boolean textExpand) {
        this.textExpand = textExpand;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        TextAreaControl textAreaControlCopy = (TextAreaControl)component;
        textAreaControlCopy.setRows(this.rows);
        textAreaControlCopy.setCols(this.cols);
        textAreaControlCopy.setMaxLength(this.maxLength);
        textAreaControlCopy.setMinLength(this.minLength);
        textAreaControlCopy.setTextExpand(this.textExpand);
        textAreaControlCopy.setWatermarkText(this.watermarkText);
    }
}

