/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.control.SizedControl;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.DatePicker;

@BeanTags(value={@BeanTag(name="textControl-bean", parent="Uif-TextControl"), @BeanTag(name="smallTextControl-bean", parent="Uif-SmallTextControl"), @BeanTag(name="mediumTextControl-bean", parent="Uif-MediumTextControl"), @BeanTag(name="largeTextControl-bean", parent="Uif-LargeTextControl"), @BeanTag(name="currencyTextControl-bean", parent="Uif-CurrencyTextControl"), @BeanTag(name="dateControl-bean", parent="Uif-DateControl")})
public class TextControl
extends ControlBase
implements SizedControl {
    private static final long serialVersionUID = -8267606288443759880L;
    private int size;
    private Integer maxLength;
    private Integer minLength;
    private DatePicker datePicker;
    private String watermarkText = "";
    private boolean textExpand;

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.datePicker);
        return components;
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (parent instanceof InputField) {
            InputField field = (InputField)parent;
            if (this.getMaxLength() == null) {
                this.setMaxLength(field.getMaxLength());
            }
            if (this.getMinLength() == null) {
                this.setMinLength(field.getMinLength());
            }
        }
    }

    @Override
    @BeanTagAttribute(name="size")
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @BeanTagAttribute(name="maxLength")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @BeanTagAttribute(name="minLength")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    @BeanTagAttribute(name="datePicker", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    public void setDatePicker(DatePicker datePicker) {
        this.datePicker = datePicker;
    }

    @BeanTagAttribute(name="watermarkText")
    public String getWatermarkText() {
        return this.watermarkText;
    }

    public void setWatermarkText(String watermarkText) {
        if (StringUtils.isNotEmpty((String)watermarkText)) {
            watermarkText = watermarkText + "   ";
        }
        this.watermarkText = watermarkText;
    }

    @BeanTagAttribute(name="textExpand")
    public boolean isTextExpand() {
        return this.textExpand;
    }

    public void setTextExpand(boolean textExpand) {
        this.textExpand = textExpand;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        TextControl textControlCopy = (TextControl)component;
        textControlCopy.setSize(this.size);
        textControlCopy.setMaxLength(this.maxLength);
        textControlCopy.setMinLength(this.minLength);
        if (this.datePicker != null) {
            textControlCopy.setDatePicker((DatePicker)this.datePicker.copy());
        }
        textControlCopy.setWatermarkText(this.watermarkText);
        textControlCopy.setTextExpand(this.textExpand);
    }
}

