/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.element.ActionSecurity;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTags(value={@BeanTag(name="action-bean", parent="Uif-Action"), @BeanTag(name="actionImage-bean", parent="Uif-ActionImage"), @BeanTag(name="primaryActionButton-bean", parent="Uif-PrimaryActionButton"), @BeanTag(name="secondaryActionButton-bean", parent="Uif-SecondaryActionButton"), @BeanTag(name="primaryActionButton-small-bean", parent="Uif-PrimaryActionButton-Small"), @BeanTag(name="secondaryActionButton-small-bean", parent="Uif-SecondaryActionButton-Small"), @BeanTag(name="actionLink-bean", parent="Uif-ActionLink"), @BeanTag(name="navigationActionLink-bean", parent="Uif-NavigationActionLink"), @BeanTag(name="navigationActionButton-bean", parent="Uif-NavigationActionButton"), @BeanTag(name="secondaryNavigationActionButton-bean", parent="Uif-SecondaryNavigationActionButton"), @BeanTag(name="helpAction-bean", parent="Uif-HelpAction"), @BeanTag(name="saveAction-bean", parent="Uif-SaveAction"), @BeanTag(name="backAction-bean", parent="Uif-BackAction"), @BeanTag(name="cancelAction-bean", parent="Uif-CancelAction"), @BeanTag(name="checkFormAction-bean", parent="Uif-CheckFormAction"), @BeanTag(name="addLineAction-bean", parent="Uif-AddLineAction"), @BeanTag(name="deleteLineAction-bean", parent="Uif-DeleteLineAction"), @BeanTag(name="saveLineAction-bean", parent="Uif-SaveLineAction"), @BeanTag(name="addBlankLineAction-bean", parent="Uif-AddBlankLineAction"), @BeanTag(name="addViaLightBoxAction-bean", parent="Uif-AddViaLightBoxAction"), @BeanTag(name="toggleRowDetailsAction-bean", parent="Uif-ToggleRowDetailsAction"), @BeanTag(name="expandDetailsAction-bean", parent="Uif-ExpandDetailsAction"), @BeanTag(name="expandDetailsImageAction-bean", parent="Uif-ExpandDetailsImageAction"), @BeanTag(name="jumpToTopLink-bean", parent="Uif-JumpToTopLink"), @BeanTag(name="jumpToBottomLink-bean", parent="Uif-JumpToBottomLink"), @BeanTag(name="expandDisclosuresButton-bean", parent="Uif-ExpandDisclosuresButton"), @BeanTag(name="collapseDisclosuresButton-bean", parent="Uif-CollapseDisclosuresButton"), @BeanTag(name="showInactiveCollectionItemsButton-bean", parent="Uif-ShowInactiveCollectionItemsButton"), @BeanTag(name="hideInactiveCollectionItemsButton-bean", parent="Uif-HideInactiveCollectionItemsButton"), @BeanTag(name="collectionQuickFinderAction-bean", parent="Uif-CollectionQuickFinderAction")})
public class Action
extends ContentElementBase {
    private static final long serialVersionUID = 1025672792657238829L;
    private String methodToCall;
    private String actionEvent;
    private String navigateToPageId;
    private String actionScript;
    private String actionLabel;
    private Image actionImage;
    private String actionImagePlacement = UifConstants.Position.LEFT.name();
    private String jumpToIdAfterSubmit;
    private String jumpToNameAfterSubmit;
    private String focusOnIdAfterSubmit;
    private boolean performClientSideValidation;
    private boolean performDirtyValidation;
    private boolean clearDirtyOnAction;
    private boolean dirtyOnAction;
    private String preSubmitCall = "";
    private boolean ajaxSubmit = true;
    private String ajaxReturnType;
    private String refreshId;
    private String refreshPropertyName;
    private String successCallback = "";
    private String errorCallback = "";
    private String loadingMessageText;
    private boolean disableBlocking;
    private Map<String, String> additionalSubmitData = new HashMap<String, String>();
    private Map<String, String> actionParameters = new HashMap<String, String>();
    private boolean evaluateDisabledOnKeyUp;
    private boolean disabled = false;
    private String disabledReason;
    private String disabledExpression;
    private String disabledConditionJs;
    private List<String> disabledConditionControlNames;
    private List<String> disabledWhenChangedPropertyNames = new ArrayList<String>();
    private List<String> enabledWhenChangedPropertyNames = new ArrayList<String>();

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        this.disabledExpression = this.getPropertyExpression("disabled");
        if (this.disabledExpression != null) {
            ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
            this.disabledExpression = expressionEvaluator.replaceBindingPrefixes(view, this, this.disabledExpression);
            this.disabled = (Boolean)expressionEvaluator.evaluateExpression(this.getContext(), this.disabledExpression);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        if (StringUtils.isNotEmpty((String)this.disabledExpression) && !this.disabledExpression.equalsIgnoreCase("true") && !this.disabledExpression.equalsIgnoreCase("false")) {
            this.disabledConditionControlNames = new ArrayList<String>();
            this.disabledConditionJs = ExpressionUtils.parseExpression(this.disabledExpression, this.disabledConditionControlNames);
        }
        ArrayList<String> adjustedDisablePropertyNames = new ArrayList<String>();
        for (String propertyName : this.disabledWhenChangedPropertyNames) {
            adjustedDisablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, propertyName));
        }
        this.disabledWhenChangedPropertyNames = adjustedDisablePropertyNames;
        ArrayList<String> adjustedEnablePropertyNames = new ArrayList<String>();
        for (String propertyName : this.enabledWhenChangedPropertyNames) {
            adjustedEnablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, propertyName));
        }
        this.enabledWhenChangedPropertyNames = adjustedEnablePropertyNames;
        if (this.actionImage != null && StringUtils.isNotBlank((String)this.actionImagePlacement) && StringUtils.isNotBlank((String)this.actionLabel)) {
            this.actionImage.setAltText("");
        }
        if (!this.actionParameters.containsKey("actionEvent") && StringUtils.isNotBlank((String)this.actionEvent)) {
            this.actionParameters.put("actionEvent", this.actionEvent);
        }
        if (StringUtils.isNotBlank((String)this.navigateToPageId)) {
            this.actionParameters.put("navigateToPageId", this.navigateToPageId);
            if (StringUtils.isBlank((String)this.methodToCall)) {
                this.methodToCall = "navigate";
            }
        }
        if (!this.actionParameters.containsKey("methodToCall") && StringUtils.isNotBlank((String)this.methodToCall)) {
            this.actionParameters.put("methodToCall", this.methodToCall);
        }
        this.setupRefreshAction(view);
        this.buildActionData(view, model, parent);
        String onClickScript = this.getOnClickScript();
        onClickScript = StringUtils.isNotBlank((String)this.actionScript) ? ScriptUtils.appendScript(onClickScript, this.actionScript) : ScriptUtils.appendScript(onClickScript, "actionInvokeHandler(this);");
        if (view instanceof FormView && ((FormView)view).isApplyDirtyCheck() && this.performDirtyValidation) {
            onClickScript = "if (dirtyFormState.checkDirty(e) == false) { " + onClickScript + " ; } ";
        }
        if (this.disabled) {
            this.addStyleClass("disabled");
            this.setSkipInTabOrder(true);
        }
        onClickScript = "if(jQuery(this).hasClass('disabled')){ return false; }" + onClickScript;
        this.addDataAttribute("onclick", KRADUtils.convertToHTMLAttributeSafeString("e.preventDefault();" + onClickScript));
    }

    protected void setupRefreshAction(View view) {
        Component component;
        if (StringUtils.isNotBlank((String)this.refreshPropertyName) || StringUtils.isNotBlank((String)this.refreshId)) {
            this.ajaxReturnType = UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey();
        }
        Component refreshComponent = null;
        if (StringUtils.isNotBlank((String)this.refreshPropertyName)) {
            if (this.refreshPropertyName.startsWith("#form.")) {
                this.refreshPropertyName = StringUtils.removeStart((String)this.refreshPropertyName, (String)"#form.");
            } else if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath())) {
                this.refreshPropertyName = view.getDefaultBindingObjectPath() + "." + this.refreshPropertyName;
            }
            DataField dataField = view.getViewIndex().getDataFieldByPath(this.refreshPropertyName);
            if (dataField != null) {
                refreshComponent = dataField;
                this.refreshId = refreshComponent.getId();
            }
        } else if (StringUtils.isNotBlank((String)this.refreshId) && (component = view.getViewIndex().getComponentById(this.refreshId)) != null) {
            refreshComponent = component;
        }
        if (refreshComponent != null) {
            refreshComponent.setRefreshedByAction(true);
            Component initialComponent = view.getViewIndex().getInitialComponentStates().get(refreshComponent.getBaseId());
            if (initialComponent != null) {
                initialComponent.setRefreshedByAction(true);
                view.getViewIndex().getInitialComponentStates().put(refreshComponent.getBaseId(), initialComponent);
            }
        }
    }

    protected void buildActionData(View view, Object model, Component parent) {
        this.addDataAttribute("ajaxsubmit", Boolean.toString(this.ajaxSubmit));
        this.addDataAttributeIfNonEmpty("successcallback", this.successCallback);
        this.addDataAttributeIfNonEmpty("errorcallback", this.errorCallback);
        this.addDataAttributeIfNonEmpty("presubmitcall", this.preSubmitCall);
        this.addDataAttributeIfNonEmpty("loadingmessage", this.loadingMessageText);
        this.addDataAttributeIfNonEmpty("disableblocking", Boolean.toString(this.disableBlocking));
        this.addDataAttributeIfNonEmpty("ajaxreturntype", this.ajaxReturnType);
        this.addDataAttributeIfNonEmpty("refreshid", this.refreshId);
        this.addDataAttribute("validate", Boolean.toString(this.performClientSideValidation));
        this.addDataAttribute("dirtyOnAction", Boolean.toString(this.dirtyOnAction));
        this.addDataAttribute("clearDirtyOnAction", Boolean.toString(this.clearDirtyOnAction));
        HashMap<String, String> submitData = new HashMap<String, String>();
        Iterator<String> i$ = this.actionParameters.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            String parameterPath = key = i$.next();
            if (!key.equals("methodToCall")) {
                parameterPath = "actionParameters[" + key + "]";
            }
            submitData.put(parameterPath, this.actionParameters.get(key));
        }
        for (String key : this.additionalSubmitData.keySet()) {
            submitData.put(key, this.additionalSubmitData.get(key));
        }
        if (this.focusOnIdAfterSubmit == null) {
            this.focusOnIdAfterSubmit = UifConstants.Order.SELF.toString();
        }
        if (this.focusOnIdAfterSubmit.equalsIgnoreCase(UifConstants.Order.SELF.toString())) {
            this.focusOnIdAfterSubmit = this.getId();
            submitData.put("focusId", this.focusOnIdAfterSubmit);
        } else if (this.focusOnIdAfterSubmit.equalsIgnoreCase(UifConstants.Order.NEXT_INPUT.toString())) {
            this.focusOnIdAfterSubmit = UifConstants.Order.NEXT_INPUT.toString() + ":" + this.getId();
            submitData.put("focusId", this.focusOnIdAfterSubmit);
        } else {
            submitData.put("focusId", this.focusOnIdAfterSubmit);
        }
        if (StringUtils.isBlank((String)this.jumpToIdAfterSubmit) && StringUtils.isBlank((String)this.jumpToNameAfterSubmit)) {
            this.jumpToIdAfterSubmit = this.getId();
            submitData.put("jumpToId", this.jumpToIdAfterSubmit);
        } else if (StringUtils.isNotBlank((String)this.jumpToIdAfterSubmit)) {
            submitData.put("jumpToId", this.jumpToIdAfterSubmit);
        } else {
            submitData.put("jumpToName", this.jumpToNameAfterSubmit);
        }
        this.addDataAttribute("submit_data", ScriptUtils.toJSON(submitData));
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.actionImage);
        return components;
    }

    @BeanTagAttribute(name="methodToCall")
    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    @BeanTagAttribute(name="actionLabel")
    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    @BeanTagAttribute(name="actionImage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Image getActionImage() {
        return this.actionImage;
    }

    public void setActionImage(Image actionImage) {
        this.actionImage = actionImage;
    }

    @BeanTagAttribute(name="navigateToPageId")
    public String getNavigateToPageId() {
        return this.navigateToPageId;
    }

    public void setNavigateToPageId(String navigateToPageId) {
        this.navigateToPageId = navigateToPageId;
    }

    @BeanTagAttribute(name="actionEvent")
    public String getActionEvent() {
        return this.actionEvent;
    }

    public void setActionEvent(String actionEvent) {
        this.actionEvent = actionEvent;
    }

    @BeanTagAttribute(name="additionalSubmitData", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getAdditionalSubmitData() {
        return this.additionalSubmitData;
    }

    public void setAdditionalSubmitData(Map<String, String> additionalSubmitData) {
        this.additionalSubmitData = additionalSubmitData;
    }

    @BeanTagAttribute(name="actionParameters", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getActionParameters() {
        return this.actionParameters;
    }

    public void setActionParameters(Map<String, String> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public void addActionParameter(String parameterName, String parameterValue) {
        if (this.actionParameters == null) {
            this.actionParameters = new HashMap<String, String>();
        }
        this.actionParameters.put(parameterName, parameterValue);
    }

    public String getActionParameter(String parameterName) {
        return this.actionParameters.get(parameterName);
    }

    public ActionSecurity getActionSecurity() {
        return (ActionSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof ActionSecurity)) {
            throw new RiceRuntimeException("Component security for Action should be instance of ActionSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return ActionSecurity.class;
    }

    @BeanTagAttribute(name="jumpToIdAfterSubmit")
    public String getJumpToIdAfterSubmit() {
        return this.jumpToIdAfterSubmit;
    }

    public void setJumpToIdAfterSubmit(String jumpToIdAfterSubmit) {
        this.jumpToIdAfterSubmit = jumpToIdAfterSubmit;
    }

    @BeanTagAttribute(name="jumpToNameAfterSubmit")
    public String getJumpToNameAfterSubmit() {
        return this.jumpToNameAfterSubmit;
    }

    public void setJumpToNameAfterSubmit(String jumpToNameAfterSubmit) {
        this.jumpToNameAfterSubmit = jumpToNameAfterSubmit;
    }

    @BeanTagAttribute(name="focusOnIdAfterSubmit")
    public String getFocusOnIdAfterSubmit() {
        return this.focusOnIdAfterSubmit;
    }

    public void setFocusOnIdAfterSubmit(String focusOnIdAfterSubmit) {
        this.focusOnIdAfterSubmit = focusOnIdAfterSubmit;
    }

    @BeanTagAttribute(name="performClientSideValidation")
    public boolean isPerformClientSideValidation() {
        return this.performClientSideValidation;
    }

    public void setPerformClientSideValidation(boolean performClientSideValidation) {
        this.performClientSideValidation = performClientSideValidation;
    }

    @BeanTagAttribute(name="actionScript")
    public String getActionScript() {
        return this.actionScript;
    }

    public void setActionScript(String actionScript) {
        if (StringUtils.isNotBlank((String)actionScript) && !StringUtils.endsWith((String)actionScript, (String)";")) {
            actionScript = actionScript + ";";
        }
        this.actionScript = actionScript;
    }

    public void setPerformDirtyValidation(boolean performDirtyValidation) {
        this.performDirtyValidation = performDirtyValidation;
    }

    @BeanTagAttribute(name="performDirtyValidation")
    public boolean isPerformDirtyValidation() {
        return this.performDirtyValidation;
    }

    @BeanTagAttribute(name="clearDirtyOnAction")
    public boolean isClearDirtyOnAction() {
        return this.clearDirtyOnAction;
    }

    public void setClearDirtyOnAction(boolean clearDirtyOnAction) {
        this.clearDirtyOnAction = clearDirtyOnAction;
    }

    @BeanTagAttribute(name="dirtyOnAction")
    public boolean isDirtyOnAction() {
        return this.dirtyOnAction;
    }

    public void setDirtyOnAction(boolean dirtyOnAction) {
        this.dirtyOnAction = dirtyOnAction;
    }

    @BeanTagAttribute(name="disabled")
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @BeanTagAttribute(name="disabledReason")
    public String getDisabledReason() {
        return this.disabledReason;
    }

    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    @BeanTagAttribute(name="actionImagePlacement")
    public String getActionImagePlacement() {
        return this.actionImagePlacement;
    }

    public void setActionImagePlacement(String actionImagePlacement) {
        this.actionImagePlacement = actionImagePlacement;
    }

    @BeanTagAttribute(name="preSubmitCall")
    public String getPreSubmitCall() {
        return this.preSubmitCall;
    }

    public void setPreSubmitCall(String preSubmitCall) {
        this.preSubmitCall = preSubmitCall;
    }

    @BeanTagAttribute(name="ajaxSubmit")
    public boolean isAjaxSubmit() {
        return this.ajaxSubmit;
    }

    public void setAjaxSubmit(boolean ajaxSubmit) {
        this.ajaxSubmit = ajaxSubmit;
    }

    @BeanTagAttribute(name="ajaxReturnType")
    public String getAjaxReturnType() {
        return this.ajaxReturnType;
    }

    public void setAjaxReturnType(String ajaxReturnType) {
        this.ajaxReturnType = ajaxReturnType;
    }

    @BeanTagAttribute(name="displayResponseInLightBox")
    public boolean isDisplayResponseInLightBox() {
        return StringUtils.equals((String)this.ajaxReturnType, (String)UifConstants.AjaxReturnTypes.DISPLAYLIGHTBOX.getKey());
    }

    public void setDisplayResponseInLightBox(boolean displayResponseInLightBox) {
        if (displayResponseInLightBox) {
            this.ajaxReturnType = UifConstants.AjaxReturnTypes.DISPLAYLIGHTBOX.getKey();
        } else if (StringUtils.equals((String)this.ajaxReturnType, (String)UifConstants.AjaxReturnTypes.DISPLAYLIGHTBOX.getKey())) {
            this.ajaxReturnType = UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey();
        }
    }

    @BeanTagAttribute(name="successCallback")
    public String getSuccessCallback() {
        return this.successCallback;
    }

    public void setSuccessCallback(String successCallback) {
        this.successCallback = successCallback;
    }

    @BeanTagAttribute(name="errorCallback")
    public String getErrorCallback() {
        return this.errorCallback;
    }

    public void setErrorCallback(String errorCallback) {
        this.errorCallback = errorCallback;
    }

    @BeanTagAttribute(name="refreshId")
    public String getRefreshId() {
        return this.refreshId;
    }

    public void setRefreshId(String refreshId) {
        this.refreshId = refreshId;
    }

    @BeanTagAttribute(name="refreshPropertyName")
    public String getRefreshPropertyName() {
        return this.refreshPropertyName;
    }

    public void setRefreshPropertyName(String refreshPropertyName) {
        this.refreshPropertyName = refreshPropertyName;
    }

    @BeanTagAttribute(name="loadingMessageText")
    public String getLoadingMessageText() {
        return this.loadingMessageText;
    }

    public void setLoadingMessageText(String loadingMessageText) {
        this.loadingMessageText = loadingMessageText;
    }

    @BeanTagAttribute(name="disableBlocking")
    public boolean isDisableBlocking() {
        return this.disableBlocking;
    }

    public void setDisableBlocking(boolean disableBlocking) {
        this.disableBlocking = disableBlocking;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getActionLabel() == null && this.getActionImage() == null) {
            currentValues = new String[]{"actionLabel =" + this.getActionLabel(), "actionImage =" + this.getActionImage()};
            tracer.createError("ActionLabel and/or actionImage must be set", currentValues);
        }
        if (this.getJumpToIdAfterSubmit() != null && this.getJumpToNameAfterSubmit() != null) {
            currentValues = new String[]{"jumpToIdAfterSubmit =" + this.getJumpToIdAfterSubmit(), "jumpToNameAfterSubmit =" + this.getJumpToNameAfterSubmit()};
            tracer.createWarning("Only 1 jumpTo property should be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @BeanTagAttribute(name="evaluateDisabledOnKeyUp")
    public boolean isEvaluateDisabledOnKeyUp() {
        return this.evaluateDisabledOnKeyUp;
    }

    public void setEvaluateDisabledOnKeyUp(boolean evaluateDisabledOnKeyUp) {
        this.evaluateDisabledOnKeyUp = evaluateDisabledOnKeyUp;
    }

    public String getDisabledConditionJs() {
        return this.disabledConditionJs;
    }

    protected void setDisabledConditionJs(String disabledConditionJs) {
        this.disabledConditionJs = disabledConditionJs;
    }

    public List<String> getDisabledConditionControlNames() {
        return this.disabledConditionControlNames;
    }

    public void setDisabledConditionControlNames(List<String> disabledConditionControlNames) {
        this.disabledConditionControlNames = disabledConditionControlNames;
    }

    @BeanTagAttribute(name="disabledWhenChangedPropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getDisabledWhenChangedPropertyNames() {
        return this.disabledWhenChangedPropertyNames;
    }

    public void setDisabledWhenChangedPropertyNames(List<String> disabledWhenChangedPropertyNames) {
        this.disabledWhenChangedPropertyNames = disabledWhenChangedPropertyNames;
    }

    @BeanTagAttribute(name="enabledWhenChangedPropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getEnabledWhenChangedPropertyNames() {
        return this.enabledWhenChangedPropertyNames;
    }

    public void setEnabledWhenChangedPropertyNames(List<String> enabledWhenChangedPropertyNames) {
        this.enabledWhenChangedPropertyNames = enabledWhenChangedPropertyNames;
    }

    protected void setDisabledExpression(String disabledExpression) {
        this.disabledExpression = disabledExpression;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Action actionCopy = (Action)component;
        actionCopy.setActionEvent(this.actionEvent);
        if (this.actionImage != null) {
            actionCopy.setActionImage((Image)this.actionImage.copy());
        }
        actionCopy.setActionImagePlacement(this.actionImagePlacement);
        actionCopy.setActionLabel(this.actionLabel);
        if (this.actionParameters != null) {
            actionCopy.setActionParameters(new HashMap<String, String>(this.actionParameters));
        }
        if (this.additionalSubmitData != null) {
            actionCopy.setAdditionalSubmitData(new HashMap<String, String>(this.additionalSubmitData));
        }
        actionCopy.setActionScript(this.actionScript);
        actionCopy.setAjaxReturnType(this.ajaxReturnType);
        actionCopy.setAjaxSubmit(this.ajaxSubmit);
        actionCopy.setClearDirtyOnAction(this.clearDirtyOnAction);
        actionCopy.setDirtyOnAction(this.dirtyOnAction);
        actionCopy.setDisableBlocking(this.disableBlocking);
        actionCopy.setDisabled(this.disabled);
        actionCopy.setDisabledConditionJs(this.disabledConditionJs);
        if (this.disabledConditionControlNames != null) {
            actionCopy.setDisabledConditionControlNames(new ArrayList<String>(this.disabledConditionControlNames));
        }
        actionCopy.setDisabledExpression(this.disabledExpression);
        actionCopy.setDisabledReason(this.disabledReason);
        if (this.disabledWhenChangedPropertyNames != null) {
            actionCopy.setDisabledWhenChangedPropertyNames(new ArrayList<String>(this.disabledWhenChangedPropertyNames));
        }
        if (this.enabledWhenChangedPropertyNames != null) {
            actionCopy.setEnabledWhenChangedPropertyNames(new ArrayList<String>(this.enabledWhenChangedPropertyNames));
        }
        actionCopy.setErrorCallback(this.errorCallback);
        actionCopy.setEvaluateDisabledOnKeyUp(this.evaluateDisabledOnKeyUp);
        actionCopy.setFocusOnIdAfterSubmit(this.focusOnIdAfterSubmit);
        actionCopy.setJumpToIdAfterSubmit(this.jumpToIdAfterSubmit);
        actionCopy.setJumpToNameAfterSubmit(this.jumpToNameAfterSubmit);
        actionCopy.setLoadingMessageText(this.loadingMessageText);
        actionCopy.setMethodToCall(this.methodToCall);
        actionCopy.setNavigateToPageId(this.navigateToPageId);
        actionCopy.setPerformClientSideValidation(this.performClientSideValidation);
        actionCopy.setPerformDirtyValidation(this.performDirtyValidation);
        actionCopy.setPreSubmitCall(this.preSubmitCall);
        actionCopy.setRefreshId(this.refreshId);
        actionCopy.setRefreshPropertyName(this.refreshPropertyName);
        actionCopy.setSuccessCallback(this.successCallback);
    }
}

