/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="header-bean", parent="Uif-HeaderBase"), @BeanTag(name="headerOne-bean", parent="Uif-HeaderOne"), @BeanTag(name="headerTwo-bean", parent="Uif-HeaderTwo"), @BeanTag(name="headerThree-bean", parent="Uif-HeaderThree"), @BeanTag(name="headerFour-bean", parent="Uif-HeaderFour"), @BeanTag(name="headerFive-bean", parent="Uif-HeaderFive"), @BeanTag(name="headerSix-bean", parent="Uif-HeaderSix"), @BeanTag(name="pageHeader-bean", parent="Uif-PageHeader"), @BeanTag(name="sectionHeader-bean", parent="Uif-SectionHeader"), @BeanTag(name="subSectionHeader-bean", parent="Uif-SubSectionHeader"), @BeanTag(name="subCollectionHeader-bean", parent="Uif-SubCollectionHeader"), @BeanTag(name="editablePageHeader-bean", parent="Uif-EditablePageHeader"), @BeanTag(name="readOnlyPageHeader-bean", parent="Uif-ReadOnlyPageHeader"), @BeanTag(name="imageCaptionHeader-bean", parent="Uif-ImageCaptionHeader"), @BeanTag(name="documentViewHeader-bean", parent="Uif-DocumentViewHeader"), @BeanTag(name="lookupPageHeader-bean", parent="Uif-LookupPageHeader")})
public class Header
extends ContentElementBase {
    private static final long serialVersionUID = -6950408292923393244L;
    private String headerText;
    private String headerLevel;
    private String headerTagStyle;
    private List<String> headerTagCssClasses = new ArrayList<String>();
    private Message richHeaderMessage;
    private List<Component> inlineComponents;
    private Group upperGroup;
    private Group rightGroup;
    private Group lowerGroup;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.richHeaderMessage == null && this.headerText != null && this.headerText.contains("[") && this.headerText.contains("]")) {
            Message message = ComponentFactory.getMessage();
            view.assignComponentIds(message);
            message.setMessageText(this.headerText);
            message.setInlineComponents(this.inlineComponents);
            message.setGenerateSpan(false);
            view.getViewHelperService().performComponentInitialization(view, model, message);
            this.setRichHeaderMessage(message);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.getUpperGroup() != null && this.getUpperGroup().getItems().isEmpty()) {
            this.getUpperGroup().setRender(false);
        }
        if (this.getRightGroup() != null && this.getRightGroup().getItems().isEmpty()) {
            this.getRightGroup().setRender(false);
        }
        if (this.getLowerGroup() != null && this.getLowerGroup().getItems().isEmpty()) {
            this.getLowerGroup().setRender(false);
        }
        if (this.getUpperGroup() != null) {
            this.getUpperGroup().addStyleClass("uif-header-upperGroup");
        }
        if (this.getRightGroup() != null) {
            this.getRightGroup().addStyleClass("uif-header-rightGroup");
        }
        if (this.getLowerGroup() != null) {
            this.getLowerGroup().addStyleClass("uif-header-lowerGroup");
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.richHeaderMessage);
        components.add(this.upperGroup);
        components.add(this.rightGroup);
        components.add(this.lowerGroup);
        return components;
    }

    @BeanTagAttribute(name="headerText")
    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    @BeanTagAttribute(name="headerLevel")
    public String getHeaderLevel() {
        return this.headerLevel;
    }

    public void setHeaderLevel(String headerLevel) {
        this.headerLevel = headerLevel;
    }

    @BeanTagAttribute(name="headerTagCssClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getHeaderTagCssClasses() {
        return this.headerTagCssClasses;
    }

    public void setHeaderTagCssClasses(List<String> headerTagCssClasses) {
        this.headerTagCssClasses = headerTagCssClasses;
    }

    public String getHeaderStyleClassesAsString() {
        if (this.headerTagCssClasses != null) {
            return StringUtils.join(this.headerTagCssClasses, (String)" ");
        }
        return "";
    }

    @BeanTagAttribute(name="headerTagStyle")
    public String getHeaderTagStyle() {
        return this.headerTagStyle;
    }

    public void setHeaderTagStyle(String headerTagStyle) {
        this.headerTagStyle = headerTagStyle;
    }

    @BeanTagAttribute(name="upperGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getUpperGroup() {
        return this.upperGroup;
    }

    public void setUpperGroup(Group upperGroup) {
        this.upperGroup = upperGroup;
    }

    @BeanTagAttribute(name="rightGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getRightGroup() {
        return this.rightGroup;
    }

    public void setRightGroup(Group rightGroup) {
        this.rightGroup = rightGroup;
    }

    @BeanTagAttribute(name="lowerGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getLowerGroup() {
        return this.lowerGroup;
    }

    public void setLowerGroup(Group lowerGroup) {
        this.lowerGroup = lowerGroup;
    }

    @BeanTagAttribute(name="items", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<? extends Component> getItems() {
        if (this.lowerGroup != null) {
            return this.lowerGroup.getItems();
        }
        return null;
    }

    public void setItems(List<? extends Component> items) {
        if (this.lowerGroup != null) {
            this.lowerGroup.setItems(items);
        }
    }

    @BeanTagAttribute(name="richHeaderMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getRichHeaderMessage() {
        return this.richHeaderMessage;
    }

    public void setRichHeaderMessage(Message richHeaderMessage) {
        this.richHeaderMessage = richHeaderMessage;
    }

    @BeanTagAttribute(name="inlineComponents", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        String headerLevel = this.getHeaderLevel().toUpperCase();
        boolean correctHeaderLevel = false;
        if (headerLevel.compareTo("H1") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H2") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H3") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H4") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H5") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H6") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("LABEL") == 0) {
            correctHeaderLevel = true;
        }
        if (!correctHeaderLevel) {
            currentValues = new String[]{"headerLevel =" + this.getHeaderLevel()};
            tracer.createError("HeaderLevel must be of values h1, h2, h3, h4, h5, h6, or label", currentValues);
        }
        if (this.getHeaderText() == null && !Validator.checkExpressions(this, "headerText")) {
            currentValues = new String[]{"headertText =" + this.getHeaderText()};
            tracer.createWarning("HeaderText should be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Header headerCopy = (Header)component;
        headerCopy.setHeaderLevel(this.headerLevel);
        if (this.headerTagCssClasses != null) {
            headerCopy.setHeaderTagCssClasses(new ArrayList<String>(this.headerTagCssClasses));
        }
        headerCopy.setHeaderTagStyle(this.headerTagStyle);
        headerCopy.setHeaderText(this.headerText);
        if (this.inlineComponents != null) {
            ArrayList inlineComponents = Lists.newArrayListWithExpectedSize((int)this.inlineComponents.size());
            for (Component inlineComponent : this.inlineComponents) {
                inlineComponents.add((Component)inlineComponent.copy());
            }
            headerCopy.setInlineComponents(inlineComponents);
        }
        if (this.lowerGroup != null) {
            headerCopy.setLowerGroup((Group)this.lowerGroup.copy());
        }
        if (this.rightGroup != null) {
            headerCopy.setRightGroup((Group)this.rightGroup.copy());
        }
        if (this.upperGroup != null) {
            headerCopy.setUpperGroup((Group)this.upperGroup.copy());
        }
        if (this.richHeaderMessage != null) {
            headerCopy.setRichHeaderMessage((Message)this.richHeaderMessage.copy());
        }
    }
}

