/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.util.MessageStructureUtils;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="message-bean", parent="Uif-Message"), @BeanTag(name="instructionalMessage-bean", parent="Uif-InstructionalMessage"), @BeanTag(name="constraintMessage-bean", parent="Uif-ConstraintMessage"), @BeanTag(name="requiredMessage-bean", parent="Uif-RequiredMessage"), @BeanTag(name="requiredInstructionsMessage-bean", parent="Uif-RequiredInstructionsMessage"), @BeanTag(name="stateBased-requiredInstructionsMessage-bean", parent="Uif-StateBased-RequiredInstructionsMessage"), @BeanTag(name="dialogPrompt-bean", parent="Uif-DialogPrompt"), @BeanTag(name="imageCutineMessage-bean", parent="Uif-ImageCutineMessage")})
public class Message
extends ContentElementBase {
    private static final long serialVersionUID = 4090058533452450395L;
    private String messageText;
    private boolean generateSpan = true;
    private List<Component> inlineComponents;
    private List<Component> messageComponentStructure;
    private boolean parseComponents = true;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.messageText != null && this.messageText.contains("[") && this.messageText.contains("]") && (this.messageComponentStructure == null || this.messageComponentStructure.isEmpty())) {
            this.messageComponentStructure = MessageStructureUtils.parseMessage(this.getId(), this.getMessageText(), this.getInlineComponents(), view, this.parseComponents);
            if (this.messageComponentStructure != null) {
                for (Component component : this.messageComponentStructure) {
                    view.getViewHelperService().performComponentInitialization(view, model, component);
                }
            }
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        this.addDataAttribute("parent", parent.getId());
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        if (this.messageComponentStructure != null) {
            for (Component component : this.messageComponentStructure) {
                components.add(component);
            }
        }
        return components;
    }

    @Override
    public boolean isRender() {
        boolean render = super.isRender();
        if (render) {
            render = this.getPropertyExpressions().containsKey("messageText") || StringUtils.isNotBlank((String)this.messageText) && !StringUtils.equals((String)this.messageText, (String)"&nbsp;");
        }
        return render;
    }

    @BeanTagAttribute(name="messageText")
    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    @BeanTagAttribute(name="generateSpan")
    public boolean isGenerateSpan() {
        return this.generateSpan;
    }

    public void setGenerateSpan(boolean generateSpan) {
        this.generateSpan = generateSpan;
    }

    public List<Component> getMessageComponentStructure() {
        return this.messageComponentStructure;
    }

    public void setMessageComponentStructure(List<Component> messageComponentStructure) {
        this.messageComponentStructure = messageComponentStructure;
    }

    @BeanTagAttribute(name="inlineComponents", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getMessageText() == null && Validator.checkExpressions(this, "messageText")) {
            String[] currentValues = new String[]{"messageText  =" + this.getMessageText()};
            tracer.createWarning("MessageText should be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @BeanTagAttribute(name="parseComponents")
    public boolean isParseComponents() {
        return this.parseComponents;
    }

    public void setParseComponents(boolean parseComponents) {
        this.parseComponents = parseComponents;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Message messageCopy = (Message)component;
        messageCopy.setGenerateSpan(this.generateSpan);
        if (this.inlineComponents != null) {
            ArrayList inlineComponents = Lists.newArrayListWithExpectedSize((int)this.inlineComponents.size());
            for (Component inlineComponent : this.inlineComponents) {
                inlineComponents.add((Component)inlineComponent.copy());
            }
            messageCopy.setInlineComponents(inlineComponents);
        }
        if (this.messageComponentStructure != null) {
            ArrayList messageComponentStructure = Lists.newArrayListWithExpectedSize((int)this.messageComponentStructure.size());
            for (Component messageComponentStructureItem : this.messageComponentStructure) {
                messageComponentStructure.add((Component)messageComponentStructureItem.copy());
            }
            messageCopy.setMessageComponentStructure(messageComponentStructure);
        }
        messageCopy.setMessageText(this.messageText);
        messageCopy.setParseComponents(this.parseComponents);
    }
}

