/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.KualiCode;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.field.DataFieldSecurity;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Help;
import org.kuali.rice.krad.uif.widget.Helpable;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.valuefinder.ValueFinder;

@BeanTags(value={@BeanTag(name="dataField-bean", parent="Uif-DataField"), @BeanTag(name="dataField-labelTop-bean", parent="Uif-DataField-LabelTop"), @BeanTag(name="dataField-labelRight-bean", parent="Uif-DataField-LabelRight"), @BeanTag(name="dataField-withoutLabel-bean", parent="Uif-DataField-withoutLabel")})
public class DataField
extends FieldBase
implements DataBinding,
Helpable {
    private static final long serialVersionUID = -4129678891948564724L;
    private String propertyName;
    private BindingInfo bindingInfo;
    private String dictionaryAttributeName;
    private String dictionaryObjectEntry;
    private String defaultValue;
    private Class<? extends ValueFinder> defaultValueFinderClass;
    private Object[] defaultValues;
    private String forcedValue;
    private PropertyEditor propertyEditor;
    private boolean addHiddenWhenReadOnly;
    protected String readOnlyDisplayReplacementPropertyName;
    protected String readOnlyDisplaySuffixPropertyName;
    private String readOnlyDisplayReplacement;
    private String readOnlyDisplaySuffix;
    private String readOnlyListDisplayType;
    private String readOnlyListDelimiter;
    private boolean applyMask;
    private MaskFormatter maskFormatter;
    private List<String> additionalHiddenPropertyNames = new ArrayList<String>();
    private List<String> propertyNamesForAdditionalDisplay = new ArrayList<String>();
    private boolean escapeHtmlInPropertyValue = true;
    private boolean multiLineReadOnlyDisplay;
    private Inquiry inquiry;
    private boolean enableAutoInquiry = true;
    private Help help;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.enableAutoInquiry && this.inquiry == null && this.isReadOnly()) {
            this.buildAutomaticInquiry(view, model, false);
        }
        if (this.isAddHiddenWhenReadOnly()) {
            this.setReadOnly(true);
            this.getAdditionalHiddenPropertyNames().add(this.getPropertyName());
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        ArrayList<String> hiddenPropertyPaths = new ArrayList<String>();
        for (String hiddenPropertyName : this.getAdditionalHiddenPropertyNames()) {
            String hiddenPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(hiddenPropertyName);
            hiddenPropertyPaths.add(hiddenPropertyPath);
        }
        this.additionalHiddenPropertyNames = hiddenPropertyPaths;
        ArrayList<String> informationalPropertyPaths = new ArrayList<String>();
        for (String infoPropertyName : this.getPropertyNamesForAdditionalDisplay()) {
            String infoPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(infoPropertyName);
            informationalPropertyPaths.add(infoPropertyPath);
        }
        this.propertyNamesForAdditionalDisplay = informationalPropertyPaths;
        Class<?> type = ObjectPropertyUtils.getPropertyType(model, this.getBindingInfo().getBindingPath());
        if (this.isReadOnly() && type != null && List.class.isAssignableFrom(type) && StringUtils.isBlank((String)this.getReadOnlyDisplayReplacement()) && StringUtils.isBlank((String)this.getReadOnlyDisplayReplacementPropertyName())) {
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath());
            if (fieldValue != null && fieldValue instanceof List && !((List)fieldValue).isEmpty()) {
                List list = (List)fieldValue;
                this.processReadOnlyListDisplay(model, list);
            } else {
                this.setReadOnlyDisplayReplacement("&nbsp;");
            }
        } else {
            this.setAlternateAndAdditionalDisplayValue(view, model);
        }
        if (this.getFieldLabel() != null && StringUtils.isNotBlank((String)this.getId())) {
            this.getFieldLabel().setLabelForComponentId(this.getId() + "_control");
        }
    }

    protected void buildAutomaticInquiry(View view, Object model, boolean enableDirectInquiry) {
        Inquiry autoInquiry = ComponentFactory.getInquiry();
        view.getViewHelperService().spawnSubLifecyle(view, model, autoInquiry, this, null, null);
        if (autoInquiry.isRender()) {
            this.inquiry = autoInquiry;
        }
    }

    protected void processReadOnlyListDisplay(Object model, List<?> originalList) {
        this.setReadOnlyDisplayReplacement(this.generateReadOnlyListDisplayReplacement(originalList));
    }

    protected String generateReadOnlyListDisplayReplacement(List<?> list) {
        String generatedHtml = "";
        if (this.getReadOnlyListDisplayType() == null) {
            this.setReadOnlyListDisplayType(UifConstants.ReadOnlyListTypes.DELIMITED.name());
        }
        if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.UL.name())) {
            generatedHtml = "<ul class='uif-readOnlyStringList'>";
        } else if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.OL.name())) {
            generatedHtml = "<ol class='uif-readOnlyStringList'>";
        } else if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.BREAK.name())) {
            this.setReadOnlyListDelimiter("<br/>");
        } else if (this.getReadOnlyListDelimiter() == null) {
            this.setReadOnlyListDelimiter(", ");
        }
        for (Object value : list) {
            if (!TypeUtils.isSimpleType(value.getClass()) || StringUtils.isBlank((String)value.toString())) continue;
            if (this.isApplyMask()) {
                value = this.getMaskFormatter().maskValue(value);
            }
            if (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.UL.name()) || this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.OL.name())) {
                generatedHtml = generatedHtml + "<li>" + StringEscapeUtils.escapeHtml((String)value.toString()) + "</li>";
                continue;
            }
            generatedHtml = generatedHtml + StringEscapeUtils.escapeHtml((String)value.toString()) + this.getReadOnlyListDelimiter();
        }
        generatedHtml = this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.UL.name()) ? generatedHtml + "</ul>" : (this.getReadOnlyListDisplayType().equalsIgnoreCase(UifConstants.ReadOnlyListTypes.OL.name()) ? generatedHtml + "</ol>" : StringUtils.removeEnd((String)generatedHtml, (String)this.getReadOnlyListDelimiter()));
        if (StringUtils.isNotBlank((String)generatedHtml)) {
            return generatedHtml;
        }
        return "&nbsp;";
    }

    protected void setAlternateAndAdditionalDisplayValue(View view, Object model) {
        String additionalDisplayPropertyPath;
        Object additionalFieldValue;
        String alternateDisplayPropertyPath;
        Object alternateFieldValue;
        if (StringUtils.isNotBlank((String)this.readOnlyDisplayReplacement) || StringUtils.isNotBlank((String)this.readOnlyDisplaySuffix)) {
            return;
        }
        if (this.isApplyMask()) {
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath());
            this.readOnlyDisplayReplacement = this.getMaskFormatter().maskValue(fieldValue);
            return;
        }
        if (!this.isReadOnly()) {
            return;
        }
        if (StringUtils.isNotBlank((String)this.getReadOnlyDisplayReplacementPropertyName()) && (alternateFieldValue = ObjectPropertyUtils.getPropertyValue(model, alternateDisplayPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(this.getReadOnlyDisplayReplacementPropertyName()))) != null) {
            this.readOnlyDisplayReplacement = alternateFieldValue.toString();
        }
        if (StringUtils.isBlank((String)this.getReadOnlyDisplaySuffixPropertyName()) && view.isTranslateCodesOnReadOnlyDisplay()) {
            Class<?> parentObjectClass = ViewModelUtils.getParentObjectClassForMetadata(view, model, this);
            DataObjectRelationship relationship = KRADServiceLocatorWeb.getDataObjectMetaDataService().getDataObjectRelationship(null, parentObjectClass, this.getBindingInfo().getBindingName(), "", true, false, false);
            if (relationship != null && this.getPropertyName().startsWith(relationship.getParentAttributeName()) && KualiCode.class.isAssignableFrom(relationship.getRelatedClass())) {
                this.readOnlyDisplaySuffixPropertyName = relationship.getParentAttributeName() + "." + "name";
            }
        }
        if (StringUtils.isNotBlank((String)this.getReadOnlyDisplaySuffixPropertyName()) && (additionalFieldValue = ObjectPropertyUtils.getPropertyValue(model, additionalDisplayPropertyPath = this.getBindingInfo().getPropertyAdjustedBindingPath(this.getReadOnlyDisplaySuffixPropertyName()))) != null) {
            this.readOnlyDisplaySuffix = additionalFieldValue.toString();
        }
    }

    public void copyFromAttributeDefinition(View view, AttributeDefinition attributeDefinition) {
        if (StringUtils.isEmpty((String)this.getLabel())) {
            this.setLabel(attributeDefinition.getLabel());
        }
        if (StringUtils.isEmpty((String)this.getShortLabel())) {
            this.setShortLabel(attributeDefinition.getShortLabel());
        }
        if (this.getDataFieldSecurity().getAttributeSecurity() == null) {
            this.getDataFieldSecurity().setAttributeSecurity(attributeDefinition.getAttributeSecurity());
        }
        if (this.getReadOnlyDisplayReplacementPropertyName() == null && StringUtils.isNotBlank((String)attributeDefinition.getAlternateDisplayAttributeName())) {
            this.setReadOnlyDisplayReplacementPropertyName(attributeDefinition.getAlternateDisplayAttributeName());
        }
        if (this.getReadOnlyDisplaySuffixPropertyName() == null && StringUtils.isNotBlank((String)attributeDefinition.getAdditionalDisplayAttributeName())) {
            this.setReadOnlyDisplaySuffixPropertyName(attributeDefinition.getAdditionalDisplayAttributeName());
        }
        if (this.getPropertyEditor() == null) {
            this.setPropertyEditor(attributeDefinition.getPropertyEditor());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.inquiry);
        components.add(this.help);
        return components;
    }

    public boolean isInputAllowed() {
        return false;
    }

    @Override
    @BeanTagAttribute(name="propertyName")
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @BeanTagAttribute(name="propertyEditor", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public void setPropertyEditorClass(Class<? extends PropertyEditor> propertyEditorClass) {
        this.propertyEditor = ObjectUtils.newInstance(propertyEditorClass);
    }

    @Override
    @BeanTagAttribute(name="bindingInfo", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public String getName() {
        return this.getBindingInfo().getBindingPath();
    }

    @BeanTagAttribute(name="dictionaryAttributeName")
    public String getDictionaryAttributeName() {
        return this.dictionaryAttributeName;
    }

    public void setDictionaryAttributeName(String dictionaryAttributeName) {
        this.dictionaryAttributeName = dictionaryAttributeName;
    }

    @BeanTagAttribute(name="dictionaryObjectEntry")
    public String getDictionaryObjectEntry() {
        return this.dictionaryObjectEntry;
    }

    public void setDictionaryObjectEntry(String dictionaryObjectEntry) {
        this.dictionaryObjectEntry = dictionaryObjectEntry;
    }

    @BeanTagAttribute(name="defaultValue")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @BeanTagAttribute(name="defaultValueFinderClass")
    public Class<? extends ValueFinder> getDefaultValueFinderClass() {
        return this.defaultValueFinderClass;
    }

    public void setDefaultValueFinderClass(Class<? extends ValueFinder> defaultValueFinderClass) {
        this.defaultValueFinderClass = defaultValueFinderClass;
    }

    @BeanTagAttribute(name="defaultValues", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public Object[] getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(Object[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public String getForcedValue() {
        return this.forcedValue;
    }

    public void setForcedValue(String forcedValue) {
        this.forcedValue = forcedValue;
    }

    @BeanTagAttribute(name="helpSummary")
    public String getHelpSummary() {
        return this.help.getTooltipHelpContent();
    }

    public void setHelpSummary(String helpSummary) {
        this.help.setTooltipHelpContent(helpSummary);
    }

    public DataFieldSecurity getDataFieldSecurity() {
        return (DataFieldSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof DataFieldSecurity)) {
            throw new RiceRuntimeException("Component security for DataField should be instance of DataFieldSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return DataFieldSecurity.class;
    }

    @BeanTagAttribute(name="addHiddenWhenReadOnly")
    public boolean isAddHiddenWhenReadOnly() {
        return this.addHiddenWhenReadOnly;
    }

    public void setAddHiddenWhenReadOnly(boolean addHiddenWhenReadOnly) {
        this.addHiddenWhenReadOnly = addHiddenWhenReadOnly;
    }

    @BeanTagAttribute(name="inquiry", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Inquiry getInquiry() {
        return this.inquiry;
    }

    public void setInquiry(Inquiry inquiry) {
        this.inquiry = inquiry;
    }

    public boolean isEnableAutoInquiry() {
        return this.enableAutoInquiry;
    }

    public void setEnableAutoInquiry(boolean enableAutoInquiry) {
        this.enableAutoInquiry = enableAutoInquiry;
    }

    @Override
    @BeanTagAttribute(name="help", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Help getHelp() {
        return this.help;
    }

    @Override
    public void setHelp(Help help) {
        this.help = help;
    }

    @Override
    @BeanTagAttribute(name="tooltipOfComponent", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public void setTooltipOfComponent(Tooltip tooltip) {
        this.getFieldLabel().setToolTip(tooltip);
    }

    @Override
    public String getHelpTitle() {
        return this.getLabel();
    }

    public void setReadOnlyDisplaySuffixPropertyName(String readOnlyDisplaySuffixPropertyName) {
        this.readOnlyDisplaySuffixPropertyName = readOnlyDisplaySuffixPropertyName;
    }

    @BeanTagAttribute(name="readOnlyDisplaceSuffixPropertyName")
    public String getReadOnlyDisplaySuffixPropertyName() {
        return this.readOnlyDisplaySuffixPropertyName;
    }

    public void setReadOnlyDisplayReplacementPropertyName(String readOnlyDisplayReplacementPropertyName) {
        this.readOnlyDisplayReplacementPropertyName = readOnlyDisplayReplacementPropertyName;
    }

    @BeanTagAttribute(name="readOnlyDisplayReplacementPropertyName")
    public String getReadOnlyDisplayReplacementPropertyName() {
        return this.readOnlyDisplayReplacementPropertyName;
    }

    @BeanTagAttribute(name="readOnlyDisplayReplacement")
    public String getReadOnlyDisplayReplacement() {
        return this.readOnlyDisplayReplacement;
    }

    public void setReadOnlyDisplayReplacement(String value) {
        this.readOnlyDisplayReplacement = value;
    }

    @BeanTagAttribute(name="readOnlyDispalySuffix")
    public String getReadOnlyDisplaySuffix() {
        return this.readOnlyDisplaySuffix;
    }

    public void setReadOnlyDisplaySuffix(String value) {
        this.readOnlyDisplaySuffix = value;
    }

    public String getReadOnlyListDisplayType() {
        return this.readOnlyListDisplayType;
    }

    public void setReadOnlyListDisplayType(String readOnlyListDisplayType) {
        this.readOnlyListDisplayType = readOnlyListDisplayType;
    }

    public String getReadOnlyListDelimiter() {
        return this.readOnlyListDelimiter;
    }

    public void setReadOnlyListDelimiter(String readOnlyListDelimiter) {
        this.readOnlyListDelimiter = readOnlyListDelimiter;
    }

    @BeanTagAttribute(name="applyMask")
    public boolean isApplyMask() {
        return this.applyMask;
    }

    public void setApplyMask(boolean applyMask) {
        this.applyMask = applyMask;
    }

    @BeanTagAttribute(name="maskFormatter", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public MaskFormatter getMaskFormatter() {
        return this.maskFormatter;
    }

    public void setMaskFormatter(MaskFormatter maskFormatter) {
        this.maskFormatter = maskFormatter;
    }

    @BeanTagAttribute(name="additionalHiddenPropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalHiddenPropertyNames() {
        return this.additionalHiddenPropertyNames;
    }

    public void setAdditionalHiddenPropertyNames(List<String> additionalHiddenPropertyNames) {
        this.additionalHiddenPropertyNames = additionalHiddenPropertyNames;
    }

    @BeanTagAttribute(name="propertyNamesForAdditionalDisplay", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getPropertyNamesForAdditionalDisplay() {
        return this.propertyNamesForAdditionalDisplay;
    }

    public void setPropertyNamesForAdditionalDisplay(List<String> propertyNamesForAdditionalDisplay) {
        this.propertyNamesForAdditionalDisplay = propertyNamesForAdditionalDisplay;
    }

    public void setEscapeHtmlInPropertyValue(boolean escapeHtmlInPropertyValue) {
        this.escapeHtmlInPropertyValue = escapeHtmlInPropertyValue;
    }

    @BeanTagAttribute(name="escapeHtmlInPropertyValue")
    public boolean isEscapeHtmlInPropertyValue() {
        return this.escapeHtmlInPropertyValue;
    }

    public boolean isMultiLineReadOnlyDisplay() {
        return this.multiLineReadOnlyDisplay;
    }

    public void setMultiLineReadOnlyDisplay(boolean multiLineReadOnlyDisplay) {
        this.multiLineReadOnlyDisplay = multiLineReadOnlyDisplay;
    }

    public boolean hasSecureValue() {
        return this.isApplyMask() || (this.getComponentSecurity().isViewAuthz() || this.getDataFieldSecurity().isViewInLineAuthz() || this.getDataFieldSecurity().getAttributeSecurity() != null && this.getDataFieldSecurity().getAttributeSecurity().isHide()) && this.isHidden();
    }

    public boolean isRenderFieldset() {
        return !this.isReadOnly() && this.inquiry != null && this.inquiry.isRender() && this.inquiry.getInquiryLink() != null && this.inquiry.getInquiryLink().isRender() || this.help != null && this.help.isRender() && this.help.getHelpAction() != null && this.help.getHelpAction().isRender();
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getPropertyName() == null && !Validator.checkExpressions(this, "propertyName")) {
            currentValues = new String[]{"propertyName = " + this.getPropertyName()};
            tracer.createError("Property name not set", currentValues);
        }
        if (this.isApplyMask() && this.maskFormatter == null) {
            currentValues = new String[]{"applyMask =" + this.isApplyMask(), "maskFormatter =" + this.maskFormatter};
            tracer.createWarning("Apply mask is true, but no value is set for maskFormatter", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        DataField dataFieldCopy = (DataField)component;
        dataFieldCopy.setAddHiddenWhenReadOnly(this.addHiddenWhenReadOnly);
        dataFieldCopy.setAdditionalHiddenPropertyNames(new ArrayList<String>(this.additionalHiddenPropertyNames));
        dataFieldCopy.setApplyMask(this.applyMask);
        if (this.maskFormatter != null) {
            dataFieldCopy.setMaskFormatter(this.maskFormatter);
        }
        if (this.bindingInfo != null) {
            dataFieldCopy.setBindingInfo((BindingInfo)this.bindingInfo.copy());
        }
        dataFieldCopy.setDefaultValue(this.defaultValue);
        if (this.defaultValues != null) {
            dataFieldCopy.setDefaultValues(this.defaultValues);
        }
        dataFieldCopy.setDictionaryAttributeName(this.dictionaryAttributeName);
        dataFieldCopy.setDictionaryObjectEntry(this.dictionaryObjectEntry);
        dataFieldCopy.setEnableAutoInquiry(this.enableAutoInquiry);
        dataFieldCopy.setEscapeHtmlInPropertyValue(this.escapeHtmlInPropertyValue);
        dataFieldCopy.setForcedValue(this.forcedValue);
        dataFieldCopy.setMultiLineReadOnlyDisplay(this.multiLineReadOnlyDisplay);
        if (this.propertyEditor != null) {
            dataFieldCopy.setPropertyEditor(this.propertyEditor);
        }
        dataFieldCopy.setPropertyName(this.propertyName);
        if (this.propertyNamesForAdditionalDisplay != null) {
            dataFieldCopy.setPropertyNamesForAdditionalDisplay(new ArrayList<String>(this.propertyNamesForAdditionalDisplay));
        }
        dataFieldCopy.setReadOnlyDisplayReplacement(this.readOnlyDisplayReplacement);
        dataFieldCopy.setReadOnlyDisplayReplacementPropertyName(this.readOnlyDisplayReplacementPropertyName);
        dataFieldCopy.setReadOnlyDisplaySuffix(this.readOnlyDisplaySuffix);
        dataFieldCopy.setReadOnlyDisplaySuffixPropertyName(this.readOnlyDisplaySuffixPropertyName);
        dataFieldCopy.setReadOnlyListDelimiter(this.readOnlyListDelimiter);
        dataFieldCopy.setReadOnlyListDisplayType(this.readOnlyListDisplayType);
        dataFieldCopy.setDefaultValueFinderClass(this.defaultValueFinderClass);
        if (this.help != null) {
            dataFieldCopy.setHelp((Help)this.help.copy());
        }
        if (this.inquiry != null) {
            dataFieldCopy.setInquiry((Inquiry)this.inquiry.copy());
        }
    }
}

