/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.LightBox;

@BeanTag(name="linkField-bean", parent="Uif-LinkField")
public class LinkField
extends FieldBase {
    private static final long serialVersionUID = -1908504471910271148L;
    private Link link;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if (StringUtils.isBlank((String)this.getLinkText())) {
            this.setLinkText(this.getLabel());
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.getFieldLabel() != null && this.getLink() != null && StringUtils.isNotBlank((String)this.getLink().getId())) {
            this.getFieldLabel().setLabelForComponentId(this.getLink().getId());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.link);
        return components;
    }

    @BeanTagAttribute(name="link", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Link getLink() {
        return this.link;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    @BeanTagAttribute(name="linkText")
    public String getLinkText() {
        return this.link.getLinkText();
    }

    public void setLinkText(String linkLabel) {
        this.link.setLinkText(linkLabel);
    }

    @BeanTagAttribute(name="target")
    public String getTarget() {
        return this.link.getTarget();
    }

    public void setTarget(String target) {
        this.link.setTarget(target);
    }

    @BeanTagAttribute(name="href")
    public String getHref() {
        return this.link.getHref();
    }

    public void setHref(String hrefText) {
        this.link.setHref(hrefText);
    }

    public void setLightBox(LightBox lightBox) {
        if (this.link != null) {
            this.link.setLightBox(lightBox);
        }
    }

    @BeanTagAttribute(name="lightBox", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public LightBox getLightBox() {
        if (this.link != null) {
            return this.link.getLightBox();
        }
        return null;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getLink() == null && Validator.checkExpressions(this, "link")) {
            currentValues = new String[]{"link = " + this.getLink()};
            tracer.createError("Link should be set", currentValues);
        }
        if (this.getLabel() == null && Validator.checkExpressions(this, "label")) {
            currentValues = new String[]{"label =" + this.getLabel(), "link =" + this.getLink()};
            tracer.createWarning("Label is null, link should be used instead", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        LinkField linkFieldCopy = (LinkField)component;
        if (this.link != null) {
            linkFieldCopy.setLink((Link)this.link.copy());
        }
    }
}

