/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControl;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.KeyMessage;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="lookupCriteriaInputField-bean", parent="Uif-LookupCriteriaInputField")
public class LookupInputField
extends InputField {
    private static final long serialVersionUID = -8294275596836322699L;
    public static final String CHECKBOX_CONVERTED_RADIO_CONTROL = "Uif-CheckboxConvertedRadioControl";
    private boolean disableWildcardsAndOperators = false;
    private boolean addControlSelectAllOption = false;
    private boolean triggerOnChange;
    private boolean ranged;

    public LookupInputField() {
        this.setTriggerOnChange(false);
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.addControlSelectAllOption && this.getControl() != null && this.getControl() instanceof MultiValueControl) {
            String allOptionText = KRADServiceLocatorWeb.getMessageService().getMessageText("option.all");
            MultiValueControl multiValueControl = (MultiValueControl)((Object)this.getControl());
            if (multiValueControl.getOptions() != null) {
                multiValueControl.getOptions().add(0, (KeyValue)new ConcreteKeyValue("", allOptionText));
            }
            if (multiValueControl.getRichOptions() != null) {
                Message message = ComponentFactory.getMessage();
                view.assignComponentIds(message);
                message.setMessageText(allOptionText);
                message.setGenerateSpan(false);
                multiValueControl.getRichOptions().add(0, new KeyMessage("", allOptionText, message));
            }
        }
    }

    @Override
    public void copyFromAttributeDefinition(View view, AttributeDefinition attributeDefinition) {
        if (StringUtils.isEmpty((String)this.getLabel())) {
            this.setLabel(attributeDefinition.getLabel());
        }
        if (StringUtils.isEmpty((String)this.getShortLabel())) {
            this.setShortLabel(attributeDefinition.getShortLabel());
        }
        if (this.getDataFieldSecurity().getAttributeSecurity() == null) {
            this.getDataFieldSecurity().setAttributeSecurity(attributeDefinition.getAttributeSecurity());
        }
        if (this.getOptionsFinder() == null) {
            this.setOptionsFinder(attributeDefinition.getOptionsFinder());
        }
        if (this.getControl() == null) {
            Control control = LookupInputField.convertControlToLookupControl(attributeDefinition);
            view.assignComponentIds(control);
            this.setControl(control);
        }
        this.setMaxLength(100);
        if (StringUtils.isEmpty((String)this.getDefaultValue()) && StringUtils.equals((String)this.getPropertyName(), (String)"active")) {
            this.setDefaultValue("Y");
        }
    }

    protected static Control convertControlToLookupControl(AttributeDefinition attributeDefinition) {
        if (attributeDefinition.getControlField() == null) {
            return null;
        }
        Control newControl = null;
        newControl = CheckboxControl.class.isAssignableFrom(attributeDefinition.getControlField().getClass()) ? LookupInputField.getCheckboxConvertedRadioControl() : (TextAreaControl.class.isAssignableFrom(attributeDefinition.getControlField().getClass()) ? ComponentFactory.getTextControl() : ComponentUtils.copy(attributeDefinition.getControlField(), ""));
        return newControl;
    }

    @BeanTagAttribute(name="disableWildcardsAndOperators")
    public boolean isDisableWildcardsAndOperators() {
        return this.disableWildcardsAndOperators;
    }

    public void setDisableWildcardsAndOperators(boolean disableWildcardsAndOperators) {
        this.disableWildcardsAndOperators = disableWildcardsAndOperators;
    }

    @BeanTagAttribute(name="addControlSelectAllOption")
    public boolean isAddControlSelectAllOption() {
        return this.addControlSelectAllOption;
    }

    public void setAddControlSelectAllOption(boolean addControlSelectAllOption) {
        this.addControlSelectAllOption = addControlSelectAllOption;
    }

    public boolean isTriggerOnChange() {
        return this.triggerOnChange;
    }

    public void setTriggerOnChange(boolean triggerOnChange) {
        this.triggerOnChange = triggerOnChange;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public void setRanged(boolean ranged) {
        this.ranged = ranged;
    }

    public Map<String, String> filterSearchCriteria(Map<String, String> searchCriteria) {
        if (this.getControl() instanceof FilterableLookupCriteriaControl) {
            return ((FilterableLookupCriteriaControl)((Object)this.getControl())).filterSearchCriteria(this.getPropertyName(), searchCriteria);
        }
        return searchCriteria;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        LookupInputField lookupInputFieldCopy = (LookupInputField)component;
        lookupInputFieldCopy.setDisableWildcardsAndOperators(this.disableWildcardsAndOperators);
        lookupInputFieldCopy.setAddControlSelectAllOption(this.addControlSelectAllOption);
        lookupInputFieldCopy.setTriggerOnChange(this.triggerOnChange);
        lookupInputFieldCopy.setRanged(this.ranged);
    }

    private static RadioGroupControl getCheckboxConvertedRadioControl() {
        return (RadioGroupControl)ComponentFactory.getNewComponentInstance(CHECKBOX_CONVERTED_RADIO_CONTROL);
    }
}

