/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.CssConstants;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="boxLayout-bean", parent="Uif-BoxLayoutBase"), @BeanTag(name="horizontalBoxLayout-bean", parent="Uif-HorizontalBoxLayout"), @BeanTag(name="verticalBoxLayout-bean", parent="Uif-VerticalBoxLayout")})
public class BoxLayoutManager
extends LayoutManagerBase {
    private static final long serialVersionUID = 4467342272983290044L;
    private UifConstants.Orientation orientation = UifConstants.Orientation.HORIZONTAL;
    private String padding;
    private String itemStyle = "";
    private List<String> itemStyleClasses = new ArrayList<String>();

    @Override
    public void performFinalize(View view, Object model, Container container) {
        super.performFinalize(view, model, container);
        if (StringUtils.isBlank((String)this.itemStyle)) {
            this.itemStyle = "";
        }
        if (StringUtils.isNotEmpty((String)this.padding)) {
            this.itemStyle = this.orientation.equals((Object)UifConstants.Orientation.VERTICAL) ? this.itemStyle + CssConstants.getCssStyle("padding-bottom: {0};", this.padding) : this.itemStyle + CssConstants.getCssStyle("padding-right: {0};", this.padding);
        }
        this.addStyleClass("clearfix");
        for (Component component : container.getItems()) {
            if (component == null) continue;
            List<String> styleClasses = component.getCssClasses();
            if (styleClasses == null) {
                styleClasses = new ArrayList<String>();
            }
            if (this.orientation.equals((Object)UifConstants.Orientation.HORIZONTAL)) {
                styleClasses.add("uif-boxLayoutHorizontalItem");
                styleClasses.addAll(this.getItemStyleClasses());
            } else {
                styleClasses.add("uif-boxLayoutVerticalItem");
                styleClasses.addAll(this.getItemStyleClasses());
                styleClasses.add("clearfix");
            }
            component.setCssClasses(styleClasses);
            if (component.getStyle() != null && !component.getStyle().endsWith(";")) {
                component.appendToStyle(";" + this.getItemStyle());
                continue;
            }
            component.appendToStyle(this.getItemStyle());
        }
    }

    @BeanTagAttribute(name="orientation", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public UifConstants.Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(UifConstants.Orientation orientation) {
        this.orientation = orientation;
    }

    @BeanTagAttribute(name="padding")
    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    @BeanTagAttribute(name="itemStyle")
    public String getItemStyle() {
        return this.itemStyle;
    }

    public void setItemStyle(String itemStyle) {
        this.itemStyle = itemStyle;
    }

    @BeanTagAttribute(name="itemStyleClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getItemStyleClasses() {
        return this.itemStyleClasses;
    }

    public void setItemStyleClasses(List<String> itemStyleClasses) {
        this.itemStyleClasses = itemStyleClasses;
    }

    public String getItemStyleClassesAsString() {
        if (this.itemStyleClasses != null) {
            return StringUtils.join(this.itemStyleClasses, (String)" ");
        }
        return "";
    }

    @Override
    protected <T> void copyProperties(T layout) {
        super.copyProperties(layout);
        BoxLayoutManager boxLayoutManagerCopy = (BoxLayoutManager)layout;
        boxLayoutManagerCopy.setPadding(this.padding);
        boxLayoutManagerCopy.setItemStyle(this.itemStyle);
        boxLayoutManagerCopy.setOrientation(this.orientation);
        if (this.itemStyleClasses != null) {
            boxLayoutManagerCopy.setItemStyleClasses(new ArrayList<String>(this.itemStyleClasses));
        }
    }
}

