/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTags(value={@BeanTag(name="cssGridLayout-bean", parent="Uif-CssGridLayoutBase"), @BeanTag(name="fixedCssGridLayout-bean", parent="Uif-FixedCssGridLayout"), @BeanTag(name="fluidCssGridLayout-bean", parent="Uif-FluidCssGridLayout")})
public class CssGridLayoutManager
extends LayoutManagerBase {
    private static final long serialVersionUID = 1830635073147703757L;
    private static final int NUMBER_OF_COLUMNS = 9;
    private static final String BOOTSTRAP_SPAN_PREFIX = "span";
    private Map<String, String> conditionalRowCssClasses;
    private String rowLayoutCssClass;
    private int defaultItemColSpan;
    protected List<List<Component>> rows = new ArrayList<List<Component>>();
    protected List<String> rowCssClassAttributes;
    protected List<String> cellCssClassAttributes;

    public CssGridLayoutManager() {
        this.conditionalRowCssClasses = new HashMap<String, String>();
        this.cellCssClassAttributes = new ArrayList<String>();
        this.rowCssClassAttributes = new ArrayList<String>();
    }

    @Override
    public void performFinalize(View view, Object model, Container container) {
        super.performFinalize(view, model, container);
        int rowSpaceLeft = 9;
        int rowIndex = 0;
        boolean isOdd = true;
        ArrayList<Component> currentRow = new ArrayList<Component>();
        for (Component component : container.getItems()) {
            String rowCss;
            List<String> cellCssClasses;
            if (component == null) continue;
            isOdd = rowIndex % 2 == 0;
            int colSpan = this.defaultItemColSpan;
            if (component.getColSpan() > 1 && component.getColSpan() <= 9) {
                colSpan = component.getColSpan();
            }
            if ((cellCssClasses = component.getCellCssClasses()) == null) {
                cellCssClasses = new ArrayList<String>();
                component.setCellCssClasses(cellCssClasses);
            }
            cellCssClasses.add(0, BOOTSTRAP_SPAN_PREFIX + colSpan);
            this.cellCssClassAttributes.add(this.getCellStyleClassesAsString(cellCssClasses));
            if ((rowSpaceLeft -= colSpan) > 0) {
                currentRow.add(component);
                continue;
            }
            if (rowSpaceLeft < 0) {
                this.rows.add(new ArrayList(currentRow));
                currentRow = new ArrayList();
                currentRow.add(component);
                rowCss = this.rowLayoutCssClass + " " + KRADUtils.generateRowCssClassString(this.conditionalRowCssClasses, rowIndex, isOdd, null, null);
                this.rowCssClassAttributes.add(rowCss);
                ++rowIndex;
                rowSpaceLeft = 9 - colSpan;
                continue;
            }
            if (rowSpaceLeft != 0) continue;
            currentRow.add(component);
            this.rows.add(new ArrayList(currentRow));
            currentRow = new ArrayList();
            rowCss = this.rowLayoutCssClass + " " + KRADUtils.generateRowCssClassString(this.conditionalRowCssClasses, rowIndex, isOdd, null, null);
            this.rowCssClassAttributes.add(rowCss);
            ++rowIndex;
            rowSpaceLeft = 9;
        }
        boolean bl = isOdd = rowIndex % 2 == 0;
        if (!currentRow.isEmpty()) {
            String rowCss = this.rowLayoutCssClass + " " + KRADUtils.generateRowCssClassString(this.conditionalRowCssClasses, rowIndex, isOdd, null, null);
            this.rowCssClassAttributes.add(rowCss);
            this.rows.add(currentRow);
        }
    }

    private String getCellStyleClassesAsString(List<String> cellCssClasses) {
        if (cellCssClasses != null) {
            return StringUtils.join(cellCssClasses, (String)" ");
        }
        return "";
    }

    public List<List<Component>> getRows() {
        return this.rows;
    }

    public List<String> getRowCssClassAttributes() {
        return this.rowCssClassAttributes;
    }

    public List<String> getCellCssClassAttributes() {
        return this.cellCssClassAttributes;
    }

    @BeanTagAttribute(name="defaultItemColSpan")
    public int getDefaultItemColSpan() {
        return this.defaultItemColSpan;
    }

    public void setDefaultItemColSpan(int defaultItemColSpan) {
        this.defaultItemColSpan = defaultItemColSpan;
    }

    @BeanTagAttribute(name="conditionalRowCssClasses", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getConditionalRowCssClasses() {
        return this.conditionalRowCssClasses;
    }

    public void setConditionalRowCssClasses(Map<String, String> conditionalRowCssClasses) {
        this.conditionalRowCssClasses = conditionalRowCssClasses;
    }

    @BeanTagAttribute(name="rowLayoutCssClass")
    public String getRowLayoutCssClass() {
        return this.rowLayoutCssClass;
    }

    public void setRowLayoutCssClass(String rowLayoutCssClass) {
        this.rowLayoutCssClass = rowLayoutCssClass;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        CssGridLayoutManager cssGridLayoutManagerCopy = (CssGridLayoutManager)component;
        if (this.rowLayoutCssClass != null) {
            cssGridLayoutManagerCopy.setRowLayoutCssClass(this.rowLayoutCssClass);
        }
        cssGridLayoutManagerCopy.setDefaultItemColSpan(this.defaultItemColSpan);
        if (this.conditionalRowCssClasses != null) {
            cssGridLayoutManagerCopy.setConditionalRowCssClasses(new HashMap<String, String>(this.conditionalRowCssClasses));
        }
        if (this.cellCssClassAttributes != null) {
            cssGridLayoutManagerCopy.cellCssClassAttributes = new ArrayList<String>(this.cellCssClassAttributes);
        }
        if (this.rowCssClassAttributes != null) {
            cssGridLayoutManagerCopy.rowCssClassAttributes = new ArrayList<String>(this.rowCssClassAttributes);
        }
        if (this.rows != null) {
            cssGridLayoutManagerCopy.rows = new ArrayList<List<Component>>();
            for (List<Component> row : this.rows) {
                ArrayList<Component> rowCopy = new ArrayList<Component>();
                if (row == null) {
                    cssGridLayoutManagerCopy.rows.add(row);
                    continue;
                }
                for (Component cellComp : row) {
                    if (cellComp == null) {
                        rowCopy.add(cellComp);
                        continue;
                    }
                    rowCopy.add((Component)cellComp.copy());
                }
                cssGridLayoutManagerCopy.rows.add(rowCopy);
            }
        }
    }
}

