/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.view.View;

public abstract class LayoutManagerBase
extends UifDictionaryBeanBase
implements LayoutManager {
    private static final long serialVersionUID = -2657663560459456814L;
    private String id;
    private String template;
    private String templateName;
    private String style;
    private List<String> libraryCssClasses;
    private List<String> cssClasses;
    private List<String> additionalCssClasses;
    @ReferenceCopy(newCollectionInstance=true)
    private Map<String, Object> context = Collections.emptyMap();
    private Map<String, Object> unmodifiableContext = this.context;
    private List<PropertyReplacer> propertyReplacers;

    @Override
    public void performInitialization(View view, Object model, Container container) {
        if (StringUtils.isBlank((String)this.id)) {
            this.id = container.getId() + "_layout";
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Container container) {
    }

    @Override
    public void performFinalize(View view, Object model, Container container) {
        ArrayList<String> finalCssClasses = new ArrayList<String>();
        if (this.libraryCssClasses != null && view.isUseLibraryCssClasses()) {
            finalCssClasses.addAll(this.libraryCssClasses);
        }
        if (this.cssClasses != null) {
            finalCssClasses.addAll(this.cssClasses);
        }
        if (this.additionalCssClasses != null) {
            finalCssClasses.addAll(this.additionalCssClasses);
        }
        this.cssClasses = finalCssClasses;
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return Container.class;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        return new ArrayList<Component>();
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        return components;
    }

    @Override
    @BeanTagAttribute(name="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    @BeanTagAttribute(name="template")
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    @BeanTagAttribute(name="tempateName")
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    @BeanTagAttribute(name="Style")
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    @BeanTagAttribute(name="libraryCssClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getLibraryCssClasses() {
        return this.libraryCssClasses;
    }

    @Override
    public void setLibraryCssClasses(List<String> libraryCssClasses) {
        this.libraryCssClasses = libraryCssClasses;
    }

    @Override
    @BeanTagAttribute(name="cssClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getCssClasses() {
        return this.cssClasses;
    }

    @Override
    @BeanTagAttribute(name="additionalCssClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalCssClasses() {
        return this.additionalCssClasses;
    }

    @Override
    public void setAdditionalCssClasses(List<String> additionalCssClasses) {
        this.additionalCssClasses = additionalCssClasses;
    }

    @Override
    public void setCssClasses(List<String> cssClasses) {
        this.cssClasses = cssClasses;
    }

    public String getStyleClassesAsString() {
        if (this.cssClasses != null) {
            return StringUtils.join(this.cssClasses, (String)" ");
        }
        return "";
    }

    public void setStyleClasses(String styleClasses) {
        String[] classes = StringUtils.split((String)styleClasses);
        this.cssClasses = Arrays.asList(classes);
    }

    @Override
    public void addStyleClass(String styleClass) {
        if (this.cssClasses == null || this.cssClasses.isEmpty()) {
            this.cssClasses = new ArrayList<String>();
        }
        if (!this.cssClasses.contains(styleClass)) {
            this.cssClasses.add(styleClass);
        }
    }

    @Override
    public void appendToStyle(String styleRules) {
        if (this.style == null) {
            this.style = "";
        }
        this.style = this.style + styleRules;
    }

    @Override
    @BeanTagAttribute(name="context", type=BeanTagAttribute.AttributeType.MAPBEAN)
    public Map<String, Object> getContext() {
        return this.unmodifiableContext;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        if (context == null || context.isEmpty()) {
            this.context = Collections.emptyMap();
            this.unmodifiableContext = this.context;
        } else {
            this.context = context;
            this.unmodifiableContext = Collections.unmodifiableMap(this.context);
        }
    }

    @Override
    public void pushObjectToContext(String objectName, Object object) {
        if (this.context.isEmpty()) {
            this.context = new HashMap<String, Object>();
            this.unmodifiableContext = Collections.unmodifiableMap(this.context);
        }
        this.context.put(objectName, object);
    }

    @Override
    public void pushAllToContext(Map<String, Object> sourceContext) {
        if (sourceContext == null || sourceContext.isEmpty()) {
            return;
        }
        if (this.context.isEmpty()) {
            this.context = new HashMap<String, Object>();
            this.unmodifiableContext = Collections.unmodifiableMap(this.context);
        }
        this.context.putAll(sourceContext);
    }

    @Override
    @BeanTagAttribute(name="propertyReplacers", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<PropertyReplacer> getPropertyReplacers() {
        return this.propertyReplacers;
    }

    @Override
    public void setPropertyReplacers(List<PropertyReplacer> propertyReplacers) {
        this.propertyReplacers = propertyReplacers;
    }

    @Override
    public <T> T copy() {
        T copiedClass = null;
        try {
            copiedClass = (T)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        this.copyProperties(copiedClass);
        return copiedClass;
    }

    @Override
    protected <T> void copyProperties(T layoutManager) {
        super.copyProperties(layoutManager);
        LayoutManagerBase layoutManagerBaseCopy = (LayoutManagerBase)layoutManager;
        layoutManagerBaseCopy.setId(this.id);
        layoutManagerBaseCopy.setTemplate(this.template);
        layoutManagerBaseCopy.setTemplateName(this.templateName);
        layoutManagerBaseCopy.setStyle(this.style);
        if (this.libraryCssClasses != null) {
            layoutManagerBaseCopy.setLibraryCssClasses(new ArrayList<String>(this.libraryCssClasses));
        }
        if (this.cssClasses != null && !this.cssClasses.isEmpty()) {
            layoutManagerBaseCopy.setCssClasses(new ArrayList<String>(this.cssClasses));
        }
        if (this.additionalCssClasses != null) {
            layoutManagerBaseCopy.setAdditionalCssClasses(new ArrayList<String>(this.additionalCssClasses));
        }
        if (this.propertyReplacers != null) {
            ArrayList<PropertyReplacer> propertyReplacersCopy = new ArrayList<PropertyReplacer>();
            for (PropertyReplacer propertyReplacer : this.propertyReplacers) {
                propertyReplacersCopy.add((PropertyReplacer)propertyReplacer.copy());
            }
            layoutManagerBaseCopy.setPropertyReplacers(propertyReplacersCopy);
        }
    }
}

