/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.layout.CollectionLayoutUtils;
import org.kuali.rice.krad.uif.layout.GridLayoutManager;
import org.kuali.rice.krad.uif.util.ColumnCalculationInfo;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Pager;
import org.kuali.rice.krad.uif.widget.RichTable;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTag(name="tableCollectionLayout-bean", parent="Uif-TableCollectionLayout")
public class TableLayoutManager
extends GridLayoutManager
implements CollectionLayoutManager {
    private static final long serialVersionUID = 3622267585541524208L;
    private boolean useShortLabels = false;
    private boolean repeatHeader = false;
    private Label headerLabelPrototype;
    private boolean renderSequenceField = true;
    private boolean generateAutoSequence = false;
    private Field sequenceFieldPrototype;
    private FieldGroup actionFieldPrototype;
    private FieldGroup subCollectionFieldGroupPrototype;
    private Field selectFieldPrototype;
    private boolean separateAddLine = false;
    private Group addLineGroup;
    private int numberOfDataColumns;
    private List<Label> headerLabels = new ArrayList<Label>();
    private List<Field> allRowFields = new ArrayList<Field>();
    private List<Field> firstRowFields = new ArrayList<Field>();
    private Pager pagerWidget;
    private RichTable richTable;
    private boolean headerAdded;
    private int actionColumnIndex = -1;
    private String actionColumnPlacement;
    private Group rowDetailsGroup;
    private boolean rowDetailsOpen = false;
    private boolean showToggleAllDetails;
    private Action toggleAllDetailsAction;
    private boolean ajaxDetailsRetrieval;
    private Action expandDetailsActionPrototype;
    @KeepExpression
    private String groupingTitle;
    private String groupingPrefix;
    private int groupingColumnIndex;
    private List<String> groupingPropertyNames;
    private boolean renderOnlyLeftTotalLabels;
    private boolean showTotal;
    private boolean showPageTotal;
    private boolean showGroupTotal;
    private boolean generateGroupTotalRows;
    private Label totalLabel;
    private Label pageTotalLabel;
    private Label groupTotalLabelPrototype;
    private List<String> columnsToCalculate = new ArrayList<String>();
    private List<ColumnCalculationInfo> columnCalculations = new ArrayList<ColumnCalculationInfo>();
    private List<Component> footerCalculationComponents;
    private Map<String, String> conditionalRowCssClasses = new HashMap<String, String>();

    @Override
    public void performInitialization(View view, Object model, Container container) {
        CollectionGroup collectionGroup = (CollectionGroup)container;
        this.setupDetails(collectionGroup, view);
        this.setupGrouping(collectionGroup, view);
        if (collectionGroup.isAddViaLightBox()) {
            this.setSeparateAddLine(true);
        }
        super.performInitialization(view, model, container);
        this.getRowCssClasses().clear();
        if (this.generateAutoSequence && !(this.getSequenceFieldPrototype() instanceof MessageField)) {
            this.sequenceFieldPrototype = ComponentFactory.getMessageField();
            view.assignComponentIds(this.getSequenceFieldPrototype());
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Container container) {
        super.performApplyModel(view, model, container);
        for (ColumnCalculationInfo cInfo : this.columnCalculations) {
            ExpressionUtils.populatePropertyExpressionsFromGraph(cInfo, false);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Container container) {
        super.performFinalize(view, model, container);
        UifFormBase formBase = (UifFormBase)model;
        CollectionGroup collectionGroup = (CollectionGroup)container;
        int totalColumns = this.getNumberOfDataColumns();
        if (this.renderSequenceField) {
            ++totalColumns;
        }
        if (collectionGroup.isIncludeLineSelectionField()) {
            ++totalColumns;
        }
        if (collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly()) {
            ++totalColumns;
        }
        this.setNumberOfColumns(totalColumns);
        if ("addLine".equals(formBase.getActionEvent())) {
            String highlightScript = "jQuery(\"#" + container.getId() + " tr:first\").effect(\"highlight\",{}, 6000);";
            String onReadyScript = collectionGroup.getOnDocumentReadyScript();
            if (StringUtils.isNotBlank((String)onReadyScript)) {
                highlightScript = onReadyScript + highlightScript;
            }
            collectionGroup.setOnDocumentReadyScript(highlightScript);
        }
        if (this.columnCalculations != null && this.richTable != null && this.getAllRowFields() != null && !this.getAllRowFields().isEmpty()) {
            this.setupColumnCalculations(view, model, container, totalColumns);
        }
        if ((this.groupingPropertyNames != null || StringUtils.isNotBlank((String)this.getGroupingTitle())) && this.richTable != null) {
            this.richTable.setGroupingOptionsJSString("{iGroupingColumnIndex: " + this.groupingColumnIndex + ", bGenerateGroupTotalRows:" + this.generateGroupTotalRows + ", bSetGroupingClassOnTR: true" + ", sGroupingClass: 'uif-groupRow'" + (this.getGroupingPrefix() != null ? ", sGroupLabelPrefix: '" + this.getGroupingPrefix() + "'" : "") + "}");
        }
        if ((this.getRichTable() == null || !this.getRichTable().isRender()) && ((CollectionGroup)container).isUseServerPaging() && this.getPagerWidget() != null) {
            CollectionLayoutUtils.setupPagerWidget(this.pagerWidget, collectionGroup, model);
        }
    }

    private void setupGrouping(CollectionGroup collectionGroup, View view) {
        String groupingTitleExpression = "";
        if (StringUtils.isNotBlank((String)this.getPropertyExpression("groupingTitle"))) {
            groupingTitleExpression = this.getPropertyExpression("groupingTitle");
            this.setGroupingTitle(this.getPropertyExpression("groupingTitle"));
        } else if (this.getGroupingPropertyNames() != null) {
            for (String propertyName : this.getGroupingPropertyNames()) {
                groupingTitleExpression = groupingTitleExpression + ", " + propertyName;
            }
            groupingTitleExpression = groupingTitleExpression.replaceFirst(", ", "@{#lp.");
            groupingTitleExpression = groupingTitleExpression.replace(", ", "}, @{#lp.");
            groupingTitleExpression = groupingTitleExpression.trim() + "}";
        }
        if (StringUtils.isNotBlank((String)groupingTitleExpression)) {
            MessageField groupingMessageField = ComponentFactory.getColGroupingField();
            groupingMessageField.getMessage().getPropertyExpressions().put("messageText", groupingTitleExpression);
            groupingMessageField.addDataAttribute("role", "RowGrouping");
            view.assignComponentIds(groupingMessageField);
            ArrayList<? extends Component> theItems = new ArrayList<Component>();
            theItems.add(groupingMessageField);
            theItems.addAll(collectionGroup.getItems());
            collectionGroup.setItems(theItems);
        }
    }

    protected void setupColumnCalculations(View view, Object model, Container container, int totalColumns) {
        this.footerCalculationComponents = new ArrayList<Component>(totalColumns);
        for (int i = 0; i < totalColumns; ++i) {
            this.footerCalculationComponents.add(null);
        }
        int leftLabelColumnIndex = 0;
        if (this.groupingPropertyNames != null || StringUtils.isNotBlank((String)this.getGroupingTitle())) {
            leftLabelColumnIndex = 1;
        }
        for (ColumnCalculationInfo cInfo : this.columnCalculations) {
            if (StringUtils.isNotBlank((String)cInfo.getPropertyName())) {
                for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                    Component component = this.getAllRowFields().get(i);
                    if (component == null || !(component instanceof DataField) || !((DataField)component).getPropertyName().equals(cInfo.getPropertyName())) continue;
                    cInfo.setColumnNumber(i);
                }
            } else {
                throw new RuntimeException("TableLayoutManager(" + container.getId() + "->" + this.getId() + ") ColumnCalculationInfo MUST have a propertyName set");
            }
            this.getColumnsToCalculate().add(cInfo.getColumnNumber().toString());
            FieldGroup calculationFieldGroup = ComponentFactory.getFieldGroup();
            calculationFieldGroup.addDataAttribute("role", "totalsBlock");
            ArrayList<Field> calculationFieldGroupItems = new ArrayList<Field>();
            if (cInfo.isShowPageTotal()) {
                Field pageTotalDataField = this.setupTotalField(cInfo.getPageTotalField(), cInfo, this.isShowPageTotal(), this.getPageTotalLabel(), "pageTotal", leftLabelColumnIndex);
                calculationFieldGroupItems.add(pageTotalDataField);
            }
            if (cInfo.isShowTotal()) {
                Field totalDataField = this.setupTotalField(cInfo.getTotalField(), cInfo, this.isShowTotal(), this.getTotalLabel(), "total", leftLabelColumnIndex);
                if (!cInfo.isRecalculateTotalClientSide()) {
                    totalDataField.addDataAttribute("skip_total", "true");
                }
                calculationFieldGroupItems.add(totalDataField);
            }
            if (cInfo.isShowGroupTotal()) {
                Field groupTotalDataField = this.setupTotalField(cInfo.getGroupTotalFieldPrototype(), cInfo, this.isShowGroupTotal(), this.getGroupTotalLabelPrototype(), "groupTotal", leftLabelColumnIndex);
                groupTotalDataField.setId(container.getId() + "_gTotal" + cInfo.getColumnNumber());
                groupTotalDataField.setStyle("display: none;");
                calculationFieldGroupItems.add(groupTotalDataField);
                this.generateGroupTotalRows = !this.isRenderOnlyLeftTotalLabels() || this.isShowGroupTotal();
            }
            calculationFieldGroup.setItems(calculationFieldGroupItems);
            view.assignComponentIds(calculationFieldGroup);
            Component component = this.footerCalculationComponents.get(cInfo.getColumnNumber());
            if (component != null && component instanceof FieldGroup) {
                Group verticalComboCalcGroup = ComponentFactory.getVerticalBoxGroup();
                view.assignComponentIds(verticalComboCalcGroup);
                ArrayList<Component> comboGroupItems = new ArrayList<Component>();
                comboGroupItems.add(component);
                comboGroupItems.add(calculationFieldGroup);
                verticalComboCalcGroup.setItems(comboGroupItems);
                this.footerCalculationComponents.set(cInfo.getColumnNumber(), verticalComboCalcGroup);
                continue;
            }
            if (component != null && component instanceof Group) {
                ArrayList<? extends Component> comboGroupItems = new ArrayList<Component>();
                comboGroupItems.addAll(((Group)component).getItems());
                comboGroupItems.add(calculationFieldGroup);
                ((Group)component).setItems(comboGroupItems);
                this.footerCalculationComponents.set(cInfo.getColumnNumber(), component);
                continue;
            }
            this.footerCalculationComponents.set(cInfo.getColumnNumber(), calculationFieldGroup);
        }
        if (this.renderOnlyLeftTotalLabels && this.footerCalculationComponents.get(leftLabelColumnIndex) == null) {
            Group labelGroup = ComponentFactory.getVerticalBoxGroup();
            view.assignComponentIds(labelGroup);
            ArrayList<Label> groupItems = new ArrayList<Label>();
            if (this.isShowGroupTotal()) {
                this.groupTotalLabelPrototype.setStyle("display: none;");
                this.groupTotalLabelPrototype.addDataAttribute("role", "groupTotalLabel");
                view.assignComponentIds(this.groupTotalLabelPrototype);
                groupItems.add(this.groupTotalLabelPrototype);
            }
            if (this.isShowPageTotal()) {
                view.assignComponentIds(this.pageTotalLabel);
                this.pageTotalLabel.addDataAttribute("role", "pageTotal");
                groupItems.add(this.pageTotalLabel);
            }
            if (this.isShowTotal()) {
                view.assignComponentIds(this.totalLabel);
                groupItems.add(this.totalLabel);
            }
            labelGroup.setItems(groupItems);
            this.footerCalculationComponents.set(leftLabelColumnIndex, labelGroup);
        }
        for (Component component : this.footerCalculationComponents) {
            view.getViewHelperService().spawnSubLifecyle(view, model, component, container, null, null);
        }
    }

    protected Field setupTotalField(Field totalField, ColumnCalculationInfo cInfo, boolean show, Label leftLabel, String type, int leftLabelColumnIndex) {
        Field totalDataField = totalField;
        totalDataField.addDataAttribute("role", type);
        totalDataField.addDataAttribute("function", cInfo.getCalculationFunctionName());
        totalDataField.addDataAttribute("params", cInfo.getCalculationFunctionExtraData());
        if (cInfo.getColumnNumber() != leftLabelColumnIndex) {
            totalDataField.getFieldLabel().setRender(!this.isRenderOnlyLeftTotalLabels());
        } else if (cInfo.getColumnNumber() == leftLabelColumnIndex && this.isRenderOnlyLeftTotalLabels()) {
            totalDataField.setFieldLabel(leftLabel);
        }
        if (this.isRenderOnlyLeftTotalLabels()) {
            totalDataField.setRender(show);
        }
        return totalDataField;
    }

    @Override
    public void buildLine(View view, Object model, CollectionGroup collectionGroup, List<Field> lineFields, List<FieldGroup> subCollectionFields, String bindingPath, List<Action> actions, String idSuffix, Object currentLine, int lineIndex) {
        boolean addLineInTable;
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        for (Field lineField : lineFields) {
            lineField.pushObjectToContext("parent", collectionGroup);
            lineField.pushAllToContext(view.getViewHelperService().getCommonContext(view, lineField));
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "rowSpan", true);
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "colSpan", true);
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "required", true);
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "readOnly", true);
        }
        if (this.allRowFields.isEmpty()) {
            if (this.isSuppressLineWrapping()) {
                this.setNumberOfDataColumns(lineFields.size());
            } else {
                this.setNumberOfDataColumns(this.getNumberOfColumns());
            }
        }
        boolean isAddLine = false;
        if (lineIndex == -1 || lineFields.size() != this.numberOfDataColumns && (lineIndex + 1) * this.numberOfDataColumns < lineFields.size()) {
            isAddLine = true;
        }
        if (lineIndex == 0 || this.firstRowFields.isEmpty()) {
            this.firstRowFields = lineFields;
        }
        boolean renderActions = collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly();
        int extraColumns = 0;
        String rowCss = "";
        boolean bl = addLineInTable = collectionGroup.isRenderAddLine() && !collectionGroup.isReadOnly() && !this.isSeparateAddLine();
        if (collectionGroup.isHighlightNewItems() && ((UifFormBase)model).isAddedCollectionItem(currentLine)) {
            rowCss = collectionGroup.getNewItemsCssClass();
        } else if (isAddLine && addLineInTable) {
            rowCss = collectionGroup.getAddItemCssClass();
            this.addStyleClass("uif-hasAddLine");
        }
        if (rowCss == null) {
            rowCss = "";
        }
        if (this.conditionalRowCssClasses != null && !this.conditionalRowCssClasses.isEmpty()) {
            int oddRemainder = 1;
            if (!addLineInTable) {
                oddRemainder = 0;
            }
            boolean isOdd = lineIndex % 2 == oddRemainder || lineIndex == -1;
            HashMap<String, Object> lineContext = new HashMap<String, Object>();
            lineContext.putAll(this.getContext());
            lineContext.put("line", currentLine);
            lineContext.put("manager", this);
            lineContext.put("view", view);
            lineContext.put("lineSuffix", idSuffix);
            lineContext.put("index", lineIndex);
            lineContext.put("collectionGroup", collectionGroup);
            lineContext.put("isAddLine", isAddLine && !this.isSeparateAddLine());
            lineContext.put("readOnlyLine", collectionGroup.isReadOnly());
            rowCss = rowCss + " " + KRADUtils.generateRowCssClassString(this.conditionalRowCssClasses, lineIndex, isOdd, lineContext, expressionEvaluator);
        }
        rowCss = StringUtils.removeStart((String)rowCss, (String)" ");
        this.getRowCssClasses().add(rowCss);
        if (isAddLine && this.separateAddLine) {
            if (StringUtils.isBlank((String)this.addLineGroup.getTitle()) && StringUtils.isBlank((String)this.addLineGroup.getHeader().getHeaderText())) {
                this.addLineGroup.getHeader().setHeaderText(collectionGroup.getAddLabel());
            }
            this.addLineGroup.setItems(lineFields);
            ArrayList<Action> footerItems = new ArrayList<Action>(actions);
            footerItems.addAll(this.addLineGroup.getFooter().getItems());
            this.addLineGroup.getFooter().setItems(footerItems);
            if (collectionGroup.isAddViaLightBox()) {
                String actionScript = "showLightboxComponent('" + this.addLineGroup.getId() + "');";
                if (StringUtils.isNotBlank((String)collectionGroup.getAddViaLightBoxAction().getActionScript())) {
                    actionScript = collectionGroup.getAddViaLightBoxAction().getActionScript() + actionScript;
                }
                collectionGroup.getAddViaLightBoxAction().setActionScript(actionScript);
                this.addLineGroup.setStyle("display: none");
            }
            return;
        }
        if (!this.headerAdded) {
            this.headerLabels = new ArrayList<Label>();
            this.allRowFields = new ArrayList<Field>();
            this.buildTableHeaderRows(collectionGroup, lineFields);
            ComponentUtils.pushObjectToContext(this.headerLabels, "line", currentLine);
            ComponentUtils.pushObjectToContext(this.headerLabels, "index", (Object)new Integer(lineIndex));
            this.headerAdded = true;
        }
        for (Field field : lineFields) {
            field.setLabelRendered(true);
            field.setFieldLabel(null);
            this.setCellAttributes(field);
        }
        int rowCount = this.calculateNumberOfRows(lineFields);
        int rowSpan = rowCount + subCollectionFields.size();
        if (this.actionColumnIndex == 1 && renderActions) {
            this.addActionColumn(idSuffix, currentLine, lineIndex, rowSpan, actions);
        }
        if (this.renderSequenceField) {
            Field sequenceField = null;
            if (!isAddLine) {
                sequenceField = ComponentUtils.copy(this.getSequenceFieldPrototype(), idSuffix);
                sequenceField.addDataAttribute("vignore", "yes");
                if (this.generateAutoSequence && sequenceField instanceof MessageField) {
                    ((MessageField)sequenceField).setMessageText(Integer.toString(lineIndex + 1));
                }
            } else {
                sequenceField = ComponentFactory.getMessageField();
                view.assignComponentIds(sequenceField);
                Message sequenceMessage = ComponentUtils.copy(collectionGroup.getAddLineLabel(), idSuffix);
                ((MessageField)sequenceField).setMessage(sequenceMessage);
                sequenceField.setCellWidth(this.getSequenceFieldPrototype().getCellWidth());
                sequenceField.setCellStyle(this.getSequenceFieldPrototype().getCellStyle());
            }
            sequenceField.setRowSpan(rowSpan);
            if (sequenceField instanceof DataBinding) {
                ((DataBinding)((Object)sequenceField)).getBindingInfo().setBindByNamePrefix(bindingPath);
            }
            this.setCellAttributes(sequenceField);
            ComponentUtils.updateContextForLine(sequenceField, currentLine, lineIndex, idSuffix);
            this.allRowFields.add(sequenceField);
            ++extraColumns;
            if (this.actionColumnIndex == 2 && renderActions) {
                this.addActionColumn(idSuffix, currentLine, lineIndex, rowSpan, actions);
            }
        }
        if (collectionGroup.isIncludeLineSelectionField()) {
            Field selectField = ComponentUtils.copy(this.getSelectFieldPrototype(), idSuffix);
            CollectionLayoutUtils.prepareSelectFieldForLine(selectField, collectionGroup, bindingPath, currentLine);
            ComponentUtils.updateContextForLine(selectField, currentLine, lineIndex, idSuffix);
            this.setCellAttributes(selectField);
            this.allRowFields.add(selectField);
            ++extraColumns;
            if (renderActions && (this.actionColumnIndex == 3 && this.renderSequenceField || this.actionColumnIndex == 2 && !this.renderSequenceField)) {
                this.addActionColumn(idSuffix, currentLine, lineIndex, rowSpan, actions);
            }
        }
        int cellPosition = 0;
        boolean renderActionsLast = this.actionColumnIndex == -1 || this.actionColumnIndex > lineFields.size() + extraColumns;
        boolean hasGrouping = this.groupingPropertyNames != null || StringUtils.isNotBlank((String)this.getGroupingTitle());
        boolean insertActionField = false;
        for (Field lineField : lineFields) {
            insertActionField = cellPosition != 0 && lineFields.size() != this.numberOfDataColumns && renderActions && renderActionsLast && cellPosition % this.numberOfDataColumns == 0;
            cellPosition += lineField.getColSpan();
            Map<String, String> lineFieldDataAttributes = lineField.getDataAttributes();
            if (hasGrouping && lineField instanceof MessageField && lineFieldDataAttributes != null && "RowGrouping".equals(lineFieldDataAttributes.get("role"))) {
                int groupFieldIndex = this.allRowFields.size() - extraColumns;
                this.allRowFields.add(groupFieldIndex, lineField);
                this.groupingColumnIndex = 0;
                if (isAddLine) {
                    ((MessageField)lineField).getMessage().getPropertyExpressions().remove("messageText");
                    ((MessageField)lineField).getMessage().setMessageText("addLine");
                }
            } else {
                if (insertActionField) {
                    this.addActionColumn(idSuffix, currentLine, lineIndex, rowSpan, actions);
                }
                this.allRowFields.add(lineField);
            }
            if (!renderActionsLast && cellPosition == this.actionColumnIndex - extraColumns - 1) {
                this.addActionColumn(idSuffix, currentLine, lineIndex, rowSpan, actions);
            }
            if (lineField instanceof FieldGroup && ((FieldGroup)lineField).getItems() != null) {
                for (Component component : ((FieldGroup)lineField).getItems()) {
                    if (component == null || !(component instanceof Action) || component.getDataAttributes() == null || component.getDataAttributes().get("role") == null || !component.getDataAttributes().get("role").equals("detailsLink") || !StringUtils.isBlank((String)((Action)component).getActionScript())) continue;
                    ((Action)component).setActionScript("rowDetailsActionHandler(this,'" + this.getId() + "');");
                }
            }
            if (!(lineField instanceof InputField) || this.columnCalculations == null) continue;
            for (ColumnCalculationInfo columnCalculationInfo : this.columnCalculations) {
                if (!columnCalculationInfo.getPropertyName().equals(((InputField)lineField).getPropertyName())) continue;
                if (columnCalculationInfo.isCalculateOnKeyUp()) {
                    lineField.addDataAttribute("total", "keyup");
                } else {
                    lineField.addDataAttribute("total", "change");
                }
                lineField.addStyleClass("uif-calculationField");
            }
        }
        if (lineFields.size() == this.numberOfDataColumns && renderActions && renderActionsLast) {
            this.addActionColumn(idSuffix, currentLine, lineIndex, rowSpan, actions);
        }
        for (FieldGroup subCollectionField : subCollectionFields) {
            subCollectionField.setColSpan(this.numberOfDataColumns);
        }
        this.allRowFields.addAll(subCollectionFields);
    }

    private void addActionColumn(String idSuffix, Object currentLine, int lineIndex, int rowSpan, List<Action> actions) {
        FieldGroup lineActionsField = ComponentUtils.copy(this.getActionFieldPrototype(), idSuffix);
        ComponentUtils.updateContextForLine(lineActionsField, currentLine, lineIndex, idSuffix);
        lineActionsField.setRowSpan(rowSpan);
        lineActionsField.setItems(actions);
        this.setCellAttributes(lineActionsField);
        this.allRowFields.add(lineActionsField);
    }

    protected void buildTableHeaderRows(CollectionGroup collectionGroup, List<Field> lineFields) {
        int rowCount = this.calculateNumberOfRows(lineFields);
        boolean renderActions = collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly();
        String idSuffix = collectionGroup.getSubCollectionSuffix();
        int extraColumns = 0;
        if (this.actionColumnIndex == 1 && renderActions) {
            this.addActionHeader(rowCount, idSuffix, 1);
        }
        if (this.renderSequenceField) {
            this.getSequenceFieldPrototype().setLabelRendered(true);
            this.getSequenceFieldPrototype().setRowSpan(rowCount);
            this.addHeaderField(this.getSequenceFieldPrototype(), idSuffix, 1);
            ++extraColumns;
            if (this.actionColumnIndex == 2 && renderActions) {
                this.addActionHeader(rowCount, idSuffix, 2);
            }
        }
        if (collectionGroup.isIncludeLineSelectionField()) {
            this.getSelectFieldPrototype().setLabelRendered(true);
            this.getSelectFieldPrototype().setRowSpan(rowCount);
            this.addHeaderField(this.getSelectFieldPrototype(), idSuffix, 1);
            ++extraColumns;
            if (this.actionColumnIndex == 3 && renderActions && this.renderSequenceField) {
                this.addActionHeader(rowCount, idSuffix, 3);
            } else if (this.actionColumnIndex == 2 && renderActions) {
                this.addActionHeader(rowCount, idSuffix, 2);
            }
        }
        int cellPosition = 0;
        boolean renderActionsLast = this.actionColumnIndex == -1 || this.actionColumnIndex > lineFields.size() + extraColumns;
        boolean insertActionHeader = false;
        for (Field field : lineFields) {
            if (!field.isRender() && StringUtils.isEmpty((String)field.getProgressiveRender())) continue;
            boolean bl = insertActionHeader = cellPosition != 0 && lineFields.size() != this.numberOfDataColumns && renderActions && renderActionsLast && cellPosition % this.numberOfDataColumns == 0;
            if (insertActionHeader) {
                this.addActionHeader(rowCount, idSuffix, cellPosition);
            }
            this.addHeaderField(field, idSuffix, cellPosition += field.getColSpan());
            if (!renderActions || renderActionsLast || cellPosition != this.actionColumnIndex - extraColumns - 1) continue;
            this.addActionHeader(rowCount, idSuffix, ++cellPosition);
        }
        if (lineFields.size() == this.numberOfDataColumns && renderActions && renderActionsLast) {
            this.addActionHeader(rowCount, idSuffix, ++cellPosition);
        }
    }

    protected void addActionHeader(int rowCount, String idSuffix, int cellPosition) {
        this.getActionFieldPrototype().setLabelRendered(true);
        this.getActionFieldPrototype().setRowSpan(rowCount);
        this.addHeaderField(this.getActionFieldPrototype(), idSuffix, cellPosition);
    }

    protected void addHeaderField(Field field, String idSuffix, int column) {
        String labelSuffix = "_c" + column;
        if (StringUtils.isNotBlank((String)idSuffix)) {
            labelSuffix = idSuffix + labelSuffix;
        }
        Label headerLabel = ComponentUtils.copy(this.getHeaderLabelPrototype(), labelSuffix);
        if (this.useShortLabels) {
            headerLabel.setLabelText(field.getShortLabel());
        } else {
            headerLabel.setLabelText(field.getLabel());
        }
        headerLabel.setRowSpan(field.getRowSpan());
        headerLabel.setColSpan(field.getColSpan());
        if (field.getRequired() != null && field.getRequired().booleanValue()) {
            headerLabel.getRequiredMessage().setRender(!field.isReadOnly());
        } else {
            headerLabel.getRequiredMessage().setRender(false);
        }
        this.setCellAttributes(field);
        headerLabel.setCellCssClasses(field.getCellCssClasses());
        headerLabel.setCellStyle(field.getCellStyle());
        headerLabel.setCellWidth(field.getCellWidth());
        this.headerLabels.add(headerLabel);
    }

    protected int calculateNumberOfRows(List<? extends Field> items) {
        int rowCount = 0;
        if (this.isSuppressLineWrapping()) {
            return 1;
        }
        if (items.size() % this.getNumberOfDataColumns() > 0) {
            Field field = items.get(items.size() - 1);
            int colSize = 0;
            for (Field field2 : items) {
                colSize += field2.getColSpan();
            }
            field.setColSpan(1 + (this.numberOfDataColumns - colSize % this.numberOfDataColumns));
            rowCount = items.size() / this.getNumberOfDataColumns() + 1;
        } else {
            rowCount = items.size() / this.getNumberOfDataColumns();
        }
        return rowCount;
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return CollectionGroup.class;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.pagerWidget);
        components.add(this.richTable);
        components.add(this.addLineGroup);
        components.addAll(this.headerLabels);
        components.addAll(this.allRowFields);
        if (this.columnCalculations != null) {
            for (ColumnCalculationInfo cInfo : this.columnCalculations) {
                components.add(cInfo.getTotalField());
                components.add(cInfo.getPageTotalField());
                components.add(cInfo.getGroupTotalFieldPrototype());
            }
        }
        if (this.isShowToggleAllDetails()) {
            components.add(this.toggleAllDetailsAction);
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.add(this.getHeaderLabelPrototype());
        components.add(this.getSequenceFieldPrototype());
        components.add(this.getActionFieldPrototype());
        components.add(this.getSubCollectionFieldGroupPrototype());
        components.add(this.getSelectFieldPrototype());
        return components;
    }

    @BeanTagAttribute(name="useShortLabels")
    public boolean isUseShortLabels() {
        return this.useShortLabels;
    }

    public void setUseShortLabels(boolean useShortLabels) {
        this.useShortLabels = useShortLabels;
    }

    @BeanTagAttribute(name="repeatHeader")
    public boolean isRepeatHeader() {
        return this.repeatHeader;
    }

    public void setRepeatHeader(boolean repeatHeader) {
        this.repeatHeader = repeatHeader;
    }

    @BeanTagAttribute(name="headerLabelPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Label getHeaderLabelPrototype() {
        return this.headerLabelPrototype;
    }

    public void setHeaderLabelPrototype(Label headerLabelPrototype) {
        this.headerLabelPrototype = headerLabelPrototype;
    }

    public List<Label> getHeaderLabels() {
        return this.headerLabels;
    }

    @BeanTagAttribute(name="renderSequenceField")
    public boolean isRenderSequenceField() {
        return this.renderSequenceField;
    }

    public void setRenderSequenceField(boolean renderSequenceField) {
        this.renderSequenceField = renderSequenceField;
    }

    @BeanTagAttribute(name="sequencePropertyName")
    public String getSequencePropertyName() {
        if (this.getSequenceFieldPrototype() != null && this.getSequenceFieldPrototype() instanceof DataField) {
            return ((DataField)this.getSequenceFieldPrototype()).getPropertyName();
        }
        return null;
    }

    public void setSequencePropertyName(String sequencePropertyName) {
        if (this.getSequenceFieldPrototype() != null && this.getSequenceFieldPrototype() instanceof DataField) {
            ((DataField)this.getSequenceFieldPrototype()).setPropertyName(sequencePropertyName);
        }
    }

    @BeanTagAttribute(name="generateAutoSequence")
    public boolean isGenerateAutoSequence() {
        return this.generateAutoSequence;
    }

    public void setGenerateAutoSequence(boolean generateAutoSequence) {
        this.generateAutoSequence = generateAutoSequence;
    }

    @BeanTagAttribute(name="sequenceFieldPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Field getSequenceFieldPrototype() {
        return this.sequenceFieldPrototype;
    }

    public void setSequenceFieldPrototype(Field sequenceFieldPrototype) {
        this.sequenceFieldPrototype = sequenceFieldPrototype;
    }

    @BeanTagAttribute(name="actionFieldPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public FieldGroup getActionFieldPrototype() {
        return this.actionFieldPrototype;
    }

    public void setActionFieldPrototype(FieldGroup actionFieldPrototype) {
        this.actionFieldPrototype = actionFieldPrototype;
    }

    @Override
    @BeanTagAttribute(name="subCollectionFieldGroupPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public FieldGroup getSubCollectionFieldGroupPrototype() {
        return this.subCollectionFieldGroupPrototype;
    }

    public void setSubCollectionFieldGroupPrototype(FieldGroup subCollectionFieldGroupPrototype) {
        this.subCollectionFieldGroupPrototype = subCollectionFieldGroupPrototype;
    }

    @BeanTagAttribute(name="selectFieldPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Field getSelectFieldPrototype() {
        return this.selectFieldPrototype;
    }

    public void setSelectFieldPrototype(Field selectFieldPrototype) {
        this.selectFieldPrototype = selectFieldPrototype;
    }

    @BeanTagAttribute(name="separateAddLine")
    public boolean isSeparateAddLine() {
        return this.separateAddLine;
    }

    public void setSeparateAddLine(boolean separateAddLine) {
        this.separateAddLine = separateAddLine;
    }

    @BeanTagAttribute(name="addLineGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getAddLineGroup() {
        return this.addLineGroup;
    }

    public void setAddLineGroup(Group addLineGroup) {
        this.addLineGroup = addLineGroup;
    }

    public List<Field> getAllRowFields() {
        return this.allRowFields;
    }

    public List<Field> getFirstRowFields() {
        return this.firstRowFields;
    }

    public Pager getPagerWidget() {
        return this.pagerWidget;
    }

    public void setPagerWidget(Pager pagerWidget) {
        this.pagerWidget = pagerWidget;
    }

    @BeanTagAttribute(name="richTable", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public RichTable getRichTable() {
        return this.richTable;
    }

    public void setRichTable(RichTable richTable) {
        this.richTable = richTable;
    }

    @BeanTagAttribute(name="numberOfDataColumns")
    public int getNumberOfDataColumns() {
        return this.numberOfDataColumns;
    }

    public void setNumberOfDataColumns(int numberOfDataColumns) {
        this.numberOfDataColumns = numberOfDataColumns;
    }

    @BeanTagAttribute(name="hiddenColumns", type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getHiddenColumns() {
        if (this.richTable != null) {
            return this.richTable.getHiddenColumns();
        }
        return null;
    }

    public void setHiddenColumns(Set<String> hiddenColumns) {
        if (this.richTable != null) {
            this.richTable.setHiddenColumns(hiddenColumns);
        }
    }

    @BeanTagAttribute(name="sortableColumns", type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getSortableColumns() {
        if (this.richTable != null) {
            return this.richTable.getSortableColumns();
        }
        return null;
    }

    public void setSortableColumns(Set<String> sortableColumns) {
        if (this.richTable != null) {
            this.richTable.setSortableColumns(sortableColumns);
        }
    }

    @BeanTagAttribute(name="actionColumnIndex")
    public int getActionColumnIndex() {
        return this.actionColumnIndex;
    }

    @BeanTagAttribute(name="actionColumnPlacement")
    public String getActionColumnPlacement() {
        return this.actionColumnPlacement;
    }

    public void setActionColumnPlacement(String actionColumnPlacement) {
        this.actionColumnPlacement = actionColumnPlacement;
        if ("LEFT".equals(actionColumnPlacement)) {
            this.actionColumnIndex = 1;
        } else if ("RIGHT".equals(actionColumnPlacement)) {
            this.actionColumnIndex = -1;
        } else if (StringUtils.isNumeric((String)actionColumnPlacement)) {
            this.actionColumnIndex = Integer.parseInt(actionColumnPlacement);
        }
    }

    @BeanTagAttribute(name="rowDetailsGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getRowDetailsGroup() {
        return this.rowDetailsGroup;
    }

    public void setRowDetailsGroup(Group rowDetailsGroup) {
        this.rowDetailsGroup = rowDetailsGroup;
    }

    public void setupDetails(CollectionGroup collectionGroup, View view) {
        if (this.getRowDetailsGroup() == null || this.getRichTable() == null || !this.getRichTable().isRender()) {
            return;
        }
        collectionGroup.addDataAttribute("details_default_open", Boolean.toString(this.rowDetailsOpen));
        this.toggleAllDetailsAction.addDataAttribute("open", Boolean.toString(this.rowDetailsOpen));
        this.toggleAllDetailsAction.addDataAttribute("tableid", this.getId());
        this.getRowDetailsGroup().setHidden(true);
        FieldGroup detailsFieldGroup = ComponentFactory.getFieldGroup();
        TreeMap<String, String> dataAttributes = new TreeMap<String, String>();
        dataAttributes.put("role", "detailsFieldGroup");
        detailsFieldGroup.setDataAttributes(dataAttributes);
        Action rowDetailsAction = this.getExpandDetailsActionPrototype();
        rowDetailsAction.addDataAttribute("role", "detailsLink");
        rowDetailsAction.setId(collectionGroup.getId() + "_detLink");
        ArrayList<ComponentBase> detailsItems = new ArrayList<ComponentBase>();
        detailsItems.add(rowDetailsAction);
        dataAttributes = new TreeMap();
        dataAttributes.put("role", "details");
        dataAttributes.put("open", Boolean.toString(this.rowDetailsOpen));
        this.getRowDetailsGroup().setDataAttributes(dataAttributes);
        if (this.ajaxDetailsRetrieval) {
            this.getRowDetailsGroup().setRender(false);
            this.getRowDetailsGroup().setDisclosedByAction(true);
        }
        detailsItems.add(this.getRowDetailsGroup());
        detailsFieldGroup.setItems(detailsItems);
        detailsFieldGroup.setId(collectionGroup.getId() + "_detGroup");
        view.assignComponentIds(detailsFieldGroup);
        ArrayList<? extends Component> theItems = new ArrayList<Component>();
        theItems.add(detailsFieldGroup);
        theItems.addAll(collectionGroup.getItems());
        collectionGroup.setItems(theItems);
    }

    public List<String> getColumnsToCalculate() {
        return this.columnsToCalculate;
    }

    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean("TableLayoutManager", this.getId());
        if (this.getRowDetailsGroup() != null) {
            boolean validTable = false;
            if (this.getRichTable() != null && this.getRichTable().isRender()) {
                validTable = true;
            }
            if (!validTable) {
                String[] currentValues = new String[]{"rowDetailsGroup =" + this.getRowDetailsGroup(), "richTable =" + this.getRichTable()};
                tracer.createError("If rowDetailsGroup is set richTable must be set and its render true", currentValues);
            }
        }
    }

    @BeanTagAttribute(name="showTotal")
    public boolean isShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean showTotal) {
        this.showTotal = showTotal;
    }

    @BeanTagAttribute(name="showPageTotal")
    public boolean isShowPageTotal() {
        return this.showPageTotal;
    }

    public void setShowPageTotal(boolean showPageTotal) {
        this.showPageTotal = showPageTotal;
    }

    @BeanTagAttribute(name="showGroupTotal")
    public boolean isShowGroupTotal() {
        return this.showGroupTotal;
    }

    public void setShowGroupTotal(boolean showGroupTotal) {
        this.showGroupTotal = showGroupTotal;
    }

    @BeanTagAttribute(name="totalLabel", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Label getTotalLabel() {
        return this.totalLabel;
    }

    public void setTotalLabel(Label totalLabel) {
        this.totalLabel = totalLabel;
    }

    @BeanTagAttribute(name="pageTotalLabel", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Label getPageTotalLabel() {
        return this.pageTotalLabel;
    }

    public void setPageTotalLabel(Label pageTotalLabel) {
        this.pageTotalLabel = pageTotalLabel;
    }

    @BeanTagAttribute(name="groupTotalLabelPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Label getGroupTotalLabelPrototype() {
        return this.groupTotalLabelPrototype;
    }

    public void setGroupTotalLabelPrototype(Label groupTotalLabelPrototype) {
        this.groupTotalLabelPrototype = groupTotalLabelPrototype;
    }

    @BeanTagAttribute(name="columnCalculations", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<ColumnCalculationInfo> getColumnCalculations() {
        return this.columnCalculations;
    }

    public void setColumnCalculations(List<ColumnCalculationInfo> columnCalculations) {
        this.columnCalculations = columnCalculations;
    }

    @BeanTagAttribute(name="renderOnlyLeftTotalLabels")
    public boolean isRenderOnlyLeftTotalLabels() {
        return this.renderOnlyLeftTotalLabels;
    }

    public void setRenderOnlyLeftTotalLabels(boolean renderOnlyLeftTotalLabels) {
        this.renderOnlyLeftTotalLabels = renderOnlyLeftTotalLabels;
    }

    public List<Component> getFooterCalculationComponents() {
        return this.footerCalculationComponents;
    }

    @BeanTagAttribute(name="groupingPropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getGroupingPropertyNames() {
        return this.groupingPropertyNames;
    }

    public void setGroupingPropertyNames(List<String> groupingPropertyNames) {
        this.groupingPropertyNames = groupingPropertyNames;
    }

    @BeanTagAttribute(name="groupingTitle")
    public String getGroupingTitle() {
        return this.groupingTitle;
    }

    public void setGroupingTitle(String groupingTitle) {
        if (groupingTitle != null && !groupingTitle.contains("@{")) {
            throw new RuntimeException("groupingTitle MUST contain a springEL expression to uniquely identify a collection group (often related to some value of the line). Value provided: " + this.getGroupingTitle());
        }
        this.groupingTitle = groupingTitle;
    }

    @BeanTagAttribute(name="groupingPrefix")
    public String getGroupingPrefix() {
        return this.groupingPrefix;
    }

    public void setGroupingPrefix(String groupingPrefix) {
        this.groupingPrefix = groupingPrefix;
    }

    public boolean isRowDetailsOpen() {
        return this.rowDetailsOpen;
    }

    public void setRowDetailsOpen(boolean rowDetailsOpen) {
        this.rowDetailsOpen = rowDetailsOpen;
    }

    public boolean isShowToggleAllDetails() {
        return this.showToggleAllDetails;
    }

    public void setShowToggleAllDetails(boolean showToggleAllDetails) {
        this.showToggleAllDetails = showToggleAllDetails;
    }

    public Action getToggleAllDetailsAction() {
        return this.toggleAllDetailsAction;
    }

    public void setToggleAllDetailsAction(Action toggleAllDetailsAction) {
        this.toggleAllDetailsAction = toggleAllDetailsAction;
    }

    public boolean isAjaxDetailsRetrieval() {
        return this.ajaxDetailsRetrieval;
    }

    public void setAjaxDetailsRetrieval(boolean ajaxDetailsRetrieval) {
        this.ajaxDetailsRetrieval = ajaxDetailsRetrieval;
    }

    public Action getExpandDetailsActionPrototype() {
        return this.expandDetailsActionPrototype;
    }

    public int getGroupingColumnIndex() {
        return this.groupingColumnIndex;
    }

    public void setExpandDetailsActionPrototype(Action expandDetailsActionPrototype) {
        this.expandDetailsActionPrototype = expandDetailsActionPrototype;
    }

    public void setHeaderLabels(List<Label> headerLabels) {
        this.headerLabels = headerLabels;
    }

    public void setAllRowFields(List<Field> allRowFields) {
        this.allRowFields = allRowFields;
    }

    public void setFirstRowFields(List<Field> firstRowFields) {
        this.firstRowFields = firstRowFields;
    }

    public void setHeaderAdded(boolean headerAdded) {
        this.headerAdded = headerAdded;
    }

    public void setActionColumnIndex(int actionColumnIndex) {
        this.actionColumnIndex = actionColumnIndex;
    }

    public void setGroupingColumnIndex(int groupingColumnIndex) {
        this.groupingColumnIndex = groupingColumnIndex;
    }

    public void setGenerateGroupTotalRows(boolean generateGroupTotalRows) {
        this.generateGroupTotalRows = generateGroupTotalRows;
    }

    public void setColumnsToCalculate(List<String> columnsToCalculate) {
        this.columnsToCalculate = columnsToCalculate;
    }

    public void setFooterCalculationComponents(List<Component> footerCalculationComponents) {
        this.footerCalculationComponents = footerCalculationComponents;
    }

    @BeanTagAttribute(name="conditionalRowCssClasses", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getConditionalRowCssClasses() {
        return this.conditionalRowCssClasses;
    }

    public void setConditionalRowCssClasses(Map<String, String> conditionalRowCssClasses) {
        this.conditionalRowCssClasses = conditionalRowCssClasses;
    }

    @Override
    protected <T> void copyProperties(T layoutManager) {
        super.copyProperties(layoutManager);
        TableLayoutManager tableLayoutManagerCopy = (TableLayoutManager)layoutManager;
        tableLayoutManagerCopy.setUseShortLabels(this.isUseShortLabels());
        tableLayoutManagerCopy.setRepeatHeader(this.isRepeatHeader());
        if (this.headerLabelPrototype != null) {
            tableLayoutManagerCopy.setHeaderLabelPrototype((Label)this.getHeaderLabelPrototype().copy());
        }
        tableLayoutManagerCopy.setRenderSequenceField(this.isRenderSequenceField());
        tableLayoutManagerCopy.setGenerateAutoSequence(this.isGenerateAutoSequence());
        if (this.sequenceFieldPrototype != null) {
            tableLayoutManagerCopy.setSequenceFieldPrototype((Field)this.getSequenceFieldPrototype().copy());
        }
        if (this.actionFieldPrototype != null) {
            tableLayoutManagerCopy.setActionFieldPrototype((FieldGroup)this.getActionFieldPrototype().copy());
        }
        if (this.subCollectionFieldGroupPrototype != null) {
            tableLayoutManagerCopy.setSubCollectionFieldGroupPrototype((FieldGroup)this.getSubCollectionFieldGroupPrototype().copy());
        }
        if (this.selectFieldPrototype != null) {
            tableLayoutManagerCopy.setSelectFieldPrototype((Field)this.getSelectFieldPrototype().copy());
        }
        tableLayoutManagerCopy.setSeparateAddLine(this.isSeparateAddLine());
        if (this.addLineGroup != null) {
            tableLayoutManagerCopy.setAddLineGroup((Group)this.getAddLineGroup().copy());
        }
        tableLayoutManagerCopy.setNumberOfDataColumns(this.numberOfDataColumns);
        if (this.headerLabels != null) {
            ArrayList headerLabelsCopy = Lists.newArrayListWithExpectedSize((int)this.headerLabels.size());
            for (Label headerLabel : this.headerLabels) {
                if (headerLabel == null) continue;
                headerLabelsCopy.add((Label)headerLabel.copy());
            }
            tableLayoutManagerCopy.setHeaderLabels(headerLabelsCopy);
        }
        if (this.allRowFields != null) {
            ArrayList allRowFieldsCopy = Lists.newArrayListWithExpectedSize((int)this.allRowFields.size());
            for (Field allRowField : this.allRowFields) {
                if (allRowField == null) continue;
                allRowFieldsCopy.add((Field)allRowField.copy());
            }
            tableLayoutManagerCopy.setAllRowFields(allRowFieldsCopy);
        }
        if (this.firstRowFields != null) {
            ArrayList firstRowFieldsCopy = Lists.newArrayListWithExpectedSize((int)this.firstRowFields.size());
            for (Field firstRowField : this.firstRowFields) {
                if (firstRowField == null) continue;
                firstRowFieldsCopy.add((Field)firstRowField.copy());
            }
            tableLayoutManagerCopy.setFirstRowFields(firstRowFieldsCopy);
        }
        if (this.pagerWidget != null) {
            tableLayoutManagerCopy.setPagerWidget((Pager)this.pagerWidget.copy());
        }
        if (this.richTable != null) {
            tableLayoutManagerCopy.setRichTable((RichTable)this.getRichTable().copy());
        }
        tableLayoutManagerCopy.setHeaderAdded(this.headerAdded);
        tableLayoutManagerCopy.setActionColumnIndex(this.getActionColumnIndex());
        if (this.rowDetailsGroup != null) {
            tableLayoutManagerCopy.setRowDetailsGroup((Group)this.getRowDetailsGroup().copy());
        }
        tableLayoutManagerCopy.setRowDetailsOpen(this.isRowDetailsOpen());
        tableLayoutManagerCopy.setShowToggleAllDetails(this.isShowToggleAllDetails());
        if (this.toggleAllDetailsAction != null) {
            tableLayoutManagerCopy.setToggleAllDetailsAction((Action)this.getToggleAllDetailsAction().copy());
        }
        tableLayoutManagerCopy.setAjaxDetailsRetrieval(this.isAjaxDetailsRetrieval());
        if (this.expandDetailsActionPrototype != null) {
            tableLayoutManagerCopy.setExpandDetailsActionPrototype((Action)this.getExpandDetailsActionPrototype().copy());
        }
        tableLayoutManagerCopy.setGroupingTitle(this.getGroupingTitle());
        tableLayoutManagerCopy.setGroupingPrefix(this.getGroupingPrefix());
        tableLayoutManagerCopy.setGroupingColumnIndex(this.getGroupingColumnIndex());
        if (this.groupingPropertyNames != null) {
            tableLayoutManagerCopy.setGroupingPropertyNames(new ArrayList<String>(this.groupingPropertyNames));
        }
        tableLayoutManagerCopy.setRenderOnlyLeftTotalLabels(this.isRenderOnlyLeftTotalLabels());
        tableLayoutManagerCopy.setShowTotal(this.isShowTotal());
        tableLayoutManagerCopy.setShowPageTotal(this.isShowPageTotal());
        tableLayoutManagerCopy.setShowGroupTotal(this.isShowGroupTotal());
        tableLayoutManagerCopy.setGenerateGroupTotalRows(this.generateGroupTotalRows);
        if (this.totalLabel != null) {
            tableLayoutManagerCopy.setTotalLabel((Label)this.getTotalLabel().copy());
        }
        if (this.pageTotalLabel != null) {
            tableLayoutManagerCopy.setPageTotalLabel((Label)this.getPageTotalLabel().copy());
        }
        if (this.groupTotalLabelPrototype != null) {
            tableLayoutManagerCopy.setGroupTotalLabelPrototype((Label)this.getGroupTotalLabelPrototype().copy());
        }
        if (this.columnsToCalculate != null) {
            tableLayoutManagerCopy.setColumnsToCalculate(new ArrayList<String>(this.columnsToCalculate));
        }
        if (this.columnCalculations != null) {
            ArrayList columnCalculationsCopy = Lists.newArrayListWithExpectedSize((int)this.columnCalculations.size());
            for (ColumnCalculationInfo columnCalculation : this.columnCalculations) {
                columnCalculationsCopy.add((ColumnCalculationInfo)columnCalculation.copy());
            }
            tableLayoutManagerCopy.setColumnCalculations(columnCalculationsCopy);
        }
        if (this.footerCalculationComponents != null) {
            ArrayList footerCalculationComponentsCopy = Lists.newArrayListWithExpectedSize((int)this.footerCalculationComponents.size());
            for (Component footerCalculationComponent : this.footerCalculationComponents) {
                if (footerCalculationComponent == null) continue;
                footerCalculationComponentsCopy.add((Component)footerCalculationComponent.copy());
            }
            tableLayoutManagerCopy.setFooterCalculationComponents(footerCalculationComponentsCopy);
        }
        if (this.conditionalRowCssClasses != null) {
            tableLayoutManagerCopy.setConditionalRowCssClasses(new HashMap<String, String>(this.conditionalRowCssClasses));
        }
    }
}

