/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.modifier;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.Ordered;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.layout.GridLayoutManager;
import org.kuali.rice.krad.uif.modifier.ComparableInfo;
import org.kuali.rice.krad.uif.modifier.ComponentModifierBase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="compareFieldCreate-modifier-bean", parent="Uif-CompareFieldCreate-Modifier"), @BeanTag(name="maintenanceCompare-modifier-bean", parent="Uif-MaintenanceCompare-Modifier")})
public class CompareFieldCreateModifier
extends ComponentModifierBase {
    private static final Logger LOG = Logger.getLogger(CompareFieldCreateModifier.class);
    private static final long serialVersionUID = -6285531580512330188L;
    private int defaultOrderSequence = 1;
    private boolean generateCompareHeaders = true;
    private Header headerFieldPrototype;
    private List<ComparableInfo> comparables = new ArrayList<ComparableInfo>();

    @Override
    public void performInitialization(View view, Object model, Component component) {
        super.performInitialization(view, model, component);
        if (this.headerFieldPrototype != null) {
            view.getViewHelperService().performComponentInitialization(view, model, this.headerFieldPrototype);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performModification(View view, Object model, Component component) {
        if (component != null && !(component instanceof Group)) {
            throw new IllegalArgumentException("Compare field initializer only support Group components, found type: " + component.getClass());
        }
        if (component == null) {
            return;
        }
        Group group = (Group)component;
        ArrayList<Component> comparisonItems = new ArrayList<Component>();
        List<? extends Ordered> groupComparables = ComponentUtils.sort(this.comparables, this.defaultOrderSequence);
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, Object> viewContext = view.getContext();
        if (viewContext != null) {
            context.putAll(view.getContext());
        }
        context.put("component", component);
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        for (ComparableInfo comparableInfo : groupComparables) {
            expressionEvaluator.evaluateExpressionsOnConfigurable(view, comparableInfo, context);
        }
        if (this.isGenerateCompareHeaders()) {
            SpaceField spaceField = ComponentFactory.getSpaceField();
            view.assignComponentIds(spaceField);
            comparisonItems.add(spaceField);
            for (ComparableInfo comparableInfo : groupComparables) {
                Header header = ComponentUtils.copy(this.headerFieldPrototype, comparableInfo.getIdSuffix());
                header.setHeaderText(comparableInfo.getHeaderText());
                comparisonItems.add(header);
            }
            if (group.getLayoutManager() instanceof GridLayoutManager) {
                ((GridLayoutManager)group.getLayoutManager()).setRenderFirstRowHeader(true);
            }
        }
        boolean performValueChangeComparison = false;
        Object var11_15 = null;
        for (ComparableInfo comparableInfo : groupComparables) {
            if (!comparableInfo.isCompareToForValueChange()) continue;
            performValueChangeComparison = true;
            String string = comparableInfo.getBindingObjectPath();
        }
        boolean bl = false;
        for (Component component2 : group.getItems()) {
            int defaultSuffix = 0;
            boolean suppressLabel = false;
            for (ComparableInfo comparableInfo : groupComparables) {
                boolean bl2;
                void var11_16;
                boolean valueChanged;
                String idSuffix = comparableInfo.getIdSuffix();
                if (StringUtils.isBlank((String)idSuffix)) {
                    idSuffix = "_comp" + defaultSuffix;
                }
                Component compareItem = ComponentUtils.copy(component2, idSuffix);
                ComponentUtils.setComponentPropertyDeep(compareItem, "bindingInfo.bindingObjectPath", comparableInfo.getBindingObjectPath());
                if (comparableInfo.isReadOnly()) {
                    compareItem.setReadOnly(true);
                    if (compareItem.getPropertyExpressions().containsKey("readOnly")) {
                        compareItem.getPropertyExpressions().remove("readOnly");
                    }
                }
                if (suppressLabel && compareItem instanceof Field) {
                    ((Field)compareItem).getFieldLabel().setRender(false);
                }
                if (performValueChangeComparison && comparableInfo.isHighlightValueChange() && !comparableInfo.isCompareToForValueChange() && (valueChanged = this.performValueComparison(group, compareItem, model, (String)var11_16)) && !bl2 && this.isGenerateCompareHeaders()) {
                    Group groupToSetHeader = null;
                    if (group.getDisclosure() != null && group.getDisclosure().isRender()) {
                        groupToSetHeader = group;
                    } else if (group.getContext().get("parent") != null) {
                        groupToSetHeader = (Group)group.getContext().get("parent");
                    }
                    if (groupToSetHeader.getDisclosure().isRender()) {
                        groupToSetHeader.getDisclosure().setOnDocumentReadyScript("showChangeIconOnDisclosure('" + groupToSetHeader.getId() + "');");
                    } else if (groupToSetHeader.getHeader() != null) {
                        groupToSetHeader.getHeader().setOnDocumentReadyScript("showChangeIconOnHeader('" + groupToSetHeader.getHeader().getId() + "');");
                    }
                    bl2 = true;
                }
                comparisonItems.add(compareItem);
                ++defaultSuffix;
                suppressLabel = true;
            }
        }
        group.setItems(comparisonItems);
    }

    protected boolean performValueComparison(Group group, Component compareItem, Object model, String compareValueObjectBindingPath) {
        List<DataField> itemFields = ComponentUtils.getComponentsOfTypeDeep(compareItem, DataField.class);
        boolean valueChanged = false;
        for (DataField field : itemFields) {
            String fieldBindingPath = field.getBindingInfo().getBindingPath();
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, fieldBindingPath);
            String compareBindingPath = StringUtils.replaceOnce((String)fieldBindingPath, (String)field.getBindingInfo().getBindingObjectPath(), (String)compareValueObjectBindingPath);
            Object compareValue = ObjectPropertyUtils.getPropertyValue(model, compareBindingPath);
            if (fieldValue != null || compareValue != null) {
                if (fieldValue == null || compareValue == null) {
                    valueChanged = true;
                } else {
                    boolean bl = valueChanged = !fieldValue.equals(compareValue);
                }
            }
            if (!valueChanged) continue;
            String onReadyScript = "showChangeIcon('" + field.getId() + "');";
            field.setOnDocumentReadyScript(onReadyScript);
        }
        return valueChanged;
    }

    protected String getIdSuffix(ComparableInfo comparable, int index) {
        String idSuffix = comparable.getIdSuffix();
        if (StringUtils.isBlank((String)idSuffix)) {
            idSuffix = "_" + index;
        }
        return idSuffix;
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> components = new HashSet<Class<? extends Component>>();
        components.add(Group.class);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.headerFieldPrototype);
        return components;
    }

    @BeanTagAttribute(name="defaultOrderSequence")
    public int getDefaultOrderSequence() {
        return this.defaultOrderSequence;
    }

    public void setDefaultOrderSequence(int defaultOrderSequence) {
        this.defaultOrderSequence = defaultOrderSequence;
    }

    @BeanTagAttribute(name="generateCompareHeaders")
    public boolean isGenerateCompareHeaders() {
        return this.generateCompareHeaders;
    }

    public void setGenerateCompareHeaders(boolean generateCompareHeaders) {
        this.generateCompareHeaders = generateCompareHeaders;
    }

    @BeanTagAttribute(name="headerFieldPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Header getHeaderFieldPrototype() {
        return this.headerFieldPrototype;
    }

    public void setHeaderFieldPrototype(Header headerFieldPrototype) {
        this.headerFieldPrototype = headerFieldPrototype;
    }

    @BeanTagAttribute(name="comparables", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<ComparableInfo> getComparables() {
        return this.comparables;
    }

    public void setComparables(List<ComparableInfo> comparables) {
        this.comparables = comparables;
    }

    @Override
    protected <T> void copyProperties(T componentModifier) {
        super.copyProperties(componentModifier);
        CompareFieldCreateModifier compareFieldCreateModifierCopy = (CompareFieldCreateModifier)componentModifier;
        compareFieldCreateModifierCopy.setDefaultOrderSequence(this.defaultOrderSequence);
        compareFieldCreateModifierCopy.setGenerateCompareHeaders(this.generateCompareHeaders);
        if (this.comparables != null) {
            ArrayList comparables = Lists.newArrayListWithExpectedSize((int)this.getComparables().size());
            for (ComparableInfo comparable : this.comparables) {
                comparables.add((ComparableInfo)comparable.copy());
            }
            compareFieldCreateModifierCopy.setComparables(comparables);
        }
        if (this.headerFieldPrototype != null) {
            compareFieldCreateModifierCopy.setHeaderFieldPrototype((Header)this.headerFieldPrototype.copy());
        }
    }
}

