/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.inquiry.Inquirable;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.LightTable;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.RemoteFieldsHolder;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.modifier.ComponentModifier;
import org.kuali.rice.krad.uif.service.ViewDictionaryService;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.BooleanMap;
import org.kuali.rice.krad.uif.util.CloneUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.util.ViewCleaner;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.DefaultExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.uif.widget.Widget;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.GrowlMessage;
import org.kuali.rice.krad.util.KRADConstants;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.valuefinder.ValueFinder;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.util.MethodInvoker;

public class ViewHelperServiceImpl
implements ViewHelperService,
Serializable {
    private static final Logger LOG = Logger.getLogger(ViewHelperServiceImpl.class);
    private transient BusinessObjectService businessObjectService;
    private transient PersistenceService persistenceService;
    private transient PersistenceStructureService persistenceStructureService;
    private transient DataDictionaryService dataDictionaryService;
    private transient ExpressionEvaluator expressionEvaluator;
    private transient ViewDictionaryService viewDictionaryService;
    private transient ConfigurationService configurationService;

    @Override
    public void populateViewFromRequestParameters(View view, Map<String, String> parameters) {
        HashMap<String, HashSet<PropertyReplacer>> viewPropertyReplacers = new HashMap<String, HashSet<PropertyReplacer>>();
        List<PropertyReplacer> propertyReplacerSource = view.getPropertyReplacers();
        if (propertyReplacerSource != null) {
            for (PropertyReplacer replacer : propertyReplacerSource) {
                String replacerPropertyName = replacer.getPropertyName();
                HashSet<PropertyReplacer> propertyReplacers = (HashSet<PropertyReplacer>)viewPropertyReplacers.get(replacerPropertyName);
                if (propertyReplacers == null) {
                    propertyReplacers = new HashSet<PropertyReplacer>();
                    viewPropertyReplacers.put(replacerPropertyName, propertyReplacers);
                }
                propertyReplacers.add(replacer);
            }
        }
        Map<String, Annotation> annotatedFields = CloneUtils.getFieldsWithAnnotation(view.getClass(), RequestParameter.class);
        HashMap<String, String> viewRequestParameters = new HashMap<String, String>();
        for (String fieldToPopulate : annotatedFields.keySet()) {
            String fieldValue;
            RequestParameter requestParameter = (RequestParameter)annotatedFields.get(fieldToPopulate);
            String requestParameterName = requestParameter.parameterName();
            if (StringUtils.isBlank((String)requestParameterName)) {
                requestParameterName = fieldToPopulate;
            }
            if (!parameters.containsKey(requestParameterName) || !StringUtils.isNotBlank((String)(fieldValue = parameters.get(requestParameterName)))) continue;
            viewRequestParameters.put(requestParameterName, fieldValue);
            ObjectPropertyUtils.setPropertyValue(view, fieldToPopulate, fieldValue);
            if (view.getPropertyExpressions().containsKey(fieldToPopulate)) {
                view.getPropertyExpressions().remove(fieldToPopulate);
            }
            if (!viewPropertyReplacers.containsKey(fieldToPopulate)) continue;
            Set propertyReplacers = (Set)viewPropertyReplacers.get(fieldToPopulate);
            for (PropertyReplacer replacer : propertyReplacers) {
                view.getPropertyReplacers().remove(replacer);
            }
        }
        view.setViewRequestParameters(viewRequestParameters);
    }

    @Override
    public void performInitialization(View view, Object model) {
        view.assignComponentIds(view);
        view.setIdSequence(100000);
        this.performComponentInitialization(view, model, view);
        this.getExpressionEvaluator().initializeEvaluationContext(model);
        for (Component component : view.getDialogs()) {
            component.setRefreshedByAction(true);
        }
    }

    @Override
    public void performComponentLifecycle(View view, Object model, Component component, String origId) {
        Component parent;
        Component origComponent = view.getViewIndex().getComponentById(origId);
        view.assignComponentIds(component);
        Map<String, Object> origContext = origComponent.getContext();
        Component component2 = parent = origContext == null ? null : (Component)origContext.get("parent");
        if (origContext != null) {
            component.pushAllToContext(origContext);
            List<Component> nestedComponents = ComponentUtils.getAllNestedComponents(component);
            for (Component nestedComponent : nestedComponents) {
                nestedComponent.pushAllToContext(origContext);
            }
        }
        component.setDataAttributes(origComponent.getDataAttributes());
        view.getViewHelperService().getExpressionEvaluator().initializeEvaluationContext(model);
        Map<String, String> expressionGraph = view.getViewIndex().getComponentExpressionGraphs().get(component.getBaseId());
        component.setExpressionGraph(expressionGraph);
        ExpressionUtils.populatePropertyExpressionsFromGraph(component, false);
        if (component instanceof DataBinding) {
            ((DataBinding)((Object)component)).setBindingInfo(((DataBinding)((Object)origComponent)).getBindingInfo());
            ((DataBinding)((Object)component)).getBindingInfo().setBindingPath(((DataBinding)((Object)origComponent)).getBindingInfo().getBindingPath());
        }
        if (component instanceof Field) {
            ((Field)component).setLabelRendered(((Field)origComponent).isLabelRendered());
        }
        if (origComponent.isRefreshedByAction()) {
            component.setRefreshedByAction(true);
        }
        if (component.isResetDataOnRefresh() && component instanceof DataField) {
            ObjectPropertyUtils.initializeProperty(model, ((DataField)component).getBindingInfo().getBindingPath());
        }
        this.performComponentInitialization(view, model, component);
        String suffix = StringUtils.replaceOnce((String)origComponent.getId(), (String)origComponent.getBaseId(), (String)"");
        if (StringUtils.isNotBlank((String)suffix)) {
            ComponentUtils.updateIdWithSuffix(component, suffix);
            ComponentUtils.updateChildIdsWithSuffixNested(component, suffix);
        }
        if (component instanceof Group || component instanceof FieldGroup) {
            List<CollectionGroup> origCollectionGroups = ComponentUtils.getComponentsOfTypeShallow(origComponent, CollectionGroup.class);
            List<CollectionGroup> collectionGroups = ComponentUtils.getComponentsOfTypeShallow(component, CollectionGroup.class);
            for (int i = 0; i < collectionGroups.size(); ++i) {
                CollectionGroup origCollectionGroup = origCollectionGroups.get(i);
                CollectionGroup collectionGroup = collectionGroups.get(i);
                String prefix = origCollectionGroup.getBindingInfo().getBindByNamePrefix();
                if (StringUtils.isNotBlank((String)prefix) && StringUtils.isBlank((String)collectionGroup.getBindingInfo().getBindByNamePrefix())) {
                    ComponentUtils.prefixBindingPath(collectionGroup, prefix);
                }
                String lineSuffix = origCollectionGroup.getSubCollectionSuffix();
                collectionGroup.setSubCollectionSuffix(lineSuffix);
            }
            List<LightTable> origLightTables = ComponentUtils.getComponentsOfTypeShallow(origComponent, LightTable.class);
            List<LightTable> lightTables = ComponentUtils.getComponentsOfTypeShallow(component, LightTable.class);
            for (int i = 0; i < lightTables.size(); ++i) {
                LightTable origLightTable = origLightTables.get(i);
                LightTable lightTable = lightTables.get(i);
                String prefix = origLightTable.getBindingInfo().getBindByNamePrefix();
                if (!StringUtils.isNotBlank((String)prefix) || !StringUtils.isBlank((String)lightTable.getBindingInfo().getBindByNamePrefix())) continue;
                ComponentUtils.prefixBindingPath(lightTable, prefix);
            }
        }
        if (component.isDisclosedByAction()) {
            ComponentUtils.setComponentPropertyFinal(component, "render", true);
            ComponentUtils.setComponentPropertyFinal(component, "hidden", false);
        }
        this.performComponentApplyModel(view, component, model, new HashMap<String, Integer>());
        view.getViewIndex().indexComponent(component);
        if (component instanceof Container) {
            ComponentUtils.adjustNestedLevelsForTableCollections((Container)component, 0);
        } else if (component instanceof FieldGroup) {
            ComponentUtils.adjustNestedLevelsForTableCollections(((FieldGroup)component).getGroup(), 0);
        }
        this.performComponentFinalize(view, component, model, parent);
        if (component instanceof Group || component instanceof FieldGroup) {
            List<Component> nestedGroupComponents = ComponentUtils.getAllNestedComponents(component);
            List<Component> originalNestedGroupComponents = ComponentUtils.getAllNestedComponents(origComponent);
            for (Component nestedComponent : nestedGroupComponents) {
                Component origNestedComponent = ComponentUtils.findComponentInList(originalNestedGroupComponents, nestedComponent.getId());
                if (origNestedComponent == null) continue;
                if (nestedComponent instanceof DataBinding) {
                    ((DataBinding)((Object)nestedComponent)).setBindingInfo(((DataBinding)((Object)origNestedComponent)).getBindingInfo());
                    ((DataBinding)((Object)nestedComponent)).getBindingInfo().setBindingPath(((DataBinding)((Object)origNestedComponent)).getBindingInfo().getBindingPath());
                }
                if (nestedComponent instanceof Field) {
                    ((Field)nestedComponent).setLabelRendered(((Field)origNestedComponent).isLabelRendered());
                }
                if (!origNestedComponent.isRefreshedByAction()) continue;
                nestedComponent.setRefreshedByAction(true);
            }
        }
        String growlScript = this.buildGrowlScript(view);
        ((ViewModel)model).setGrowlScript(growlScript);
        view.getViewIndex().indexComponent(component);
    }

    @Override
    public void spawnSubLifecyle(View view, Object model, Component component, Component parent, String startPhase, String endPhase) {
        if (component == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Spawning sub-lifecycle for component: " + component.getId()));
        }
        if (StringUtils.isBlank((String)component.getId())) {
            view.assignComponentIds(component);
        }
        if (StringUtils.isBlank((String)startPhase)) {
            startPhase = "INITIALIZE";
        } else if (!("INITIALIZE".equals(startPhase) || "APPLY_MODEL".equals(startPhase) || "FINALIZE".equals(startPhase))) {
            throw new RuntimeException("Invalid start phase given: " + startPhase);
        }
        if (StringUtils.isBlank((String)endPhase)) {
            endPhase = "FINALIZE";
        } else if (!("INITIALIZE".equals(endPhase) || "APPLY_MODEL".equals(endPhase) || "FINALIZE".equals(endPhase))) {
            throw new RuntimeException("Invalid end phase given: " + endPhase);
        }
        if ("INITIALIZE".equals(startPhase)) {
            this.performComponentInitialization(view, model, component);
            view.getViewIndex().indexComponent(component);
            startPhase = "APPLY_MODEL";
        }
        if ("INITIALIZE".equals(endPhase)) {
            return;
        }
        component.pushObjectToContext("parent", parent);
        if ("APPLY_MODEL".equals(startPhase)) {
            this.performComponentApplyModel(view, component, model, new HashMap<String, Integer>());
            view.getViewIndex().indexComponent(component);
        }
        if ("APPLY_MODEL".equals(endPhase)) {
            return;
        }
        this.performComponentFinalize(view, component, model, parent);
        view.getViewIndex().indexComponent(component);
    }

    @Override
    public void performComponentInitialization(View view, Object model, Component component) {
        List<ComponentModifier> componentModifiers;
        if (component == null) {
            return;
        }
        if (StringUtils.isBlank((String)component.getId())) {
            throw new RiceRuntimeException("Id is not set, this should not happen unless a component is misconfigured");
        }
        LOG.debug((Object)("Initializing component: " + component.getId() + " with type: " + component.getClass()));
        if (!(component instanceof View)) {
            view.getViewIndex().addInitialComponentStateIfNeeded(component);
        }
        ExpressionUtils.populatePropertyExpressionsFromGraph(component, true);
        component.performInitialization(view, model);
        List<PropertyReplacer> componentPropertyReplacers = component.getPropertyReplacers();
        if (componentPropertyReplacers != null) {
            for (PropertyReplacer replacer : componentPropertyReplacers) {
                ExpressionUtils.populatePropertyExpressionsFromGraph(replacer, true);
            }
        }
        if ((componentModifiers = component.getComponentModifiers()) != null) {
            for (ComponentModifier modifier : component.getComponentModifiers()) {
                ExpressionUtils.populatePropertyExpressionsFromGraph(modifier, true);
            }
        }
        if (component instanceof DataField) {
            this.initializeDataFieldFromDataDictionary(view, (DataField)component);
        }
        if (component instanceof Container) {
            this.addCustomContainerComponents(view, model, (Container)component);
            if (!(component instanceof CollectionGroup)) {
                this.processAnyRemoteFieldsHolder(view, model, (Container)component);
            }
        }
        if (component instanceof CollectionGroup) {
            // empty if block
        }
        this.performCustomInitialization(view, component);
        this.runComponentModifiers(view, component, null, "INITIALIZE");
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            this.performComponentInitialization(view, model, nestedComponent);
        }
        for (Component nestedComponent : component.getComponentPrototypes()) {
            this.performComponentInitialization(view, model, nestedComponent);
        }
    }

    protected void processAnyRemoteFieldsHolder(View view, Object model, Container container) {
        ArrayList<Component> processedItems = new ArrayList<Component>();
        for (Component component : container.getItems()) {
            if (component instanceof RemoteFieldsHolder) {
                List<InputField> translatedFields = ((RemoteFieldsHolder)component).fetchAndTranslateRemoteFields(view, model, container);
                processedItems.addAll(translatedFields);
                continue;
            }
            processedItems.add(component);
        }
        container.setItems(processedItems);
    }

    protected void initializeDataFieldFromDataDictionary(View view, DataField field) {
        InputField inputField;
        AttributeDefinition attributeDefinition = null;
        String dictionaryAttributeName = field.getDictionaryAttributeName();
        String dictionaryObjectEntry = field.getDictionaryObjectEntry();
        if (StringUtils.isNotBlank((String)dictionaryObjectEntry) && StringUtils.isBlank((String)dictionaryAttributeName)) {
            dictionaryAttributeName = field.getPropertyName();
        }
        if (StringUtils.isNotBlank((String)dictionaryAttributeName) && StringUtils.isNotBlank((String)dictionaryObjectEntry)) {
            attributeDefinition = this.getDataDictionaryService().getAttributeDefinition(dictionaryObjectEntry, dictionaryAttributeName);
        }
        if (attributeDefinition == null) {
            String propertyPath = field.getBindingInfo().getBindingPath();
            if (StringUtils.isNotBlank((String)field.getBindingInfo().getCollectionPath())) {
                propertyPath = field.getBindingInfo().getCollectionPath();
                if (StringUtils.isNotBlank((String)field.getBindingInfo().getBindByNamePrefix())) {
                    propertyPath = propertyPath + "." + field.getBindingInfo().getBindByNamePrefix();
                }
                propertyPath = propertyPath + "." + field.getBindingInfo().getBindingName();
            }
            attributeDefinition = this.findNestedDictionaryAttribute(view, field, null, propertyPath);
        }
        if (attributeDefinition != null) {
            field.copyFromAttributeDefinition(view, attributeDefinition);
        }
        if (field instanceof InputField && (inputField = (InputField)field).getControl() == null) {
            TextControl control = ComponentFactory.getTextControl();
            view.assignComponentIds(control);
            inputField.setControl(control);
        }
    }

    protected AttributeDefinition findNestedDictionaryAttribute(View view, DataField field, String parentPath, String propertyPath) {
        Class<?> dictionaryModelClass;
        AttributeDefinition attributeDefinition = null;
        String dictionaryAttributeName = propertyPath;
        String dictionaryObjectEntry = null;
        if (field.getBindingInfo().isBindToMap()) {
            parentPath = "";
            if (!field.getBindingInfo().isBindToForm() && StringUtils.isNotBlank((String)field.getBindingInfo().getBindingObjectPath())) {
                parentPath = field.getBindingInfo().getBindingObjectPath();
            }
            if (StringUtils.isNotBlank((String)field.getBindingInfo().getBindByNamePrefix())) {
                parentPath = StringUtils.isNotBlank((String)parentPath) ? parentPath + "." + field.getBindingInfo().getBindByNamePrefix() : field.getBindingInfo().getBindByNamePrefix();
            }
            dictionaryAttributeName = field.getBindingInfo().getBindingName();
        }
        if (StringUtils.isNotBlank((String)parentPath) && (dictionaryModelClass = ViewModelUtils.getPropertyTypeByClassAndView(view, parentPath)) != null) {
            dictionaryObjectEntry = dictionaryModelClass.getName();
            attributeDefinition = this.getDataDictionaryService().getAttributeDefinition(dictionaryObjectEntry, dictionaryAttributeName);
        }
        if (attributeDefinition == null && StringUtils.contains((String)propertyPath, (String)".")) {
            String nextParentPath = StringUtils.substringBefore((String)propertyPath, (String)".");
            if (StringUtils.isNotBlank((String)parentPath)) {
                nextParentPath = parentPath + "." + nextParentPath;
            }
            String nextPropertyPath = StringUtils.substringAfter((String)propertyPath, (String)".");
            return this.findNestedDictionaryAttribute(view, field, nextParentPath, nextPropertyPath);
        }
        if (attributeDefinition != null) {
            field.setDictionaryAttributeName(dictionaryAttributeName);
            field.setDictionaryObjectEntry(dictionaryObjectEntry);
        }
        return attributeDefinition;
    }

    @Override
    public void performApplyModel(View view, Object model) {
        ProcessLogger.trace("apply-model:" + view.getId());
        if (!((ViewModel)model).isDefaultsApplied()) {
            this.applyDefaultValues(view, view, model);
            ((ViewModel)model).setDefaultsApplied(true);
        }
        this.retrieveEditModesAndActionFlags(view, (UifFormBase)model);
        this.setViewContext(view, model);
        ProcessLogger.trace("apply-comp-model:" + view.getId());
        HashMap<String, Integer> visitedIds = new HashMap<String, Integer>();
        this.performComponentApplyModel(view, view, model, visitedIds);
        ProcessLogger.trace("apply-model-end:" + view.getId());
    }

    protected void retrieveEditModesAndActionFlags(View view, UifFormBase model) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Set<String> actionFlags = presentationController.getActionFlags(view, model);
        Set<String> editModes = presentationController.getEditModes(view, model);
        if (GlobalVariables.getUserSession() != null) {
            Person user = GlobalVariables.getUserSession().getPerson();
            actionFlags = authorizer.getActionFlags(view, model, user, actionFlags);
            editModes = authorizer.getEditModes(view, model, user, editModes);
        }
        view.setActionFlags(new BooleanMap(actionFlags));
        view.setEditModes(new BooleanMap(editModes));
    }

    protected void setViewContext(View view, Object model) {
        view.pushAllToContext(this.getPreModelContext(view));
        for (Map.Entry<String, String> variableExpression : view.getExpressionVariables().entrySet()) {
            String variableName = variableExpression.getKey();
            Object value = this.getExpressionEvaluator().evaluateExpression(view.getContext(), variableExpression.getValue());
            view.pushObjectToContext(variableName, value);
        }
    }

    protected Map<String, Object> getPreModelContext(View view) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("view", view);
        context.put("ViewHelper", this);
        Map properties = CoreApiServiceLocator.getKualiConfigurationService().getAllProperties();
        context.put("ConfigProperties", properties);
        context.put("Constants", KRADConstants.class);
        context.put("UifConstants", UifConstants.class);
        return context;
    }

    protected void performComponentApplyModel(View view, Component component, Object model, Map<String, Integer> visitedIds) {
        LayoutManager layoutManager;
        List<ComponentModifier> componentModifiers;
        if (component == null) {
            return;
        }
        component.pushAllToContext(this.getCommonContext(view, component));
        List<PropertyReplacer> componentPropertyReplacers = component.getPropertyReplacers();
        if (componentPropertyReplacers != null) {
            for (PropertyReplacer replacer : componentPropertyReplacers) {
                this.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, replacer, component.getContext());
            }
        }
        if ((componentModifiers = component.getComponentModifiers()) != null) {
            for (ComponentModifier modifier : component.getComponentModifiers()) {
                this.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, modifier, component.getContext());
            }
        }
        this.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, component, component.getContext());
        ComponentSecurity componentSecurity = component.getComponentSecurity();
        this.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, componentSecurity, component.getContext());
        if (component instanceof DataBinding) {
            BindingInfo bindingInfo = ((DataBinding)((Object)component)).getBindingInfo();
            this.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, bindingInfo, component.getContext());
        }
        if (component instanceof Container && (layoutManager = ((Container)component).getLayoutManager()) != null) {
            layoutManager.pushAllToContext(this.getCommonContext(view, component));
            layoutManager.pushObjectToContext("parent", component);
            layoutManager.pushObjectToContext("manager", layoutManager);
            this.getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, layoutManager, layoutManager.getContext());
            layoutManager.setId(this.adjustIdIfNecessary(layoutManager.getId(), visitedIds));
        }
        this.syncClientSideStateForComponent(component, ((ViewModel)model).getClientStateForSyncing());
        this.applyAuthorizationAndPresentationLogic(view, component, (ViewModel)model);
        Map<String, Object> parentContext = component.getContext();
        Component parent = parentContext == null ? null : (Component)parentContext.get("parent");
        component.performApplyModel(view, model, parent);
        this.performCustomApplyModel(view, component, model);
        this.runComponentModifiers(view, component, model, "APPLY_MODEL");
        LinkedList<Component> nested = new LinkedList<Component>();
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            if (nestedComponent == null) continue;
            nested.offer(nestedComponent);
        }
        if (!nested.isEmpty()) {
            while (!nested.isEmpty()) {
                Component nestedComponent = (Component)nested.poll();
                nestedComponent.pushObjectToContext("parent", component);
                this.performComponentApplyModel(view, nestedComponent, model, visitedIds);
            }
        }
    }

    protected String adjustIdIfNecessary(String id, Map<String, Integer> visitedIds) {
        String adjustedId = id;
        if (visitedIds.containsKey(id)) {
            Integer nextAdjustSeq = visitedIds.get(id);
            adjustedId = id + nextAdjustSeq;
            while (visitedIds.containsKey(adjustedId)) {
                nextAdjustSeq = nextAdjustSeq + 1;
                adjustedId = id + nextAdjustSeq;
            }
            visitedIds.put(adjustedId, 1);
            nextAdjustSeq = nextAdjustSeq + 1;
            visitedIds.put(id, nextAdjustSeq);
        } else {
            visitedIds.put(id, 1);
        }
        return adjustedId;
    }

    protected void applyAuthorizationAndPresentationLogic(View view, Component component, ViewModel model) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        if (GlobalVariables.getUserSession() == null) {
            return;
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!component.isRender()) {
            return;
        }
        if (component instanceof View) {
            if (!view.isReadOnly()) {
                boolean canEditView = authorizer.canEditView(view, model, user);
                if (canEditView) {
                    canEditView = presentationController.canEditView(view, model);
                }
                view.setReadOnly(!canEditView);
            }
        } else if (component instanceof Group) {
            Group group = (Group)component;
            if (!group.isHidden()) {
                boolean canViewGroup = authorizer.canViewGroup(view, model, group, group.getId(), user);
                if (canViewGroup) {
                    canViewGroup = presentationController.canViewGroup(view, model, group, group.getId());
                }
                group.setHidden(!canViewGroup);
                group.setRender(canViewGroup);
            }
            if (!group.isReadOnly()) {
                boolean canEditGroup = authorizer.canEditGroup(view, model, group, group.getId(), user);
                if (canEditGroup) {
                    canEditGroup = presentationController.canEditGroup(view, model, group, group.getId());
                }
                group.setReadOnly(!canEditGroup);
            }
        } else if (component instanceof Field && !(component instanceof ActionField)) {
            Field field = (Field)component;
            String propertyName = null;
            if (field instanceof DataBinding) {
                propertyName = ((DataBinding)((Object)field)).getPropertyName();
            }
            if (!field.isHidden()) {
                boolean canViewField = authorizer.canViewField(view, model, field, propertyName, user);
                if (canViewField) {
                    canViewField = presentationController.canViewField(view, model, field, propertyName);
                }
                field.setHidden(!canViewField);
                field.setRender(canViewField);
            }
            if (!field.isReadOnly()) {
                boolean canEditField = authorizer.canEditField(view, model, field, propertyName, user);
                if (canEditField) {
                    canEditField = presentationController.canEditField(view, model, field, propertyName);
                }
                field.setReadOnly(!canEditField);
            }
            if (field.getRequired() == null || !field.getRequired().booleanValue()) {
                boolean fieldIsRequired = presentationController.fieldIsRequired(view, model, field, propertyName);
            }
            if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                boolean canUnmaskValue = authorizer.canUnmaskField(view, model, dataField, dataField.getPropertyName(), user);
                if (!canUnmaskValue) {
                    dataField.setApplyMask(true);
                    dataField.setMaskFormatter(dataField.getDataFieldSecurity().getAttributeSecurity().getMaskFormatter());
                } else {
                    boolean canPartiallyUnmaskValue = authorizer.canPartialUnmaskField(view, model, dataField, dataField.getPropertyName(), user);
                    if (!canPartiallyUnmaskValue) {
                        dataField.setApplyMask(true);
                        dataField.setMaskFormatter(dataField.getDataFieldSecurity().getAttributeSecurity().getPartialMaskFormatter());
                    }
                }
            }
        } else if (component instanceof ActionField || component instanceof Action) {
            Action action = null;
            action = component instanceof ActionField ? ((ActionField)component).getAction() : (Action)component;
            boolean canTakeAction = authorizer.canPerformAction(view, model, action, action.getActionEvent(), action.getId(), user);
            if (canTakeAction) {
                canTakeAction = presentationController.canPerformAction(view, model, action, action.getActionEvent(), action.getId());
            }
            action.setRender(canTakeAction);
        } else if (component instanceof Widget) {
            Widget widget = (Widget)component;
            if (!widget.isHidden()) {
                boolean canViewWidget = authorizer.canViewWidget(view, model, widget, widget.getId(), user);
                if (canViewWidget) {
                    canViewWidget = presentationController.canViewWidget(view, model, widget, widget.getId());
                }
                widget.setHidden(!canViewWidget);
                widget.setRender(canViewWidget);
            }
            if (!widget.isReadOnly()) {
                boolean canEditWidget = authorizer.canEditWidget(view, model, widget, widget.getId(), user);
                if (canEditWidget) {
                    canEditWidget = presentationController.canEditWidget(view, model, widget, widget.getId());
                }
                widget.setReadOnly(!canEditWidget);
            }
        }
    }

    protected void runComponentModifiers(View view, Component component, Object model, String runPhase) {
        List<ComponentModifier> componentModifiers = component.getComponentModifiers();
        if (componentModifiers == null) {
            return;
        }
        for (ComponentModifier modifier : component.getComponentModifiers()) {
            if (StringUtils.equals((String)runPhase, (String)"INITIALIZE")) {
                modifier.performInitialization(view, model, component);
            }
            if (!StringUtils.equals((String)modifier.getRunPhase(), (String)runPhase)) continue;
            boolean runModifier = true;
            if (StringUtils.isNotBlank((String)modifier.getRunCondition())) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("component", component);
                context.put("view", view);
                String conditionEvaluation = this.getExpressionEvaluator().evaluateExpressionTemplate(context, modifier.getRunCondition());
                runModifier = Boolean.parseBoolean(conditionEvaluation);
            }
            if (!runModifier) continue;
            modifier.performModification(view, model, component);
        }
    }

    @Override
    public Map<String, Object> getCommonContext(View view, Component component) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, Object> viewContext = view.getContext();
        if (viewContext != null) {
            context.putAll(view.getContext());
        }
        context.put("ThemeImages", view.getTheme().getImageDirectory());
        context.put("component", component);
        return context;
    }

    @Override
    public void performFinalize(View view, Object model) {
        String growlScript = this.buildGrowlScript(view);
        ((ViewModel)model).setGrowlScript(growlScript);
        this.performComponentFinalize(view, view, model, null);
        String clientStateScript = this.buildClientSideStateScript(view, model);
        view.setPreLoadScript(ScriptUtils.appendScript(view.getPreLoadScript(), clientStateScript));
        this.setExpressionEvaluator(null);
    }

    protected String buildClientSideStateScript(View view, Object model) {
        Map<String, Object> clientSideState = ((ViewModel)model).getClientStateForSyncing();
        String clientStateScript = "";
        if (!clientSideState.isEmpty()) {
            clientStateScript = ScriptUtils.buildFunctionCall("initializeViewState", clientSideState);
        }
        String kradImageLocation = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.externalizable.images.url");
        clientStateScript = clientStateScript + ScriptUtils.buildFunctionCall("setConfigParam", "kradImageLocation", kradImageLocation);
        String kradURL = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.url");
        clientStateScript = clientStateScript + ScriptUtils.buildFunctionCall("setConfigParam", "kradUrl", kradURL);
        String applicationURL = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
        clientStateScript = clientStateScript + ScriptUtils.buildFunctionCall("setConfigParam", "applicationUrl", applicationURL);
        return clientStateScript;
    }

    @Override
    public String buildExportTableData(View view, Object model, String tableId, String formatType) {
        Map<String, String> exportTableFormatOptions = this.getExportTableFormatOptions(formatType);
        String startTable = exportTableFormatOptions.get("startTable");
        String endTable = exportTableFormatOptions.get("endTable");
        Component component = view.getViewIndex().getComponentById(tableId);
        StringBuilder tableRows = new StringBuilder("");
        if (component instanceof CollectionGroup && ((CollectionGroup)component).getLayoutManager() instanceof TableLayoutManager) {
            CollectionGroup collectionGroup = (CollectionGroup)component;
            TableLayoutManager layoutManager = (TableLayoutManager)collectionGroup.getLayoutManager();
            List<Label> headerLabels = layoutManager.getHeaderLabels();
            List<Field> rowFields = layoutManager.getAllRowFields();
            int numberOfColumns = layoutManager.getNumberOfColumns();
            List<Integer> ignoredColumns = this.findIgnoredColumns(layoutManager, collectionGroup);
            if (headerLabels.size() > 0) {
                ArrayList<String> labels = new ArrayList<String>();
                for (Label label : headerLabels) {
                    labels.add(label.getLabelText());
                }
                tableRows.append(this.buildExportTableRow(labels, exportTableFormatOptions, ignoredColumns));
            }
            if (rowFields.size() > 0) {
                ArrayList<String> columnData = new ArrayList<String>();
                for (Field field : rowFields) {
                    columnData.add(KRADUtils.getSimpleFieldValue(model, field));
                    if (columnData.size() < numberOfColumns) continue;
                    tableRows.append(this.buildExportTableRow(columnData, exportTableFormatOptions, ignoredColumns));
                    columnData.clear();
                }
            }
        }
        return startTable + tableRows.toString() + endTable;
    }

    protected String buildExportTableRow(List<String> columnData, Map<String, String> tableFormatOptions, List<Integer> ignoredColumns) {
        String startRow = tableFormatOptions.get("startRow");
        String endRow = tableFormatOptions.get("endRow");
        String startColumn = tableFormatOptions.get("startColumn");
        String endColumn = tableFormatOptions.get("endColumn");
        boolean appendLastColumn = Boolean.valueOf(tableFormatOptions.get("appendLastColumn"));
        int columnIndex = 0;
        StringBuilder builder = new StringBuilder();
        for (String columnItem : columnData) {
            boolean displayColumn;
            boolean bl = displayColumn = !ignoredColumns.contains(columnIndex);
            if (displayColumn) {
                builder.append(startColumn + columnItem + endColumn);
            }
            if (columnIndex >= columnData.size() - 1 && !appendLastColumn) {
                builder.delete(builder.length() - endColumn.length(), builder.length());
            }
            ++columnIndex;
        }
        return startRow + builder.toString() + endRow;
    }

    private List<Integer> findIgnoredColumns(TableLayoutManager layoutManager, CollectionGroup collectionGroup) {
        ArrayList<Integer> ignoreColumns = new ArrayList<Integer>();
        int actionColumnIndex = layoutManager.getActionColumnIndex();
        int numberOfColumns = layoutManager.getNumberOfColumns();
        boolean renderActions = collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly();
        boolean renderSelectField = collectionGroup.isIncludeLineSelectionField();
        boolean renderSequenceField = layoutManager.isRenderSequenceField();
        if (renderActions || renderSelectField || renderSequenceField) {
            int shiftColumn = 0;
            if (renderSelectField) {
                ignoreColumns.add(shiftColumn);
                ++shiftColumn;
            }
            if (renderSequenceField) {
                ignoreColumns.add(shiftColumn);
                ++shiftColumn;
            }
            if (renderActions) {
                if (actionColumnIndex == 1) {
                    ignoreColumns.add(shiftColumn);
                } else if (actionColumnIndex == -1) {
                    ignoreColumns.add(numberOfColumns - 1);
                } else if (actionColumnIndex > 1) {
                    ignoreColumns.add(actionColumnIndex);
                }
            }
        }
        return ignoreColumns;
    }

    protected Map<String, String> getExportTableFormatOptions(String formatType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contentType", "text/plain");
        map.put("formatType", "txt");
        map.put("startTable", "");
        map.put("endTable", "");
        map.put("startRow", "");
        map.put("endRow", "\n");
        map.put("startColumn", "");
        map.put("endColumn", ", ");
        map.put("appendLastColumn", "false");
        if ("csv".equals(formatType)) {
            map.put("contentType", "text/csv");
            map.put("formatType", "csv");
            map.put("startTable", "");
            map.put("endTable", "");
            map.put("startRow", "");
            map.put("endRow", "\n");
            map.put("startColumn", "");
            map.put("endColumn", ", ");
            map.put("appendLastColumn", "false");
        } else if ("xls".equals(formatType)) {
            map.put("contentType", "application/vnd.ms-excel");
            map.put("formatType", "xls");
            map.put("startTable", "");
            map.put("endTable", "");
            map.put("startRow", "");
            map.put("endRow", "\n");
            map.put("startColumn", "\"");
            map.put("endColumn", "\"\t");
            map.put("appendLastColumn", "true");
        } else if ("xml".equals(formatType)) {
            map.put("contentType", "application/xml");
            map.put("formatType", "xml");
            map.put("startTable", "<table>\n");
            map.put("endTable", "</table>\n");
            map.put("startRow", "  <row>\n");
            map.put("endRow", "  </row>\n");
            map.put("startColumn", "    <column>");
            map.put("endColumn", "</column>\n");
            map.put("appendLastColumn", "true");
        }
        return map;
    }

    protected String buildGrowlScript(View view) {
        String growlScript = "";
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        MessageMap messageMap = GlobalVariables.getMessageMap();
        for (GrowlMessage growl : messageMap.getGrowlMessages()) {
            if (view.isGrowlMessagingEnabled()) {
                String message = messageService.getMessageText(growl.getNamespaceCode(), growl.getComponentCode(), growl.getMessageKey());
                if (!StringUtils.isNotBlank((String)message)) continue;
                if (growl.getMessageParameters() != null) {
                    message = message.replace("'", "''");
                    message = MessageFormat.format(message, growl.getMessageParameters());
                }
                message = message.replace("'", "\\'");
                String title = growl.getTitle();
                if (StringUtils.isNotBlank((String)growl.getTitleKey())) {
                    title = messageService.getMessageText(growl.getNamespaceCode(), growl.getComponentCode(), growl.getTitleKey());
                }
                title = title.replace("'", "\\'");
                growlScript = growlScript + "showGrowl('" + message + "', '" + title + "', '" + growl.getTheme() + "');";
                continue;
            }
            ErrorMessage infoMessage = new ErrorMessage(growl.getMessageKey(), growl.getMessageParameters());
            infoMessage.setNamespaceCode(growl.getNamespaceCode());
            infoMessage.setComponentCode(growl.getComponentCode());
            messageMap.putInfoForSectionId("GLOBAL_INFO", infoMessage);
        }
        return growlScript;
    }

    protected void performComponentFinalize(View view, Component component, Object model, Component parent) {
        LayoutManager layoutManager;
        if (component == null) {
            return;
        }
        ViewModel viewModel = (ViewModel)model;
        if (component instanceof DataBinding && view.isSupportsRequestOverrideOfReadOnlyFields() && !viewModel.getReadOnlyFieldsList().isEmpty()) {
            String propertyName = ((DataBinding)((Object)component)).getPropertyName();
            if (viewModel.getReadOnlyFieldsList().contains(propertyName)) {
                component.setReadOnly(true);
            }
        }
        this.invokeMethodFinalizer(view, component, model);
        component.performFinalize(view, model, parent);
        this.performCustomFinalize(view, component, model, parent);
        this.runComponentModifiers(view, component, model, "FINALIZE");
        if (!component.isSelfRendered() && StringUtils.isNotBlank((String)component.getTemplate()) && !view.getViewTemplates().contains(component.getTemplate())) {
            view.getViewTemplates().add(component.getTemplate());
        }
        if (component instanceof Container && (layoutManager = ((Container)component).getLayoutManager()) != null && !view.getViewTemplates().contains(layoutManager.getTemplate())) {
            view.getViewTemplates().add(layoutManager.getTemplate());
        }
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            this.performComponentFinalize(view, nestedComponent, model, component);
        }
    }

    protected void syncClientSideStateForComponent(Component component, Map<String, Object> clientSideState) {
        Map componentState = null;
        if (component instanceof View) {
            componentState = clientSideState;
        } else if (clientSideState.containsKey(component.getId())) {
            componentState = (Map)clientSideState.get(component.getId());
        }
        if (componentState != null && !componentState.isEmpty()) {
            Map<String, Annotation> annotatedFields = CloneUtils.getFieldsWithAnnotation(component.getClass(), ClientSideState.class);
            for (Map.Entry<String, Annotation> annotatedField : annotatedFields.entrySet()) {
                ClientSideState clientSideStateAnnot = (ClientSideState)annotatedField.getValue();
                String variableName = clientSideStateAnnot.variableName();
                if (StringUtils.isBlank((String)variableName)) {
                    variableName = annotatedField.getKey();
                }
                if (!componentState.containsKey(variableName)) continue;
                Object value = componentState.get(variableName);
                ObjectPropertyUtils.setPropertyValue(component, annotatedField.getKey(), value);
            }
        }
    }

    protected void invokeMethodFinalizer(View view, Component component, Object model) {
        List<Object> additionalArguments;
        String finalizeMethodToCall = component.getFinalizeMethodToCall();
        MethodInvokerConfig finalizeMethodInvoker = component.getFinalizeMethodInvoker();
        if (StringUtils.isBlank((String)finalizeMethodToCall) && finalizeMethodInvoker == null) {
            return;
        }
        if (finalizeMethodInvoker == null) {
            finalizeMethodInvoker = new MethodInvoker();
        }
        if (StringUtils.isBlank((String)finalizeMethodInvoker.getTargetMethod())) {
            finalizeMethodInvoker.setTargetMethod(finalizeMethodToCall);
        }
        if (finalizeMethodInvoker.getTargetClass() == null && finalizeMethodInvoker.getTargetObject() == null) {
            finalizeMethodInvoker.setTargetObject(view.getViewHelperService());
        }
        if ((additionalArguments = component.getFinalizeMethodAdditionalArguments()) == null) {
            additionalArguments = new ArrayList<Object>();
        }
        Object[] arguments = new Object[2 + additionalArguments.size()];
        arguments[0] = component;
        arguments[1] = model;
        int argumentIndex = 1;
        for (Object argument : additionalArguments) {
            arguments[++argumentIndex] = argument;
        }
        finalizeMethodInvoker.setArguments(arguments);
        try {
            LOG.debug((Object)("Invoking finalize method: " + finalizeMethodInvoker.getTargetMethod() + " for component: " + component.getId()));
            finalizeMethodInvoker.prepare();
            Class<?> methodReturnType = finalizeMethodInvoker.getPreparedMethod().getReturnType();
            if (StringUtils.equals((String)"void", (String)methodReturnType.getName())) {
                finalizeMethodInvoker.invoke();
            } else {
                String renderOutput = (String)finalizeMethodInvoker.invoke();
                component.setSelfRendered(true);
                component.setRenderedHtmlOutput(renderOutput);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error invoking finalize method for component: " + component.getId()), (Throwable)e);
            throw new RuntimeException("Error invoking finalize method for component: " + component.getId(), e);
        }
    }

    @Override
    public void cleanViewAfterRender(View view) {
        ViewCleaner.cleanView(view);
    }

    @Override
    public void refreshReferences(Object model, String referencesToRefresh) {
        for (String reference : StringUtils.split((String)referencesToRefresh, (String)",")) {
            if (StringUtils.isBlank((String)reference)) continue;
            if (ObjectUtils.isNestedAttribute(reference)) {
                String parentPath = ObjectUtils.getNestedAttributePrefix(reference);
                Object parentObject = ObjectPropertyUtils.getPropertyValue(model, parentPath);
                String referenceObjectName = ObjectUtils.getNestedAttributePrimitive(reference);
                if (parentObject == null) {
                    LOG.warn((Object)("Unable to refresh references for " + referencesToRefresh + ". Object not found in model. Nothing refreshed."));
                    continue;
                }
                this.refreshReference(parentObject, referenceObjectName);
                continue;
            }
            this.refreshReference(model, reference);
        }
    }

    private void refreshReference(Object parentObject, String referenceObjectName) {
        if (!(parentObject instanceof PersistableBusinessObject)) {
            LOG.warn((Object)("Could not refresh reference " + referenceObjectName + " off class " + parentObject.getClass().getName() + ". Class not of type PersistableBusinessObject"));
            return;
        }
        if (this.getPersistenceStructureService().hasReference(parentObject.getClass(), referenceObjectName) || this.getPersistenceStructureService().hasCollection(parentObject.getClass(), referenceObjectName)) {
            this.getPersistenceService().retrieveReferenceObject(parentObject, referenceObjectName);
        } else if (this.getDataDictionaryService().hasRelationship(parentObject.getClass().getName(), referenceObjectName)) {
            Object referenceObject = ObjectUtils.getPropertyValue(parentObject, referenceObjectName);
            if (!(referenceObject instanceof PersistableBusinessObject)) {
                LOG.warn((Object)("Could not refresh reference " + referenceObjectName + " off class " + parentObject.getClass().getName() + ". Class not of type PersistableBusinessObject"));
                return;
            }
            referenceObject = this.getBusinessObjectService().retrieve((PersistableBusinessObject)referenceObject);
            if (referenceObject == null) {
                LOG.warn((Object)("Could not refresh reference " + referenceObjectName + " off class " + parentObject.getClass().getName() + "."));
                return;
            }
            try {
                ObjectUtils.setObjectProperty(parentObject, referenceObjectName, referenceObject);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to refresh persistable business object: " + referenceObjectName + "\n" + e.getMessage()));
                throw new RuntimeException("Unable to refresh persistable business object: " + referenceObjectName + "\n" + e.getMessage());
            }
        } else {
            LOG.warn((Object)("Could not refresh reference " + referenceObjectName + " off class " + parentObject.getClass().getName() + "."));
        }
    }

    @Override
    public void processCollectionAddLine(View view, Object model, String collectionPath) {
        String addLinePath;
        Object addLine;
        Collection collection;
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            this.logAndThrowRuntime("Unable to get collection group component for path: " + collectionPath);
        }
        if ((collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath)) == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if ((addLine = ObjectPropertyUtils.getPropertyValue(model, addLinePath = collectionGroup.getAddLineBindingInfo().getBindingPath())) == null) {
            this.logAndThrowRuntime("Add line instance not found for path: " + addLinePath);
        }
        this.processBeforeAddLine(view, collectionGroup, model, addLine);
        boolean isValidLine = this.performAddLineValidation(view, collectionGroup, model, addLine);
        if (isValidLine) {
            this.addLine(collection, addLine, collectionGroup.getAddLinePlacement().equals(UifConstants.Position.TOP.name()));
            collectionGroup.initializeNewCollectionLine(view, model, collectionGroup, true);
        }
        ((UifFormBase)model).getAddedCollectionItems().add(addLine);
        this.processAfterAddLine(view, collectionGroup, model, addLine, isValidLine);
    }

    @Override
    public void processCollectionSaveLine(View view, Object model, String collectionPath, int selectedLineIndex) {
        Collection collection;
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            this.logAndThrowRuntime("Unable to get collection group component for path: " + collectionPath);
        }
        if ((collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath)) == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            Object saveLine = ((List)collection).get(selectedLineIndex);
            this.processBeforeSaveLine(view, collectionGroup, model, saveLine);
            ((UifFormBase)model).getAddedCollectionItems().remove(saveLine);
            this.processAfterSaveLine(view, collectionGroup, model, saveLine);
        } else {
            this.logAndThrowRuntime("Only List collection implementations are supported for the delete by index method");
        }
    }

    @Override
    public void processCollectionAddBlankLine(View view, Object model, String collectionPath) {
        Collection collection;
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            this.logAndThrowRuntime("Unable to get collection group component for path: " + collectionPath);
        }
        if ((collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath)) == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        Object newLine = ObjectUtils.newInstance(collectionGroup.getCollectionObjectClass());
        this.applyDefaultValuesForCollectionLine(view, model, collectionGroup, newLine);
        this.addLine(collection, newLine, collectionGroup.getAddLinePlacement().equals("TOP"));
        ((UifFormBase)model).getAddedCollectionItems().add(newLine);
    }

    protected void addLine(Collection<Object> collection, Object addLine, boolean insertFirst) {
        if (insertFirst && collection instanceof List) {
            ((List)collection).add(0, addLine);
        } else {
            collection.add(addLine);
        }
    }

    protected boolean performAddLineValidation(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
        boolean isValid = true;
        return isValid;
    }

    @Override
    public void processCollectionDeleteLine(View view, Object model, String collectionPath, int lineIndex) {
        Collection collection;
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            this.logAndThrowRuntime("Unable to get collection group component for path: " + collectionPath);
        }
        if ((collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionPath)) == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            Object deleteLine = ((List)collection).get(lineIndex);
            boolean isValid = this.performDeleteLineValidation(view, collectionGroup, deleteLine);
            if (isValid) {
                ((List)collection).remove(lineIndex);
                this.processAfterDeleteLine(view, collectionGroup, model, lineIndex);
            }
        } else {
            this.logAndThrowRuntime("Only List collection implementations are supported for the delete by index method");
        }
    }

    protected boolean performDeleteLineValidation(View view, CollectionGroup collectionGroup, Object deleteLine) {
        boolean isValid = true;
        return isValid;
    }

    @Override
    public void processMultipleValueLookupResults(View view, Object model, String collectionPath, String lookupResultValues) {
        String[] lineValues;
        if (StringUtils.isBlank((String)lookupResultValues)) {
            return;
        }
        CollectionGroup collectionGroup = view.getViewIndex().getCollectionGroupByPath(collectionPath);
        if (collectionGroup == null) {
            throw new RuntimeException("Unable to find collection group for path: " + collectionPath);
        }
        Class<?> collectionObjectClass = collectionGroup.getCollectionObjectClass();
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath());
        if (collection == null) {
            Class<?> collectionClass = ObjectPropertyUtils.getPropertyType(model, collectionGroup.getBindingInfo().getBindingPath());
            collection = (Collection)ObjectUtils.newInstance(collectionClass);
            ObjectPropertyUtils.setPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath(), collection);
        }
        Map<String, String> fieldConversions = collectionGroup.getCollectionLookup().getFieldConversions();
        ArrayList<String> toFieldNamesColl = new ArrayList<String>(fieldConversions.values());
        Collections.sort(toFieldNamesColl);
        String[] toFieldNames = new String[toFieldNamesColl.size()];
        toFieldNamesColl.toArray(toFieldNames);
        for (String lineValue : lineValues = StringUtils.split((String)lookupResultValues, (String)",")) {
            ExternalizableBusinessObject lineDataObject = null;
            ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(collectionObjectClass);
            lineDataObject = moduleService != null && moduleService.isExternalizable(collectionObjectClass) ? moduleService.createNewObjectFromExternalizableClass(collectionObjectClass.asSubclass(ExternalizableBusinessObject.class)) : (ExternalizableBusinessObject)ObjectUtils.newInstance(collectionObjectClass);
            this.applyDefaultValuesForCollectionLine(view, model, collectionGroup, lineDataObject);
            String[] fieldValues = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)lineValue, (String)":");
            if (fieldValues.length != toFieldNames.length) {
                throw new RuntimeException("Value count passed back from multi-value lookup does not match field conversion count");
            }
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldName = toFieldNames[i];
                ObjectPropertyUtils.setPropertyValue(lineDataObject, fieldName, fieldValues[i]);
            }
            collection.add(lineDataObject);
        }
    }

    @Override
    public void buildInquiryLink(Object dataObject, String propertyName, Inquiry inquiry) {
        Inquirable inquirable = this.getViewDictionaryService().getInquirable(dataObject.getClass(), inquiry.getViewName());
        if (inquirable != null) {
            inquirable.buildInquirableLink(dataObject, propertyName, inquiry);
        } else {
            inquiry.setRender(false);
        }
    }

    @Override
    public void applyDefaultValuesForCollectionLine(View view, Object model, CollectionGroup collectionGroup, Object line) {
        List<DataField> dataFields = ComponentUtils.getComponentsOfTypeDeep(collectionGroup.getAddLineItems(), DataField.class);
        for (DataField dataField : dataFields) {
            String bindingPath = "";
            if (StringUtils.isNotBlank((String)dataField.getBindingInfo().getBindByNamePrefix())) {
                bindingPath = dataField.getBindingInfo().getBindByNamePrefix() + ".";
            }
            bindingPath = bindingPath + dataField.getBindingInfo().getBindingName();
            this.populateDefaultValueForField(view, line, dataField, bindingPath);
        }
    }

    protected void applyDefaultValues(View view, Component component, Object model) {
        if (component == null) {
            return;
        }
        if (component instanceof DataField) {
            DataField dataField = (DataField)component;
            dataField.getBindingInfo().setDefaults(view, dataField.getPropertyName());
            this.populateDefaultValueForField(view, model, dataField, dataField.getBindingInfo().getBindingPath());
        }
        for (Component component2 : component.getComponentsForLifecycle()) {
            this.applyDefaultValues(view, component2, model);
        }
        if (component instanceof View) {
            for (Component component3 : ((View)component).getItems()) {
                this.applyDefaultValues(view, component3, model);
            }
        }
    }

    protected void populateDefaultValueForField(View view, Object object, DataField dataField, String bindingPath) {
        if (dataField == null) {
            return;
        }
        String defaultValue = dataField.getDefaultValue();
        Object[] defaultValues = dataField.getDefaultValues();
        if (!ObjectPropertyUtils.isReadableProperty(object, bindingPath) || !ObjectPropertyUtils.isWritableProperty(object, bindingPath)) {
            return;
        }
        Object currentValue = ObjectPropertyUtils.getPropertyValue(object, bindingPath);
        if (currentValue != null) {
            return;
        }
        if (StringUtils.isBlank((String)defaultValue) && dataField.getDefaultValueFinderClass() != null) {
            ValueFinder defaultValueFinder = ObjectUtils.newInstance(dataField.getDefaultValueFinderClass());
            defaultValue = defaultValueFinder.getValue();
        }
        if (StringUtils.isBlank((String)defaultValue)) {
            String defaultValuesExpression = null;
            if (dataField.getExpressionGraph() != null && dataField.getExpressionGraph().containsKey("defaultValues")) {
                defaultValuesExpression = dataField.getExpressionGraph().get("defaultValues");
            }
            if (defaultValuesExpression != null && this.getExpressionEvaluator().containsElPlaceholder(defaultValuesExpression)) {
                Map<String, Object> context = this.getPreModelContext(view);
                context.putAll(dataField.getContext());
                defaultValuesExpression = this.expressionEvaluator.replaceBindingPrefixes(view, object, defaultValuesExpression);
                ExpressionEvaluator expressionEvaluator = this.getExpressionEvaluator();
                defaultValuesExpression = expressionEvaluator.evaluateExpressionTemplate(context, defaultValuesExpression);
                ObjectPropertyUtils.setPropertyValue(object, bindingPath, defaultValuesExpression);
            } else if (defaultValues != null) {
                ObjectPropertyUtils.setPropertyValue(object, bindingPath, defaultValues);
            }
        } else {
            if (dataField.getExpressionGraph() != null && dataField.getExpressionGraph().containsKey("defaultValue")) {
                defaultValue = dataField.getExpressionGraph().get("defaultValue");
            }
            if (StringUtils.isNotBlank((String)defaultValue)) {
                if (this.getExpressionEvaluator().containsElPlaceholder(defaultValue)) {
                    Map<String, Object> context = this.getPreModelContext(view);
                    context.putAll(dataField.getContext());
                    defaultValue = this.expressionEvaluator.replaceBindingPrefixes(view, object, defaultValue);
                    ExpressionEvaluator expressionEvaluator = this.getExpressionEvaluator();
                    defaultValue = expressionEvaluator.evaluateExpressionTemplate(context, defaultValue);
                }
                ObjectPropertyUtils.setPropertyValue(object, bindingPath, defaultValue);
            }
        }
    }

    protected void addCustomContainerComponents(View view, Object model, Container container) {
    }

    protected void performCustomInitialization(View view, Component component) {
    }

    protected void performCustomApplyModel(View view, Component component, Object model) {
    }

    protected void performCustomFinalize(View view, Component component, Object model, Component parent) {
    }

    protected void processBeforeAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
    }

    protected void processAfterAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine, boolean isValidLine) {
    }

    protected void processBeforeSaveLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
    }

    protected void processAfterSaveLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
    }

    protected void processAfterDeleteLine(View view, CollectionGroup collectionGroup, Object model, int lineIndex) {
    }

    protected void logAndThrowRuntime(String message) {
        LOG.error((Object)message);
        throw new RuntimeException(message);
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public PersistenceService getPersistenceService() {
        if (this.persistenceService == null) {
            this.persistenceService = KRADServiceLocator.getPersistenceService();
        }
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public PersistenceStructureService getPersistenceStructureService() {
        if (this.persistenceStructureService == null) {
            this.persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        if (this.expressionEvaluator == null) {
            this.expressionEvaluator = new DefaultExpressionEvaluator();
        }
        return this.expressionEvaluator;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public ViewDictionaryService getViewDictionaryService() {
        if (this.viewDictionaryService == null) {
            this.viewDictionaryService = KRADServiceLocatorWeb.getViewDictionaryService();
        }
        return this.viewDictionaryService;
    }

    public void setViewDictionaryService(ViewDictionaryService viewDictionaryService) {
        this.viewDictionaryService = viewDictionaryService;
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

