/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.util.UrlInfo;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="breadcrumbItem-bean", parent="Uif-BreadcrumbItem")
public class BreadcrumbItem
extends ContentElementBase {
    private String label;
    private UrlInfo url;
    private Component siblingBreadcrumbComponent;
    private boolean renderAsLink;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.url != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            Map<String, Object> viewContext = view.getContext();
            if (viewContext != null) {
                context.putAll(viewContext);
            }
            ExpressionUtils.populatePropertyExpressionsFromGraph(this.url, false);
            view.getViewHelperService().getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, this.url, context);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.siblingBreadcrumbComponent);
        components.addAll(super.getComponentsForLifecycle());
        return components;
    }

    @BeanTagAttribute(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @BeanTagAttribute(name="url")
    public UrlInfo getUrl() {
        return this.url;
    }

    public void setUrl(UrlInfo urlObject) {
        this.url = urlObject;
    }

    @BeanTagAttribute(name="siblingBreadcrumbComponent", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Component getSiblingBreadcrumbComponent() {
        return this.siblingBreadcrumbComponent;
    }

    public void setSiblingBreadcrumbComponent(Component siblingBreadcrumbComponent) {
        this.siblingBreadcrumbComponent = siblingBreadcrumbComponent;
    }

    @BeanTagAttribute(name="renderAsLink")
    public boolean isRenderAsLink() {
        return this.renderAsLink;
    }

    public void setRenderAsLink(boolean renderAsLink) {
        this.renderAsLink = renderAsLink;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        BreadcrumbItem breadcrumbItemCopy = (BreadcrumbItem)component;
        breadcrumbItemCopy.setLabel(this.label);
        if (this.siblingBreadcrumbComponent != null) {
            breadcrumbItemCopy.setSiblingBreadcrumbComponent((Component)this.siblingBreadcrumbComponent.copy());
        }
        breadcrumbItemCopy.setRenderAsLink(this.renderAsLink);
        if (this.url != null) {
            breadcrumbItemCopy.setUrl((UrlInfo)this.url.copy());
        }
    }
}

