/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.util.BreadcrumbItem;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.HistoryFlow;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTag(name="breadcrumbOptions-bean", parent="Uif-BreadcrumbOptions")
public class BreadcrumbOptions
implements Serializable {
    private static final long serialVersionUID = -6705552809624394000L;
    private List<BreadcrumbItem> homewardPathBreadcrumbs;
    private List<BreadcrumbItem> preViewBreadcrumbs;
    private List<BreadcrumbItem> prePageBreadcrumbs;
    private List<BreadcrumbItem> breadcrumbOverrides;

    public void setupBreadcrumbs(View view, Object model) {
        if (model != null && model instanceof UifFormBase) {
            boolean usingFlow;
            UifFormBase form = (UifFormBase)model;
            boolean bl = usingFlow = StringUtils.isNotBlank((String)form.getFlowKey()) || view.getBreadcrumbs() != null && view.getBreadcrumbs().isUsePathBasedBreadcrumbs();
            if (usingFlow && form.getHistoryManager() != null) {
                HistoryFlow historyFlow;
                String formKey = form.getRequestedFormKey();
                if (StringUtils.isBlank((String)formKey)) {
                    formKey = form.getFormKey();
                    form.setRequestedFormKey(formKey);
                }
                if ((historyFlow = form.getHistoryManager().process(form.getFlowKey(), formKey, form.getRequestUrl())) != null) {
                    form.setHistoryFlow(historyFlow);
                    form.setFlowKey(historyFlow.getFlowKey());
                }
            }
            view.getBreadcrumbs().setUsePathBasedBreadcrumbs(usingFlow);
            if (view.getBreadcrumbs() != null && view.getBreadcrumbs().isUsePathBasedBreadcrumbs() && form.getHistoryFlow().getPastItems() != null) {
                List<BreadcrumbItem> pastItems = form.getHistoryFlow().getPastItems();
                ComponentUtils.clearIds(pastItems);
                for (BreadcrumbItem item : pastItems) {
                    view.assignComponentIds(item);
                }
                view.setPathBasedBreadcrumbs(pastItems);
            }
        }
    }

    public void finalizeBreadcrumbs(View view, Object model, Container parent, BreadcrumbItem breadcrumbItem) {
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel()) && view.getHeader() != null && !StringUtils.isBlank((String)view.getHeader().getHeaderText()) && model instanceof UifFormBase) {
            breadcrumbItem.setLabel(KRADUtils.generateUniqueViewTitle((UifFormBase)model, view));
        }
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel())) {
            breadcrumbItem.setRender(false);
        }
        if (breadcrumbItem.getUrl().getControllerMapping() == null && breadcrumbItem.getUrl().getViewId() == null && model instanceof UifFormBase && breadcrumbItem.getUrl().getRequestParameters() == null && ((UifFormBase)model).getInitialRequestParameters() != null) {
            Map<String, String> requestParameters = ((UifFormBase)model).getInitialRequestParameters();
            requestParameters.remove("ajaxReturnType");
            requestParameters.remove("ajaxRequest");
            requestParameters.remove("pageId");
            breadcrumbItem.getUrl().setRequestParameters(requestParameters);
        }
        if (breadcrumbItem.getUrl().getFormKey() == null && model instanceof UifFormBase && ((UifFormBase)model).getFormKey() != null) {
            breadcrumbItem.getUrl().setFormKey(((UifFormBase)model).getFormKey());
        }
        if (breadcrumbItem.getUrl().getControllerMapping() == null && model instanceof UifFormBase) {
            breadcrumbItem.getUrl().setControllerMapping(((UifFormBase)model).getControllerMapping());
        }
        if (breadcrumbItem.getUrl().getViewId() == null) {
            breadcrumbItem.getUrl().setViewId(view.getId());
        }
        if (breadcrumbItem.getUrl().getPageId() == null && !view.getBreadcrumbs().isUsePathBasedBreadcrumbs()) {
            if (view.getEntryPageId() != null) {
                breadcrumbItem.getUrl().setPageId(view.getEntryPageId());
            } else if (view.isSinglePageView() && view.getPage() != null) {
                breadcrumbItem.getUrl().setPageId(view.getPage().getId());
            } else if (!view.getItems().isEmpty() && view.getItems().get(0) != null) {
                breadcrumbItem.getUrl().setPageId(view.getItems().get(0).getId());
            }
        }
        if (model instanceof UifFormBase && ((UifFormBase)model).getHistoryFlow() != null) {
            ((UifFormBase)model).getHistoryFlow().setCurrentViewItem(view.getBreadcrumbItem());
        }
    }

    @BeanTagAttribute(name="homewardPathBreadcrumbs", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getHomewardPathBreadcrumbs() {
        return this.homewardPathBreadcrumbs;
    }

    public void setHomewardPathBreadcrumbs(List<BreadcrumbItem> homewardPathBreadcrumbs) {
        this.homewardPathBreadcrumbs = homewardPathBreadcrumbs;
    }

    @BeanTagAttribute(name="preViewBreadcrumbs", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getPreViewBreadcrumbs() {
        return this.preViewBreadcrumbs;
    }

    public void setPreViewBreadcrumbs(List<BreadcrumbItem> preViewBreadcrumbs) {
        this.preViewBreadcrumbs = preViewBreadcrumbs;
    }

    @BeanTagAttribute(name="prePageBreadcrumbs", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getPrePageBreadcrumbs() {
        return this.prePageBreadcrumbs;
    }

    public void setPrePageBreadcrumbs(List<BreadcrumbItem> prePageBreadcrumbs) {
        this.prePageBreadcrumbs = prePageBreadcrumbs;
    }

    @BeanTagAttribute(name="breadcrumbOverrides", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getBreadcrumbOverrides() {
        return this.breadcrumbOverrides;
    }

    public void setBreadcrumbOverrides(List<BreadcrumbItem> breadcrumbOverrides) {
        this.breadcrumbOverrides = breadcrumbOverrides;
    }

    public <T> T copy() {
        T copiedClass = null;
        try {
            copiedClass = (T)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        this.copyProperties(copiedClass);
        return copiedClass;
    }

    protected <T> void copyProperties(T breadcrumbOptions) {
        BreadcrumbOptions breadcrumbOptionsCopy = (BreadcrumbOptions)breadcrumbOptions;
        if (this.breadcrumbOverrides != null) {
            ArrayList breadcrumbOverrides = Lists.newArrayListWithExpectedSize((int)this.getBreadcrumbOverrides().size());
            for (BreadcrumbItem breadcrumbOverride : this.breadcrumbOverrides) {
                breadcrumbOverrides.add((BreadcrumbItem)breadcrumbOverride.copy());
            }
            breadcrumbOptionsCopy.setBreadcrumbOverrides(breadcrumbOverrides);
        }
        if (this.homewardPathBreadcrumbs != null) {
            ArrayList homewardPathBreadcrumbs = Lists.newArrayListWithExpectedSize((int)this.getHomewardPathBreadcrumbs().size());
            for (BreadcrumbItem homewardPathBreadcrumb : this.homewardPathBreadcrumbs) {
                homewardPathBreadcrumbs.add((BreadcrumbItem)homewardPathBreadcrumb.copy());
            }
            breadcrumbOptionsCopy.setHomewardPathBreadcrumbs(homewardPathBreadcrumbs);
        }
        if (this.prePageBreadcrumbs != null) {
            ArrayList prePageBreadcrumbs = Lists.newArrayListWithExpectedSize((int)this.getPrePageBreadcrumbs().size());
            for (BreadcrumbItem prePageBreadcrumb : this.prePageBreadcrumbs) {
                prePageBreadcrumbs.add((BreadcrumbItem)prePageBreadcrumb.copy());
            }
            breadcrumbOptionsCopy.setPrePageBreadcrumbs(prePageBreadcrumbs);
        }
        if (this.preViewBreadcrumbs != null) {
            ArrayList preViewBreadcrumbs = Lists.newArrayListWithExpectedSize((int)this.getPreViewBreadcrumbs().size());
            for (BreadcrumbItem preViewBreadcrumb : this.preViewBreadcrumbs) {
                preViewBreadcrumbs.add((BreadcrumbItem)preViewBreadcrumb.copy());
            }
            breadcrumbOptionsCopy.setPreViewBreadcrumbs(preViewBreadcrumbs);
        }
    }
}

