/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

public class ExpressionUtils {
    private static final Log LOG = LogFactory.getLog(ExpressionUtils.class);

    public static void populatePropertyExpressionsFromGraph(UifDictionaryBean expressionConfigurable, boolean buildRefreshGraphs) {
        if (expressionConfigurable == null || expressionConfigurable.getExpressionGraph() == null) {
            return;
        }
        HashMap refreshExpressionGraphs = new HashMap();
        Map<String, String> expressionGraph = expressionConfigurable.getExpressionGraph();
        for (Map.Entry<String, String> expressionEntry : expressionGraph.entrySet()) {
            String propertyName = expressionEntry.getKey();
            String expression = expressionEntry.getValue();
            UifDictionaryBean configurableWithExpression = expressionConfigurable;
            String adjustedPropertyName = propertyName;
            if (StringUtils.contains((String)propertyName, (String)".")) {
                String configurablePath = StringUtils.substringBeforeLast((String)propertyName, (String)".");
                adjustedPropertyName = StringUtils.substringAfterLast((String)propertyName, (String)".");
                Object nestedObject = ObjectPropertyUtils.getPropertyValue(expressionConfigurable, configurablePath);
                if (nestedObject == null || !(nestedObject instanceof UifDictionaryBean)) {
                    throw new RiceRuntimeException("Object for which expression is configured on is null or does not implement UifDictionaryBean: '" + configurablePath + "'");
                }
                configurableWithExpression = (UifDictionaryBean)nestedObject;
                if (buildRefreshGraphs) {
                    String[] configurablePathNames;
                    String currentPath = "";
                    for (String configurablePathName : configurablePathNames = StringUtils.split((String)configurablePath, (String)".")) {
                        if (StringUtils.isNotBlank((String)currentPath)) {
                            currentPath = currentPath + ".";
                        }
                        currentPath = currentPath + configurablePathName;
                        Map<String, String> graphExpressions = null;
                        if (refreshExpressionGraphs.containsKey(currentPath)) {
                            graphExpressions = (Map)refreshExpressionGraphs.get(currentPath);
                        } else {
                            graphExpressions = new HashMap();
                            refreshExpressionGraphs.put(currentPath, graphExpressions);
                        }
                        String configurablePropertyName = StringUtils.substringAfter((String)propertyName, (String)(currentPath + "."));
                        graphExpressions.put(configurablePropertyName, expression);
                    }
                }
            }
            configurableWithExpression.getPropertyExpressions().put(adjustedPropertyName, expression);
        }
        if (buildRefreshGraphs) {
            for (String configurablePath : refreshExpressionGraphs.keySet()) {
                Object nestedObject = ObjectPropertyUtils.getPropertyValue(expressionConfigurable, configurablePath);
                if (nestedObject == null || !(nestedObject instanceof UifDictionaryBean)) continue;
                ((UifDictionaryBean)nestedObject).setRefreshExpressionGraph((Map)refreshExpressionGraphs.get(configurablePath));
            }
            expressionConfigurable.setRefreshExpressionGraph(expressionGraph);
        }
    }

    public static String parseExpression(String exp, List<String> controlNames) {
        if ((exp = exp.trim()).startsWith("@{") && (exp = StringUtils.removeStart((String)exp, (String)"@{")).endsWith("}")) {
            exp = StringUtils.removeEnd((String)exp, (String)"}");
        }
        exp = StringUtils.replace((String)exp, (String)"!=", (String)" != ");
        exp = StringUtils.replace((String)exp, (String)"==", (String)" == ");
        exp = StringUtils.replace((String)exp, (String)">", (String)" > ");
        exp = StringUtils.replace((String)exp, (String)"<", (String)" < ");
        exp = StringUtils.replace((String)exp, (String)"<=", (String)" <= ");
        String conditionJs = exp = StringUtils.replace((String)exp, (String)">=", (String)" >= ");
        String stack = "";
        boolean expectingSingleQuote = false;
        boolean ignoreNext = false;
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (!(expectingSingleQuote || ignoreNext || c != '(' && c != ' ' && c != ')')) {
                ExpressionUtils.evaluateCurrentStack(stack.trim(), controlNames);
                stack = "";
                continue;
            }
            if (!ignoreNext && c == '\'') {
                stack = stack + c;
                expectingSingleQuote = !expectingSingleQuote;
                continue;
            }
            if (c == '\\') {
                stack = stack + c;
                ignoreNext = !ignoreNext;
                continue;
            }
            stack = stack + c;
            ignoreNext = false;
        }
        if (StringUtils.isNotEmpty((String)stack)) {
            ExpressionUtils.evaluateCurrentStack(stack.trim(), controlNames);
        }
        if ((conditionJs = conditionJs.replaceAll("\\s(?i:ne)\\s", " != ").replaceAll("\\s(?i:eq)\\s", " == ").replaceAll("\\s(?i:gt)\\s", " > ").replaceAll("\\s(?i:lt)\\s", " < ").replaceAll("\\s(?i:lte)\\s", " <= ").replaceAll("\\s(?i:gte)\\s", " >= ").replaceAll("\\s(?i:and)\\s", " && ").replaceAll("\\s(?i:or)\\s", " || ").replaceAll("\\s(?i:not)\\s", " != ").replaceAll("\\s(?i:null)\\s?", " '' ").replaceAll("\\s?(?i:#empty)\\((.*?)\\)", "isValueEmpty($1)").replaceAll("\\s?(?i:#listContains)\\((.*?)\\)", "listContains($1)").replaceAll("\\s?(?i:#emptyList)\\((.*?)\\)", "emptyList($1)")).contains("matches")) {
            conditionJs = conditionJs.replaceAll("\\s+(?i:matches)\\s+'.*'", ".match(/$0/) != null ");
            conditionJs = conditionJs.replaceAll("\\(/\\s+(?i:matches)\\s+'", "(/");
            conditionJs = conditionJs.replaceAll("'\\s*/\\)", "/)");
        }
        ArrayList<String> removeControlNames = new ArrayList<String>();
        ArrayList<String> addControlNames = new ArrayList<String>();
        for (String propertyName : controlNames) {
            if (propertyName.trim().startsWith("{") && propertyName.trim().endsWith("}")) {
                String array = propertyName.trim().replace('{', '[');
                array = array.replace('}', ']');
                conditionJs = conditionJs.replace(propertyName, array);
                removeControlNames.add(propertyName);
                continue;
            }
            if (propertyName.startsWith("!")) {
                String actualPropertyName = StringUtils.removeStart((String)propertyName, (String)"!");
                conditionJs = conditionJs.replace(propertyName, "!coerceValue(\"" + actualPropertyName + "\")");
                removeControlNames.add(propertyName);
                addControlNames.add(actualPropertyName);
                continue;
            }
            conditionJs = conditionJs.replace(propertyName, "coerceValue(\"" + propertyName + "\")");
        }
        controlNames.removeAll(removeControlNames);
        controlNames.addAll(addControlNames);
        return conditionJs;
    }

    public static void evaluateCurrentStack(String stack, List<String> controlNames) {
        if (!(!StringUtils.isNotBlank((String)stack) || stack.equals("==") || stack.equals("!=") || stack.equals(">") || stack.equals("<") || stack.equals(">=") || stack.equals("<=") || stack.equalsIgnoreCase("ne") || stack.equalsIgnoreCase("eq") || stack.equalsIgnoreCase("gt") || stack.equalsIgnoreCase("lt") || stack.equalsIgnoreCase("lte") || stack.equalsIgnoreCase("gte") || stack.equalsIgnoreCase("matches") || stack.equalsIgnoreCase("null") || stack.equalsIgnoreCase("false") || stack.equalsIgnoreCase("true") || stack.equalsIgnoreCase("and") || stack.equalsIgnoreCase("or") || stack.contains("#empty") || stack.equals("!") || stack.contains("#emptyList") || stack.contains("#listContains") || stack.startsWith("'") || stack.endsWith("'"))) {
            boolean isNumber = false;
            if (StringUtils.isNumeric((String)stack.substring(0, 1)) || stack.substring(0, 1).equals("-")) {
                try {
                    Double.parseDouble(stack);
                    isNumber = true;
                }
                catch (NumberFormatException e) {
                    isNumber = false;
                }
            }
            if (!isNumber) {
                if (StringUtils.endsWith((String)stack, (String)",")) {
                    stack = StringUtils.removeEnd((String)stack, (String)",").trim();
                }
                if (!controlNames.contains(stack)) {
                    controlNames.add(stack);
                }
            }
        }
    }
}

