/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADConstants;

public class MessageStructureUtils {
    public static String translateStringMessage(String messageText) {
        Component message;
        List<Component> components;
        if (!StringUtils.isEmpty((String)messageText) && !(components = MessageStructureUtils.parseMessage(null, messageText, null, null, false)).isEmpty() && (message = components.get(0)) instanceof Message) {
            messageText = ((Message)message).getMessageText();
        }
        return messageText;
    }

    public static List<Component> parseMessage(String messageId, String messageText, List<Component> componentList, View view, boolean parseComponents) {
        messageText = messageText.replace("\\[", "&#91;");
        messageText = messageText.replace("\\]", "&#93;");
        messageText = messageText.replace("]", "$@$]");
        String[] messagePieces = messageText.split("[\\[|\\]]");
        ArrayList<Component> messageComponentStructure = new ArrayList<Component>();
        Message currentMessageComponent = null;
        for (String messagePiece : messagePieces) {
            if (messagePiece.endsWith("$@$")) {
                if (StringUtils.startsWithIgnoreCase((String)(messagePiece = StringUtils.removeEnd((String)messagePiece, (String)"$@$")), (String)"id=") && parseComponents) {
                    currentMessageComponent = MessageStructureUtils.processIdComponentContent(messagePiece, messageComponentStructure, currentMessageComponent, view);
                    continue;
                }
                if (messagePiece.matches("^[0-9]+( .+=.+)*$") && parseComponents) {
                    currentMessageComponent = MessageStructureUtils.processIndexComponentContent(messagePiece, componentList, messageComponentStructure, currentMessageComponent, view, messageId);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"color=") || StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/color")) {
                    currentMessageComponent = MessageStructureUtils.processColorContent(messagePiece, currentMessageComponent, view);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"css=") || StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/css")) {
                    currentMessageComponent = MessageStructureUtils.processCssClassContent(messagePiece, currentMessageComponent, view);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"link=") || StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/link")) {
                    currentMessageComponent = MessageStructureUtils.processLinkContent(messagePiece, currentMessageComponent, view);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"action=") || StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/action")) {
                    currentMessageComponent = MessageStructureUtils.processActionLinkContent(messagePiece, currentMessageComponent, view);
                    continue;
                }
                if (messagePiece.equals("")) continue;
                currentMessageComponent = MessageStructureUtils.processHtmlContent(messagePiece, currentMessageComponent, view);
                continue;
            }
            messagePiece = MessageStructureUtils.addBlanks(messagePiece);
            currentMessageComponent = MessageStructureUtils.concatenateStringMessageContent(currentMessageComponent, messagePiece, view);
        }
        if (currentMessageComponent != null && StringUtils.isNotEmpty((String)currentMessageComponent.getMessageText())) {
            messageComponentStructure.add(currentMessageComponent);
            currentMessageComponent = null;
        }
        return messageComponentStructure;
    }

    private static Message concatenateStringMessageContent(Message currentMessageComponent, String messagePiece, View view) {
        if (currentMessageComponent == null) {
            currentMessageComponent = ComponentFactory.getMessage();
            if (view != null) {
                view.assignComponentIds(currentMessageComponent);
            }
            currentMessageComponent.setMessageText(messagePiece);
            currentMessageComponent.setGenerateSpan(false);
        } else {
            currentMessageComponent.setMessageText(currentMessageComponent.getMessageText() + messagePiece);
        }
        return currentMessageComponent;
    }

    private static Component processAdditionalProperties(Component component, String[] tagParts) {
        String componentString = tagParts[0];
        for (String part : tagParts = (String[])ArrayUtils.remove((Object[])tagParts, (int)0)) {
            String[] propertyValue = part.split("=");
            if (propertyValue.length != 2) {
                throw new RuntimeException("Invalid Message structure for component defined as " + componentString + " around " + part);
            }
            String path = propertyValue[0];
            String value = propertyValue[1].trim();
            value = StringUtils.removeStart((String)value, (String)"'");
            value = StringUtils.removeEnd((String)value, (String)"'");
            ObjectPropertyUtils.setPropertyValue(component, path, value);
        }
        return component;
    }

    public static String addBlanks(String text) {
        if (StringUtils.startsWithIgnoreCase((String)text, (String)" ")) {
            text = "&nbsp;" + StringUtils.removeStart((String)text, (String)" ");
        }
        if (text.endsWith(" ")) {
            text = StringUtils.removeEnd((String)text, (String)" ") + "&nbsp;";
        }
        return text;
    }

    private static Message processIdComponentContent(String messagePiece, List<Component> messageComponentStructure, Message currentMessageComponent, View view) {
        String[] parts = messagePiece.trim().trim().split("([ ]+(?=([^']*'[^']*')*[^']*$))");
        messagePiece = parts[0];
        if (currentMessageComponent != null && StringUtils.isNotEmpty((String)currentMessageComponent.getMessageText())) {
            messageComponentStructure.add(currentMessageComponent);
            currentMessageComponent = null;
        }
        messagePiece = StringUtils.remove((String)messagePiece, (String)"'");
        Component component = ComponentFactory.getNewComponentInstance(StringUtils.removeStart((String)(messagePiece = StringUtils.remove((String)messagePiece, (String)"\"")), (String)"id="));
        if (component != null) {
            view.assignComponentIds(component);
            component.addStyleClass("inlineBlock");
            if (parts.length > 1) {
                component = MessageStructureUtils.processAdditionalProperties(component, parts);
            }
            messageComponentStructure.add(component);
        }
        return currentMessageComponent;
    }

    private static Message processIndexComponentContent(String messagePiece, List<Component> componentList, List<Component> messageComponentStructure, Message currentMessageComponent, View view, String messageId) {
        String[] parts = messagePiece.trim().trim().split("([ ]+(?=([^']*'[^']*')*[^']*$))");
        messagePiece = parts[0];
        if (currentMessageComponent != null && StringUtils.isNotEmpty((String)currentMessageComponent.getMessageText())) {
            messageComponentStructure.add(currentMessageComponent);
            currentMessageComponent = null;
        }
        int cIndex = Integer.parseInt(messagePiece);
        if (componentList != null && cIndex < componentList.size() && !componentList.isEmpty()) {
            Component component = componentList.get(cIndex);
            if (component != null) {
                if (component.getId() == null) {
                    view.assignComponentIds(component);
                }
                if (parts.length > 1) {
                    component = MessageStructureUtils.processAdditionalProperties(component, parts);
                }
                component.addStyleClass("inlineBlock");
                messageComponentStructure.add(component);
            }
        } else {
            throw new RuntimeException("Component with index " + cIndex + " does not exist in inlineComponents of the message component with id " + messageId);
        }
        return currentMessageComponent;
    }

    private static Message processColorContent(String messagePiece, Message currentMessageComponent, View view) {
        if (!StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/")) {
            messagePiece = StringUtils.remove((String)messagePiece, (String)"'");
            messagePiece = StringUtils.remove((String)messagePiece, (String)"\"");
            messagePiece = "<span style='color: " + StringUtils.removeStart((String)messagePiece, (String)"color=") + ";'>";
        } else {
            messagePiece = "</span>";
        }
        return MessageStructureUtils.concatenateStringMessageContent(currentMessageComponent, messagePiece, view);
    }

    private static Message processCssClassContent(String messagePiece, Message currentMessageComponent, View view) {
        if (!StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/")) {
            messagePiece = StringUtils.remove((String)messagePiece, (String)"'");
            messagePiece = StringUtils.remove((String)messagePiece, (String)"\"");
            messagePiece = "<span class='" + StringUtils.removeStart((String)messagePiece, (String)"css=") + "'>";
        } else {
            messagePiece = "</span>";
        }
        return MessageStructureUtils.concatenateStringMessageContent(currentMessageComponent, messagePiece, view);
    }

    private static Message processLinkContent(String messagePiece, Message currentMessageComponent, View view) {
        if (!StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/")) {
            messagePiece = StringUtils.removeStart((String)messagePiece, (String)"link=");
            messagePiece = StringUtils.removeStart((String)messagePiece, (String)"'");
            messagePiece = StringUtils.removeEnd((String)messagePiece, (String)"'");
            messagePiece = StringUtils.removeStart((String)messagePiece, (String)"\"");
            messagePiece = StringUtils.removeEnd((String)messagePiece, (String)"\"");
            messagePiece = "<a href='" + messagePiece + "' target='_blank'>";
        } else {
            messagePiece = "</a>";
        }
        return MessageStructureUtils.concatenateStringMessageContent(currentMessageComponent, messagePiece, view);
    }

    private static Message processActionLinkContent(String messagePiece, Message currentMessageComponent, View view) {
        if (!StringUtils.startsWithIgnoreCase((String)messagePiece, (String)"/")) {
            String[] splitData = (messagePiece = StringUtils.removeStart((String)messagePiece, (String)"action=")).split("data=");
            String[] params = splitData[0].trim().split("([,]+(?=([^']*'[^']*')*[^']*$))");
            String methodToCall = params.length >= 1 ? params[0] : "";
            String validate = params.length >= 2 ? params[1] : "true";
            String ajaxSubmit = params.length >= 3 ? params[2] : "true";
            String successCallback = params.length >= 4 ? params[3] : "null";
            String submitData = "null";
            if (splitData.length > 1) {
                submitData = splitData[1].trim();
            }
            methodToCall = StringUtils.remove((String)methodToCall, (String)"'");
            methodToCall = StringUtils.remove((String)methodToCall, (String)"\"");
            messagePiece = "<a href=\"javascript:void(null)\" onclick=\"submitForm('" + methodToCall + "'," + submitData + "," + validate + "," + ajaxSubmit + "," + successCallback + "); return false;\">";
        } else {
            messagePiece = "</a>";
        }
        return MessageStructureUtils.concatenateStringMessageContent(currentMessageComponent, messagePiece, view);
    }

    private static Message processHtmlContent(String messagePiece, Message currentMessageComponent, View view) {
        if (StringUtils.startsWithAny((String)(messagePiece = messagePiece.trim()), (String[])KRADConstants.MessageParsing.UNALLOWED_HTML) || StringUtils.endsWithAny((String)messagePiece, (String[])KRADConstants.MessageParsing.UNALLOWED_HTML)) {
            throw new RuntimeException("The following html is not allowed in Messages: " + Arrays.toString(KRADConstants.MessageParsing.UNALLOWED_HTML));
        }
        messagePiece = "<" + messagePiece + ">";
        return MessageStructureUtils.concatenateStringMessageContent(currentMessageComponent, messagePiece, view);
    }
}

