/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.comparator.NumericValueComparator;
import org.kuali.rice.krad.comparator.TemporalValueComparator;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.util.ColumnSort;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;

public class MultiColumnComparator
implements Comparator<Integer> {
    private final List<Object> modelCollection;
    private final CollectionGroup collectionGroup;
    private final List<ColumnSort> columnSorts;
    private final View view;
    private final TableLayoutManager tableLayoutManager;
    private final List<Field> prototypeRow;
    private final WeakHashMap<String, String> calculatedValueCache;
    private final HashMap<String, Class> propertyClassCache;

    public MultiColumnComparator(List<Object> modelCollection, CollectionGroup collectionGroup, List<ColumnSort> columnSorts, View view) {
        this.modelCollection = modelCollection;
        this.collectionGroup = collectionGroup;
        this.columnSorts = columnSorts;
        this.view = view;
        this.calculatedValueCache = new WeakHashMap();
        this.propertyClassCache = new HashMap();
        this.tableLayoutManager = (TableLayoutManager)collectionGroup.getLayoutManager();
        this.prototypeRow = this.buildPrototypeRow();
    }

    @Override
    public int compare(Integer index1, Integer index2) {
        int sortResult = 0;
        for (ColumnSort columnSort : this.columnSorts) {
            Object modelElement2;
            Field protoField = this.prototypeRow.get(columnSort.getColumnIndex());
            Object modelElement1 = this.modelCollection.get(index1);
            sortResult = this.isOneNull(modelElement1, modelElement2 = this.modelCollection.get(index2)) ? this.compareOneIsNull(modelElement1, modelElement2) : (protoField instanceof DataField ? this.compareDataFieldValues(columnSort, (DataField)protoField, index1, index2) : this.compareFieldStringValues(columnSort, protoField, index1, index2));
            if (sortResult == 0) continue;
            if (columnSort.getDirection() != ColumnSort.Direction.DESC) break;
            sortResult *= -1;
            break;
        }
        return sortResult;
    }

    private int compareDataFieldValues(ColumnSort columnSort, DataField protoField, Integer index1, Integer index2) {
        Comparable datum2;
        Comparable datum1;
        Object modelElement1 = this.modelCollection.get(index1);
        Object modelElement2 = this.modelCollection.get(index2);
        String propertyPath = protoField.getBindingInfo().getBindingName();
        Class<?> columnDataClass = this.getColumnDataClass(propertyPath);
        int sortResult = Comparable.class.isAssignableFrom(columnDataClass) ? (this.isOneNull(datum1 = (Comparable)ObjectUtils.getPropertyValue(modelElement1, propertyPath), datum2 = (Comparable)ObjectUtils.getPropertyValue(modelElement2, propertyPath)) ? this.compareOneIsNull(datum1, datum2) : (String.class.equals(columnDataClass) ? this.columnTypeCompare((String)((Object)datum1), (String)((Object)datum2), columnSort.getSortType()) : datum1.compareTo(datum2))) : this.compareFieldStringValues(columnSort, protoField, index1, index2);
        return sortResult;
    }

    private Class<?> getColumnDataClass(String propertyPath) {
        Class dataClass = this.propertyClassCache.get(propertyPath);
        if (dataClass == null) {
            for (int i = 0; i < this.modelCollection.size() && dataClass == null; ++i) {
                dataClass = ObjectPropertyUtils.getPropertyType(this.modelCollection.get(i), propertyPath);
            }
            if (dataClass == null) {
                dataClass = Object.class;
            }
            this.propertyClassCache.put(propertyPath, dataClass);
        }
        return dataClass;
    }

    private int compareFieldStringValues(ColumnSort columnSort, Field protoField, Integer index1, Integer index2) {
        String fieldValue2;
        String fieldValue1;
        if (!CollectionUtils.sizeIsEmpty(protoField.getPropertyExpressions())) {
            fieldValue1 = this.calculateFieldValue(protoField, index1, columnSort.getColumnIndex());
            fieldValue2 = this.calculateFieldValue(protoField, index2, columnSort.getColumnIndex());
        } else {
            fieldValue1 = KRADUtils.getSimpleFieldValue(this.modelCollection.get(index1), protoField);
            fieldValue2 = KRADUtils.getSimpleFieldValue(this.modelCollection.get(index2), protoField);
        }
        int sortResult = this.columnTypeCompare(fieldValue1, fieldValue2, columnSort.getSortType());
        return sortResult;
    }

    private String calculateFieldValue(Field protoField, Integer collectionIndex, int columnIndex) {
        String fieldValue1;
        String cacheKey = String.format("%d,%d", collectionIndex, columnIndex);
        String cachedValue = this.calculatedValueCache.get(cacheKey);
        if (cachedValue == null) {
            Object collectionElement = this.modelCollection.get(collectionIndex);
            ExpressionEvaluator expressionEvaluator = this.view.getViewHelperService().getExpressionEvaluator();
            Map<String, Object> viewContext = this.view.getContext();
            HashMap<String, Object> expressionContext = new HashMap<String, Object>();
            if (viewContext != null) {
                expressionContext.putAll(viewContext);
            }
            expressionContext.put("line", collectionElement);
            expressionContext.put("index", collectionIndex);
            expressionContext.put("collectionGroup", this.collectionGroup);
            expressionContext.put("manager", this.tableLayoutManager);
            expressionContext.put("component", protoField);
            expressionContext.put("parent", this.collectionGroup);
            expressionEvaluator.evaluateExpressionsOnConfigurable(this.view, protoField, expressionContext);
            fieldValue1 = KRADUtils.getSimpleFieldValue(collectionElement, protoField);
            this.calculatedValueCache.put(cacheKey, fieldValue1);
        } else {
            fieldValue1 = cachedValue;
        }
        return fieldValue1;
    }

    private int columnTypeCompare(String val1, String val2, String sortType) {
        int result;
        if (this.isOneNull(val1, val2)) {
            result = this.compareOneIsNull(val1, val2);
        } else if ("string".equals(sortType)) {
            result = val1.compareTo(val2);
        } else if ("numeric".equals(sortType)) {
            result = NumericValueComparator.getInstance().compare((Object)val1, (Object)val2);
        } else if ("kuali_percent".equals(sortType)) {
            result = NumericValueComparator.getInstance().compare((Object)val1, (Object)val2);
        } else if ("kuali_date".equals(sortType)) {
            result = TemporalValueComparator.getInstance().compare((Object)val1, (Object)val2);
        } else if ("kuali_currency".equals(sortType)) {
            KualiDecimal decimal1 = new KualiDecimal(val1.replaceAll("[^0-9.]", ""));
            KualiDecimal decimal2 = new KualiDecimal(val2.replaceAll("[^0-9.]", ""));
            result = decimal1.compareTo((AbstractKualiDecimal)decimal2);
        } else {
            throw new RuntimeException("unknown sort type: " + sortType);
        }
        return result;
    }

    private boolean isOneNull(Object o1, Object o2) {
        return o1 == null || o2 == null;
    }

    private int compareOneIsNull(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 != null) {
            throw new IllegalStateException("at least one parameter must be null");
        }
        return 1;
    }

    private List<Field> buildPrototypeRow() {
        ArrayList<Field> prototypeRow = new ArrayList<Field>(this.tableLayoutManager.getNumberOfColumns());
        List<Field> allRowFields = this.tableLayoutManager.getAllRowFields();
        Iterator<Field> allRowFieldsIter = allRowFields.iterator();
        int componentsSkipped = 0;
        int columnsSkipped = 0;
        if (this.collectionGroup.isRenderAddLine() && !this.collectionGroup.isReadOnly() && !this.tableLayoutManager.isSeparateAddLine()) {
            while (columnsSkipped < this.tableLayoutManager.getNumberOfColumns()) {
                columnsSkipped += allRowFieldsIter.next().getColSpan();
                ++componentsSkipped;
            }
        }
        for (int i = 0; i < this.tableLayoutManager.getNumberOfColumns(); ++i) {
            Field protoField = (Field)allRowFields.get(componentsSkipped + i).copy();
            if (protoField instanceof DataField) {
                DataField dataField = (DataField)protoField;
                BindingInfo bindingInfoCopy = (BindingInfo)dataField.getBindingInfo().copy();
                dataField.setBindingInfo(bindingInfoCopy);
                String elementAdjustedBindingPath = dataField.getBindingInfo().getBindingName();
                bindingInfoCopy.setBindingPath(elementAdjustedBindingPath);
            }
            prototypeRow.add(protoField);
        }
        return prototypeRow;
    }
}

