/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.Deque;
import java.util.LinkedList;
import org.kuali.rice.krad.uif.util.ProcessLogger;

public class ObjectPathExpressionParser {
    private static final ThreadLocal<ParseState> TL_EL_PARSE_STATE = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parsePathExpression(Object root, String path, PathEntry pathEntry) {
        boolean recycle;
        ParseState parseState = TL_EL_PARSE_STATE.get();
        if (parseState == null) {
            TL_EL_PARSE_STATE.set(new ParseState());
            parseState = TL_EL_PARSE_STATE.get();
            recycle = true;
        } else if (parseState.isActive()) {
            ProcessLogger.ntrace("el-parse:", ":nested", 100L);
            parseState = new ParseState();
            recycle = false;
        } else {
            recycle = true;
        }
        try {
            parseState.root = root;
            parseState.currentContinuation = pathEntry.parse(root, null, false);
            while (path != null) {
                path = parseState.prepareNextScan(path);
                parseState.scan(path);
                path = parseState.step(path, pathEntry);
            }
            Object object = parseState.currentContinuation;
            return object;
        }
        finally {
            assert (!recycle || parseState == TL_EL_PARSE_STATE.get());
            parseState.reset();
        }
    }

    private ObjectPathExpressionParser() {
    }

    public static interface PathEntry {
        public Object parse(Object var1, String var2, boolean var3);

        public Object prepare(Object var1);

        public String dereference(Object var1);
    }

    private static final class ParseState {
        private final Deque<Object> stack = new LinkedList<Object>();
        private int nextScanIndex;
        private int nextTokenIndex;
        private Object root;
        private Object currentContinuation;

        private ParseState() {
        }

        private boolean isActive() {
            return this.stack != null && !this.stack.isEmpty() || this.currentContinuation != null;
        }

        private void reset() {
            this.stack.clear();
            this.currentContinuation = null;
        }

        public String prepareNextScan(String path) {
            char inQuote;
            this.nextScanIndex = 0;
            char firstChar = path.charAt(0);
            if (firstChar != '(' && firstChar != '\'' && firstChar != '\"') {
                return path;
            }
            int parenCount = firstChar == '(' ? 1 : 0;
            int pathLen = path.length() - 1;
            char lastChar = firstChar;
            char c = inQuote = firstChar == '(' ? (char)'\u0000' : firstChar;
            while (this.nextScanIndex < pathLen && (firstChar == '(' && parenCount > 0 || firstChar != '(' && inQuote != '\u0000')) {
                ++this.nextScanIndex;
                char currentChar = path.charAt(this.nextScanIndex);
                if (lastChar == '\\') continue;
                if (inQuote == '\u0000') {
                    if (currentChar == '\'' || currentChar == '\"') {
                        inQuote = currentChar;
                    }
                } else if (currentChar == inQuote) {
                    switch (this.nextScanIndex >= path.length() - 1 ? 0 : (int)path.charAt(this.nextScanIndex + 1)) {
                        case 46: 
                        case 91: 
                        case 93: {
                            inQuote = '\u0000';
                        }
                    }
                }
                if (inQuote != '\u0000') continue;
                if (currentChar == '(') {
                    ++parenCount;
                }
                if (currentChar != ')') continue;
                --parenCount;
            }
            if (parenCount > 0) {
                throw new IllegalArgumentException("Unmatched '(': " + path);
            }
            if (firstChar == '(') {
                assert (path.charAt(this.nextScanIndex) == ')');
                path = this.nextScanIndex < pathLen ? path.substring(1, this.nextScanIndex) + path.substring(this.nextScanIndex + 1) : path.substring(1, this.nextScanIndex);
                --this.nextScanIndex;
            } else {
                ++this.nextScanIndex;
            }
            return path;
        }

        public void scan(String path) {
            this.nextTokenIndex = -1;
            for (int currentIndex = this.nextScanIndex; currentIndex < path.length(); ++currentIndex) {
                switch (path.charAt(currentIndex)) {
                    case ')': {
                        throw new IllegalArgumentException("Unmatched ')': " + path);
                    }
                    case '\"': 
                    case '\'': 
                    case '(': 
                    case '.': 
                    case '[': 
                    case ']': {
                        if (this.nextTokenIndex == -1) {
                            this.nextTokenIndex = currentIndex;
                        }
                        return;
                    }
                }
            }
        }

        private String step(String path, PathEntry pathEntry) {
            if (this.nextTokenIndex == -1) {
                this.currentContinuation = pathEntry.parse(pathEntry.prepare(this.currentContinuation), path, false);
                return null;
            }
            char nextToken = path.charAt(this.nextTokenIndex);
            switch (nextToken) {
                case '[': {
                    if (this.nextTokenIndex != 0) {
                        this.currentContinuation = pathEntry.parse(pathEntry.prepare(this.currentContinuation), path.substring(0, this.nextTokenIndex), false);
                    }
                    this.stack.push(this.currentContinuation);
                    this.currentContinuation = pathEntry.parse(this.root, null, false);
                    return path.substring(this.nextTokenIndex + 1);
                }
                case '(': {
                    this.currentContinuation = pathEntry.parse(pathEntry.prepare(this.currentContinuation), path.substring(0, this.nextTokenIndex), false);
                    return path.substring(this.nextTokenIndex);
                }
                case '.': {
                    this.currentContinuation = pathEntry.parse(pathEntry.prepare(this.currentContinuation), path.substring(0, this.nextTokenIndex), false);
                    return path.substring(this.nextTokenIndex + 1);
                }
                case ']': {
                    if (this.nextTokenIndex > 0) {
                        this.currentContinuation = pathEntry.parse(pathEntry.prepare(this.currentContinuation), path.substring(0, this.nextTokenIndex), false);
                        return path.substring(this.nextTokenIndex);
                    }
                    this.currentContinuation = pathEntry.parse(pathEntry.prepare(this.stack.pop()), pathEntry.dereference(this.currentContinuation), true);
                    if (this.nextTokenIndex + 1 < path.length()) {
                        switch (path.charAt(this.nextTokenIndex + 1)) {
                            case '.': {
                                return path.substring(this.nextTokenIndex + 2);
                            }
                            case '[': 
                            case ']': {
                                return path.substring(this.nextTokenIndex + 1);
                            }
                        }
                        throw new IllegalArgumentException("Expected '.', '[', or ']': " + path);
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("Unexpected '" + nextToken + "' :" + path);
        }
    }
}

