/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;

public class UifBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final Log LOG = LogFactory.getLog(UifBeanFactoryPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashSet<String> processedBeanNames = new HashSet<String>();
        LOG.info((Object)"Beginning post processing of bean factory for UIF expressions");
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            this.processBeanDefinition(beanName, beanDefinition, beanFactory, processedBeanNames);
        }
        LOG.info((Object)"Finished post processing of bean factory for UIF expressions");
    }

    protected void processBeanDefinition(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        Class<?> beanClass = this.getBeanClass(beanDefinition, beanFactory);
        if (beanClass == null || !UifDictionaryBean.class.isAssignableFrom(beanClass) || processedBeanNames.contains(beanName)) {
            return;
        }
        ManagedMap expressionGraph = new ManagedMap();
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs.contains("expressionGraph") && (expressionGraph = (ManagedMap)pvs.getPropertyValue("expressionGraph").getValue()) == null) {
            expressionGraph = new ManagedMap();
        }
        expressionGraph.setMergeEnabled(false);
        this.processNestedBeanDefinition(beanName, beanDefinition, "", (Map<String, String>)expressionGraph, beanFactory, processedBeanNames);
        pvs = beanDefinition.getPropertyValues();
        pvs.addPropertyValue("expressionGraph", (Object)expressionGraph);
    }

    protected void processNestedBeanDefinition(String beanName, BeanDefinition beanDefinition, String nestedPropertyName, Map<String, String> expressionGraph, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        PropertyValue[] pvArray;
        Class<?> beanClass = this.getBeanClass(beanDefinition, beanFactory);
        if (beanClass == null || !UifDictionaryBean.class.isAssignableFrom(beanClass) || processedBeanNames.contains(beanName)) {
            return;
        }
        LOG.debug((Object)("Processing bean name '" + beanName + "'"));
        Map<String, String> parentExpressionGraph = this.getExpressionGraphFromParent(beanDefinition.getParentName(), beanFactory, processedBeanNames);
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        for (PropertyValue pv : pvArray = pvs.getPropertyValues()) {
            if (pv.getName().equals("expressionGraph")) continue;
            String propertyPath = pv.getName();
            if (StringUtils.isNotBlank((String)nestedPropertyName)) {
                propertyPath = nestedPropertyName + "." + propertyPath;
            }
            if (expressionGraph.containsKey(propertyPath)) {
                expressionGraph.remove(propertyPath);
            }
            if (this.hasExpression(pv.getValue())) {
                String strValue = this.getStringValue(pv.getValue());
                expressionGraph.put(propertyPath, strValue);
                pvs.removePropertyValue(pv.getName());
            } else {
                Object newValue = this.processPropertyValue(propertyPath, pv.getName(), pv.getValue(), beanDefinition, parentExpressionGraph, expressionGraph, beanFactory, processedBeanNames);
                pvs.removePropertyValue(pv.getName());
                pvs.addPropertyValue(pv.getName(), newValue);
            }
            if (!parentExpressionGraph.containsKey(pv.getName())) continue;
            parentExpressionGraph.remove(pv.getName());
        }
        if (StringUtils.isNotBlank((String)nestedPropertyName)) {
            pvs.addPropertyValue("expressionGraph", null);
        }
        for (Map.Entry<String, String> parentExpression : parentExpressionGraph.entrySet()) {
            String expressionPath = parentExpression.getKey();
            if (StringUtils.isNotBlank((String)nestedPropertyName)) {
                expressionPath = nestedPropertyName + "." + expressionPath;
            }
            if (expressionGraph.containsKey(expressionPath)) continue;
            expressionGraph.put(expressionPath, parentExpression.getValue());
        }
        if (StringUtils.isNotBlank((String)beanName) && !StringUtils.contains((String)beanName, (String)"$") && !StringUtils.contains((String)beanName, (String)"#") && !beanFactory.containsBean(beanName)) {
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(beanName, beanDefinition);
        }
        if (StringUtils.isNotBlank((String)beanName)) {
            processedBeanNames.add(beanName);
        }
    }

    protected Class<?> getBeanClass(BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition parentBeanDefinition;
        if (StringUtils.isNotBlank((String)beanDefinition.getBeanClassName())) {
            try {
                return Class.forName(beanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)beanDefinition.getParentName()) && (parentBeanDefinition = beanFactory.getBeanDefinition(beanDefinition.getParentName())) != null) {
            return this.getBeanClass(parentBeanDefinition, beanFactory);
        }
        return null;
    }

    protected Map<String, String> getExpressionGraphFromParent(String parentBeanName, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        Object value;
        MutablePropertyValues pvs;
        PropertyValue propertyExpressionsPV;
        HashMap<String, String> expressionGraph = new HashMap<String, String>();
        if (StringUtils.isBlank((String)parentBeanName) || !beanFactory.containsBeanDefinition(parentBeanName)) {
            return expressionGraph;
        }
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(parentBeanName);
        if (!processedBeanNames.contains(parentBeanName)) {
            this.processBeanDefinition(parentBeanName, beanDefinition, beanFactory, processedBeanNames);
        }
        if ((propertyExpressionsPV = (pvs = beanDefinition.getPropertyValues()).getPropertyValue("expressionGraph")) != null && (value = propertyExpressionsPV.getValue()) != null && value instanceof ManagedMap) {
            expressionGraph.putAll((Map<String, String>)((ManagedMap)value));
        }
        return expressionGraph;
    }

    protected boolean hasExpression(Object propertyValue) {
        String elPlaceholder;
        String strValue;
        return propertyValue != null && (strValue = this.getStringValue(propertyValue)) != null && StringUtils.isNotBlank((String)(elPlaceholder = StringUtils.substringBetween((String)strValue, (String)"@{", (String)"}")));
    }

    protected Object processPropertyValue(String nestedPropertyName, String propertyName, Object propertyValue, BeanDefinition beanDefinition, Map<String, String> parentExpressionGraph, Map<String, String> expressionGraph, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        boolean clearExpressionsForNull = false;
        if (propertyValue instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)propertyValue;
            String value = typedStringValue.getValue();
            if (value == null) {
                clearExpressionsForNull = true;
            }
        } else if (propertyValue == null) {
            clearExpressionsForNull = true;
        }
        if (clearExpressionsForNull) {
            this.removeExpressionsByPrefix(nestedPropertyName, expressionGraph);
            this.removeExpressionsByPrefix(propertyName, parentExpressionGraph);
            return propertyValue;
        }
        if (propertyValue instanceof BeanDefinition || propertyValue instanceof BeanDefinitionHolder) {
            BeanDefinition beanDefinitionValue;
            String beanName = null;
            if (propertyValue instanceof BeanDefinition) {
                beanDefinitionValue = (BeanDefinition)propertyValue;
            } else {
                beanDefinitionValue = ((BeanDefinitionHolder)propertyValue).getBeanDefinition();
                beanName = ((BeanDefinitionHolder)propertyValue).getBeanName();
            }
            this.removeExpressionsByPrefix(nestedPropertyName, expressionGraph);
            this.removeExpressionsByPrefix(propertyName, parentExpressionGraph);
            this.processNestedBeanDefinition(beanName, beanDefinitionValue, nestedPropertyName, expressionGraph, beanFactory, processedBeanNames);
            return propertyValue;
        }
        if (propertyValue instanceof Object[]) {
            this.visitArray(nestedPropertyName, parentExpressionGraph, expressionGraph, (Object[])propertyValue, beanFactory, processedBeanNames);
        } else if (propertyValue instanceof List) {
            this.visitList(nestedPropertyName, propertyName, beanDefinition, parentExpressionGraph, expressionGraph, (List)propertyValue, beanFactory, processedBeanNames);
        } else if (propertyValue instanceof Set) {
            this.visitSet(nestedPropertyName, parentExpressionGraph, expressionGraph, (Set)propertyValue, beanFactory, processedBeanNames);
        } else if (propertyValue instanceof Map) {
            this.visitMap(nestedPropertyName, parentExpressionGraph, expressionGraph, (Map)propertyValue, beanFactory, processedBeanNames);
        }
        return propertyValue;
    }

    protected void removeExpressionsByPrefix(String propertyNamePrefix, Map<String, String> expressionGraph) {
        HashMap<String, String> adjustedExpressionGraph = new HashMap<String, String>();
        for (String propertyName : expressionGraph.keySet()) {
            if (propertyName.startsWith(propertyNamePrefix + ".")) continue;
            adjustedExpressionGraph.put(propertyName, expressionGraph.get(propertyName));
        }
        expressionGraph.clear();
        expressionGraph.putAll(adjustedExpressionGraph);
    }

    protected String getStringValue(Object value) {
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            return typedStringValue.getValue();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected void visitArray(String propertyName, Map<String, String> parentExpressionGraph, Map<String, String> expressionGraph, Object array, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        ManagedArray newArray = null;
        Object[] arrayVal = null;
        boolean isMergeEnabled = false;
        if (array instanceof ManagedArray) {
            isMergeEnabled = ((ManagedArray)array).isMergeEnabled();
            arrayVal = (Object[])((ManagedArray)array).getSource();
            newArray = new ManagedArray(((ManagedArray)array).getElementTypeName(), arrayVal.length);
            newArray.setMergeEnabled(isMergeEnabled);
        } else {
            arrayVal = (Object[])array;
            newArray = new Object[arrayVal.length];
        }
        for (int i = 0; i < arrayVal.length; ++i) {
            Object elem = arrayVal[i];
            String elemPropertyName = propertyName + "[" + i + "]";
            if (this.hasExpression(elem)) {
                String strValue = this.getStringValue(elem);
                expressionGraph.put(elemPropertyName, strValue);
                arrayVal[i] = null;
            } else {
                if (elem instanceof BeanDefinition || elem instanceof BeanDefinitionHolder) {
                    BeanDefinition beanDefinition;
                    String beanName = null;
                    if (elem instanceof BeanDefinition) {
                        beanDefinition = (BeanDefinition)elem;
                    } else {
                        beanDefinition = ((BeanDefinitionHolder)elem).getBeanDefinition();
                        beanName = ((BeanDefinitionHolder)elem).getBeanName();
                    }
                    this.processBeanDefinition(beanName, beanDefinition, beanFactory, processedBeanNames);
                }
                arrayVal[i] = elem;
            }
            if (!isMergeEnabled || !parentExpressionGraph.containsKey(elemPropertyName)) continue;
            parentExpressionGraph.remove(elemPropertyName);
        }
        if (!isMergeEnabled) {
            HashMap<String, String> adjustedParentExpressionGraph = new HashMap<String, String>();
            for (Map.Entry<String, String> parentExpression : parentExpressionGraph.entrySet()) {
                if (parentExpression.getKey().startsWith(propertyName + "[")) continue;
                adjustedParentExpressionGraph.put(parentExpression.getKey(), parentExpression.getValue());
            }
            parentExpressionGraph.clear();
            parentExpressionGraph.putAll(adjustedParentExpressionGraph);
        }
        if (array instanceof ManagedArray) {
            ((ManagedArray)array).setSource((Object)newArray);
        } else {
            array = newArray;
        }
    }

    protected void visitList(String nestedPropertyName, String propertyName, BeanDefinition beanDefinition, Map<String, String> parentExpressionGraph, Map<String, String> expressionGraph, List listVal, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        BeanDefinition parentBeanDefinition;
        PropertyValue parentListPropertyValue;
        boolean isMergeEnabled = false;
        if (listVal instanceof ManagedList) {
            isMergeEnabled = ((ManagedList)listVal).isMergeEnabled();
        }
        ManagedList newList = new ManagedList();
        newList.setMergeEnabled(isMergeEnabled);
        int parentListSize = 0;
        if (isMergeEnabled && StringUtils.isNotBlank((String)beanDefinition.getParentName()) && (parentListPropertyValue = (parentBeanDefinition = beanFactory.getMergedBeanDefinition(beanDefinition.getParentName())).getPropertyValues().getPropertyValue(propertyName)) != null) {
            List parentList = (List)parentListPropertyValue.getValue();
            parentListSize = parentList.size();
        }
        for (int i = 0; i < listVal.size(); ++i) {
            Object elem = listVal.get(i);
            int elementPosition = i + parentListSize;
            String elemPropertyName = nestedPropertyName + "[" + elementPosition + "]";
            if (this.hasExpression(elem)) {
                String strValue = this.getStringValue(elem);
                expressionGraph.put(elemPropertyName, strValue);
                newList.add(i, null);
                continue;
            }
            if (elem instanceof BeanDefinition || elem instanceof BeanDefinitionHolder) {
                BeanDefinition beanDefinitionValue;
                String beanName = null;
                if (elem instanceof BeanDefinition) {
                    beanDefinitionValue = (BeanDefinition)elem;
                } else {
                    beanDefinitionValue = ((BeanDefinitionHolder)elem).getBeanDefinition();
                    beanName = ((BeanDefinitionHolder)elem).getBeanName();
                }
                this.processBeanDefinition(beanName, beanDefinitionValue, beanFactory, processedBeanNames);
            }
            newList.add(i, elem);
        }
        if (!isMergeEnabled) {
            HashMap<String, String> adjustedParentExpressionGraph = new HashMap<String, String>();
            for (Map.Entry<String, String> parentExpression : parentExpressionGraph.entrySet()) {
                if (parentExpression.getKey().startsWith(nestedPropertyName + "[")) continue;
                adjustedParentExpressionGraph.put(parentExpression.getKey(), parentExpression.getValue());
            }
            parentExpressionGraph.clear();
            parentExpressionGraph.putAll(adjustedParentExpressionGraph);
        }
        listVal.clear();
        listVal.addAll(newList);
    }

    protected void visitSet(String propertyName, Map<String, String> parentPropertyExpressions, Map<String, String> propertyExpressions, Set setVal, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        boolean isMergeEnabled = false;
        if (setVal instanceof ManagedSet) {
            isMergeEnabled = ((ManagedSet)setVal).isMergeEnabled();
        }
        ManagedSet newSet = new ManagedSet();
        newSet.setMergeEnabled(isMergeEnabled);
        for (Object elem : setVal) {
            if (this.hasExpression(elem)) {
                String strValue = this.getStringValue(elem);
                propertyExpressions.put(propertyName + ".add", strValue);
                continue;
            }
            if (elem instanceof BeanDefinition || elem instanceof BeanDefinitionHolder) {
                BeanDefinition beanDefinition;
                String beanName = null;
                if (elem instanceof BeanDefinition) {
                    beanDefinition = (BeanDefinition)elem;
                } else {
                    beanDefinition = ((BeanDefinitionHolder)elem).getBeanDefinition();
                    beanName = ((BeanDefinitionHolder)elem).getBeanName();
                }
                this.processBeanDefinition(beanName, beanDefinition, beanFactory, processedBeanNames);
            }
            newSet.add(elem);
        }
        if (!isMergeEnabled) {
            HashMap<String, String> adjustedParentExpressions = new HashMap<String, String>();
            for (Map.Entry<String, String> parentExpression : parentPropertyExpressions.entrySet()) {
                if (parentExpression.getKey().startsWith(propertyName + ".add")) continue;
                adjustedParentExpressions.put(parentExpression.getKey(), parentExpression.getValue());
            }
            parentPropertyExpressions.clear();
            parentPropertyExpressions.putAll(adjustedParentExpressions);
        }
        setVal.clear();
        setVal.addAll(newSet);
    }

    protected void visitMap(String propertyName, Map<String, String> parentExpressionGraph, Map<String, String> expressionGraph, Map<?, ?> mapVal, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        boolean isMergeEnabled = false;
        if (mapVal instanceof ManagedMap) {
            isMergeEnabled = ((ManagedMap)mapVal).isMergeEnabled();
        }
        ManagedMap newMap = new ManagedMap();
        newMap.setMergeEnabled(isMergeEnabled);
        for (Map.Entry<?, ?> entry : mapVal.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            String keyStr = this.getStringValue(key);
            String elemPropertyName = propertyName + "['" + keyStr + "']";
            if (this.hasExpression(val)) {
                String strValue = this.getStringValue(val);
                expressionGraph.put(elemPropertyName, strValue);
            } else {
                if (val instanceof BeanDefinition || val instanceof BeanDefinitionHolder) {
                    BeanDefinition beanDefinition;
                    String beanName = null;
                    if (val instanceof BeanDefinition) {
                        beanDefinition = (BeanDefinition)val;
                    } else {
                        beanDefinition = ((BeanDefinitionHolder)val).getBeanDefinition();
                        beanName = ((BeanDefinitionHolder)val).getBeanName();
                    }
                    this.processBeanDefinition(beanName, beanDefinition, beanFactory, processedBeanNames);
                }
                newMap.put(key, val);
            }
            if (!isMergeEnabled || !parentExpressionGraph.containsKey(elemPropertyName)) continue;
            parentExpressionGraph.remove(elemPropertyName);
        }
        if (!isMergeEnabled) {
            HashMap<String, String> adjustedParentExpressionGraph = new HashMap<String, String>();
            for (Map.Entry<String, String> parentExpression : parentExpressionGraph.entrySet()) {
                if (parentExpression.getKey().startsWith(propertyName + "[")) continue;
                adjustedParentExpressionGraph.put(parentExpression.getKey(), parentExpression.getValue());
            }
            parentExpressionGraph.clear();
            parentExpressionGraph.putAll(adjustedParentExpressionGraph);
        }
        mapVal.clear();
        mapVal.putAll((Map<?, ?>)newMap);
    }
}

