/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.StackedLayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewIndex;

public class ViewCleaner {
    public static void cleanView(View view) {
        view.setApplicationHeader(null);
        view.setApplicationFooter(null);
        view.setBreadcrumbs(null);
        view.setBreadcrumbOptions(null);
        view.setBreadcrumbItem(null);
        view.setParentLocation(null);
        view.setPathBasedBreadcrumbs(null);
        view.setNavigation(null);
        view.setPage(null);
        view.setNavigation(null);
        view.setAdditionalCssFiles(null);
        view.setAdditionalScriptFiles(null);
        view.setActionFlags(null);
        view.setEditModes(null);
        view.setViewMenuLink(null);
        view.setViewMenuLink(null);
        view.setPreLoadScript(null);
        view.setViewTemplates(new ArrayList<String>());
        view.setSessionPolicy(null);
        view.setViewHelperServiceClass(null);
        view.getViewIndex().clearIndexesAfterRender();
        PageGroup currentPage = view.getCurrentPage();
        ViewCleaner.cleanComponent(currentPage, view.getViewIndex());
        ViewCleaner.cleanComponent(view, view.getViewIndex());
        ArrayList<PageGroup> pages = new ArrayList<PageGroup>();
        pages.add(currentPage);
        view.setItems(pages);
    }

    public static void cleanComponent(Component component, ViewIndex viewIndex) {
        if (component == null) {
            return;
        }
        if (component.isForceSessionPersistence()) {
            return;
        }
        component.setTemplate(null);
        component.setTemplateName(null);
        component.setTitle(null);
        component.setProgressiveRender(null);
        component.setConditionalRefresh(null);
        component.setRefreshWhenChangedPropertyNames(null);
        component.setAdditionalComponentsToRefresh(null);
        component.setAlign(null);
        component.setValign(null);
        component.setWidth(null);
        component.setCellCssClasses(null);
        component.setCellStyle(null);
        component.setCellWidth(null);
        component.setStyle(null);
        component.setLibraryCssClasses(null);
        component.setCssClasses(null);
        component.setAdditionalCssClasses(null);
        component.setToolTip(null);
        component.setRenderedHtmlOutput(null);
        component.setComponentSecurity(null);
        component.setOnLoadScript(null);
        component.setOnUnloadScript(null);
        component.setOnCloseScript(null);
        component.setOnBlurScript(null);
        component.setOnChangeScript(null);
        component.setOnClickScript(null);
        component.setOnDblClickScript(null);
        component.setOnFocusScript(null);
        component.setOnSubmitScript(null);
        component.setOnKeyPressScript(null);
        component.setOnKeyUpScript(null);
        component.setOnKeyDownScript(null);
        component.setOnMouseOverScript(null);
        component.setOnMouseOutScript(null);
        component.setOnMouseUpScript(null);
        component.setOnMouseDownScript(null);
        component.setOnMouseMoveScript(null);
        component.setOnDocumentReadyScript(null);
        component.setComponentModifiers(null);
        component.setTemplateOptions(null);
        component.setTemplateOptionsJSString(null);
        component.setPropertyReplacers(null);
        if (!viewIndex.isIdForRefreshComponent(component.getId())) {
            component.setDataAttributes(null);
        }
        component.setPreRenderContent(null);
        component.setPostRenderContent(null);
        component.setExpressionGraph(null);
        component.setPropertyExpressions(null);
        if (!(viewIndex.isIdForRefreshComponent(component.getId()) || component instanceof PageGroup || component instanceof View)) {
            component.setContext(null);
        }
        if (component instanceof Container) {
            ViewCleaner.cleanContainer((Container)component, viewIndex);
        }
        if (component instanceof DataField) {
            ViewCleaner.cleanDataField((DataField)component);
        }
        if (component instanceof FieldGroup) {
            Group group = ((FieldGroup)component).getGroup();
            ViewCleaner.cleanComponent(group, viewIndex);
        }
    }

    protected static void cleanContainer(Container container, ViewIndex viewIndex) {
        container.setHeader(null);
        container.setFooter(null);
        container.setHelp(null);
        container.setInstructionalMessage(null);
        if (!(container instanceof PageGroup)) {
            container.setValidationMessages(null);
        }
        if (container.getItems() != null) {
            for (Component component : container.getItems()) {
                ViewCleaner.cleanComponent(component, viewIndex);
            }
        }
        if (container instanceof Group) {
            Group group = (Group)container;
            group.setDisclosure(null);
            group.setScrollpane(null);
        }
        if (container instanceof CollectionGroup) {
            ViewCleaner.cleanCollectionGroup((CollectionGroup)container, viewIndex);
        } else {
            container.setLayoutManager(null);
        }
    }

    protected static void cleanCollectionGroup(CollectionGroup collectionGroup, ViewIndex viewIndex) {
        collectionGroup.setAddLineLabel(null);
        if (collectionGroup.getAddLineItems() != null) {
            for (Component component : collectionGroup.getAddLineItems()) {
                ViewCleaner.cleanComponent(component, viewIndex);
            }
        }
        collectionGroup.setAddLineActions(null);
        collectionGroup.setLineActions(null);
        collectionGroup.setActiveCollectionFilter(null);
        collectionGroup.setFilters(null);
        collectionGroup.setSubCollections(null);
        collectionGroup.setCollectionGroupBuilder(null);
        collectionGroup.setNewItemsCssClass(null);
        collectionGroup.setAddItemCssClass(null);
        collectionGroup.setAddBlankLineAction(null);
        collectionGroup.setAddViaLightBoxAction(null);
        if (collectionGroup.getLayoutManager() != null && collectionGroup.getLayoutManager() instanceof TableLayoutManager && !collectionGroup.isUseServerPaging()) {
            ViewCleaner.cleanTableLayoutManager((TableLayoutManager)collectionGroup.getLayoutManager());
        } else if (collectionGroup.getLayoutManager() != null && collectionGroup.getLayoutManager() instanceof StackedLayoutManager) {
            collectionGroup.setLayoutManager(null);
        }
    }

    protected static void cleanTableLayoutManager(TableLayoutManager tableLayoutManager) {
        tableLayoutManager.setHeaderLabelPrototype(null);
        tableLayoutManager.setSequenceFieldPrototype(null);
        tableLayoutManager.setActionFieldPrototype(null);
        tableLayoutManager.setSubCollectionFieldGroupPrototype(null);
        tableLayoutManager.setSelectFieldPrototype(null);
        tableLayoutManager.setAddLineGroup(null);
        tableLayoutManager.setRowDetailsGroup(null);
        tableLayoutManager.setToggleAllDetailsAction(null);
        tableLayoutManager.setExpandDetailsActionPrototype(null);
        tableLayoutManager.setGroupingPropertyNames(null);
        tableLayoutManager.setTotalLabel(null);
        tableLayoutManager.setPageTotalLabel(null);
        tableLayoutManager.setGroupTotalLabelPrototype(null);
        tableLayoutManager.setColumnCalculations(null);
    }

    protected static void cleanDataField(DataField dataField) {
        dataField.setLabel(null);
        dataField.setFieldLabel(null);
        dataField.setDictionaryAttributeName(null);
        dataField.setDictionaryObjectEntry(null);
        dataField.setForcedValue(null);
        dataField.setReadOnlyDisplayReplacementPropertyName(null);
        dataField.setReadOnlyDisplaySuffixPropertyName(null);
        dataField.setReadOnlyDisplayReplacement(null);
        dataField.setReadOnlyDisplaySuffix(null);
        dataField.setReadOnlyListDisplayType(null);
        dataField.setReadOnlyListDelimiter(null);
        dataField.setMaskFormatter(null);
        dataField.setAdditionalHiddenPropertyNames(null);
        dataField.setPropertyNamesForAdditionalDisplay(null);
        dataField.setInquiry(null);
        dataField.setHelp(null);
        if (dataField instanceof InputField) {
            ViewCleaner.cleanInputField((InputField)dataField);
        }
    }

    protected static void cleanInputField(InputField inputField) {
        inputField.setCustomValidatorClass(null);
        inputField.setValidCharactersConstraint(null);
        inputField.setCaseConstraint(null);
        inputField.setDependencyConstraints(null);
        inputField.setMustOccurConstraints(null);
        inputField.setControl(null);
        inputField.setOptionsFinder(null);
        inputField.setValidationMessages(null);
        inputField.setConstraintText(null);
        inputField.setInstructionalText(null);
        inputField.setInstructionalMessage(null);
        inputField.setConstraintMessage(null);
        inputField.setQuickfinder(null);
    }
}

