/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.util.CloneUtils;
import org.kuali.rice.krad.uif.util.ExpressionFunctions;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class DefaultExpressionEvaluator
implements ExpressionEvaluator {
    private static final Logger LOG = Logger.getLogger(DefaultExpressionEvaluator.class);
    private StandardEvaluationContext evaluationContext;
    private Map<String, Expression> cachedExpressions = new HashMap<String, Expression>();
    protected static ExpressionParser parser = new SpelExpressionParser();
    private static Method isAssignableFrom;
    private static Method empty;
    private static Method emptyList;
    private static Method listContains;
    private static Method getName;
    private static Method getParm;
    private static Method getParmInd;
    private static Method hasPerm;
    private static Method hasPermDtls;
    private static Method hasPermTmpl;
    private static Method sequence;
    private static Method getDataObjectKey;

    @Override
    public void initializeEvaluationContext(Object contextObject) {
        this.evaluationContext = new StandardEvaluationContext(contextObject);
        this.addCustomFunctions(this.evaluationContext);
    }

    @Override
    public void evaluateExpressionsOnConfigurable(View view, UifDictionaryBean expressionConfigurable, Map<String, Object> evaluationParameters) {
        if (expressionConfigurable instanceof Component || expressionConfigurable instanceof LayoutManager) {
            this.evaluatePropertyReplacers(view, expressionConfigurable, evaluationParameters);
        }
        this.evaluatePropertyExpressions(view, expressionConfigurable, evaluationParameters);
    }

    @Override
    public Object evaluateExpression(Map<String, Object> evaluationParameters, String expressionStr) {
        Object result = null;
        if (StringUtils.startsWith((String)expressionStr, (String)"@{") && StringUtils.endsWith((String)expressionStr, (String)"}")) {
            expressionStr = StringUtils.removeStart((String)expressionStr, (String)"@{");
            expressionStr = StringUtils.removeEnd((String)expressionStr, (String)"}");
        }
        try {
            Expression expression = this.retrieveCachedExpression(expressionStr);
            if (evaluationParameters != null) {
                this.evaluationContext.setVariables(evaluationParameters);
            }
            result = expression.getValue((EvaluationContext)this.evaluationContext);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception evaluating expression: " + expressionStr));
            throw new RuntimeException("Exception evaluating expression: " + expressionStr, e);
        }
        return result;
    }

    @Override
    public String evaluateExpressionTemplate(Map<String, Object> evaluationParameters, String expressionTemplate) {
        String result = null;
        try {
            Expression expression = this.retrieveCachedExpression(expressionTemplate);
            if (evaluationParameters != null) {
                this.evaluationContext.setVariables(evaluationParameters);
            }
            result = (String)expression.getValue((EvaluationContext)this.evaluationContext, String.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception evaluating expression: " + expressionTemplate));
            throw new RuntimeException("Exception evaluating expression: " + expressionTemplate, e);
        }
        return result;
    }

    @Override
    public void evaluatePropertyExpression(View view, Map<String, Object> evaluationParameters, UifDictionaryBean expressionConfigurable, String propertyName, boolean removeExpression) {
        Map<String, String> propertyExpressions = expressionConfigurable.getPropertyExpressions();
        if (propertyExpressions == null || !propertyExpressions.containsKey(propertyName)) {
            return;
        }
        String expression = propertyExpressions.get(propertyName);
        if (CloneUtils.fieldHasAnnotation(expressionConfigurable.getClass(), propertyName, KeepExpression.class)) {
            ObjectPropertyUtils.setPropertyValue(expressionConfigurable, propertyName, expression);
            return;
        }
        Object propertyValue = null;
        String adjustedExpression = this.replaceBindingPrefixes(view, expressionConfigurable, expression);
        propertyValue = StringUtils.startsWith((String)adjustedExpression, (String)"@{") && StringUtils.endsWith((String)adjustedExpression, (String)"}") && StringUtils.countMatches((String)adjustedExpression, (String)"@{") == 1 ? this.evaluateExpression(evaluationParameters, adjustedExpression) : this.evaluateExpressionTemplate(evaluationParameters, adjustedExpression);
        if (StringUtils.endsWith((String)propertyName, (String)".add")) {
            StringUtils.removeEnd((String)propertyName, (String)".add");
            Collection collectionValue = (Collection)ObjectPropertyUtils.getPropertyValue(expressionConfigurable, propertyName);
            if (collectionValue == null) {
                throw new RuntimeException("Property name: " + propertyName + " with collection type was not initialized. Cannot add expression result");
            }
            collectionValue.add(propertyValue);
        } else {
            ObjectPropertyUtils.setPropertyValue(expressionConfigurable, propertyName, propertyValue);
        }
        if (removeExpression) {
            propertyExpressions.remove(propertyName);
        }
    }

    @Override
    public boolean containsElPlaceholder(String value) {
        String elPlaceholder;
        boolean containsElPlaceholder = false;
        if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)(elPlaceholder = StringUtils.substringBetween((String)value, (String)"@{", (String)"}")))) {
            containsElPlaceholder = true;
        }
        return containsElPlaceholder;
    }

    @Override
    public String replaceBindingPrefixes(View view, Object object, String expression) {
        String adjustedExpression = StringUtils.replace((String)expression, (String)"#form.", (String)"");
        if (StringUtils.contains((String)adjustedExpression, (String)"#fp.")) {
            if (object instanceof DataField) {
                BindingInfo bindingInfo = ((DataField)object).getBindingInfo();
                Pattern pattern = Pattern.compile("(" + Pattern.quote("#fp.") + "[\\.\\w]+" + ")");
                Matcher matcher = pattern.matcher(adjustedExpression);
                while (matcher.find()) {
                    String path = matcher.group();
                    String adjustedPath = bindingInfo.getPropertyAdjustedBindingPath(path);
                    adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)path, (String)adjustedPath);
                }
            } else {
                adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#fp.", (String)"");
            }
        }
        if ((adjustedExpression = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? StringUtils.replace((String)adjustedExpression, (String)"#dp.", (String)(view.getDefaultBindingObjectPath() + ".")) : StringUtils.replace((String)adjustedExpression, (String)"#dp.", (String)"")).contains("#lp.") && object instanceof Component) {
            String linePath = DefaultExpressionEvaluator.getLinePathPrefixValue((Component)object);
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#lp.", (String)(linePath + "."));
        }
        if (adjustedExpression.contains("#np.") && object instanceof Component) {
            String nodePath = "";
            Map<String, Object> context = ((Component)object).getContext();
            if (context != null && context.containsKey("nodePath")) {
                nodePath = (String)context.get("nodePath");
            }
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#np.", (String)(nodePath + "."));
        }
        return adjustedExpression;
    }

    protected Expression retrieveCachedExpression(String expressionTemplate) {
        Expression expression = null;
        if (this.cachedExpressions.containsKey(expressionTemplate)) {
            return this.cachedExpressions.get(expressionTemplate);
        }
        expression = StringUtils.contains((String)expressionTemplate, (String)"@{") ? parser.parseExpression(expressionTemplate, (ParserContext)new TemplateParserContext("@{", "}")) : parser.parseExpression(expressionTemplate);
        this.cachedExpressions.put(expressionTemplate, expression);
        return expression;
    }

    protected void addCustomFunctions(StandardEvaluationContext context) {
        context.registerFunction("isAssignableFrom", isAssignableFrom);
        context.registerFunction("empty", empty);
        context.registerFunction("emptyList", emptyList);
        context.registerFunction("listContains", listContains);
        context.registerFunction("getName", getName);
        context.registerFunction("getParm", getParm);
        context.registerFunction("getParmInd", getParmInd);
        context.registerFunction("hasPerm", hasPerm);
        context.registerFunction("hasPermDtls", hasPermDtls);
        context.registerFunction("hasPermTmpl", hasPermTmpl);
        context.registerFunction("sequence", sequence);
        context.registerFunction("getDataObjectKey", getDataObjectKey);
    }

    protected void evaluatePropertyReplacers(View view, UifDictionaryBean expressionConfigurable, Map<String, Object> evaluationParameters) {
        List<PropertyReplacer> replacers = null;
        if (Component.class.isAssignableFrom(expressionConfigurable.getClass())) {
            replacers = ((Component)expressionConfigurable).getPropertyReplacers();
        } else if (LayoutManager.class.isAssignableFrom(expressionConfigurable.getClass())) {
            replacers = ((LayoutManager)expressionConfigurable).getPropertyReplacers();
        }
        if (replacers != null) {
            for (PropertyReplacer propertyReplacer : replacers) {
                String expression = propertyReplacer.getCondition();
                String adjustedExpression = this.replaceBindingPrefixes(view, expressionConfigurable, expression);
                String conditionEvaluation = this.evaluateExpressionTemplate(evaluationParameters, adjustedExpression);
                boolean conditionSuccess = Boolean.parseBoolean(conditionEvaluation);
                if (!conditionSuccess) continue;
                ObjectPropertyUtils.setPropertyValue(expressionConfigurable, propertyReplacer.getPropertyName(), propertyReplacer.getReplacement());
            }
        }
    }

    protected void evaluatePropertyExpressions(View view, UifDictionaryBean expressionConfigurable, Map<String, Object> evaluationParameters) {
        Map<String, String> propertyExpressions = expressionConfigurable.getPropertyExpressions();
        for (String propertyName : propertyExpressions.keySet()) {
            this.evaluatePropertyExpression(view, evaluationParameters, expressionConfigurable, propertyName, false);
        }
    }

    protected static String getLinePathPrefixValue(Component component) {
        Object indexObj;
        CollectionGroup collectionGroup;
        String linePath = "";
        Map<String, Object> componentContext = component.getContext();
        CollectionGroup collectionGroup2 = collectionGroup = componentContext == null ? null : (CollectionGroup)componentContext.get("collectionGroup");
        if (collectionGroup == null) {
            LOG.warn((Object)("collection group not found for " + component + "," + component.getId() + ", " + component.getComponentTypeName()));
            return linePath;
        }
        Object object = indexObj = componentContext == null ? null : componentContext.get("index");
        if (indexObj != null) {
            Object addLineObj;
            int index = (Integer)indexObj;
            boolean addLine = false;
            Object object2 = addLineObj = componentContext == null ? null : componentContext.get("isAddLine");
            if (addLineObj != null) {
                addLine = (Boolean)addLineObj;
            }
            linePath = addLine ? collectionGroup.getAddLineBindingInfo().getBindingPath() : collectionGroup.getBindingInfo().getBindingPath() + "[" + index + "]";
        }
        return linePath;
    }

    static {
        try {
            isAssignableFrom = ExpressionFunctions.class.getDeclaredMethod("isAssignableFrom", Class.class, Class.class);
            empty = ExpressionFunctions.class.getDeclaredMethod("empty", Object.class);
            emptyList = ExpressionFunctions.class.getDeclaredMethod("emptyList", List.class);
            listContains = ExpressionFunctions.class.getDeclaredMethod("listContains", List.class, Object[].class);
            getName = ExpressionFunctions.class.getDeclaredMethod("getName", Class.class);
            getParm = ExpressionFunctions.class.getDeclaredMethod("getParm", String.class, String.class, String.class);
            getParmInd = ExpressionFunctions.class.getDeclaredMethod("getParmInd", String.class, String.class, String.class);
            hasPerm = ExpressionFunctions.class.getDeclaredMethod("hasPerm", String.class, String.class);
            hasPermDtls = ExpressionFunctions.class.getDeclaredMethod("hasPermDtls", String.class, String.class, Map.class, Map.class);
            hasPermTmpl = ExpressionFunctions.class.getDeclaredMethod("hasPermTmpl", String.class, String.class, Map.class, Map.class);
            sequence = ExpressionFunctions.class.getDeclaredMethod("sequence", String.class);
            getDataObjectKey = ExpressionFunctions.class.getDeclaredMethod("getDataObjectKey", String.class);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Custom function for el expressions not found: " + e.getMessage()));
            throw new RuntimeException("Custom function for el expressions not found: " + e.getMessage(), e);
        }
    }
}

