/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentViewAuthorizerBase;
import org.kuali.rice.krad.document.DocumentViewPresentationControllerBase;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="documentView-bean", parent="Uif-DocumentView")
public class DocumentView
extends FormView {
    private static final long serialVersionUID = 2251983409572774175L;
    private Class<? extends Document> documentClass;
    private boolean allowsNoteAttachments = true;
    private boolean allowsNoteFYI = false;
    private boolean displayTopicFieldInNotes = false;
    private Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass;

    @Override
    public void performInitialization(View view, Object model) {
        DocumentViewPresentationControllerBase documentViewPresentationControllerBase;
        DocumentViewAuthorizerBase documentViewAuthorizerBase;
        super.performInitialization(view, model);
        DocumentEntry documentEntry = this.getDocumentEntryForView();
        this.pushObjectToContext("DocumentEntry", documentEntry);
        if (this.getAuthorizer() == null) {
            this.setAuthorizer(new DocumentViewAuthorizerBase());
        }
        if (this.getAuthorizer() instanceof DocumentViewAuthorizerBase && (documentViewAuthorizerBase = (DocumentViewAuthorizerBase)this.getAuthorizer()).getDocumentAuthorizer() == null) {
            documentViewAuthorizerBase.setDocumentAuthorizerClass(documentEntry.getDocumentAuthorizerClass());
        }
        if (this.getPresentationController() == null) {
            this.setPresentationController(new DocumentViewPresentationControllerBase());
        }
        if (this.getPresentationController() instanceof DocumentViewPresentationControllerBase && (documentViewPresentationControllerBase = (DocumentViewPresentationControllerBase)this.getPresentationController()).getDocumentPresentationController() == null) {
            documentViewPresentationControllerBase.setDocumentPresentationControllerClass(documentEntry.getDocumentPresentationControllerClass());
        }
        this.getObjectPathToConcreteClassMapping().put(this.getDefaultBindingObjectPath(), this.getDocumentClass());
    }

    protected DocumentEntry getDocumentEntryForView() {
        DocumentEntry documentEntry = KRADServiceLocatorWeb.getDocumentDictionaryService().getDocumentEntryByClass(this.getDocumentClass());
        if (documentEntry == null) {
            throw new RuntimeException("Unable to find document entry for document class: " + this.getDocumentClass().getName());
        }
        return documentEntry;
    }

    @BeanTagAttribute(name="documentClass")
    public Class<? extends Document> getDocumentClass() {
        return this.documentClass;
    }

    public void setDocumentClass(Class<? extends Document> documentClass) {
        this.documentClass = documentClass;
    }

    @BeanTagAttribute(name="allowsNoteAttachments")
    public boolean isAllowsNoteAttachments() {
        return this.allowsNoteAttachments;
    }

    public void setAllowsNoteAttachments(boolean allowsNoteAttachments) {
        this.allowsNoteAttachments = allowsNoteAttachments;
    }

    @BeanTagAttribute(name="allowsNoteFYI")
    public boolean isAllowsNoteFYI() {
        return this.allowsNoteFYI;
    }

    public void setAllowsNoteFYI(boolean allowsNoteFYI) {
        this.allowsNoteFYI = allowsNoteFYI;
    }

    @BeanTagAttribute(name="displayTopicFieldInNotes")
    public boolean isDisplayTopicFieldInNotes() {
        return this.displayTopicFieldInNotes;
    }

    public void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes) {
        this.displayTopicFieldInNotes = displayTopicFieldInNotes;
    }

    @BeanTagAttribute(name="attachmentTypesValuesFinderClass", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Class<? extends KeyValuesFinder> getAttachmentTypesValuesFinderClass() {
        return this.attachmentTypesValuesFinderClass;
    }

    public void setAttachmentTypesValuesFinderClass(Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass) {
        this.attachmentTypesValuesFinderClass = attachmentTypesValuesFinderClass;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        DocumentView documentViewCopy = (DocumentView)component;
        if (this.documentClass != null) {
            documentViewCopy.setDocumentClass(this.getDocumentClass());
        }
        if (this.attachmentTypesValuesFinderClass != null) {
            documentViewCopy.setAttachmentTypesValuesFinderClass(this.getAttachmentTypesValuesFinderClass());
        }
        documentViewCopy.setAllowsNoteAttachments(this.isAllowsNoteAttachments());
        documentViewCopy.setAllowsNoteFYI(this.isAllowsNoteFYI());
        documentViewCopy.setDisplayTopicFieldInNotes(this.isDisplayTopicFieldInNotes());
    }
}

