/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.ContainerBase;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.element.ViewHeader;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.BooleanMap;
import org.kuali.rice.krad.uif.util.BreadcrumbItem;
import org.kuali.rice.krad.uif.util.BreadcrumbOptions;
import org.kuali.rice.krad.uif.util.ClientValidationUtils;
import org.kuali.rice.krad.uif.util.CloneUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ParentLocation;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewIndex;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.uif.view.ViewSessionPolicy;
import org.kuali.rice.krad.uif.view.ViewTheme;
import org.kuali.rice.krad.uif.widget.BlockUI;
import org.kuali.rice.krad.uif.widget.Breadcrumbs;
import org.kuali.rice.krad.uif.widget.Growls;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="view-bean", parent="Uif-View"), @BeanTag(name="view-knsTheme-bean", parent="Uif-View-KnsTheme")})
public class View
extends ContainerBase {
    private static final long serialVersionUID = -1220009725554576953L;
    private static final Logger LOG = Logger.getLogger(View.class);
    private String namespaceCode;
    private String viewName;
    private ViewTheme theme;
    private int idSequence = 0;
    private String stateObjectBindingPath;
    private StateMapping stateMapping;
    private boolean unifiedHeader;
    private Group topGroup;
    private Header applicationHeader;
    private Group applicationFooter;
    private boolean stickyTopGroup;
    private boolean stickyBreadcrumbs;
    private boolean stickyHeader;
    private boolean stickyApplicationHeader;
    private boolean stickyFooter;
    private boolean stickyApplicationFooter;
    private Breadcrumbs breadcrumbs;
    private BreadcrumbOptions breadcrumbOptions;
    private BreadcrumbItem breadcrumbItem;
    private ParentLocation parentLocation;
    private List<BreadcrumbItem> pathBasedBreadcrumbs;
    private Growls growls;
    private boolean growlMessagingEnabled;
    private BlockUI refreshBlockUI;
    private BlockUI navigationBlockUI;
    private String entryPageId;
    @RequestParameter
    private String currentPageId;
    private Group navigation;
    private Class<?> formClass = UifFormBase.class;
    private String defaultBindingObjectPath;
    private Map<String, Class<?>> objectPathToConcreteClassMapping;
    private List<String> additionalScriptFiles;
    private List<String> additionalCssFiles;
    private boolean useLibraryCssClasses;
    private UifConstants.ViewType viewTypeName = UifConstants.ViewType.DEFAULT;
    private String viewStatus = "C";
    protected ViewIndex viewIndex;
    private Map<String, String> viewRequestParameters;
    private boolean persistFormToSession = true;
    private ViewSessionPolicy sessionPolicy = new ViewSessionPolicy();
    private ViewPresentationController presentationController;
    private ViewAuthorizer authorizer;
    private BooleanMap actionFlags;
    private BooleanMap editModes;
    private Map<String, String> expressionVariables;
    private boolean singlePageView = false;
    private boolean mergeWithPageItems = true;
    private PageGroup page;
    private List<? extends Group> items;
    private List<Group> dialogs;
    private Link viewMenuLink;
    private String viewMenuGroupName;
    private boolean applyDirtyCheck;
    private boolean translateCodesOnReadOnlyDisplay = false;
    private boolean supportsRequestOverrideOfReadOnlyFields = true;
    private boolean disableNativeAutocomplete;
    private boolean disableBrowserCache = true;
    private String preLoadScript;
    private List<String> viewTemplates;
    private Class<? extends ViewHelperService> viewHelperServiceClass;
    @ReferenceCopy
    private ViewHelperService viewHelperService;

    public View() {
        this.viewIndex = new ViewIndex();
        this.additionalScriptFiles = new ArrayList<String>();
        this.additionalCssFiles = new ArrayList<String>();
        this.items = new ArrayList<Group>();
        this.objectPathToConcreteClassMapping = new HashMap();
        this.viewRequestParameters = new HashMap<String, String>();
        this.expressionVariables = new HashMap<String, String>();
        this.dialogs = new ArrayList<Group>();
        this.viewTemplates = new ArrayList<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void performInitialization(View view, Object model) {
        Component itemComponent;
        super.performInitialization(view, model);
        if (this.singlePageView) {
            if (this.page == null) throw new RuntimeException("For single paged views the page Group must be set.");
            if (!this.mergeWithPageItems) {
                this.page.setItems(new ArrayList());
            }
            view.assignComponentIds(this.page);
            List<? extends Component> newItems = this.page.getItems();
            newItems.addAll(this.items);
            this.page.setItems(newItems);
            this.items = new ArrayList<Group>();
            this.items.add(this.page);
        } else if (this.items != null && this.items.size() == 1 && (itemComponent = (Component)this.items.get(0)) instanceof PageGroup) {
            this.singlePageView = true;
        }
        if (this.sessionPolicy.isEnableTimeoutWarning()) {
            DialogGroup warningDialog = ComponentFactory.getSessionTimeoutWarningDialog();
            warningDialog.setId("Uif-SessionTimeoutWarning-DialogGroup");
            view.assignComponentIds(warningDialog);
            this.getDialogs().add(warningDialog);
            DialogGroup timeoutDialog = ComponentFactory.getSessionTimeoutDialog();
            timeoutDialog.setId("Uif-SessionTimeout-DialogGroup");
            view.assignComponentIds(timeoutDialog);
            this.getDialogs().add(timeoutDialog);
        }
        this.breadcrumbOptions.setupBreadcrumbs(view, model);
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.theme != null) {
            view.getViewHelperService().getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, this.theme, this.getContext());
            this.theme.configureThemeDefaults();
        }
        this.parentLocation.constructParentLocationBreadcrumbItems(view, model, view.getContext());
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        BlockUI refBlockUI;
        BlockUI navBlockUI;
        Growls gw;
        super.performFinalize(view, model, parent);
        String preLoadScript = "";
        if (this.getPreLoadScript() != null) {
            preLoadScript = this.getPreLoadScript();
        }
        if (!(gw = view.getGrowls()).getTemplateOptions().isEmpty()) {
            preLoadScript = preLoadScript + "setGrowlDefaults(" + gw.getTemplateOptionsJSString() + ");";
        }
        if (!(navBlockUI = view.getNavigationBlockUI()).getTemplateOptions().isEmpty()) {
            preLoadScript = preLoadScript + "setBlockUIDefaults(" + navBlockUI.getTemplateOptionsJSString() + ", '" + "navigation" + "');";
        }
        if (!(refBlockUI = view.getRefreshBlockUI()).getTemplateOptions().isEmpty()) {
            preLoadScript = preLoadScript + "setBlockUIDefaults(" + refBlockUI.getTemplateOptionsJSString() + ", '" + "refresh" + "');";
        }
        this.setPreLoadScript(preLoadScript);
        String onReadyScript = "";
        if (this.getOnDocumentReadyScript() != null) {
            onReadyScript = this.getOnDocumentReadyScript();
        }
        if (this.sessionPolicy.isEnableTimeoutWarning()) {
            int sessionTimeoutInterval = ((UifFormBase)model).getSessionTimeoutInterval();
            int sessionWarningMilliseconds = this.sessionPolicy.getTimeoutWarningSeconds() * 1000;
            if (sessionWarningMilliseconds >= sessionTimeoutInterval) {
                throw new RuntimeException("Time until giving the session warning should be less than the session timeout. Session Warning is " + sessionWarningMilliseconds + "ms, session timeout is " + sessionTimeoutInterval + "ms.");
            }
            int sessionWarningInterval = sessionTimeoutInterval - sessionWarningMilliseconds;
            onReadyScript = ScriptUtils.appendScript(onReadyScript, ScriptUtils.buildFunctionCall("initializeSessionTimers", sessionWarningInterval, sessionTimeoutInterval));
        }
        onReadyScript = ScriptUtils.appendScript(onReadyScript, "jQuery.extend(jQuery.validator.messages, " + ClientValidationUtils.generateValidatorMessagesOption() + ");");
        this.setOnDocumentReadyScript(onReadyScript);
        this.breadcrumbOptions.finalizeBreadcrumbs(view, model, this, this.breadcrumbItem);
        Object groupValidationDataDefaults = KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryObject("Uif-GroupValidationMessages-DataDefaults");
        Object fieldValidationDataDefaults = KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryObject("Uif-FieldValidationMessages-DataDefaults");
        this.addDataAttribute("group_validation_defaults", ScriptUtils.convertToJsValue((Map)groupValidationDataDefaults));
        this.addDataAttribute("field_validation_defaults", ScriptUtils.convertToJsValue((Map)fieldValidationDataDefaults));
        this.addDataAttribute("role", "view");
    }

    public void assignComponentIds(Component component) {
        if (component == null) {
            return;
        }
        int origIdSequence = -1;
        if (component.getBaseId() != null && this.viewIndex != null && this.viewIndex.getIdSequenceSnapshot() != null && this.viewIndex.getIdSequenceSnapshot().containsKey(component.getBaseId())) {
            origIdSequence = this.idSequence;
            this.idSequence = this.viewIndex.getIdSequenceSnapshot().get(component.getBaseId());
        }
        this.assignComponentId(component);
        ArrayList<Component> allNested = new ArrayList<Component>(component.getComponentsForLifecycle());
        allNested.addAll(component.getComponentPrototypes());
        for (Component nestedComponent : allNested) {
            this.assignComponentIds(nestedComponent);
        }
        if (origIdSequence != -1) {
            this.idSequence = origIdSequence;
        }
    }

    protected void assignPageIds(View view) {
        if (view.isSinglePageView() && view.getPage() != null) {
            this.assignComponentId(view.getPage());
            return;
        }
        if (view.getItems() != null) {
            for (Component component : view.getItems()) {
                if (!(component instanceof PageGroup)) continue;
                this.assignComponentId(component);
            }
            for (Component component : view.getItems()) {
                if (!(component instanceof PageGroup)) continue;
                this.assignComponentIds(component);
            }
        }
    }

    protected void assignComponentId(Component component) {
        LayoutManager layoutManager;
        Integer currentSequenceVal = this.idSequence;
        if (StringUtils.isBlank((String)component.getId())) {
            component.setId("u" + this.getNextId());
        }
        this.getViewIndex().addSequenceValueToSnapshot(component.getId(), currentSequenceVal);
        if (component instanceof Container && (layoutManager = ((Container)component).getLayoutManager()) != null && StringUtils.isBlank((String)layoutManager.getId())) {
            layoutManager.setId("u" + this.getNextId());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.applicationHeader);
        components.add(this.applicationFooter);
        components.add(this.topGroup);
        components.add(this.navigation);
        components.add(this.breadcrumbs);
        components.add(this.growls);
        components.addAll(this.dialogs);
        components.add(this.viewMenuLink);
        components.add(this.navigationBlockUI);
        components.add(this.refreshBlockUI);
        components.add(this.breadcrumbItem);
        if (this.parentLocation != null) {
            components.add(this.parentLocation.getPageBreadcrumbItem());
            components.add(this.parentLocation.getViewBreadcrumbItem());
            components.addAll(this.parentLocation.getResolvedBreadcrumbItems());
        }
        components.addAll(super.getComponentsForLifecycle());
        if (!this.singlePageView && this.getItems() != null) {
            for (Group group : this.getItems()) {
                if (!(group instanceof PageGroup) || StringUtils.equals((String)group.getId(), (String)this.getCurrentPageId()) || !components.contains(group)) continue;
                components.remove(group);
            }
        }
        return components;
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> supportedComponents = new HashSet<Class<? extends Component>>();
        supportedComponents.add(Group.class);
        return supportedComponents;
    }

    @Override
    public String getComponentTypeName() {
        return "view";
    }

    public PageGroup getCurrentPage() {
        for (Group group : this.getItems()) {
            if (!StringUtils.equals((String)group.getId(), (String)this.getCurrentPageId()) || !(group instanceof PageGroup)) continue;
            return (PageGroup)group;
        }
        return null;
    }

    @Override
    protected void sortItems(View view, Object model) {
        if (!this.singlePageView) {
            super.sortItems(view, model);
        }
    }

    @Override
    @BeanTagAttribute(name="namespaceCode")
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    @BeanTagAttribute(name="viewName")
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @BeanTagAttribute(name="unifiedHeader")
    public boolean isUnifiedHeader() {
        return this.unifiedHeader;
    }

    public void setUnifiedHeader(boolean unifiedHeader) {
        this.unifiedHeader = unifiedHeader;
    }

    @BeanTagAttribute(name="topGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getTopGroup() {
        return this.topGroup;
    }

    public void setTopGroup(Group topGroup) {
        this.topGroup = topGroup;
    }

    @BeanTagAttribute(name="applicationHeader", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Header getApplicationHeader() {
        return this.applicationHeader;
    }

    public void setApplicationHeader(Header applicationHeader) {
        this.applicationHeader = applicationHeader;
    }

    @BeanTagAttribute(name="applicationFooter", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getApplicationFooter() {
        return this.applicationFooter;
    }

    public void setApplicationFooter(Group applicationFooter) {
        this.applicationFooter = applicationFooter;
    }

    @BeanTagAttribute(name="stickyTopGroup")
    public boolean isStickyTopGroup() {
        return this.stickyTopGroup;
    }

    public void setStickyTopGroup(boolean stickyTopGroup) {
        this.stickyTopGroup = stickyTopGroup;
    }

    @BeanTagAttribute(name="stickyBreadcrumbs")
    public boolean isStickyBreadcrumbs() {
        return this.stickyBreadcrumbs;
    }

    public void setStickyBreadcrumbs(boolean stickyBreadcrumbs) {
        this.stickyBreadcrumbs = stickyBreadcrumbs;
    }

    @BeanTagAttribute(name="stickyHeader")
    public boolean isStickyHeader() {
        if (this.getHeader() != null && this.getHeader() instanceof ViewHeader) {
            return ((ViewHeader)this.getHeader()).isSticky();
        }
        return false;
    }

    public void setStickyHeader(boolean stickyHeader) {
        this.stickyHeader = stickyHeader;
        if (this.getHeader() != null && this.getHeader() instanceof ViewHeader) {
            ((ViewHeader)this.getHeader()).setSticky(stickyHeader);
        }
    }

    @BeanTagAttribute(name="stickyApplicationHeader")
    public boolean isStickyApplicationHeader() {
        return this.stickyApplicationHeader;
    }

    public void setStickyApplicationHeader(boolean stickyApplicationHeader) {
        this.stickyApplicationHeader = stickyApplicationHeader;
    }

    @BeanTagAttribute(name="stickyFooter")
    public boolean isStickyFooter() {
        return this.stickyFooter;
    }

    public void setStickyFooter(boolean stickyFooter) {
        this.stickyFooter = stickyFooter;
        if (this.getFooter() != null) {
            this.getFooter().addDataAttribute("sticky_footer", Boolean.toString(stickyFooter));
        }
    }

    @BeanTagAttribute(name="stickyApplicationFooter")
    public boolean isStickyApplicationFooter() {
        return this.stickyApplicationFooter;
    }

    public void setStickyApplicationFooter(boolean stickyApplicationFooter) {
        this.stickyApplicationFooter = stickyApplicationFooter;
    }

    public int getIdSequence() {
        return this.idSequence;
    }

    public void setIdSequence(int idSequence) {
        this.idSequence = idSequence;
    }

    public String getNextId() {
        ++this.idSequence;
        return Integer.toString(this.idSequence);
    }

    @BeanTagAttribute(name="entryPageId")
    public String getEntryPageId() {
        return this.entryPageId;
    }

    public void setEntryPageId(String entryPageId) {
        this.entryPageId = entryPageId;
    }

    public String getCurrentPageId() {
        if (StringUtils.isBlank((String)this.currentPageId)) {
            if (StringUtils.isNotBlank((String)this.entryPageId)) {
                this.currentPageId = this.entryPageId;
            } else if (this.getItems() != null && !this.getItems().isEmpty()) {
                Group firstPageGroup = this.getItems().get(0);
                this.currentPageId = firstPageGroup.getId();
            }
        }
        return this.currentPageId;
    }

    public void setCurrentPageId(String currentPageId) {
        this.currentPageId = currentPageId;
    }

    @BeanTagAttribute(name="navigation", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getNavigation() {
        return this.navigation;
    }

    public void setNavigation(Group navigation) {
        this.navigation = navigation;
    }

    @BeanTagAttribute(name="formClass")
    public Class<?> getFormClass() {
        return this.formClass;
    }

    public void setFormClass(Class<?> formClass) {
        this.formClass = formClass;
    }

    @BeanTagAttribute(name="defaultObjectPath")
    public String getDefaultBindingObjectPath() {
        return this.defaultBindingObjectPath;
    }

    public void setDefaultBindingObjectPath(String defaultBindingObjectPath) {
        this.defaultBindingObjectPath = defaultBindingObjectPath;
    }

    @BeanTagAttribute(name="objectPathConcreteClassMapping", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, Class<?>> getObjectPathToConcreteClassMapping() {
        return this.objectPathToConcreteClassMapping;
    }

    public void setObjectPathToConcreteClassMapping(Map<String, Class<?>> objectPathToConcreteClassMapping) {
        this.objectPathToConcreteClassMapping = objectPathToConcreteClassMapping;
    }

    @BeanTagAttribute(name="additionalScriptFiles", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalScriptFiles() {
        return this.additionalScriptFiles;
    }

    public void setAdditionalScriptFiles(List<String> additionalScriptFiles) {
        this.additionalScriptFiles = additionalScriptFiles;
    }

    @BeanTagAttribute(name="additionalCssFiles", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalCssFiles() {
        return this.additionalCssFiles;
    }

    public void setAdditionalCssFiles(List<String> additionalCssFiles) {
        this.additionalCssFiles = additionalCssFiles;
    }

    public boolean isUseLibraryCssClasses() {
        return this.useLibraryCssClasses;
    }

    public void setUseLibraryCssClasses(boolean useLibraryCssClasses) {
        this.useLibraryCssClasses = useLibraryCssClasses;
    }

    public List<String> getViewTemplates() {
        return this.viewTemplates;
    }

    public void setViewTemplates(List<String> viewTemplates) {
        this.viewTemplates = viewTemplates;
    }

    @BeanTagAttribute(name="viewTypeName", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public UifConstants.ViewType getViewTypeName() {
        return this.viewTypeName;
    }

    public void setViewTypeName(UifConstants.ViewType viewTypeName) {
        this.viewTypeName = viewTypeName;
    }

    @BeanTagAttribute(name="viewHelperServiceClass")
    public Class<? extends ViewHelperService> getViewHelperServiceClass() {
        return this.viewHelperServiceClass;
    }

    public void setViewHelperServiceClass(Class<? extends ViewHelperService> viewHelperServiceClass) {
        this.viewHelperServiceClass = viewHelperServiceClass;
        if (this.viewHelperService == null && this.viewHelperServiceClass != null) {
            this.viewHelperService = ObjectUtils.newInstance(viewHelperServiceClass);
        }
    }

    @BeanTagAttribute(name="viewHelperService", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ViewHelperService getViewHelperService() {
        return this.viewHelperService;
    }

    public void setViewHelperService(ViewHelperService viewHelperService) {
        this.viewHelperService = viewHelperService;
    }

    public void index() {
        if (this.viewIndex == null) {
            this.viewIndex = new ViewIndex();
        }
        this.viewIndex.index(this);
    }

    @BeanTagAttribute(name="viewIndex", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ViewIndex getViewIndex() {
        return this.viewIndex;
    }

    public Map<String, String> getViewRequestParameters() {
        return this.viewRequestParameters;
    }

    public void setViewRequestParameters(Map<String, String> viewRequestParameters) {
        this.viewRequestParameters = viewRequestParameters;
    }

    @BeanTagAttribute(name="persistFormToSession")
    public boolean isPersistFormToSession() {
        return this.persistFormToSession;
    }

    public void setPersistFormToSession(boolean persistFormToSession) {
        this.persistFormToSession = persistFormToSession;
    }

    public ViewSessionPolicy getSessionPolicy() {
        return this.sessionPolicy;
    }

    public void setSessionPolicy(ViewSessionPolicy sessionPolicy) {
        this.sessionPolicy = sessionPolicy;
    }

    @BeanTagAttribute(name="presentationController", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ViewPresentationController getPresentationController() {
        return this.presentationController;
    }

    public void setPresentationController(ViewPresentationController presentationController) {
        this.presentationController = presentationController;
    }

    public void setPresentationControllerClass(Class<? extends ViewPresentationController> presentationControllerClass) {
        this.presentationController = ObjectUtils.newInstance(presentationControllerClass);
    }

    @BeanTagAttribute(name="authorizer", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ViewAuthorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(ViewAuthorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setAuthorizerClass(Class<? extends ViewAuthorizer> authorizerClass) {
        this.authorizer = ObjectUtils.newInstance(authorizerClass);
    }

    @BeanTagAttribute(name="actionFlags", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BooleanMap getActionFlags() {
        return this.actionFlags;
    }

    public void setActionFlags(BooleanMap actionFlags) {
        this.actionFlags = actionFlags;
    }

    @BeanTagAttribute(name="editModes", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BooleanMap getEditModes() {
        return this.editModes;
    }

    public void setEditModes(BooleanMap editModes) {
        this.editModes = editModes;
    }

    @BeanTagAttribute(name="expressionVariables", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getExpressionVariables() {
        return this.expressionVariables;
    }

    public void setExpressionVariables(Map<String, String> expressionVariables) {
        this.expressionVariables = expressionVariables;
    }

    @BeanTagAttribute(name="singlePageView")
    public boolean isSinglePageView() {
        return this.singlePageView;
    }

    public void setSinglePageView(boolean singlePageView) {
        this.singlePageView = singlePageView;
    }

    public boolean isMergeWithPageItems() {
        return this.mergeWithPageItems;
    }

    public void setMergeWithPageItems(boolean mergeWithPageItems) {
        this.mergeWithPageItems = mergeWithPageItems;
    }

    @BeanTagAttribute(name="page", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public PageGroup getPage() {
        return this.page;
    }

    public void setPage(PageGroup page) {
        this.page = page;
    }

    @BeanTagAttribute(name="items", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<? extends Group> getItems() {
        return this.items;
    }

    @Override
    public void setItems(List<? extends Component> items) {
        this.items = items;
    }

    @BeanTagAttribute(name="dialogs", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Group> getDialogs() {
        return this.dialogs;
    }

    public void setDialogs(List<Group> dialogs) {
        this.dialogs = dialogs;
    }

    @BeanTagAttribute(name="viewMenuLink", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Link getViewMenuLink() {
        return this.viewMenuLink;
    }

    public void setViewMenuLink(Link viewMenuLink) {
        this.viewMenuLink = viewMenuLink;
    }

    @BeanTagAttribute(name="viewMenuGroupName")
    public String getViewMenuGroupName() {
        return this.viewMenuGroupName;
    }

    public void setViewMenuGroupName(String viewMenuGroupName) {
        this.viewMenuGroupName = viewMenuGroupName;
    }

    public String getViewStatus() {
        return this.viewStatus;
    }

    public void setViewStatus(String viewStatus) {
        this.viewStatus = viewStatus;
    }

    public boolean isInitialized() {
        return StringUtils.equals((String)this.viewStatus, (String)"I") || StringUtils.equals((String)this.viewStatus, (String)"F");
    }

    public boolean isFinal() {
        return StringUtils.equals((String)this.viewStatus, (String)"F");
    }

    @BeanTagAttribute(name="breadcrumbs", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Breadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public void setBreadcrumbs(Breadcrumbs breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    @BeanTagAttribute(name="breadcrumbOptions", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BreadcrumbOptions getBreadcrumbOptions() {
        return this.breadcrumbOptions;
    }

    public void setBreadcrumbOptions(BreadcrumbOptions breadcrumbOptions) {
        this.breadcrumbOptions = breadcrumbOptions;
    }

    @BeanTagAttribute(name="breadcrumbItem", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BreadcrumbItem getBreadcrumbItem() {
        return this.breadcrumbItem;
    }

    public void setBreadcrumbItem(BreadcrumbItem breadcrumbItem) {
        this.breadcrumbItem = breadcrumbItem;
    }

    @BeanTagAttribute(name="parentLocation", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ParentLocation getParentLocation() {
        return this.parentLocation;
    }

    public void setParentLocation(ParentLocation parentLocation) {
        this.parentLocation = parentLocation;
    }

    public List<BreadcrumbItem> getPathBasedBreadcrumbs() {
        return this.pathBasedBreadcrumbs;
    }

    public void setPathBasedBreadcrumbs(List<BreadcrumbItem> pathBasedBreadcrumbs) {
        this.pathBasedBreadcrumbs = pathBasedBreadcrumbs;
    }

    @BeanTagAttribute(name="growls", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Growls getGrowls() {
        return this.growls;
    }

    public void setGrowls(Growls growls) {
        this.growls = growls;
    }

    public void setRefreshBlockUI(BlockUI refreshBlockUI) {
        this.refreshBlockUI = refreshBlockUI;
    }

    @BeanTagAttribute(name="refreshBlockUI", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BlockUI getRefreshBlockUI() {
        return this.refreshBlockUI;
    }

    public void setNavigationBlockUI(BlockUI navigationBlockUI) {
        this.navigationBlockUI = navigationBlockUI;
    }

    @BeanTagAttribute(name="navigationBlockUI", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BlockUI getNavigationBlockUI() {
        return this.navigationBlockUI;
    }

    @BeanTagAttribute(name="growlMessagingEnabled")
    public boolean isGrowlMessagingEnabled() {
        return this.growlMessagingEnabled;
    }

    public void setGrowlMessagingEnabled(boolean growlMessagingEnabled) {
        this.growlMessagingEnabled = growlMessagingEnabled;
    }

    @BeanTagAttribute(name="applyDirtyCheck")
    public boolean isApplyDirtyCheck() {
        return this.applyDirtyCheck;
    }

    public void setApplyDirtyCheck(boolean applyDirtyCheck) {
        this.applyDirtyCheck = applyDirtyCheck;
    }

    public void setTranslateCodesOnReadOnlyDisplay(boolean translateCodesOnReadOnlyDisplay) {
        this.translateCodesOnReadOnlyDisplay = translateCodesOnReadOnlyDisplay;
    }

    @BeanTagAttribute(name="translateCodesOnReadOnlyDisplay")
    public boolean isTranslateCodesOnReadOnlyDisplay() {
        return this.translateCodesOnReadOnlyDisplay;
    }

    @BeanTagAttribute(name="supportsRequestOverrideOfReadOnlyFields")
    public boolean isSupportsRequestOverrideOfReadOnlyFields() {
        return this.supportsRequestOverrideOfReadOnlyFields;
    }

    public void setSupportsRequestOverrideOfReadOnlyFields(boolean supportsRequestOverrideOfReadOnlyFields) {
        this.supportsRequestOverrideOfReadOnlyFields = supportsRequestOverrideOfReadOnlyFields;
    }

    public boolean isDisableNativeAutocomplete() {
        return this.disableNativeAutocomplete;
    }

    public void setDisableNativeAutocomplete(boolean disableNativeAutocomplete) {
        this.disableNativeAutocomplete = disableNativeAutocomplete;
    }

    public boolean isDisableBrowserCache() {
        return this.disableBrowserCache;
    }

    public void setDisableBrowserCache(boolean disableBrowserCache) {
        this.disableBrowserCache = disableBrowserCache;
    }

    @BeanTagAttribute(name="preLoadScript")
    public String getPreLoadScript() {
        return this.preLoadScript;
    }

    public void setPreLoadScript(String preLoadScript) {
        this.preLoadScript = preLoadScript;
    }

    @BeanTagAttribute(name="theme", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ViewTheme getTheme() {
        return this.theme;
    }

    public void setTheme(ViewTheme theme) {
        this.theme = theme;
    }

    @BeanTagAttribute(name="stateObjectBindingPath")
    public String getStateObjectBindingPath() {
        return this.stateObjectBindingPath;
    }

    public void setStateObjectBindingPath(String stateObjectBindingPath) {
        this.stateObjectBindingPath = stateObjectBindingPath;
    }

    @BeanTagAttribute(name="stateMapping", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public StateMapping getStateMapping() {
        return this.stateMapping;
    }

    public void setStateMapping(StateMapping stateMapping) {
        this.stateMapping = stateMapping;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        View viewCopy = (View)component;
        viewCopy.setNamespaceCode(this.namespaceCode);
        viewCopy.setViewName(this.viewName);
        if (this.theme != null) {
            viewCopy.setTheme((ViewTheme)this.theme.copy());
        }
        viewCopy.setIdSequence(this.idSequence);
        viewCopy.setStateObjectBindingPath(this.stateObjectBindingPath);
        if (this.stateMapping != null) {
            viewCopy.setStateMapping(CloneUtils.deepClone(this.stateMapping));
        }
        viewCopy.setUnifiedHeader(this.unifiedHeader);
        if (this.topGroup != null) {
            viewCopy.setTopGroup((Group)this.topGroup.copy());
        }
        if (this.applicationHeader != null) {
            viewCopy.setApplicationHeader((Header)this.applicationHeader.copy());
        }
        if (this.applicationFooter != null) {
            viewCopy.setApplicationFooter((Group)this.applicationFooter.copy());
        }
        viewCopy.setStickyApplicationFooter(this.stickyApplicationFooter);
        viewCopy.setStickyApplicationHeader(this.stickyApplicationHeader);
        viewCopy.setStickyBreadcrumbs(this.stickyBreadcrumbs);
        viewCopy.setStickyFooter(this.stickyFooter);
        viewCopy.setStickyHeader(this.stickyHeader);
        viewCopy.setStickyTopGroup(this.stickyTopGroup);
        if (this.breadcrumbItem != null) {
            viewCopy.setBreadcrumbItem((BreadcrumbItem)this.breadcrumbItem.copy());
        }
        if (this.breadcrumbs != null) {
            viewCopy.setBreadcrumbs((Breadcrumbs)this.breadcrumbs.copy());
        }
        if (this.breadcrumbOptions != null) {
            viewCopy.setBreadcrumbOptions((BreadcrumbOptions)this.breadcrumbOptions.copy());
        }
        if (this.parentLocation != null) {
            viewCopy.setParentLocation((ParentLocation)this.parentLocation.copy());
        }
        if (this.pathBasedBreadcrumbs != null) {
            ArrayList pathBasedBreadcrumbsCopy = Lists.newArrayListWithExpectedSize((int)this.pathBasedBreadcrumbs.size());
            for (BreadcrumbItem pathBasedBreadcrumb : this.pathBasedBreadcrumbs) {
                this.pathBasedBreadcrumbs.add((BreadcrumbItem)pathBasedBreadcrumb.copy());
            }
            viewCopy.setPathBasedBreadcrumbs(pathBasedBreadcrumbsCopy);
        }
        viewCopy.setGrowlMessagingEnabled(this.growlMessagingEnabled);
        if (this.growls != null) {
            viewCopy.setGrowls((Growls)this.growls.copy());
        }
        if (this.refreshBlockUI != null) {
            viewCopy.setRefreshBlockUI((BlockUI)this.refreshBlockUI.copy());
        }
        if (this.navigationBlockUI != null) {
            viewCopy.setNavigationBlockUI((BlockUI)this.navigationBlockUI.copy());
        }
        viewCopy.setEntryPageId(this.entryPageId);
        viewCopy.setCurrentPageId(this.currentPageId);
        if (this.navigation != null) {
            viewCopy.setNavigation((Group)this.navigation.copy());
        }
        viewCopy.setFormClass(this.formClass);
        viewCopy.setDefaultBindingObjectPath(this.defaultBindingObjectPath);
        if (this.objectPathToConcreteClassMapping != null) {
            viewCopy.setObjectPathToConcreteClassMapping(new HashMap(this.objectPathToConcreteClassMapping));
        }
        if (this.additionalCssFiles != null) {
            viewCopy.setAdditionalCssFiles(new ArrayList<String>(this.additionalCssFiles));
        }
        if (this.additionalScriptFiles != null) {
            viewCopy.setAdditionalScriptFiles(new ArrayList<String>(this.additionalScriptFiles));
        }
        viewCopy.setUseLibraryCssClasses(this.useLibraryCssClasses);
        viewCopy.setViewTypeName(this.viewTypeName);
        viewCopy.setViewStatus(this.viewStatus);
        if (this.viewIndex != null) {
            viewCopy.viewIndex = this.viewIndex.copy();
        }
        if (this.viewRequestParameters != null) {
            viewCopy.setViewRequestParameters(new HashMap<String, String>(this.viewRequestParameters));
        }
        viewCopy.setPersistFormToSession(this.persistFormToSession);
        if (this.sessionPolicy != null) {
            viewCopy.setSessionPolicy(CloneUtils.deepClone(this.sessionPolicy));
        }
        if (this.presentationController != null) {
            viewCopy.setPresentationController(this.presentationController);
        }
        if (this.authorizer != null) {
            viewCopy.setAuthorizer(this.authorizer);
        }
        if (this.actionFlags != null) {
            viewCopy.setActionFlags(new BooleanMap(this.actionFlags));
        }
        if (this.editModes != null) {
            viewCopy.setEditModes(new BooleanMap(this.editModes));
        }
        if (this.expressionVariables != null) {
            viewCopy.setExpressionVariables(new HashMap<String, String>(this.expressionVariables));
        }
        viewCopy.setSinglePageView(this.singlePageView);
        viewCopy.setMergeWithPageItems(this.mergeWithPageItems);
        if (this.page != null) {
            viewCopy.setPage((PageGroup)this.page.copy());
        }
        if (this.dialogs != null) {
            ArrayList dialogsCopy = Lists.newArrayListWithExpectedSize((int)this.dialogs.size());
            for (Group dialog : this.dialogs) {
                dialogsCopy.add((Group)dialog.copy());
            }
            viewCopy.setDialogs(dialogsCopy);
        }
        if (this.viewMenuLink != null) {
            viewCopy.setViewMenuLink((Link)this.viewMenuLink.copy());
        }
        viewCopy.setViewMenuGroupName(this.viewMenuGroupName);
        viewCopy.setApplyDirtyCheck(this.applyDirtyCheck);
        viewCopy.setTranslateCodesOnReadOnlyDisplay(this.translateCodesOnReadOnlyDisplay);
        viewCopy.setSupportsRequestOverrideOfReadOnlyFields(this.supportsRequestOverrideOfReadOnlyFields);
        viewCopy.setDisableBrowserCache(this.disableBrowserCache);
        viewCopy.setDisableNativeAutocomplete(this.disableNativeAutocomplete);
        viewCopy.setPreLoadScript(this.preLoadScript);
        if (this.viewTemplates != null) {
            viewCopy.setViewTemplates(new ArrayList<String>(this.viewTemplates));
        }
        if (this.viewHelperServiceClass != null) {
            viewCopy.setViewHelperServiceClass(this.viewHelperServiceClass);
        } else if (this.viewHelperService != null) {
            viewCopy.setViewHelperService(CloneUtils.deepClone(this.viewHelperService));
        }
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        String[] currentValues2;
        tracer.addBean(this);
        boolean validPageId = false;
        if (this.getEntryPageId() != null) {
            for (int i = 0; i < this.getItems().size(); ++i) {
                if (this.getEntryPageId().compareTo(this.getItems().get(i).getId()) != 0) continue;
                validPageId = true;
            }
        } else {
            validPageId = true;
        }
        if (!validPageId) {
            String[] currentValues3 = new String[]{"entryPageId = " + this.getEntryPageId()};
            tracer.createError("Items must contain an item with a matching id to entryPageId", currentValues3);
        }
        if (tracer.getValidationStage() == 0 && this.getViewStatus().compareTo("C") != 0) {
            String[] currentValues4 = new String[]{"viewStatus = " + this.getViewStatus()};
            tracer.createError("ViewStatus should not be set", currentValues4);
        }
        boolean validDefaultBindingObjectPath = false;
        if (this.getDefaultBindingObjectPath() == null) {
            validDefaultBindingObjectPath = true;
        } else if (DataDictionary.isPropertyOf(this.getFormClass(), this.getDefaultBindingObjectPath())) {
            validDefaultBindingObjectPath = true;
        }
        if (!validDefaultBindingObjectPath) {
            currentValues2 = new String[]{"formClass = " + this.getFormClass(), "defaultBindingPath = " + this.getDefaultBindingObjectPath()};
            tracer.createError("DefaultBingdingObjectPath must be a valid property of the formClass", currentValues2);
        }
        if (this.isSinglePageView()) {
            if (this.getPage() == null) {
                currentValues2 = new String[]{"singlePageView = " + this.isSinglePageView(), "page = " + this.getPage()};
                tracer.createError("Page must be set if singlePageView is true", currentValues2);
            }
            for (int i = 0; i < this.getItems().size(); ++i) {
                if (this.getItems().get(i).getClass() != PageGroup.class) continue;
                currentValues = new String[]{"singlePageView = " + this.isSinglePageView(), "items(" + i + ") = " + this.getItems().get(i).getClass()};
                tracer.createError("Items cannot be pageGroups if singlePageView is true", currentValues);
            }
        }
        if (this.isGrowlMessagingEnabled() && this.getGrowls() == null && Validator.checkExpressions(this, "growls")) {
            currentValues2 = new String[]{"growlMessagingEnabled = " + this.isGrowlMessagingEnabled(), "growls = " + this.getGrowls()};
            tracer.createError("Growls cannot be null if Growl Messaging is enabled", currentValues2);
        }
        if (!this.isSinglePageView()) {
            if (this.getItems().size() == 0) {
                currentValues2 = new String[]{"singlePageView = " + this.isSinglePageView(), "items.size = " + this.getItems().size()};
                tracer.createWarning("Items cannot be empty if singlePageView is false", currentValues2);
            } else {
                for (int i = 0; i < this.getItems().size(); ++i) {
                    if (this.getItems().get(i).getClass() == PageGroup.class) continue;
                    currentValues = new String[]{"singlePageView = " + this.isSinglePageView(), "items(" + i + ") = " + this.getItems().get(i).getClass()};
                    tracer.createError("Items must be pageGroups if singlePageView is false", currentValues);
                }
            }
        }
        super.completeValidation(tracer.getCopy());
    }
}

