/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.datadictionary.HelpDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Helpable;
import org.kuali.rice.krad.uif.widget.WidgetBase;

@BeanTag(name="help-bean", parent="Uif-Help")
public class Help
extends WidgetBase {
    private static final long serialVersionUID = -1514436681476297241L;
    private Action helpAction;
    private HelpDefinition helpDefinition;
    private String externalHelpUrl;
    private String tooltipHelpContent;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if (this.helpAction == null) {
            if (StringUtils.isNotBlank((String)this.externalHelpUrl) || this.getPropertyExpression("externalHelpUrl") != null || this.helpDefinition != null && StringUtils.isNotBlank((String)this.helpDefinition.getParameterName()) && StringUtils.isNotBlank((String)this.helpDefinition.getParameterDetailType())) {
                this.helpAction = ComponentFactory.getHelpAction();
                view.assignComponentIds(this.helpAction);
                this.helpAction.addDataAttribute("role", "help");
            }
        } else {
            this.helpAction.addDataAttribute("role", "help");
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        this.buildExternalHelp(view, parent);
        this.buildTooltipHelp(parent);
        if (StringUtils.isBlank((String)this.externalHelpUrl) && StringUtils.isBlank((String)this.tooltipHelpContent)) {
            this.setRender(false);
        }
    }

    protected void buildExternalHelp(View view, Component parent) {
        if (StringUtils.isBlank((String)this.externalHelpUrl) && this.helpDefinition != null) {
            if (StringUtils.isBlank((String)this.helpDefinition.getParameterNamespace())) {
                this.helpDefinition.setParameterNamespace(view.getNamespaceCode());
            }
            if (StringUtils.isNotBlank((String)this.helpDefinition.getParameterNamespace()) && StringUtils.isNotBlank((String)this.helpDefinition.getParameterDetailType()) && StringUtils.isNotBlank((String)this.helpDefinition.getParameterName())) {
                this.externalHelpUrl = this.getParameterService().getParameterValueAsString(this.helpDefinition.getParameterNamespace(), this.helpDefinition.getParameterDetailType(), this.helpDefinition.getParameterName());
            }
        }
        if (StringUtils.isNotBlank((String)this.externalHelpUrl)) {
            this.getHelpAction().setActionScript("openHelpWindow('" + this.externalHelpUrl + "')");
            String helpTitle = parent instanceof Helpable && ((Helpable)((Object)parent)).getHelp() == this ? MessageFormat.format(CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("help.icon.title.tag.with.field.label"), ((Helpable)((Object)parent)).getHelpTitle()) : CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("help.icon.title.tag");
            this.getHelpAction().getActionImage().setAltText(helpTitle);
            this.getHelpAction().getActionImage().setTitle(helpTitle);
        }
    }

    protected void buildTooltipHelp(Component parent) {
        if (StringUtils.isNotBlank((String)this.tooltipHelpContent) && this.isRender() && parent instanceof Helpable && ((Helpable)((Object)parent)).getHelp() == this) {
            this.getToolTip().setTooltipContent(this.tooltipHelpContent);
            ((Helpable)((Object)parent)).setTooltipOfComponent(this.getToolTip());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.helpAction);
        return components;
    }

    @BeanTagAttribute(name="helpAction", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Action getHelpAction() {
        return this.helpAction;
    }

    public void setHelpAction(Action helpAction) {
        this.helpAction = helpAction;
    }

    @BeanTagAttribute(name="helpDefinition", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public HelpDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(HelpDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    @BeanTagAttribute(name="externalHelpUrl")
    public String getExternalHelpUrl() {
        return this.externalHelpUrl;
    }

    public void setExternalHelpUrl(String externalHelpUrl) {
        this.externalHelpUrl = externalHelpUrl;
    }

    @BeanTagAttribute(name="tooltipHelpContent")
    public String getTooltipHelpContent() {
        return this.tooltipHelpContent;
    }

    public void setTooltipHelpContent(String tooltipHelpContent) {
        this.tooltipHelpContent = tooltipHelpContent;
    }

    protected ParameterService getParameterService() {
        return CoreFrameworkServiceLocator.getParameterService();
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Help helpCopy = (Help)component;
        helpCopy.setExternalHelpUrl(this.getExternalHelpUrl());
        if (this.helpAction != null) {
            helpCopy.setHelpAction((Action)this.helpAction.copy());
        }
        helpCopy.setHelpDefinition(this.getHelpDefinition());
        helpCopy.setTooltipHelpContent(this.tooltipHelpContent);
    }
}

