/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import com.google.common.collect.Maps;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.LookupInquiryUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;
import org.kuali.rice.krad.util.UrlFactory;

@BeanTag(name="inquiry-bean", parent="Uif-Inquiry")
public class Inquiry
extends WidgetBase {
    private static final long serialVersionUID = -2154388007867302901L;
    private static final Logger LOG = Logger.getLogger(Inquiry.class);
    public static final String INQUIRY_TITLE_PREFIX = "title.inquiry.url.value.prependtext";
    private String baseInquiryUrl;
    private String dataObjectClassName;
    private String viewName;
    private Map<String, String> inquiryParameters = new HashMap<String, String>();
    private Link inquiryLink;
    private Action directInquiryAction;
    private boolean enableDirectInquiry;
    private boolean adjustInquiryParameters;
    private BindingInfo fieldBindingInfo;
    private boolean parentReadOnly;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (!this.isRender()) {
            return;
        }
        this.setRender(false);
        this.setParentReadOnly(parent.isReadOnly());
        if (this.isParentReadOnly()) {
            if (StringUtils.isBlank((String)((DataField)parent).getBindingInfo().getBindingPath()) || ((DataField)parent).getBindingInfo().getBindingPath().equals("null")) {
                return;
            }
            try {
                Object propertyValue = ObjectPropertyUtils.getPropertyValue(model, ((DataField)parent).getBindingInfo().getBindingPath());
                if (propertyValue == null || StringUtils.isBlank((String)propertyValue.toString())) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (!this.isParentReadOnly() && parent instanceof InputField) {
            if (!this.enableDirectInquiry) {
                return;
            }
            if (StringUtils.isBlank((String)this.getDataObjectClassName()) || this.getInquiryParameters() == null || this.getInquiryParameters().isEmpty()) {
                this.adjustInquiryParameters = true;
                this.fieldBindingInfo = ((InputField)parent).getBindingInfo();
            }
        }
        this.setupLink(view, model, (DataField)parent);
    }

    public void setupLink(View view, Object model, DataField field) {
        String propertyName = field.getBindingInfo().getBindingName();
        if (StringUtils.isNotBlank((String)this.getDataObjectClassName()) && this.getInquiryParameters() != null && !this.getInquiryParameters().isEmpty()) {
            Class<?> inquiryObjectClass;
            try {
                inquiryObjectClass = Class.forName(this.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Unable to get class for: " + this.getDataObjectClassName()));
                throw new RuntimeException(e);
            }
            this.updateInquiryParameters(field.getBindingInfo());
            this.buildInquiryLink(model, propertyName, inquiryObjectClass, this.getInquiryParameters());
        } else {
            Object parentObject = ViewModelUtils.getParentObjectForMetadata(view, model, field);
            view.getViewHelperService().buildInquiryLink(parentObject, propertyName, this);
        }
    }

    public void updateInquiryParameters(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedInquiryParameters = new HashMap<String, String>();
        for (Map.Entry<String, String> stringEntry : this.inquiryParameters.entrySet()) {
            String toField = stringEntry.getValue();
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(stringEntry.getKey());
            adjustedInquiryParameters.put(adjustedFromFieldPath, toField);
        }
        this.inquiryParameters = adjustedInquiryParameters;
    }

    public void buildInquiryLink(Object dataObject, String propertyName, Class<?> inquiryObjectClass, Map<String, String> inquiryParams) {
        Properties urlParameters = new Properties();
        urlParameters.setProperty("dataObjectClassName", inquiryObjectClass.getName());
        urlParameters.setProperty("methodToCall", "start");
        if (StringUtils.isNotBlank((String)this.viewName)) {
            urlParameters.setProperty("viewName", this.viewName);
        }
        if (this.getInquiryLink().getLightBox() != null) {
            this.getInquiryLink().getLightBox().setAddAppParms(true);
        }
        if (this.isParentReadOnly()) {
            for (Map.Entry<String, String> inquiryParameter : inquiryParams.entrySet()) {
                String parameterName = inquiryParameter.getKey();
                Object parameterValue = ObjectPropertyUtils.getPropertyValue(dataObject, parameterName);
                if (parameterValue == null) {
                    parameterValue = "";
                } else if (parameterValue instanceof Date) {
                    if (Formatter.findFormatter(parameterValue.getClass()) != null) {
                        Formatter formatter = Formatter.getFormatter(parameterValue.getClass());
                        parameterValue = formatter.format(parameterValue);
                    }
                } else {
                    parameterValue = parameterValue.toString();
                }
                if (KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(inquiryObjectClass, inquiryParameter.getValue())) {
                    try {
                        parameterValue = CoreApiServiceLocator.getEncryptionService().encrypt(parameterValue);
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException("Exception while trying to encrypted value for inquiry framework.", e);
                    }
                }
                urlParameters.put(inquiryParameter.getValue(), parameterValue);
            }
            ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
            String inquiryUrl = responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass) ? responsibleModuleService.getExternalizableDataObjectInquiryUrl(inquiryObjectClass, urlParameters) : UrlFactory.parameterizeUrl((String)this.getBaseInquiryUrl(), (Properties)urlParameters);
            this.getInquiryLink().setHref(inquiryUrl);
            String linkTitle = this.createTitleText(inquiryObjectClass);
            linkTitle = LookupInquiryUtils.getLinkTitleText(linkTitle, inquiryObjectClass, this.getInquiryParameters());
            this.getInquiryLink().setTitle(linkTitle);
            this.setRender(true);
        } else {
            boolean lightBoxShow;
            String inquiryUrl = UrlFactory.parameterizeUrl((String)this.getBaseInquiryUrl(), (Properties)urlParameters);
            StringBuilder paramMapString = new StringBuilder();
            for (Map.Entry<String, String> inquiryParameter : inquiryParams.entrySet()) {
                String inquiryParameterFrom = inquiryParameter.getKey();
                if (this.adjustInquiryParameters && this.fieldBindingInfo != null) {
                    inquiryParameterFrom = this.fieldBindingInfo.getPropertyAdjustedBindingPath(inquiryParameterFrom);
                }
                paramMapString.append(inquiryParameterFrom);
                paramMapString.append(":");
                paramMapString.append(inquiryParameter.getValue());
                paramMapString.append(",");
            }
            paramMapString.deleteCharAt(paramMapString.length() - 1);
            String lightBoxOptions = "";
            boolean bl = lightBoxShow = this.getInquiryLink().getLightBox() != null;
            if (lightBoxShow) {
                lightBoxOptions = this.getInquiryLink().getLightBox().getTemplateOptionsJSString();
            }
            StringBuilder onClickScript = new StringBuilder("showDirectInquiry(\"");
            onClickScript.append(inquiryUrl);
            onClickScript.append("\", \"");
            onClickScript.append((CharSequence)paramMapString);
            onClickScript.append("\", ");
            onClickScript.append(lightBoxShow);
            onClickScript.append(", ");
            onClickScript.append(lightBoxOptions);
            onClickScript.append(");");
            this.directInquiryAction.setPerformDirtyValidation(false);
            this.directInquiryAction.setActionScript(onClickScript.toString());
            this.setRender(true);
        }
    }

    public String createTitleText(Class<?> dataObjectClass) {
        String objectLabel;
        String titleText = "";
        String titlePrefixProp = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString(INQUIRY_TITLE_PREFIX);
        if (StringUtils.isNotBlank((String)titlePrefixProp)) {
            titleText = titleText + titlePrefixProp + " ";
        }
        if (StringUtils.isNotBlank((String)(objectLabel = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDataObjectEntry(dataObjectClass.getName()).getObjectLabel()))) {
            titleText = titleText + objectLabel + " ";
        }
        return titleText;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.getInquiryLink());
        components.add(this.getDirectInquiryAction());
        return components;
    }

    @BeanTagAttribute(name="baseInquiryUrl")
    public String getBaseInquiryUrl() {
        return this.baseInquiryUrl;
    }

    public void setBaseInquiryUrl(String baseInquiryUrl) {
        this.baseInquiryUrl = baseInquiryUrl;
    }

    @BeanTagAttribute(name="dataObjectClassName")
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute(name="viewName")
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @BeanTagAttribute(name="inquiryParameters", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getInquiryParameters() {
        return this.inquiryParameters;
    }

    public void setInquiryParameters(Map<String, String> inquiryParameters) {
        this.inquiryParameters = inquiryParameters;
    }

    @BeanTagAttribute(name="inquiryLink", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Link getInquiryLink() {
        return this.inquiryLink;
    }

    public void setInquiryLink(Link inquiryLink) {
        this.inquiryLink = inquiryLink;
    }

    @BeanTagAttribute(name="directInquiryAction", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Action getDirectInquiryAction() {
        return this.directInquiryAction;
    }

    public void setDirectInquiryAction(Action directInquiryAction) {
        this.directInquiryAction = directInquiryAction;
    }

    @BeanTagAttribute(name="enableDirectInquiry")
    public boolean isEnableDirectInquiry() {
        return this.enableDirectInquiry;
    }

    public void setEnableDirectInquiry(boolean enableDirectInquiry) {
        this.enableDirectInquiry = enableDirectInquiry;
    }

    protected boolean isParentReadOnly() {
        return this.parentReadOnly;
    }

    protected void setParentReadOnly(boolean parentReadOnly) {
        this.parentReadOnly = parentReadOnly;
    }

    public boolean isAdjustInquiryParameters() {
        return this.adjustInquiryParameters;
    }

    public void setAdjustInquiryParameters(boolean adjustInquiryParameters) {
        this.adjustInquiryParameters = adjustInquiryParameters;
    }

    public void setFieldBindingInfo(BindingInfo fieldBindingInfo) {
        this.fieldBindingInfo = fieldBindingInfo;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Inquiry inquiryCopy = (Inquiry)component;
        inquiryCopy.setBaseInquiryUrl(this.getBaseInquiryUrl());
        inquiryCopy.setDataObjectClassName(this.getDataObjectClassName());
        inquiryCopy.setViewName(this.getViewName());
        inquiryCopy.setInquiryLink((Link)this.getInquiryLink().copy());
        inquiryCopy.setDirectInquiryAction((Action)this.getDirectInquiryAction().copy());
        inquiryCopy.setEnableDirectInquiry(this.isEnableDirectInquiry());
        inquiryCopy.setAdjustInquiryParameters(this.isAdjustInquiryParameters());
        inquiryCopy.setParentReadOnly(this.isParentReadOnly());
        if (this.inquiryParameters != null) {
            HashMap inquiryParametersCopy = Maps.newHashMapWithExpectedSize((int)this.inquiryParameters.size());
            for (Map.Entry<String, String> inquiryParameter : this.inquiryParameters.entrySet()) {
                inquiryParametersCopy.put(inquiryParameter.getKey().toString(), inquiryParameter.getValue().toString());
            }
            inquiryCopy.setInquiryParameters(inquiryParametersCopy);
        }
        if (this.fieldBindingInfo != null) {
            inquiryCopy.setFieldBindingInfo((BindingInfo)this.fieldBindingInfo.copy());
        }
    }
}

