/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.LightBox;
import org.kuali.rice.krad.uif.widget.WidgetBase;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTags(value={@BeanTag(name="quickFinder-bean", parent="Uif-QuickFinder"), @BeanTag(name="quickFinderByScript-bean", parent="Uif-QuickFinderByScript"), @BeanTag(name="collectionQuickFinder-bean", parent="Uif-CollectionQuickFinder")})
public class QuickFinder
extends WidgetBase {
    private static final long serialVersionUID = 3302390972815386785L;
    private String baseLookupUrl;
    private String dataObjectClassName;
    private String viewName;
    private String referencesToRefresh;
    private Map<String, String> fieldConversions = new HashMap<String, String>();
    private Map<String, String> lookupParameters = new HashMap<String, String>();
    private String readOnlySearchFields;
    private Boolean hideReturnLink;
    private Boolean suppressActions;
    private Boolean autoSearch;
    private Boolean renderLookupCriteria;
    private Boolean supplementalActionsEnabled;
    private Boolean renderSearchButtons;
    private Boolean renderHeader;
    private Boolean showMaintenanceLinks;
    private Boolean multipleValuesSelect;
    private String lookupCollectionName;
    private Action quickfinderAction;
    private LightBox lightBoxLookup;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if (this.quickfinderAction != null && this.lightBoxLookup != null && this.lightBoxLookup.isRender()) {
            this.quickfinderAction.setActionScript("voidAction");
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (parent.isReadOnly()) {
            this.setRender(false);
        }
        if (!this.isRender()) {
            return;
        }
        if (parent instanceof InputField) {
            InputField field = (InputField)parent;
            if (StringUtils.isBlank((String)this.dataObjectClassName)) {
                DataObjectRelationship relationship = this.getRelationshipForField(view, model, field);
                if (relationship == null) {
                    this.setRender(false);
                    return;
                }
                this.dataObjectClassName = relationship.getRelatedClass().getName();
                if (this.fieldConversions == null || this.fieldConversions.isEmpty()) {
                    this.generateFieldConversions(field, relationship);
                }
                if (this.lookupParameters == null || this.lookupParameters.isEmpty()) {
                    this.generateLookupParameters(field, relationship);
                }
            }
            this.updateFieldConversions(field.getBindingInfo());
            this.updateLookupParameters(field.getBindingInfo());
            this.updateReferencesToRefresh(field.getBindingInfo());
        } else if (parent instanceof CollectionGroup) {
            CollectionGroup collectionGroup = (CollectionGroup)parent;
            if (StringUtils.isBlank((String)this.getDataObjectClassName())) {
                Class<?> collectionObjectClass = collectionGroup.getCollectionObjectClass();
                boolean isCollectionClassLookupable = KRADServiceLocatorWeb.getViewDictionaryService().isLookupable(collectionObjectClass);
                if (isCollectionClassLookupable) {
                    this.setDataObjectClassName(collectionObjectClass.getName());
                    if (this.fieldConversions == null || this.fieldConversions.isEmpty()) {
                        List<String> collectionObjectPKFields = KRADServiceLocatorWeb.getDataObjectMetaDataService().listPrimaryKeyFieldNames(collectionObjectClass);
                        for (String pkField : collectionObjectPKFields) {
                            this.fieldConversions.put(pkField, pkField);
                        }
                    }
                } else {
                    this.setRender(false);
                }
            }
            if (this.isRender() && StringUtils.isBlank((String)this.getLookupCollectionName())) {
                this.setLookupCollectionName(collectionGroup.getBindingInfo().getBindingPath());
            }
        }
        this.quickfinderAction.addActionParameter("baseLookupUrl", this.baseLookupUrl);
        this.quickfinderAction.addActionParameter("dataObjectClassName", this.dataObjectClassName);
        if (!this.fieldConversions.isEmpty()) {
            this.quickfinderAction.addActionParameter("conversionFields", KRADUtils.buildMapParameterString(this.fieldConversions));
        }
        if (!this.lookupParameters.isEmpty()) {
            this.quickfinderAction.addActionParameter("lookupParameters", KRADUtils.buildMapParameterString(this.lookupParameters));
        }
        this.addActionParameterIfNotNull("viewName", this.viewName);
        this.addActionParameterIfNotNull("readOnlyFields", this.readOnlySearchFields);
        this.addActionParameterIfNotNull("hideReturnLink", this.hideReturnLink);
        this.addActionParameterIfNotNull("suppressActions", this.suppressActions);
        this.addActionParameterIfNotNull("referencesToRefresh", this.referencesToRefresh);
        this.addActionParameterIfNotNull("autoSearch", this.autoSearch);
        this.addActionParameterIfNotNull("renderlookupCriteria", this.renderLookupCriteria);
        this.addActionParameterIfNotNull("supplementalActionsEnabled", this.supplementalActionsEnabled);
        this.addActionParameterIfNotNull("renderSearchButtons", this.renderSearchButtons);
        this.addActionParameterIfNotNull("renderHeader", this.renderHeader);
        this.addActionParameterIfNotNull("showMaintenanceLinks", this.showMaintenanceLinks);
        this.addActionParameterIfNotNull("multipleValuesSelect", this.multipleValuesSelect);
        this.addActionParameterIfNotNull("lookupCollectionName", this.lookupCollectionName);
    }

    protected void addActionParameterIfNotNull(String parameterName, Object parameterValue) {
        if (parameterValue != null && StringUtils.isNotBlank((String)parameterValue.toString())) {
            this.quickfinderAction.addActionParameter(parameterName, parameterValue.toString());
        }
    }

    protected DataObjectRelationship getRelationshipForField(View view, Object model, InputField field) {
        String propertyName = field.getBindingInfo().getBindingName();
        Object parentObject = ViewModelUtils.getParentObjectForMetadata(view, model, field);
        Class<?> parentObjectClass = null;
        if (parentObject != null) {
            parentObjectClass = parentObject.getClass();
        }
        return KRADServiceLocatorWeb.getDataObjectMetaDataService().getDataObjectRelationship(parentObject, parentObjectClass, propertyName, "", true, true, false);
    }

    protected void generateFieldConversions(InputField field, DataObjectRelationship relationship) {
        this.fieldConversions = new HashMap<String, String>();
        for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = (String)entry.getValue();
            String toField = (String)entry.getKey();
            this.fieldConversions.put(fromField, toField);
        }
    }

    protected void generateLookupParameters(InputField field, DataObjectRelationship relationship) {
        this.lookupParameters = new HashMap<String, String>();
        for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = (String)entry.getKey();
            String toField = (String)entry.getValue();
            if (relationship.getUserVisibleIdentifierKey() != null && !relationship.getUserVisibleIdentifierKey().equals(fromField)) continue;
            this.lookupParameters.put(fromField, toField);
        }
    }

    public void updateFieldConversions(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedFieldConversions = new HashMap<String, String>();
        for (String fromField : this.fieldConversions.keySet()) {
            String toField = this.fieldConversions.get(fromField);
            String adjustedToFieldPath = bindingInfo.getPropertyAdjustedBindingPath(toField);
            adjustedFieldConversions.put(fromField, adjustedToFieldPath);
        }
        this.fieldConversions = adjustedFieldConversions;
    }

    public void updateLookupParameters(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedLookupParameters = new HashMap<String, String>();
        for (String fromField : this.lookupParameters.keySet()) {
            String toField = this.lookupParameters.get(fromField);
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(fromField);
            adjustedLookupParameters.put(adjustedFromFieldPath, toField);
        }
        this.lookupParameters = adjustedLookupParameters;
    }

    public void updateReferencesToRefresh(BindingInfo bindingInfo) {
        String adjustedReferencesToRefresh = new String();
        if (this.referencesToRefresh == null) {
            this.referencesToRefresh = adjustedReferencesToRefresh;
        }
        for (String reference : StringUtils.split((String)this.referencesToRefresh, (String)",")) {
            if (StringUtils.isNotBlank((String)adjustedReferencesToRefresh)) {
                adjustedReferencesToRefresh = adjustedReferencesToRefresh + ",";
            }
            String adjustedReference = bindingInfo.getPropertyAdjustedBindingPath(reference);
            adjustedReferencesToRefresh = adjustedReferencesToRefresh + adjustedReference;
        }
        this.referencesToRefresh = adjustedReferencesToRefresh;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.quickfinderAction);
        components.add(this.lightBoxLookup);
        return components;
    }

    @BeanTagAttribute(name="baseLookupUrl")
    public String getBaseLookupUrl() {
        return this.baseLookupUrl;
    }

    public void setBaseLookupUrl(String baseLookupUrl) {
        this.baseLookupUrl = baseLookupUrl;
    }

    @BeanTagAttribute(name="dataOjbectClassName")
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute(name="viewName")
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @BeanTagAttribute(name="referencesToRefresh")
    public String getReferencesToRefresh() {
        return this.referencesToRefresh;
    }

    public void setReferencesToRefresh(String referencesToRefresh) {
        this.referencesToRefresh = referencesToRefresh;
    }

    @BeanTagAttribute(name="fieldConversions", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(Map<String, String> fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    @BeanTagAttribute(name="lookupParameters", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getLookupParameters() {
        return this.lookupParameters;
    }

    public void setLookupParameters(Map<String, String> lookupParameters) {
        this.lookupParameters = lookupParameters;
    }

    @BeanTagAttribute(name="readOnlySearchFields")
    public String getReadOnlySearchFields() {
        return this.readOnlySearchFields;
    }

    public void setReadOnlySearchFields(String readOnlySearchFields) {
        this.readOnlySearchFields = readOnlySearchFields;
    }

    @BeanTagAttribute(name="hideReturnLink")
    public Boolean getHideReturnLink() {
        return this.hideReturnLink;
    }

    public void setHideReturnLink(Boolean hideReturnLink) {
        this.hideReturnLink = hideReturnLink;
    }

    @BeanTagAttribute(name="suppressActions")
    public Boolean getSuppressActions() {
        return this.suppressActions;
    }

    public void setSuppressActions(Boolean suppressActions) {
        this.suppressActions = suppressActions;
    }

    @BeanTagAttribute(name="autoSearch")
    public Boolean getAutoSearch() {
        return this.autoSearch;
    }

    public void setAutoSearch(Boolean autoSearch) {
        this.autoSearch = autoSearch;
    }

    @BeanTagAttribute(name="renderLookupCriteria")
    public Boolean getRenderLookupCriteria() {
        return this.renderLookupCriteria;
    }

    public void setRenderLookupCriteria(Boolean renderLookupCriteria) {
        this.renderLookupCriteria = renderLookupCriteria;
    }

    @BeanTagAttribute(name="supplementalActionsEnabled")
    public Boolean getSupplementalActionsEnabled() {
        return this.supplementalActionsEnabled;
    }

    public void setSupplementalActionsEnabled(Boolean supplementalActionsEnabled) {
        this.supplementalActionsEnabled = supplementalActionsEnabled;
    }

    @BeanTagAttribute(name="renderSearchButtons")
    public Boolean getRenderSearchButtons() {
        return this.renderSearchButtons;
    }

    public void setRenderSearchButtons(Boolean renderSearchButtons) {
        this.renderSearchButtons = renderSearchButtons;
    }

    @BeanTagAttribute(name="renderHeader")
    public Boolean getRenderHeader() {
        return this.renderHeader;
    }

    public void setRenderHeader(Boolean renderHeader) {
        this.renderHeader = renderHeader;
    }

    @BeanTagAttribute(name="showMaintenanceLinks")
    public Boolean getShowMaintenanceLinks() {
        return this.showMaintenanceLinks;
    }

    public void setShowMaintenanceLinks(Boolean showMaintenanceLinks) {
        this.showMaintenanceLinks = showMaintenanceLinks;
    }

    @BeanTagAttribute(name="quickfinderAction", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Action getQuickfinderAction() {
        return this.quickfinderAction;
    }

    public void setQuickfinderAction(Action quickfinderAction) {
        this.quickfinderAction = quickfinderAction;
    }

    public void setLightBoxLookup(LightBox lightBoxLookup) {
        this.lightBoxLookup = lightBoxLookup;
    }

    @BeanTagAttribute(name="lightBoxLookup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public LightBox getLightBoxLookup() {
        return this.lightBoxLookup;
    }

    @BeanTagAttribute(name="MultipleValuesSelect")
    public Boolean getMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(Boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    @BeanTagAttribute(name="lookupCollectionName")
    public String getLookupCollectionName() {
        return this.lookupCollectionName;
    }

    public void setLookupCollectionName(String lookupCollectionName) {
        this.lookupCollectionName = lookupCollectionName;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        QuickFinder quickFinderCopy = (QuickFinder)component;
        quickFinderCopy.setBaseLookupUrl(this.getBaseLookupUrl());
        quickFinderCopy.setDataObjectClassName(this.getDataObjectClassName());
        quickFinderCopy.setViewName(this.getViewName());
        quickFinderCopy.setReferencesToRefresh(this.getReferencesToRefresh());
        if (this.fieldConversions != null) {
            HashMap fieldConversionsCopy = Maps.newHashMapWithExpectedSize((int)this.fieldConversions.size());
            for (Map.Entry<String, String> fieldConversion : this.fieldConversions.entrySet()) {
                fieldConversionsCopy.put(fieldConversion.getKey().toString(), fieldConversion.getValue().toString());
            }
            quickFinderCopy.setFieldConversions(fieldConversionsCopy);
        }
        if (this.lookupParameters != null) {
            HashMap lookupParametersCopy = Maps.newHashMapWithExpectedSize((int)this.lookupParameters.size());
            for (Map.Entry<String, String> lookupParameter : this.lookupParameters.entrySet()) {
                lookupParametersCopy.put(lookupParameter.getKey().toString(), lookupParameter.getValue().toString());
            }
            quickFinderCopy.setLookupParameters(lookupParametersCopy);
        }
        quickFinderCopy.setReadOnlySearchFields(this.getReadOnlySearchFields());
        quickFinderCopy.setHideReturnLink(this.getHideReturnLink());
        quickFinderCopy.setSuppressActions(this.getSuppressActions());
        quickFinderCopy.setAutoSearch(this.getAutoSearch());
        quickFinderCopy.setRenderLookupCriteria(this.getRenderLookupCriteria());
        quickFinderCopy.setSupplementalActionsEnabled(this.getSupplementalActionsEnabled());
        quickFinderCopy.setRenderSearchButtons(this.getRenderSearchButtons());
        quickFinderCopy.setRenderHeader(this.getRenderHeader());
        quickFinderCopy.setShowMaintenanceLinks(this.getShowMaintenanceLinks());
        quickFinderCopy.setMultipleValuesSelect(this.getMultipleValuesSelect());
        quickFinderCopy.setLookupCollectionName(this.getLookupCollectionName());
        if (this.lightBoxLookup != null) {
            quickFinderCopy.setLightBoxLookup((LightBox)this.getLightBoxLookup().copy());
        }
        if (this.quickfinderAction != null) {
            quickFinderCopy.setQuickfinderAction((Action)this.quickfinderAction.copy());
        }
    }
}

