/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;

@BeanTag(name="suggest-bean", parent="Uif-Suggest")
public class Suggest
extends WidgetBase {
    private static final long serialVersionUID = 7373706855319347225L;
    private AttributeQuery suggestQuery;
    private String valuePropertyName;
    private String labelPropertyName;
    private List<String> additionalPropertiesToReturn;
    private boolean returnFullQueryObject;
    private boolean retrieveAllSuggestions;
    private List<Object> suggestOptions;
    private String suggestOptionsJsString;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.suggestQuery != null) {
            view.getViewHelperService().getExpressionEvaluator().evaluateExpressionsOnConfigurable(view, this.suggestQuery, this.getContext());
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (!this.isSuggestConfigured()) {
            this.setRender(false);
        }
        if (!this.isRender()) {
            return;
        }
        if (this.retrieveAllSuggestions) {
            if (this.suggestOptions == null || this.suggestOptions.isEmpty()) {
                if (this.suggestQuery.hasConfiguredMethod()) {
                    this.retrieveSuggestOptions(view);
                }
            } else {
                this.suggestOptionsJsString = ScriptUtils.translateValue(this.suggestOptions);
            }
        } else {
            InputField field = (InputField)parent;
            BindingInfo bindingInfo = field.getBindingInfo();
            this.suggestQuery.updateQueryFieldMapping(bindingInfo);
        }
    }

    public boolean isSuggestConfigured() {
        return StringUtils.isNotBlank((String)this.valuePropertyName) || this.suggestQuery.hasConfiguredMethod() || this.suggestOptions != null && !this.suggestOptions.isEmpty();
    }

    protected void retrieveSuggestOptions(View view) {
        block7: {
            String queryMethodToCall = this.suggestQuery.getQueryMethodToCall();
            MethodInvokerConfig queryMethodInvoker = this.suggestQuery.getQueryMethodInvokerConfig();
            if (queryMethodInvoker == null) {
                queryMethodInvoker = new MethodInvokerConfig();
            }
            if (StringUtils.isBlank((String)queryMethodInvoker.getTargetMethod())) {
                queryMethodInvoker.setTargetMethod(queryMethodToCall);
            }
            if (queryMethodInvoker.getTargetClass() == null && queryMethodInvoker.getTargetObject() == null) {
                queryMethodInvoker.setTargetObject(view.getViewHelperService());
            }
            try {
                queryMethodInvoker.prepare();
                Object methodResult = queryMethodInvoker.invoke();
                if (methodResult instanceof String) {
                    this.suggestOptionsJsString = (String)methodResult;
                    break block7;
                }
                if (methodResult instanceof List) {
                    this.suggestOptions = (List)methodResult;
                    this.suggestOptionsJsString = ScriptUtils.translateValue(this.suggestOptions);
                    break block7;
                }
                throw new RuntimeException("Suggest query method did not return List<String> for suggestions");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke query method: " + queryMethodInvoker.getTargetMethod(), e);
            }
        }
    }

    @BeanTagAttribute(name="suggestQuery", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public AttributeQuery getSuggestQuery() {
        return this.suggestQuery;
    }

    public void setSuggestQuery(AttributeQuery suggestQuery) {
        this.suggestQuery = suggestQuery;
    }

    @BeanTagAttribute(name="valuePropertyName")
    public String getValuePropertyName() {
        return this.valuePropertyName;
    }

    public void setValuePropertyName(String valuePropertyName) {
        this.valuePropertyName = valuePropertyName;
    }

    @BeanTagAttribute(name="labelPropertyName")
    public String getLabelPropertyName() {
        return this.labelPropertyName;
    }

    public void setLabelPropertyName(String labelPropertyName) {
        this.labelPropertyName = labelPropertyName;
    }

    @BeanTagAttribute(name="additionalPropertiesToReturn", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalPropertiesToReturn() {
        return this.additionalPropertiesToReturn;
    }

    public void setAdditionalPropertiesToReturn(List<String> additionalPropertiesToReturn) {
        this.additionalPropertiesToReturn = additionalPropertiesToReturn;
    }

    @BeanTagAttribute(name="returnFullQueryObject")
    public boolean isReturnFullQueryObject() {
        return this.returnFullQueryObject;
    }

    public void setReturnFullQueryObject(boolean returnFullQueryObject) {
        this.returnFullQueryObject = returnFullQueryObject;
    }

    @BeanTagAttribute(name="retrieveAllSuggestions")
    public boolean isRetrieveAllSuggestions() {
        return this.retrieveAllSuggestions;
    }

    public void setRetrieveAllSuggestions(boolean retrieveAllSuggestions) {
        this.retrieveAllSuggestions = retrieveAllSuggestions;
    }

    @BeanTagAttribute(name="suggestOptions", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Object> getSuggestOptions() {
        return this.suggestOptions;
    }

    public void setSuggestOptions(List<Object> suggestOptions) {
        this.suggestOptions = suggestOptions;
    }

    public String getSuggestOptionsJsString() {
        if (StringUtils.isNotBlank((String)this.suggestOptionsJsString)) {
            return this.suggestOptionsJsString;
        }
        return "null";
    }

    public void setSuggestOptionsJsString(String suggestOptionsJsString) {
        this.suggestOptionsJsString = suggestOptionsJsString;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Suggest suggestCopy = (Suggest)component;
        suggestCopy.setValuePropertyName(this.getValuePropertyName());
        suggestCopy.setLabelPropertyName(this.getLabelPropertyName());
        if (this.additionalPropertiesToReturn != null) {
            suggestCopy.setAdditionalPropertiesToReturn(new ArrayList<String>(this.additionalPropertiesToReturn));
        }
        suggestCopy.setReturnFullQueryObject(this.isReturnFullQueryObject());
        suggestCopy.setRetrieveAllSuggestions(this.isRetrieveAllSuggestions());
        if (this.suggestQuery != null) {
            suggestCopy.setSuggestQuery((AttributeQuery)this.suggestQuery.copy());
        }
        suggestCopy.setSuggestOptions(this.getSuggestOptions());
        suggestCopy.setSuggestOptionsJsString(this.suggestOptionsJsString);
    }
}

