/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.TabGroup;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;

@BeanTag(name="tabs-bean", parent="Uif-Tabs")
public class Tabs
extends WidgetBase {
    private static final long serialVersionUID = 2L;
    @ClientSideState(variableName="activeTab")
    private String defaultActiveTabId;
    private UifConstants.Position position = UifConstants.Position.TOP;

    @Override
    public void performFinalize(View view, Object model, Component component) {
        super.performFinalize(view, model, component);
        if (!(component instanceof TabGroup)) {
            throw new RuntimeException("Parent for tabs widget should be tab group, not " + component.getClass());
        }
        TabGroup tabGroup = (TabGroup)component;
        if (StringUtils.isNotBlank((String)this.defaultActiveTabId)) {
            int index = 0;
            boolean found = false;
            for (Component component2 : tabGroup.getItems()) {
                if (StringUtils.equals((String)this.defaultActiveTabId, (String)component2.getId())) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (found) {
                Map<String, String> oTemplateOptions = this.getTemplateOptions();
                if (oTemplateOptions == null) {
                    oTemplateOptions = new HashMap<String, String>();
                    this.setTemplateOptions(oTemplateOptions);
                }
                oTemplateOptions.put("active", Integer.toString(index));
            }
        }
    }

    @BeanTagAttribute(name="defaultActiveTabId")
    public String getDefaultActiveTabId() {
        return this.defaultActiveTabId;
    }

    public void setDefaultActiveTabId(String defaultActiveTabId) {
        this.defaultActiveTabId = defaultActiveTabId;
    }

    @BeanTagAttribute(name="position")
    public UifConstants.Position getPosition() {
        return this.position;
    }

    public void setPosition(UifConstants.Position position) {
        this.position = position;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Tabs tabsCopy = (Tabs)component;
        tabsCopy.setDefaultActiveTabId(this.getDefaultActiveTabId());
        tabsCopy.setPosition(this.getPosition());
    }
}

