/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/listener"})
public class UifClientListener
extends UifControllerBase {
    @Override
    protected UifFormBase createInitialForm(HttpServletRequest request) {
        return new UifFormBase();
    }

    @RequestMapping(params={"methodToCall=clearForm"})
    @ResponseBody
    public String clearForm(@RequestParam(value="formKeyToClear") String formKeyToClear, HttpServletRequest request, HttpServletResponse response) {
        GlobalVariables.getUifFormManager().removeFormWithHistoryFormsByKey(formKeyToClear);
        return "{\"status\":\"success\"}";
    }

    @RequestMapping(params={"methodToCall=retrieveMessage"})
    @ResponseBody
    public String retrieveMessage(@RequestParam(value="key") String key, HttpServletRequest request, HttpServletResponse response) {
        String namespace = request.getParameter("namespaceCode");
        String componentCode = request.getParameter("componentCode");
        String messageText = KRADServiceLocatorWeb.getMessageService().getMessageText(namespace, componentCode, key);
        messageText = messageText == null ? "" : ScriptUtils.escapeJSONString(messageText);
        return "{\"messageText\":\"" + messageText + "\"}";
    }

    @RequestMapping(params={"methodToCall=keepSessionAlive"})
    @ResponseBody
    public String keepSessionAlive(HttpServletRequest request, HttpServletResponse response) {
        return "{\"status\":\"success\"}";
    }

    @RequestMapping(params={"methodToCall=logout"})
    public ModelAndView logout(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        request.getSession().invalidate();
        return this.getUIFModelAndViewWithInit(form, "Uif-LoggedOutView");
    }
}

