/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.util.LookupInquiryUtils;
import org.kuali.rice.krad.uif.view.DialogManager;
import org.kuali.rice.krad.uif.view.MessageView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.UrlFactory;
import org.kuali.rice.krad.web.controller.UifControllerHelper;
import org.kuali.rice.krad.web.controller.helper.CollectionPagingHelper;
import org.kuali.rice.krad.web.controller.helper.DataTablesPagingHelper;
import org.kuali.rice.krad.web.form.HistoryFlow;
import org.kuali.rice.krad.web.form.HistoryManager;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public abstract class UifControllerBase {
    private static final Logger LOG = Logger.getLogger(UifControllerBase.class);
    private UrlBasedViewResolver viewResolver;

    @ModelAttribute(value="KualiForm")
    public UifFormBase initForm(HttpServletRequest request, HttpServletResponse response) {
        String requestedFormKey;
        UifFormBase requestForm = null;
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        if (uifFormManager == null) {
            uifFormManager = new UifFormManager();
            request.getSession().setAttribute("formManager", (Object)uifFormManager);
        }
        GlobalVariables.setUifFormManager(uifFormManager);
        requestForm = this.createInitialForm(request);
        String formKeyParam = request.getParameter("formKey");
        if (StringUtils.isNotBlank((String)formKeyParam)) {
            uifFormManager.updateFormWithSession(requestForm, formKeyParam);
        }
        if (StringUtils.isNotBlank((String)(requestedFormKey = request.getParameter("requestedFormKey")))) {
            requestForm.setRequestedFormKey(requestedFormKey);
        } else {
            requestForm.setRequestedFormKey(formKeyParam);
        }
        String referer = request.getHeader("Referer");
        if (StringUtils.isBlank((String)referer) && StringUtils.isBlank((String)requestForm.getReturnLocation())) {
            requestForm.setReturnLocation("NO_RETURN");
        } else if (StringUtils.isBlank((String)requestForm.getReturnLocation())) {
            requestForm.setReturnLocation(referer);
        }
        if (requestForm.getInitialRequestParameters() == null) {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            Enumeration names = request.getParameterNames();
            while (names != null && names.hasMoreElements()) {
                String name = KRADUtils.stripXSSPatterns((String)names.nextElement());
                String value = KRADUtils.stripXSSPatterns(request.getParameter(name));
                requestParams.put(name, value);
            }
            requestParams.remove("__login_user");
            requestForm.setInitialRequestParameters(requestParams);
        }
        String requestUrl = KRADUtils.stripXSSPatterns(KRADUtils.getFullURL(request));
        requestForm.setRequestUrl(requestUrl);
        Object historyManager = request.getSession().getAttribute("historyManager");
        String flowKey = request.getParameter("flow");
        if (requestForm != null && historyManager != null && historyManager instanceof HistoryManager) {
            requestForm.setHistoryManager((HistoryManager)historyManager);
            requestForm.setFlowKey(flowKey);
        }
        request.setAttribute("requestForm", (Object)requestForm);
        return requestForm;
    }

    protected abstract UifFormBase createInitialForm(HttpServletRequest var1);

    @RequestMapping
    public ModelAndView defaultMapping(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.start(form, result, request, response);
    }

    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        if (form.getView() != null) {
            String methodToCall = request.getParameter("methodToCall");
            this.checkViewAuthorization(form, methodToCall);
        }
        return this.getUIFModelAndView(form);
    }

    public void checkViewAuthorization(UifFormBase form, String methodToCall) throws AuthorizationException {
        if (GlobalVariables.getUserSession() == null) {
            return;
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean canOpenView = form.getView().getAuthorizer().canOpenView(form.getView(), form, user);
        if (!canOpenView) {
            throw new AuthorizationException(user.getPrincipalName(), "open", form.getView().getId(), "User '" + user.getPrincipalName() + "' is not authorized to open view ID: " + form.getView().getId(), null);
        }
    }

    @RequestMapping(params={"methodToCall=sessionTimeout"})
    public ModelAndView sessionTimeout(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addLine"})
    public ModelAndView addLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = uifForm.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection was not set for add line action, cannot add new line");
        }
        View view = uifForm.getPostedView();
        view.getViewHelperService().processCollectionAddLine(view, uifForm, selectedCollectionPath);
        return this.getUIFModelAndView(uifForm);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addBlankLine"})
    public ModelAndView addBlankLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm) {
        String selectedCollectionPath = uifForm.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection was not set for add line action, cannot add new line");
        }
        View view = uifForm.getPostedView();
        view.getViewHelperService().processCollectionAddBlankLine(view, uifForm, selectedCollectionPath);
        return this.getUIFModelAndView(uifForm);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=saveLine"})
    public ModelAndView saveLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = uifForm.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection was not set for add line action, cannot add new line");
        }
        int selectedLineIndex = -1;
        String selectedLine = uifForm.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotBlank((String)selectedLine)) {
            selectedLineIndex = Integer.parseInt(selectedLine);
        }
        if (selectedLineIndex == -1) {
            throw new RuntimeException("Selected line index was not set for delete line action, cannot delete line");
        }
        View view = uifForm.getPostedView();
        view.getViewHelperService().processCollectionSaveLine(view, uifForm, selectedCollectionPath, selectedLineIndex);
        return this.getUIFModelAndView(uifForm);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=deleteLine"})
    public ModelAndView deleteLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = uifForm.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection was not set for delete line action, cannot delete line");
        }
        int selectedLineIndex = -1;
        String selectedLine = uifForm.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotBlank((String)selectedLine)) {
            selectedLineIndex = Integer.parseInt(selectedLine);
        }
        if (selectedLineIndex == -1) {
            throw new RuntimeException("Selected line index was not set for delete line action, cannot delete line");
        }
        View view = uifForm.getPostedView();
        view.getViewHelperService().processCollectionDeleteLine(view, uifForm, selectedCollectionPath, selectedLineIndex);
        return this.getUIFModelAndView(uifForm);
    }

    @RequestMapping(params={"methodToCall=cancel"})
    public ModelAndView cancel(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.back(form, result, request, response);
    }

    @RequestMapping(params={"methodToCall=back"})
    public ModelAndView back(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String returnToStart;
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((String)form.getReturnFormKey())) {
            props.put("formKey", form.getReturnFormKey());
        }
        HistoryFlow historyFlow = form.getHistoryManager().getMostRecentFlowByFormKey(form.getFlowKey(), form.getRequestedFormKey());
        String returnUrl = form.getReturnLocation();
        if (historyFlow != null) {
            returnUrl = historyFlow.getFlowReturnPoint();
        }
        if (StringUtils.isBlank((String)(returnToStart = form.getActionParamaterValue("returnToStart")))) {
            returnToStart = request.getParameter("returnToStart");
        }
        if (StringUtils.isNotBlank((String)returnToStart) && Boolean.parseBoolean(returnToStart) && historyFlow != null && StringUtils.isNotBlank((String)historyFlow.getFlowStartPoint())) {
            returnUrl = historyFlow.getFlowStartPoint();
        }
        if (StringUtils.isBlank((String)returnUrl) || returnUrl.equals("NO_RETURN")) {
            returnUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        }
        GlobalVariables.getUifFormManager().removeSessionForm(form);
        return this.performRedirect(form, returnUrl, props);
    }

    @RequestMapping(params={"methodToCall=returnToPrevious"})
    public ModelAndView returnToPrevious(@ModelAttribute(value="KualiForm") UifFormBase form) {
        return this.returnToHistory(form, false);
    }

    @RequestMapping(params={"methodToCall=returnToHub"})
    public ModelAndView returnToHub(@ModelAttribute(value="KualiForm") UifFormBase form) {
        return this.returnToHistory(form, true);
    }

    public ModelAndView returnToHistory(UifFormBase form, boolean homeFlag) {
        String returnUrl = form.getReturnLocation();
        if (StringUtils.isBlank((String)returnUrl) || homeFlag) {
            returnUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        }
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        GlobalVariables.getUifFormManager().removeSessionForm(form);
        return this.performRedirect(form, returnUrl, props);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=navigate"})
    public ModelAndView navigate(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String pageId = form.getActionParamaterValue("navigateToPageId");
        form.setDirtyForm(false);
        return this.getUIFModelAndView(form, pageId);
    }

    @RequestMapping(params={"methodToCall=refresh"})
    public ModelAndView refresh(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String flashMapSelectedLineValues = "";
        if (RequestContextUtils.getInputFlashMap((HttpServletRequest)request) != null) {
            flashMapSelectedLineValues = (String)RequestContextUtils.getInputFlashMap((HttpServletRequest)request).get("selectedLineValues");
        }
        String refreshCallerType = "";
        if (request.getParameterMap().containsKey("refreshCallerType")) {
            refreshCallerType = request.getParameter("refreshCallerType");
        }
        if (StringUtils.equals((String)refreshCallerType, (String)"MULTI_VALUE_LOOKUP")) {
            String lookupCollectionName = "";
            if (request.getParameterMap().containsKey("lookupCollectionName")) {
                lookupCollectionName = request.getParameter("lookupCollectionName");
            }
            if (StringUtils.isBlank((String)lookupCollectionName)) {
                throw new RuntimeException("Lookup collection name is required for processing multi-value lookup results");
            }
            String selectedLineValues = "";
            if (request.getParameterMap().containsKey("selectedLineValues")) {
                selectedLineValues = request.getParameter("selectedLineValues");
            }
            if (!StringUtils.isBlank((String)flashMapSelectedLineValues)) {
                selectedLineValues = flashMapSelectedLineValues;
            }
            form.getPostedView().getViewHelperService().processMultipleValueLookupResults(form.getPostedView(), form, lookupCollectionName, selectedLineValues);
        }
        if (request.getParameterMap().containsKey("referencesToRefresh")) {
            String referencesToRefresh = request.getParameter("referencesToRefresh");
            form.getPostedView().getViewHelperService().refreshReferences(form, referencesToRefresh);
        }
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=performLookup"})
    public ModelAndView performLookup(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ModuleService responsibleModuleService;
        Properties lookupParameters = form.getActionParametersAsProperties();
        String lookupObjectClassName = (String)lookupParameters.get("dataObjectClassName");
        Class<?> lookupObjectClass = null;
        try {
            lookupObjectClass = Class.forName(lookupObjectClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Unable to get class for name: " + lookupObjectClassName));
            throw new RuntimeException("Unable to get class for name: " + lookupObjectClassName, e);
        }
        String lookupParameterString = (String)lookupParameters.get("lookupParameters");
        if (lookupParameterString != null) {
            Map<String, String> lookupParameterFields = KRADUtils.getMapFromParameterString(lookupParameterString);
            for (Map.Entry<String, String> lookupParameter : lookupParameterFields.entrySet()) {
                String lookupParameterValue = LookupInquiryUtils.retrieveLookupParameterValue(form, request, lookupObjectClass, lookupParameter.getValue(), lookupParameter.getKey());
                if (!StringUtils.isNotBlank((String)lookupParameterValue)) continue;
                lookupParameters.put("lookupCriteria['" + lookupParameter.getValue() + "']", lookupParameterValue);
            }
            lookupParameters.remove("lookupParameters");
        }
        String baseLookupUrl = (String)lookupParameters.get("baseLookupUrl");
        lookupParameters.remove("baseLookupUrl");
        lookupParameters.put("methodToCall", "start");
        String autoSearchString = (String)lookupParameters.get("autoSearch");
        if (Boolean.parseBoolean(autoSearchString)) {
            lookupParameters.put("methodToCall", "search");
        }
        lookupParameters.put("returnLocation", form.getFormPostUrl());
        lookupParameters.put("returnFormKey", form.getFormKey());
        if (lookupObjectClass != null && (responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(lookupObjectClass)) != null && responsibleModuleService.isExternalizable(lookupObjectClass)) {
            String lookupUrl = responsibleModuleService.getExternalizableDataObjectLookupUrl(lookupObjectClass, lookupParameters);
            return this.performRedirect(form, lookupUrl, new Properties());
        }
        return this.performRedirect(form, baseLookupUrl, lookupParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=checkForm"})
    public ModelAndView checkForm(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        KRADServiceLocatorWeb.getViewValidationService().validateViewSimulation(form.getPostedView(), form);
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=performFieldSuggest"})
    @ResponseBody
    public AttributeQueryResult performFieldSuggest(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (Object parameterName : request.getParameterMap().keySet()) {
            if (!parameterName.toString().startsWith("queryParameter.")) continue;
            String fieldName = StringUtils.substringAfter((String)parameterName.toString(), (String)"queryParameter.");
            String fieldValue = request.getParameter(parameterName.toString());
            queryParameters.put(fieldName, fieldValue);
        }
        String queryFieldId = request.getParameter("queryFieldId");
        if (StringUtils.isBlank((String)queryFieldId)) {
            throw new RuntimeException("Unable to find id for field to perform query on under request parameter name: queryFieldId");
        }
        String queryTerm = request.getParameter("queryTerm");
        if (StringUtils.isBlank((String)queryTerm)) {
            throw new RuntimeException("Unable to find id for query term value for attribute query on under request parameter name: queryTerm");
        }
        AttributeQueryResult queryResult = KRADServiceLocatorWeb.getAttributeQueryService().performFieldSuggestQuery(form.getPostedView(), queryFieldId, queryTerm, queryParameters);
        return queryResult;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=performFieldQuery"})
    @ResponseBody
    public AttributeQueryResult performFieldQuery(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (Object parameterName : request.getParameterMap().keySet()) {
            if (!parameterName.toString().startsWith("queryParameter.")) continue;
            String fieldName = StringUtils.substringAfter((String)parameterName.toString(), (String)"queryParameter.");
            String fieldValue = request.getParameter(parameterName.toString());
            queryParameters.put(fieldName, fieldValue);
        }
        String queryFieldId = request.getParameter("queryFieldId");
        if (StringUtils.isBlank((String)queryFieldId)) {
            throw new RuntimeException("Unable to find id for field to perform query on under request parameter name: queryFieldId");
        }
        AttributeQueryResult queryResult = KRADServiceLocatorWeb.getAttributeQueryService().performFieldQuery(form.getPostedView(), queryFieldId, queryParameters);
        return queryResult;
    }

    protected boolean hasDialogBeenDisplayed(String dialogId, UifFormBase form) {
        return form.getDialogManager().hasDialogBeenDisplayed(dialogId);
    }

    protected boolean hasDialogBeenAnswered(String dialogId, UifFormBase form) {
        return form.getDialogManager().hasDialogBeenAnswered(dialogId);
    }

    protected void resetDialogStatus(String dialogId, UifFormBase form) {
        form.getDialogManager().resetDialogStatus(dialogId);
    }

    protected boolean getBooleanDialogResponse(String dialogId, UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        DialogManager dm = form.getDialogManager();
        if (!dm.hasDialogBeenAnswered(dialogId)) {
            throw new RiceRuntimeException("Dialog has not yet been answered by client. Check that hasDialogBeenAnswered(id) returns true.");
        }
        return dm.wasDialogAnswerAffirmative(dialogId);
    }

    protected String getStringDialogResponse(String dialogId, UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        DialogManager dm = form.getDialogManager();
        if (!dm.hasDialogBeenAnswered(dialogId)) {
            throw new RiceRuntimeException("Dialog has not yet been answered by client. Check that hasDialogBeenAnswered(id) returns true.");
        }
        return dm.getDialogAnswer(dialogId);
    }

    protected ModelAndView showDialog(String dialogId, UifFormBase form, HttpServletRequest request, HttpServletResponse response) {
        form.setLightboxScript("openLightboxOnLoad('" + dialogId + "');");
        form.getDialogManager().addDialog(dialogId, form.getMethodToCall());
        if (form.isAjaxRequest()) {
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEDIALOG.getKey());
            form.setUpdateComponentId(dialogId);
        }
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=returnFromLightbox"})
    public ModelAndView returnFromLightbox(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String newMethodToCall = "";
        DialogManager dm = form.getDialogManager();
        String dialogId = dm.getCurrentDialogId();
        if (dialogId == null) {
            newMethodToCall = "start";
        } else {
            dm.setDialogAnswer(dialogId, form.getDialogResponse());
            dm.setDialogExplanation(dialogId, form.getDialogExplanation());
            newMethodToCall = dm.getDialogReturnMethod(dialogId);
            dm.setCurrentDialogId(null);
        }
        Properties props = new Properties();
        props.put("methodToCall", newMethodToCall);
        props.put("viewId", form.getViewId());
        props.put("formKey", form.getFormKey());
        props.put("ajaxRequest", "false");
        return this.performRedirect(form, form.getFormPostUrl(), props);
    }

    protected ModelAndView performRedirect(UifFormBase form, String baseUrl, Properties urlParameters) {
        String redirectUrl = UrlFactory.parameterizeUrl((String)baseUrl, (Properties)urlParameters);
        return this.performRedirect(form, redirectUrl);
    }

    protected ModelAndView performRedirect(UifFormBase form, String redirectUrl) {
        ModelAndView modelAndView;
        form.setRequestRedirected(true);
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.REDIRECT.getKey());
        if (form.isAjaxRequest()) {
            modelAndView = this.getUIFModelAndView(form, form.getPageId());
            modelAndView.addObject("redirectUrl", (Object)redirectUrl);
        } else {
            modelAndView = new ModelAndView("redirect:" + redirectUrl);
        }
        return modelAndView;
    }

    protected ModelAndView getMessageView(UifFormBase form, String headerText, String messageText) {
        MessageView messageView = (MessageView)this.getViewService().getViewById("Uif-MessageView");
        messageView.setHeaderText(headerText);
        messageView.setMessageText(messageText);
        form.setViewId("Uif-MessageView");
        form.setView(messageView);
        return this.getUIFModelAndView(form);
    }

    protected ModelAndView getUIFModelAndView(UifFormBase form) {
        return this.getUIFModelAndView(form, form.getPageId());
    }

    protected ModelAndView getUIFModelAndView(UifFormBase form, String pageId) {
        return UifControllerHelper.getUIFModelAndView(form, pageId);
    }

    protected ModelAndView getUIFModelAndViewWithInit(UifFormBase form, String viewId) {
        View view = this.getViewService().getViewById(viewId);
        Assert.notNull((Object)view, (String)("View not found with id: " + viewId));
        form.setView(view);
        form.setViewId(viewId);
        return UifControllerHelper.getUIFModelAndView(form, form.getPageId());
    }

    protected ModelAndView getUIFModelAndView(UifFormBase form, Map<String, Object> additionalViewAttributes) {
        ModelAndView modelAndView = UifControllerHelper.getUIFModelAndView(form, form.getPageId());
        if (additionalViewAttributes != null) {
            for (Map.Entry<String, Object> additionalViewAttribute : additionalViewAttributes.entrySet()) {
                modelAndView.getModelMap().put((Object)additionalViewAttribute.getKey(), additionalViewAttribute.getValue());
            }
        }
        return modelAndView;
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableCsvRetrieval"}, produces={"text/csv"})
    @ResponseBody
    public String tableCsvRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug((Object)"processing csv table data request");
        return this.retrieveTableData(form, result, request, response);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableXlsRetrieval"}, produces={"application/vnd.ms-excel"})
    @ResponseBody
    public String tableXlsRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug((Object)"processing xls table data request");
        return this.retrieveTableData(form, result, request, response);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableXmlRetrieval"}, produces={"application/xml"})
    @ResponseBody
    public String tableXmlRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug((Object)"processing xml table data request");
        return this.retrieveTableData(form, result, request, response);
    }

    private String retrieveTableData(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug((Object)"processing table data request");
        String tableData = "";
        String formatType = this.getValidatedFormatType(request.getParameter("formatType"));
        String contentType = this.getContentType(formatType);
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        String formKey = request.getParameter("formKey");
        String tableId = request.getParameter("tableId");
        UifFormBase currentForm = uifFormManager.getSessionForm(formKey);
        View view = currentForm.getPostedView() != null ? currentForm.getPostedView() : currentForm.getView();
        LOG.debug((Object)"identifying table from model and form");
        tableData = view.getViewHelperService().buildExportTableData(view, currentForm, tableId, formatType);
        response.setHeader("content-type", contentType);
        response.setHeader("Content-disposition", "attachment; filename=\"export." + formatType + "\"");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        return tableData;
    }

    @RequestMapping(params={"methodToCall=retrieveCollectionPage"})
    public ModelAndView retrieveCollectionPage(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String collectionId = request.getParameter("updateComponentId");
        String pageNumber = request.getParameter("pageNumber");
        CollectionPagingHelper pagingHelper = new CollectionPagingHelper();
        pagingHelper.processPagingRequest(form.getPostedView(), collectionId, form, pageNumber);
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=retrieveOriginalComponent"})
    public ModelAndView retrieveOriginalComponent(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String componentId = request.getParameter("updateComponentId");
        form.setOriginalComponentRequest(true);
        return this.getUIFModelAndView(form);
    }

    private String getValidatedFormatType(String formatType) {
        if ("xls".equals(formatType) || "xml".equals(formatType) || "csv".equals(formatType)) {
            return formatType;
        }
        return "csv";
    }

    private String getContentType(String formatType) {
        if ("csv".equals(formatType)) {
            return "text/csv";
        }
        if ("xls".equals(formatType)) {
            return "application/vnd.ms-excel";
        }
        if ("xml".equals(formatType)) {
            return "application/xml";
        }
        return "text/csv";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableJsonRetrieval"})
    public ModelAndView tableJsonRetrieval(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String tableId = request.getParameter("tableId");
        DataTablesPagingHelper.DataTablesInputs dataTablesInputs = new DataTablesPagingHelper.DataTablesInputs(request);
        DataTablesPagingHelper pagingHelper = this.createDataTablesPagingHelperInstance(form, request);
        pagingHelper.processPagingRequest(form.getPostedView(), tableId, form, dataTablesInputs);
        HashMap<String, Object> additionalViewAttributes = new HashMap<String, Object>();
        additionalViewAttributes.put("DataTablesPagingHelper", pagingHelper);
        return this.getUIFModelAndView(form, additionalViewAttributes);
    }

    protected DataTablesPagingHelper createDataTablesPagingHelperInstance(UifFormBase form, HttpServletRequest request) {
        return new DataTablesPagingHelper();
    }
}

