/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.controller.UifControllerHelper;
import org.kuali.rice.krad.web.form.HistoryManager;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UifControllerHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = Logger.getLogger(UifControllerHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        UserSession session = KRADUtils.getUserSessionFromRequest(request);
        GlobalVariables.setUserSession(session);
        GlobalVariables.clear();
        if (request.getSession().getAttribute("historyManager") == null) {
            request.getSession().setAttribute("historyManager", (Object)new HistoryManager());
        }
        ProcessLogger.trace("pre-handle");
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        UifControllerHelper.postControllerHandle(request, response, handler, modelAndView);
        ProcessLogger.trace("post-handle");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        boolean persistFormToSession;
        ProcessLogger.trace("after-completion");
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        UifFormBase uifForm = (UifFormBase)request.getAttribute("requestForm");
        if (uifForm == null || uifForm.getView() == null && uifForm.getPostedView() == null) {
            return;
        }
        boolean bl = persistFormToSession = uifForm.getView() != null ? uifForm.getView().isPersistFormToSession() : uifForm.getPostedView().isPersistFormToSession();
        if (uifForm.isRequestRedirected() || uifForm.isUpdateNoneRequest()) {
            uifForm.setView(null);
        } else if (uifForm.isBuildViewRequest()) {
            View view = uifForm.getView();
            if (view != null) {
                view.getViewHelperService().cleanViewAfterRender(view);
            }
            uifForm.setPostedView(view);
            uifForm.setView(null);
        } else {
            View postedView = uifForm.getPostedView();
            if (postedView != null) {
                postedView.getViewHelperService().cleanViewAfterRender(postedView);
            }
        }
        if (persistFormToSession && uifFormManager != null) {
            uifFormManager.purgeForm(uifForm);
            uifFormManager.addSessionForm(uifForm);
        }
        ProcessLogger.trace("after-completion-end");
    }
}

