/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.controller.UifControllerHelper;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.IncidentReportForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class UifHandlerExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger LOG = Logger.getLogger(UifHandlerExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LOG.error((Object)"The following error was caught by the UifHandlerExceptionResolver : ", (Throwable)ex);
        LOG.error((Object)ex.getMessage(), (Throwable)ex);
        String incidentDocId = request.getParameter("document.documentNumber");
        String incidentViewId = "";
        UifFormBase form = (UifFormBase)request.getAttribute("requestForm");
        if (form instanceof DocumentFormBase) {
            if (((DocumentFormBase)form).getDocument() != null) {
                incidentDocId = ((DocumentFormBase)form).getDocument().getDocumentNumber();
            }
            incidentViewId = ((DocumentFormBase)form).getViewId();
        }
        GlobalVariables.getUifFormManager().removeSessionForm(form);
        UserSession userSession = (UserSession)request.getSession().getAttribute("UserSession");
        IncidentReportForm incidentReportForm = new IncidentReportForm();
        String postUrl = request.getRequestURL().toString();
        postUrl = postUrl.substring(0, postUrl.lastIndexOf("/")) + "/incidentReport";
        incidentReportForm.setFormPostUrl(postUrl);
        incidentReportForm.setException(ex);
        incidentReportForm.setIncidentDocId(incidentDocId);
        incidentReportForm.setIncidentViewId(incidentViewId);
        incidentReportForm.setController(handler.getClass().toString());
        if (userSession != null) {
            incidentReportForm.setUserId(userSession.getPrincipalId());
            incidentReportForm.setUserName(userSession.getPrincipalName());
            incidentReportForm.setUserEmail(userSession.getPerson().getEmailAddress());
        }
        incidentReportForm.setDevMode(!KRADUtils.isProductionEnvironment());
        incidentReportForm.setViewId("Uif-IncidentReportView");
        if (form != null) {
            incidentReportForm.setAjaxRequest(form.isAjaxRequest());
        } else {
            String ajaxRequestParm = request.getParameter("ajaxRequest");
            if (StringUtils.isNotBlank((String)ajaxRequestParm)) {
                incidentReportForm.setAjaxRequest(Boolean.parseBoolean(ajaxRequestParm));
            }
        }
        incidentReportForm.setView(this.getViewService().getViewById("Uif-IncidentReportView"));
        incidentReportForm.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEVIEW.getKey());
        ModelAndView modelAndView = UifControllerHelper.getUIFModelAndView(incidentReportForm, "");
        try {
            UifControllerHelper.postControllerHandle(request, response, handler, modelAndView);
        }
        catch (Exception e) {
            LOG.error((Object)"An error stopped the incident form from loading", (Throwable)e);
        }
        return modelAndView;
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }
}

