/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.lookup.Lookupable;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.view.LookupView;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

public class LookupForm
extends UifFormBase {
    private static final long serialVersionUID = -7323484966538685327L;
    private static final Logger LOG = Logger.getLogger(LookupForm.class);
    private String dataObjectClassName;
    private String docNum;
    private String referencesToRefresh;
    private boolean multipleValuesSelect;
    private String lookupCollectionName;
    private Map<String, String> lookupCriteria;
    private Map<String, String> fieldConversions;
    private Collection<?> lookupResults;
    private boolean atLeastOneRowReturnable;
    private boolean atLeastOneRowHasActions;
    private boolean redirectedLookup;

    public LookupForm() {
        this.setViewTypeName(UifConstants.ViewType.LOOKUP);
        this.atLeastOneRowReturnable = false;
        this.atLeastOneRowHasActions = false;
        this.multipleValuesSelect = false;
        this.redirectedLookup = false;
        this.lookupCriteria = new HashMap<String, String>();
        this.fieldConversions = new HashMap<String, String>();
    }

    @Override
    public void postBind(HttpServletRequest request) {
        super.postBind(request);
        try {
            Lookupable lookupable = this.getLookupable();
            if (lookupable == null) {
                return;
            }
            if (StringUtils.isBlank((String)this.getDataObjectClassName())) {
                this.setDataObjectClassName(((LookupView)this.getView()).getDataObjectClassName().getName());
            }
            Class<?> dataObjectClass = Class.forName(this.getDataObjectClassName());
            lookupable.setDataObjectClass(dataObjectClass);
            if (request.getMethod().equals("GET")) {
                if (request.getParameter("conversionFields") != null) {
                    String conversionFields = request.getParameter("conversionFields");
                    this.setFieldConversions(KRADUtils.convertStringParameterToMap(conversionFields));
                }
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                if (this.getLookupCriteria() != null) {
                    for (Map.Entry<String, String> entry : this.getLookupCriteria().entrySet()) {
                        fieldValues.put(entry.getKey(), LookupUtils.forceUppercase(dataObjectClass, entry.getKey(), entry.getValue()));
                    }
                }
                if (StringUtils.isNotBlank((String)this.getDocNum())) {
                    fieldValues.put("docNum", this.getDocNum());
                }
                this.setLookupCriteria(fieldValues);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Object class " + this.getDataObjectClassName() + " not found"));
            throw new RuntimeException("Object class " + this.getDataObjectClassName() + " not found", e);
        }
    }

    public Lookupable getLookupable() {
        if (this.getView() != null && this.getView().getViewHelperService() != null && Lookupable.class.isAssignableFrom(this.getView().getViewHelperService().getClass())) {
            return (Lookupable)this.getView().getViewHelperService();
        }
        if (this.getPostedView() != null && this.getPostedView().getViewHelperService() != null && Lookupable.class.isAssignableFrom(this.getPostedView().getViewHelperService().getClass())) {
            return (Lookupable)this.getPostedView().getViewHelperService();
        }
        return null;
    }

    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public String getDocNum() {
        return this.docNum;
    }

    public void setDocNum(String docNum) {
        this.docNum = docNum;
    }

    public String getReferencesToRefresh() {
        return this.referencesToRefresh;
    }

    public void setReferencesToRefresh(String referencesToRefresh) {
        this.referencesToRefresh = referencesToRefresh;
    }

    public boolean isMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    public String getLookupCollectionName() {
        return this.lookupCollectionName;
    }

    public void setLookupCollectionName(String lookupCollectionName) {
        this.lookupCollectionName = lookupCollectionName;
    }

    public Map<String, String> getLookupCriteria() {
        return this.lookupCriteria;
    }

    public void setLookupCriteria(Map<String, String> lookupCriteria) {
        this.lookupCriteria = lookupCriteria;
    }

    public Map<String, String> getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(Map<String, String> fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    public Collection<?> getLookupResults() {
        return this.lookupResults;
    }

    public void setLookupResults(Collection<?> lookupResults) {
        this.lookupResults = lookupResults;
    }

    public boolean isAtLeastOneRowReturnable() {
        return this.atLeastOneRowReturnable;
    }

    public void setAtLeastOneRowReturnable(boolean atLeastOneRowReturnable) {
        this.atLeastOneRowReturnable = atLeastOneRowReturnable;
    }

    public boolean isAtLeastOneRowHasActions() {
        return this.atLeastOneRowHasActions;
    }

    public void setAtLeastOneRowHasActions(boolean atLeastOneRowHasActions) {
        this.atLeastOneRowHasActions = atLeastOneRowHasActions;
    }

    public boolean isRedirectedLookup() {
        return this.redirectedLookup;
    }

    public void setRedirectedLookup(boolean redirectedLookup) {
        this.redirectedLookup = redirectedLookup;
    }
}

