/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.util.SessionTransient;
import org.kuali.rice.krad.uif.view.DialogManager;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.HistoryFlow;
import org.kuali.rice.krad.web.form.HistoryManager;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.web.multipart.MultipartFile;

public class UifFormBase
implements ViewModel {
    private static final long serialVersionUID = 8432543267099454434L;
    private static final Log LOG = LogFactory.getLog(UifFormBase.class);
    protected String viewId;
    protected String viewName;
    protected UifConstants.ViewType viewTypeName;
    protected String pageId;
    protected String methodToCall;
    protected String formKey;
    @SessionTransient
    protected String requestedFormKey;
    protected String flowKey;
    protected String sessionId;
    protected int sessionTimeoutInterval;
    @SessionTransient
    protected HistoryFlow historyFlow;
    @SessionTransient
    protected HistoryManager historyManager;
    @SessionTransient
    protected String jumpToId;
    @SessionTransient
    protected String jumpToName;
    @SessionTransient
    protected String focusId;
    @SessionTransient
    protected boolean dirtyForm;
    protected String formPostUrl;
    protected String controllerMapping;
    @SessionTransient
    private String requestUrl;
    private Map<String, String> initialRequestParameters;
    protected String state;
    protected boolean defaultsApplied = false;
    protected boolean renderedInLightBox = false;
    @SessionTransient
    protected String growlScript;
    @SessionTransient
    protected String lightboxScript;
    protected View view;
    protected View postedView;
    protected Map<String, String> viewRequestParameters;
    protected List<String> readOnlyFieldsList = new ArrayList<String>();
    protected Map<String, Object> newCollectionLines;
    @SessionTransient
    protected Map<String, String> actionParameters;
    protected Map<String, Object> clientStateForSyncing;
    @SessionTransient
    protected Map<String, Set<String>> selectedCollectionLines;
    protected List<Object> addedCollectionItems;
    @SessionTransient
    protected MultipartFile attachmentFile;
    protected String returnLocation;
    protected String returnFormKey;
    @SessionTransient
    protected boolean ajaxRequest;
    @SessionTransient
    protected String ajaxReturnType;
    @SessionTransient
    private String requestJsonTemplate;
    @SessionTransient
    private boolean originalComponentRequest;
    @SessionTransient
    protected String dialogExplanation;
    @SessionTransient
    protected String dialogResponse;
    protected DialogManager dialogManager;
    @SessionTransient
    protected boolean requestRedirected = false;
    @SessionTransient
    protected String updateComponentId;
    protected Map<String, Object> extensionData;

    public UifFormBase() {
        this.viewRequestParameters = new HashMap<String, String>();
        this.newCollectionLines = new HashMap<String, Object>();
        this.actionParameters = new HashMap<String, String>();
        this.clientStateForSyncing = new HashMap<String, Object>();
        this.selectedCollectionLines = new HashMap<String, Set<String>>();
        this.addedCollectionItems = new ArrayList<Object>();
        this.dialogManager = new DialogManager();
        this.extensionData = new HashMap<String, Object>();
    }

    @Override
    public void postBind(HttpServletRequest request) {
        String clientStateJSON;
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        if (StringUtils.isBlank((String)this.formKey) || !uifFormManager.hasSessionForm(this.formKey)) {
            this.formKey = this.generateFormKey();
        }
        this.formPostUrl = request.getRequestURL().toString();
        if (request.getSession() != null) {
            this.sessionId = request.getSession().getId();
            this.sessionTimeoutInterval = request.getSession().getMaxInactiveInterval();
        }
        this.controllerMapping = request.getPathInfo();
        if (request.getParameterMap().containsKey("clientViewState") && StringUtils.isNotBlank((String)(clientStateJSON = request.getParameter("clientViewState")))) {
            clientStateJSON = StringUtils.replace((String)clientStateJSON, (String)"'", (String)"\"");
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.clientStateForSyncing = (Map)mapper.readValue(clientStateJSON, Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to decode client side state JSON", e);
            }
        }
        if (request.getParameter("readOnlyFields") != null) {
            String readOnlyFields = request.getParameter("readOnlyFields");
            this.setReadOnlyFieldsList(KRADUtils.convertStringParameterToList(readOnlyFields));
        }
        this.pageId = KRADUtils.stripXSSPatterns(this.pageId);
        this.methodToCall = KRADUtils.stripXSSPatterns(this.methodToCall);
        this.formKey = KRADUtils.stripXSSPatterns(this.formKey);
        this.requestedFormKey = KRADUtils.stripXSSPatterns(this.requestedFormKey);
        this.flowKey = KRADUtils.stripXSSPatterns(this.flowKey);
        this.sessionId = KRADUtils.stripXSSPatterns(this.sessionId);
        this.formPostUrl = KRADUtils.stripXSSPatterns(this.formPostUrl);
        this.returnLocation = KRADUtils.stripXSSPatterns(this.returnLocation);
        this.returnFormKey = KRADUtils.stripXSSPatterns(this.returnFormKey);
        this.requestUrl = KRADUtils.stripXSSPatterns(this.requestUrl);
    }

    protected String generateFormKey() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public UifConstants.ViewType getViewTypeName() {
        return this.viewTypeName;
    }

    @Override
    public void setViewTypeName(UifConstants.ViewType viewTypeName) {
        this.viewTypeName = viewTypeName;
    }

    @Override
    public String getPageId() {
        return this.pageId;
    }

    @Override
    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    @Override
    public String getFormPostUrl() {
        return this.formPostUrl;
    }

    @Override
    public void setFormPostUrl(String formPostUrl) {
        this.formPostUrl = formPostUrl;
    }

    public String getControllerMapping() {
        return this.controllerMapping;
    }

    public HistoryFlow getHistoryFlow() {
        return this.historyFlow;
    }

    public void setHistoryFlow(HistoryFlow historyFlow) {
        this.historyFlow = historyFlow;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public void setHistoryManager(HistoryManager historyManager) {
        this.historyManager = historyManager;
    }

    public String getFlowKey() {
        return this.flowKey;
    }

    public void setFlowKey(String flowKey) {
        this.flowKey = flowKey;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public Map<String, String> getInitialRequestParameters() {
        return this.initialRequestParameters;
    }

    public void setInitialRequestParameters(Map<String, String> requestParameters) {
        this.initialRequestParameters = requestParameters;
    }

    public String getReturnLocation() {
        return this.returnLocation;
    }

    public void setReturnLocation(String returnLocation) {
        this.returnLocation = returnLocation;
    }

    public String getReturnFormKey() {
        return this.returnFormKey;
    }

    public void setReturnFormKey(String returnFormKey) {
        this.returnFormKey = returnFormKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getSessionTimeoutInterval() {
        return this.sessionTimeoutInterval;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    @Override
    public Map<String, String> getViewRequestParameters() {
        return this.viewRequestParameters;
    }

    @Override
    public void setViewRequestParameters(Map<String, String> viewRequestParameters) {
        this.viewRequestParameters = viewRequestParameters;
    }

    @Override
    public List<String> getReadOnlyFieldsList() {
        return this.readOnlyFieldsList;
    }

    @Override
    public void setReadOnlyFieldsList(List<String> readOnlyFieldsList) {
        this.readOnlyFieldsList = readOnlyFieldsList;
    }

    @Override
    public Map<String, Object> getNewCollectionLines() {
        return this.newCollectionLines;
    }

    @Override
    public void setNewCollectionLines(Map<String, Object> newCollectionLines) {
        this.newCollectionLines = newCollectionLines;
    }

    @Override
    public Map<String, String> getActionParameters() {
        return this.actionParameters;
    }

    public Properties getActionParametersAsProperties() {
        return KRADUtils.convertMapToProperties(this.actionParameters);
    }

    @Override
    public void setActionParameters(Map<String, String> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public String getActionParamaterValue(String actionParameterName) {
        if (this.actionParameters != null && this.actionParameters.containsKey(actionParameterName)) {
            return this.actionParameters.get(actionParameterName);
        }
        return "";
    }

    public String getActionEvent() {
        if (this.actionParameters != null && this.actionParameters.containsKey("actionEvent")) {
            return this.actionParameters.get("actionEvent");
        }
        return "";
    }

    @Override
    public Map<String, Object> getClientStateForSyncing() {
        return this.clientStateForSyncing;
    }

    public void setClientStateForSyncing(Map<String, Object> clientStateForSyncing) {
        this.clientStateForSyncing = clientStateForSyncing;
    }

    @Override
    public Map<String, Set<String>> getSelectedCollectionLines() {
        return this.selectedCollectionLines;
    }

    @Override
    public void setSelectedCollectionLines(Map<String, Set<String>> selectedCollectionLines) {
        this.selectedCollectionLines = selectedCollectionLines;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getRequestedFormKey() {
        return this.requestedFormKey;
    }

    public void setRequestedFormKey(String requestedFormKey) {
        this.requestedFormKey = requestedFormKey;
    }

    @Override
    public boolean isDefaultsApplied() {
        return this.defaultsApplied;
    }

    @Override
    public void setDefaultsApplied(boolean defaultsApplied) {
        this.defaultsApplied = defaultsApplied;
    }

    public boolean isRequestRedirected() {
        return this.requestRedirected;
    }

    public void setRequestRedirected(boolean requestRedirected) {
        this.requestRedirected = requestRedirected;
    }

    public MultipartFile getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(MultipartFile attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    @Override
    public String getUpdateComponentId() {
        return this.updateComponentId;
    }

    @Override
    public void setUpdateComponentId(String updateComponentId) {
        this.updateComponentId = updateComponentId;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void setView(View view) {
        this.view = view;
    }

    @Override
    public View getPostedView() {
        return this.postedView;
    }

    @Override
    public void setPostedView(View postedView) {
        this.postedView = postedView;
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }

    public String getJumpToId() {
        return this.jumpToId;
    }

    public void setJumpToId(String jumpToId) {
        this.jumpToId = jumpToId;
    }

    public String getJumpToName() {
        return this.jumpToName;
    }

    public void setJumpToName(String jumpToName) {
        this.jumpToName = jumpToName;
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public boolean isDirtyForm() {
        return this.dirtyForm;
    }

    public void setDirtyForm(boolean dirtyForm) {
        this.dirtyForm = dirtyForm;
    }

    public void setDirtyForm(String dirtyForm) {
        if (dirtyForm != null) {
            this.dirtyForm = Boolean.parseBoolean(dirtyForm);
        }
    }

    public boolean isRenderedInLightBox() {
        return this.renderedInLightBox;
    }

    public void setRenderedInLightBox(boolean renderedInLightBox) {
        this.renderedInLightBox = renderedInLightBox;
    }

    @Override
    public String getGrowlScript() {
        return this.growlScript;
    }

    @Override
    public void setGrowlScript(String growlScript) {
        this.growlScript = growlScript;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getLightboxScript() {
        return this.lightboxScript;
    }

    @Override
    public void setLightboxScript(String lightboxScript) {
        this.lightboxScript = lightboxScript;
    }

    @Override
    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    @Override
    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    @Override
    public String getAjaxReturnType() {
        return this.ajaxReturnType;
    }

    @Override
    public boolean isUpdateComponentRequest() {
        return this.isAjaxRequest() && StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
    }

    @Override
    public boolean isUpdateDialogRequest() {
        return this.isAjaxRequest() && StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATEDIALOG.getKey());
    }

    @Override
    public boolean isUpdatePageRequest() {
        return this.isAjaxRequest() && StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
    }

    @Override
    public boolean isUpdateNoneRequest() {
        return this.isAjaxRequest() && StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATENONE.getKey());
    }

    @Override
    public boolean isBuildViewRequest() {
        return !this.isAjaxRequest() || StringUtils.isNotBlank((String)this.getAjaxReturnType()) && (this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATEVIEW.getKey()) || this.isUpdatePageRequest());
    }

    @Override
    public boolean isUpdateViewRequest() {
        return this.isAjaxRequest() && StringUtils.isNotBlank((String)this.getAjaxReturnType()) && (this.isUpdateComponentRequest() || this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.DISPLAYLIGHTBOX.getKey()));
    }

    @Override
    public void setAjaxReturnType(String ajaxReturnType) {
        this.ajaxReturnType = ajaxReturnType;
    }

    @Override
    public boolean isJsonRequest() {
        return StringUtils.isNotBlank((String)this.getRequestJsonTemplate());
    }

    @Override
    public String getRequestJsonTemplate() {
        return this.requestJsonTemplate;
    }

    @Override
    public void setRequestJsonTemplate(String requestJsonTemplate) {
        this.requestJsonTemplate = requestJsonTemplate;
    }

    public boolean isOriginalComponentRequest() {
        return this.originalComponentRequest;
    }

    public void setOriginalComponentRequest(boolean originalComponentRequest) {
        this.originalComponentRequest = originalComponentRequest;
    }

    public String getDialogExplanation() {
        return this.dialogExplanation;
    }

    public void setDialogExplanation(String dialogExplanation) {
        this.dialogExplanation = dialogExplanation;
    }

    public String getDialogResponse() {
        return this.dialogResponse;
    }

    public void setDialogResponse(String dialogResponse) {
        this.dialogResponse = dialogResponse;
    }

    public DialogManager getDialogManager() {
        return this.dialogManager;
    }

    public void setDialogManager(DialogManager dialogManager) {
        this.dialogManager = dialogManager;
    }

    @Override
    public Map<String, Object> getExtensionData() {
        return this.extensionData;
    }

    @Override
    public void setExtensionData(Map<String, Object> extensionData) {
        this.extensionData = extensionData;
    }

    public List getAddedCollectionItems() {
        return this.addedCollectionItems;
    }

    public void setAddedCollectionItems(List addedCollectionItems) {
        this.addedCollectionItems = addedCollectionItems;
    }

    public boolean isAddedCollectionItem(Object item) {
        return this.addedCollectionItems.contains(item);
    }
}

