/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.login;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.login.DummyLoginForm;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/login"})
public class DummyLoginController
extends UifControllerBase {
    @Override
    protected UifFormBase createInitialForm(HttpServletRequest request) {
        return new DummyLoginForm();
    }

    @Override
    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        if (form.getView() != null) {
            String methodToCall = request.getParameter("methodToCall");
            this.checkViewAuthorization(form, methodToCall);
        }
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=submit"})
    public ModelAndView submit(@ModelAttribute(value="KualiForm") DummyLoginForm uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String returnUrl = this.decode(uifForm.getReturnLocation());
        if (StringUtils.isBlank((String)returnUrl)) {
            returnUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        }
        Properties props = new Properties();
        String user = uifForm.getLogin_user();
        props.put("__login_user", user);
        String password = uifForm.getLogin_pw();
        if (StringUtils.isNotBlank((String)password)) {
            props.put("__login_pw", password);
        }
        return this.performRedirect(uifForm, returnUrl, props);
    }

    private String decode(String encodedUrl) {
        try {
            return URLDecoder.decode(encodedUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to decode value: " + encodedUrl, e);
        }
    }
}

