/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.framework.resourceloader.BeanFactoryResourceLoader;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.bo.test.TestEBOInterface;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.impl.ModuleServiceBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ModuleServiceBaseTest {
    private ModuleServiceBase module = new ModuleServiceBase();
    private ModuleConfiguration config = new ModuleConfiguration();
    @Mock
    private KualiModuleService kualiModuleService;
    private List<ModuleService> installedModuleServices = new ArrayList<ModuleService>();

    @Before
    public void initGRL() throws Exception {
        GlobalResourceLoader.stop();
        SimpleConfig config = new SimpleConfig();
        config.putProperty("application.id", "APPID");
        ConfigContext.init((Config)config);
        StaticListableBeanFactory testBf = new StaticListableBeanFactory();
        Mockito.when((Object)this.kualiModuleService.getInstalledModuleServices()).thenReturn(this.installedModuleServices);
        testBf.addBean("providerRegistry", Mockito.mock(ProviderRegistry.class));
        testBf.addBean("kualiModuleService", (Object)this.kualiModuleService);
        BeanFactoryResourceLoader rl = new BeanFactoryResourceLoader(new QName("moduleservicebase-unittest"), (BeanFactory)testBf);
        GlobalResourceLoader.addResourceLoader((ResourceLoader)rl);
        GlobalResourceLoader.start();
    }

    @Before
    public void setup() {
        this.config.setNamespaceCode("moduleconfiguration-unittest");
        this.config.setDatabaseRepositoryFilePaths(Arrays.asList("path1", "path2"));
        this.config.setDataDictionaryPackages(Arrays.asList("ddpackage1", "ddpackage2"));
        this.config.setPackagePrefixes(Arrays.asList(TestEBOInterface.class.getPackage().getName(), this.getClass().getPackage().getName()));
        PersistenceProvider pp = (PersistenceProvider)Mockito.mock(PersistenceProvider.class);
        Mockito.when((Object)pp.handles(DataObject.class)).thenReturn((Object)true);
        this.config.setProviders(Arrays.asList(pp));
        this.module.setModuleConfiguration(this.config);
    }

    @Test
    public void testRegistersWithKualiModuleService() throws Exception {
        this.module.afterPropertiesSet();
        Assert.assertTrue((boolean)this.installedModuleServices.contains(this.module));
    }

    @Test
    public void testNotResponsibleForNullClass() {
        Assert.assertFalse((boolean)this.module.isResponsibleFor(null));
    }

    @Test
    public void testIsResponsibleForClassByPackagePrefix() {
        Assert.assertTrue((boolean)this.module.isResponsibleFor(TestEBOInterface.class));
    }

    @Test
    public void testIsResponsibleForClassByProvider() {
        Assert.assertTrue((boolean)this.module.isResponsibleFor(DataObject.class));
    }

    @Test
    public void testIsResponsibleForEBOSubclass() {
        Assert.assertTrue((boolean)this.module.isResponsibleFor(ModuleServiceBaseTestEBO.class));
    }

    @Test
    public void testIsResponsibleForEBOInterface() {
        Assert.assertTrue((boolean)this.module.isResponsibleFor(ModuleServiceBaseTestEBOInterface.class));
    }

    private static class DataObject {
        private DataObject() {
        }
    }

    private static interface ModuleServiceBaseTestEBOInterface
    extends TestEBOInterface {
    }

    private static class ModuleServiceBaseTestEBO
    implements TestEBOInterface {
        private ModuleServiceBaseTestEBO() {
        }

        public void refresh() {
        }
    }
}

