/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.validation.Person;
import org.kuali.rice.krad.datadictionary.validation.ValidationUtils;

public class NullOrEmptyTest {
    @Test
    public void testNullObject() {
        Object person = null;
        Assert.assertTrue((boolean)ValidationUtils.isNullOrEmpty(person));
    }

    @Test
    public void testNotNullObject() {
        Person person = new Person();
        Assert.assertFalse((boolean)ValidationUtils.isNullOrEmpty((Object)person));
    }

    @Test
    public void testStringEmpty() {
        String message = "";
        Assert.assertTrue((boolean)ValidationUtils.isNullOrEmpty((Object)message));
    }

    @Test
    public void testStringNotEmpty() {
        String message = "Hi";
        Assert.assertFalse((boolean)ValidationUtils.isNullOrEmpty((Object)message));
    }

    @Test
    public void testListEmpty() {
        ArrayList quickList = new ArrayList();
        Assert.assertTrue((boolean)ValidationUtils.isNullOrEmpty(quickList));
    }

    @Test
    public void testListNotEmpty() {
        ArrayList<String> quickList = new ArrayList<String>();
        quickList.add("Hi");
        Assert.assertFalse((boolean)ValidationUtils.isNullOrEmpty(quickList));
    }

    @Test
    public void testSetEmpty() {
        HashSet quickSet = new HashSet();
        Assert.assertTrue((boolean)ValidationUtils.isNullOrEmpty(quickSet));
    }

    @Test
    public void testSetNotEmpty() {
        HashSet<String> quickSet = new HashSet<String>();
        quickSet.add("Hi");
        Assert.assertFalse((boolean)ValidationUtils.isNullOrEmpty(quickSet));
    }

    @Test
    public void testMapEmpty() {
        HashMap quickMap = new HashMap();
        Assert.assertTrue((boolean)ValidationUtils.isNullOrEmpty(quickMap));
    }

    @Test
    public void testMapNotEmpty() {
        HashMap<String, String> quickMap = new HashMap<String, String>();
        quickMap.put("Hi", "There!");
        Assert.assertFalse((boolean)ValidationUtils.isNullOrEmpty(quickMap));
    }
}

