/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;
import org.mockito.Mockito;

public class FieldBaseTest {
    View view = null;

    @Before
    public void setUp() {
        this.view = (View)Mockito.mock(View.class);
        ViewHelperService mockViewHelperService = (ViewHelperService)Mockito.mock(ViewHelperService.class);
        Mockito.when((Object)this.view.getViewHelperService()).thenReturn((Object)mockViewHelperService);
    }

    @Test
    public void testRequiredMessageDisplay() throws Exception {
        ViewLifecycle.encapsulateLifecycle((View)this.view, null, null, (Runnable)new Runnable(){

            @Override
            public void run() {
                Object nullModel = null;
                Component mockComponent = (Component)Mockito.mock(Component.class);
                Label mockLabel = new Label();
                Message message = new Message();
                message.setMessageText("*");
                message.setRender(true);
                FieldBase fieldBase = new FieldBase();
                fieldBase.setFieldLabel(mockLabel);
                fieldBase.setRequired(Boolean.valueOf(true));
                fieldBase.setReadOnly(Boolean.valueOf(false));
                FieldBase fieldBaseCopy = (FieldBase)CopyUtils.copy((Copyable)fieldBase);
                fieldBaseCopy.performFinalize(nullModel, (LifecycleElement)mockComponent);
                Assert.assertTrue((boolean)fieldBaseCopy.getFieldLabel().isRenderRequiredIndicator());
                fieldBaseCopy = (FieldBase)CopyUtils.copy((Copyable)fieldBase);
                fieldBaseCopy.setReadOnly(Boolean.valueOf(true));
                fieldBaseCopy.performFinalize(nullModel, (LifecycleElement)mockComponent);
                Assert.assertFalse((boolean)fieldBaseCopy.getFieldLabel().isRenderRequiredIndicator());
            }
        });
    }
}

