/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.io.FileNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.lifecycle.RenderComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ProcessLoggingUnitTest;
import org.kuali.rice.krad.uif.util.UifUnitTestUtils;
import org.kuali.rice.krad.uif.view.View;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;

public class ComponentFreemarkerTest
extends ProcessLoggingUnitTest {
    @BeforeClass
    public static void setUpClass() throws Throwable {
        UifUnitTestUtils.establishMockConfig("KRAD-ComponentFreemarkerTest");
    }

    @AfterClass
    public static void tearDownClass() throws Throwable {
        UifUnitTestUtils.tearDownMockConfig();
    }

    @Test
    public void testHtmlOutput() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        View view = (View)Mockito.mock(View.class);
        ViewLifecycle.encapsulateLifecycle((View)view, (Object)new Object(), (HttpServletRequest)request, (Runnable)new Runnable(){

            @Override
            public void run() {
                Message msg = (Message)CopyUtils.copy((Copyable)ComponentFactory.getMessage());
                msg.setMessageText("foobar");
                msg.setId("_naps");
                msg.setWrapperTag("pans");
                msg.setViewStatus("F");
                RenderComponentPhase renderPhase = (RenderComponentPhase)KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase("RENDER", (LifecycleElement)msg, null, "", null);
                try {
                    ViewLifecycle.getProcessor().performPhase((ViewLifecyclePhase)renderPhase);
                }
                catch (IllegalStateException e) {
                    if (e.getCause() instanceof FileNotFoundException) {
                        Assume.assumeNoException((Throwable)e.getCause());
                    }
                    throw e;
                }
                Assert.assertTrue((boolean)msg.isSelfRendered());
                Assert.assertEquals((Object)"<pans id=\"_naps\" class=\"uif-message\"     >\r\nfoobar  </pans>", (Object)msg.getRenderedHtmlOutput().trim());
            }
        });
    }
}

