/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.test.TestForm;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.bind.UifBeanPropertyBindingResult;
import org.kuali.rice.krad.web.bind.UifViewBeanWrapper;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;

public class UifViewBeanWrapperTest {
    private UifViewBeanWrapper beanWrapper;

    @Before
    public void setUp() throws Exception {
        TestForm model = new TestForm();
        model.setMethodToCall("field7TestMethodToCall");
        UifBeanPropertyBindingResult bindingResult = new UifBeanPropertyBindingResult((Object)model, "model", true, 100);
        this.beanWrapper = new UifViewBeanWrapper((ViewModel)model, bindingResult);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("POST");
        request.addParameter("methodToCall", "field7TestMethodToCall");
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletWebRequest((HttpServletRequest)request));
    }

    @Test
    public void testCheckForAnnotationInPropertyPath() {
        this.assertBindingAnnotationsInPath("Annotation on simple form property not picked up", "field1", Boolean.TRUE);
        this.assertBindingAnnotationsInPath("Annotation on simple form property not picked up", "field2", Boolean.FALSE);
        this.assertBindingAnnotationsInPath("Annotation picked up where not present", "field3", null);
        this.assertBindingAnnotationsInPath("Annotation on nested property not picked up", "dataObject.field5", Boolean.FALSE);
        this.assertBindingAnnotationsInPath("Annotation picked up on nested property where not present", "dataObject.field1", null);
        this.assertBindingAnnotationsInPath("Annotation on nested property not picked up", "dataObject.nestedObject.field1", Boolean.TRUE);
        this.assertBindingAnnotationsInPath("Annotation not correctly picked up for multiple annotations", "dataObject.nestedObject.field5", Boolean.FALSE);
        this.assertBindingAnnotationsInPath("Annotation on nested list property not picked up", "dataObject.list[0].field5", Boolean.FALSE);
        this.assertBindingAnnotationsInPath("Annotation on nested list property picked up where not present", "dataObject.list[0].field1", null);
        this.assertBindingAnnotationsInPath("Annotation on map property not picked up", "dataObject.map['key']", Boolean.TRUE);
        this.assertBindingAnnotationsInPath("Annotation on accessible list property not picked up", "dataObject.list2[3].field7", Boolean.TRUE);
        this.assertBindingAnnotationsInPath("Annotation picked up for wrong request method", "field4", null);
        this.assertBindingAnnotationsInPath("Annotation picked up for wrong request method", "field7", Boolean.TRUE);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("GET");
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletWebRequest((HttpServletRequest)request));
        this.assertBindingAnnotationsInPath("Annotation not picked up for correct request method", "field4", Boolean.TRUE);
        this.assertBindingAnnotationsInPath("Annotation not picked up for multiple request methods", "dataObject.field8", Boolean.TRUE);
    }

    protected void assertBindingAnnotationsInPath(String failureMessage, String path, Boolean result) {
        Boolean bindingAnnotationAccess = this.beanWrapper.checkBindingAnnotationsInPath(path);
        Assert.assertEquals((String)failureMessage, (Object)result, (Object)bindingAnnotationAccess);
    }

    @Test
    public void testCheckPropertyAccess() {
        ViewPostMetadata viewPostMetadata = new ViewPostMetadata();
        ((ViewModel)this.beanWrapper.getWrappedInstance()).setViewPostMetadata(viewPostMetadata);
        viewPostMetadata.addAccessibleBindingPath("field5");
        viewPostMetadata.addAccessibleBindingPath("dataObject.field1");
        viewPostMetadata.addAccessibleBindingPath("dataObject.list[3].field3");
        viewPostMetadata.addAccessibleBindingPath("dataObject.list[3].list[2].field3");
        this.assertPropertyBindingAccess("Access not granted for view binding path", "field5", true);
        this.assertPropertyBindingAccess("Access granted for path without annotation and not in view", "field6", false);
        this.assertPropertyBindingAccess("Access not granted for path with accessible annotation", "field1", true);
        this.assertPropertyBindingAccess("Access granted for path with protected annotation", "field2", false);
        this.assertPropertyBindingAccess("Access not granted for nested view binding path", "dataObject.field1", true);
        this.assertPropertyBindingAccess("Access not granted for nested view binding path", "dataObject.list[3].field3", true);
        this.assertPropertyBindingAccess("Access not granted for nested view binding path", "dataObject.list[3].list[2].field3", true);
        this.assertPropertyBindingAccess("Access granted for path without annotation and not in view", "dataObject.list[3].list[1].field3", false);
    }

    protected void assertPropertyBindingAccess(String failureMessage, String path, boolean access) {
        boolean isPropertyAccessible = this.beanWrapper.checkPropertyBindingAccess(path);
        Assert.assertEquals((String)failureMessage, (Object)access, (Object)isPropertyAccessible);
    }
}

