/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;

public class ValidationUtils {
    public static String buildPath(String attributePath, String attributeName) {
        if (StringUtils.isNotBlank((String)attributeName)) {
            if (StringUtils.isNotBlank((String)attributePath)) {
                return attributePath + "." + attributeName;
            }
            return attributeName;
        }
        return attributePath;
    }

    public static int getLastPathIndex(String attributePath) {
        int index = -1;
        int leftBracket = attributePath.lastIndexOf("[");
        int rightBracket = attributePath.lastIndexOf("]");
        if (leftBracket > 0 && rightBracket > leftBracket) {
            String indexString = attributePath.substring(leftBracket + 1, rightBracket);
            try {
                index = Integer.valueOf(indexString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return index;
    }

    public static boolean compareValues(Object fieldValue, Object whenValue, DataType dataType, String operator, boolean isCaseSensitive, DateTimeService dateTimeService) {
        boolean result = false;
        Integer compareResult = null;
        if ("has_value".equalsIgnoreCase(operator)) {
            if (fieldValue == null) {
                return "false".equals(whenValue.toString().toLowerCase());
            }
            if (fieldValue instanceof String && ((String)fieldValue).isEmpty()) {
                return "false".equals(whenValue.toString().toLowerCase());
            }
            if (fieldValue instanceof Collection && ((Collection)fieldValue).isEmpty()) {
                return "false".equals(whenValue.toString().toLowerCase());
            }
            return "true".equals(whenValue.toString().toLowerCase());
        }
        if (null != dataType) {
            if (DataType.STRING.equals((Object)dataType)) {
                String v1 = ValidationUtils.getString(fieldValue);
                String v2 = ValidationUtils.getString(whenValue);
                if (!isCaseSensitive) {
                    v1 = v1.toUpperCase();
                    v2 = v2.toUpperCase();
                }
                compareResult = v1.compareTo(v2);
            } else if (DataType.INTEGER.equals((Object)dataType)) {
                Integer v1 = ValidationUtils.getInteger(fieldValue);
                Integer v2 = ValidationUtils.getInteger(whenValue);
                compareResult = v1.compareTo(v2);
            } else if (DataType.LONG.equals((Object)dataType)) {
                Long v1 = ValidationUtils.getLong(fieldValue);
                Long v2 = ValidationUtils.getLong(whenValue);
                compareResult = v1.compareTo(v2);
            } else if (DataType.DOUBLE.equals((Object)dataType)) {
                Double v1 = ValidationUtils.getDouble(fieldValue);
                Double v2 = ValidationUtils.getDouble(whenValue);
                compareResult = v1.compareTo(v2);
            } else if (DataType.FLOAT.equals((Object)dataType)) {
                Float v1 = ValidationUtils.getFloat(fieldValue);
                Float v2 = ValidationUtils.getFloat(whenValue);
                compareResult = v1.compareTo(v2);
            } else if (DataType.BOOLEAN.equals((Object)dataType)) {
                Boolean v1 = ValidationUtils.getBoolean(fieldValue);
                Boolean v2 = ValidationUtils.getBoolean(whenValue);
                compareResult = v1.compareTo(v2);
            } else if (DataType.DATE.equals((Object)dataType)) {
                Date v1 = ValidationUtils.getDate(fieldValue, dateTimeService);
                Date v2 = ValidationUtils.getDate(whenValue, dateTimeService);
                compareResult = v1.compareTo(v2);
            }
        }
        if (null != compareResult) {
            if (("equals".equalsIgnoreCase(operator) || "greater_than_equal".equalsIgnoreCase(operator) || "less_than_equal".equalsIgnoreCase(operator)) && 0 == compareResult) {
                result = true;
            }
            if (("not_equal".equalsIgnoreCase(operator) || "not_equals".equalsIgnoreCase(operator) || "greater_than".equalsIgnoreCase(operator)) && compareResult >= 1) {
                result = true;
            }
            if (("not_equal".equalsIgnoreCase(operator) || "not_equals".equalsIgnoreCase(operator) || "less_than".equalsIgnoreCase(operator)) && compareResult <= -1) {
                result = true;
            }
        }
        return result;
    }

    public static Integer getInteger(Object o) {
        Integer result = null;
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        String s = o.toString();
        if (s != null && s.trim().length() > 0) {
            result = Integer.valueOf(s.trim());
        }
        return result;
    }

    public static Long getLong(Object o) {
        Long result = null;
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        String s = o.toString();
        if (s != null && s.trim().length() > 0) {
            result = Long.valueOf(s.trim());
        }
        return result;
    }

    public static Float getFloat(Object o) {
        Float result = null;
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        String s = o.toString();
        if (s != null && s.trim().length() > 0) {
            result = Float.valueOf(s.trim());
        }
        return result;
    }

    public static Double getDouble(Object o) {
        Double result = null;
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        String s = o.toString();
        if (s != null && s.trim().length() > 0) {
            result = Double.valueOf(s.trim());
        }
        return result;
    }

    public static Date getDate(Object object, DateTimeService dateTimeService) throws IllegalArgumentException {
        Date result = null;
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object == null) {
            return null;
        }
        String s = object.toString();
        if (s != null && s.trim().length() > 0) {
            try {
                result = dateTimeService.convertToDate(s.trim());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static String getString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static Boolean getBoolean(Object o) {
        Boolean result = null;
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s != null && s.trim().length() > 0) {
            result = Boolean.parseBoolean(s.trim());
        }
        return result;
    }

    public static boolean hasText(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        int stringLength = string.length();
        for (int i = 0; i < stringLength; ++i) {
            char currentChar = string.charAt(i);
            if (' ' == currentChar && '\t' == currentChar && '\n' == currentChar) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object value) {
        boolean nullOrEmpty = false;
        if (value == null) {
            nullOrEmpty = true;
        } else if (value instanceof String) {
            nullOrEmpty = StringUtils.isBlank((String)((String)value).trim());
        } else if (value instanceof List) {
            nullOrEmpty = ((List)value).isEmpty();
        } else if (value instanceof Set) {
            nullOrEmpty = ((Set)value).isEmpty();
        } else if (value instanceof Map) {
            nullOrEmpty = ((Map)value).isEmpty();
        }
        return nullOrEmpty;
    }

    public static Object convertToDataType(Object value, DataType dataType, DateTimeService dateTimeService) throws AttributeValidationException {
        Object returnValue = value;
        if (null == value) {
            return null;
        }
        switch (dataType) {
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                returnValue = Boolean.valueOf(value.toString());
                if (value.toString().equalsIgnoreCase("TRUE") || value.toString().equalsIgnoreCase("FALSE")) break;
                throw new AttributeValidationException("Value " + value.toString() + " is not a boolean!");
            }
            case INTEGER: {
                if (value instanceof Number) break;
                returnValue = Integer.valueOf(value.toString());
                break;
            }
            case LONG: {
                if (value instanceof Number) break;
                returnValue = Long.valueOf(value.toString());
                break;
            }
            case DOUBLE: {
                if (!(value instanceof Number)) {
                    returnValue = Double.valueOf(value.toString());
                }
                if (((Double)returnValue).isNaN()) {
                    throw new AttributeValidationException("Infinite Double values are not valid!");
                }
                if (!((Double)returnValue).isInfinite()) break;
                throw new AttributeValidationException("Infinite Double values are not valid!");
            }
            case FLOAT: {
                if (!(value instanceof Number)) {
                    returnValue = Float.valueOf(value.toString());
                }
                if (((Float)returnValue).isNaN()) {
                    throw new AttributeValidationException("NaN Float values are not valid!");
                }
                if (!((Float)returnValue).isInfinite()) break;
                throw new AttributeValidationException("Infinite Float values are not valid!");
            }
            case TRUNCATED_DATE: 
            case DATE: {
                if (value instanceof Date) break;
                try {
                    returnValue = dateTimeService.convertToDate(value.toString());
                    break;
                }
                catch (ParseException pe) {
                    throw new AttributeValidationException("Value " + value.toString() + " is not a date!");
                }
            }
        }
        return returnValue;
    }

    public static <T> Result isGreaterThan(T value, Comparable<T> limit) {
        return limit == null ? Result.UNDEFINED : (limit.compareTo(value) < 0 ? Result.VALID : Result.INVALID);
    }

    public static <T> Result isGreaterThanOrEqual(T value, Comparable<T> limit) {
        return limit == null ? Result.UNDEFINED : (limit.compareTo(value) <= 0 ? Result.VALID : Result.INVALID);
    }

    public static <T> Result isLessThan(T value, Comparable<T> limit) {
        return limit == null ? Result.UNDEFINED : (limit.compareTo(value) > 0 ? Result.VALID : Result.INVALID);
    }

    public static <T> Result isLessThanOrEqual(T value, Comparable<T> limit) {
        return limit == null ? Result.UNDEFINED : (limit.compareTo(value) >= 0 ? Result.VALID : Result.INVALID);
    }

    public static String[] getPathTokens(String fieldPath) {
        String[] stringArray;
        if (fieldPath != null && fieldPath.contains(".")) {
            stringArray = fieldPath.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldPath;
        }
        return stringArray;
    }

    public static enum Result {
        VALID,
        INVALID,
        UNDEFINED;

    }
}

