/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.CssGridLayoutManagerBase;
import org.kuali.rice.krad.uif.layout.CssGridSizes;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="cssGridLabelColumnLayout", parent="Uif-CssGridLabelColumnLayout")
public class CssGridLabelColumnLayoutManager
extends CssGridLayoutManagerBase {
    private static final long serialVersionUID = 3100360397450755904L;
    private int numberOfLabelColumns = 1;
    private String labelColumnCssClass = "";
    private CssGridSizes labelColumnSizes = new CssGridSizes();
    private CssGridSizes fieldColumnSizes = new CssGridSizes();
    protected int xsCurrentFieldSize;
    protected int smCurrentFieldSize;
    protected int mdCurrentFieldSize;
    protected int lgCurrentFieldSize;

    @Override
    public void performFinalize(Object model, LifecycleElement component) {
        super.performFinalize(model, component);
        Container container = (Container)component;
        this.cellItems = new ArrayList();
        this.processSeparateLabelLayout(container);
    }

    private void processSeparateLabelLayout(Container container) {
        int labelColumnSize = 3;
        int fieldColumnSize = 9;
        if (this.numberOfLabelColumns > 1) {
            labelColumnSize = 12 / this.numberOfLabelColumns * 1 / 3;
            fieldColumnSize = 12 / this.numberOfLabelColumns * 2 / 3;
        }
        for (Component component : container.getItems()) {
            if (!(component instanceof Field)) {
                throw new RuntimeException("Must use fields  for CssGridLabelColumnLayouts. Item class: " + component.getClass().getName() + " in Container id: " + container.getId());
            }
            if (((Field)component).getFieldLabel() == null) {
                throw new RuntimeException("Label must exist on fields in CssGridLabelColumnLayoutManager. Item class: " + component.getClass().getName() + " in Container id: " + container.getId());
            }
            this.xsCurrentFieldSize = 0;
            this.smCurrentFieldSize = 0;
            this.mdCurrentFieldSize = 0;
            this.lgCurrentFieldSize = 0;
            Field field = (Field)component;
            Label label = this.separateLabel(field);
            List<String> cellCssClasses = label.getWrapperCssClasses();
            if (cellCssClasses == null) {
                label.setWrapperCssClasses(new ArrayList<String>());
                cellCssClasses = label.getWrapperCssClasses();
            }
            cellCssClasses.add(0, this.labelColumnCssClass);
            this.calculateCssClassAndSize(label, cellCssClasses, this.labelColumnSizes, labelColumnSize);
            this.addLeftClearCssClass(cellCssClasses);
            this.cellCssClassAttributes.add(this.getCellStyleClassesAsString(cellCssClasses));
            this.cellItems.add(label);
            cellCssClasses = field.getWrapperCssClasses();
            if (cellCssClasses == null) {
                field.setWrapperCssClasses(new ArrayList<String>());
                cellCssClasses = field.getWrapperCssClasses();
            }
            this.calculateCssClassAndSize(field, cellCssClasses, this.fieldColumnSizes, fieldColumnSize);
            if (this.xsCurrentFieldSize > 0 && this.xsCurrentFieldSize <= 12) {
                label.addStyleClass("xs-float-right");
            } else if (this.smCurrentFieldSize > 0 && this.smCurrentFieldSize <= 12) {
                label.addStyleClass("sm-float-right");
            } else if (this.mdCurrentFieldSize > 0 && this.mdCurrentFieldSize <= 12) {
                label.addStyleClass("md-float-right");
            } else if (this.lgCurrentFieldSize > 0 && this.lgCurrentFieldSize <= 12) {
                label.addStyleClass("lg-float-right");
            }
            this.addLeftClearCssClass(cellCssClasses);
            this.cellCssClassAttributes.add(this.getCellStyleClassesAsString(cellCssClasses));
            this.cellItems.add(field);
        }
    }

    @Override
    protected void calculateCssClassAndSize(Component item, List<String> cellCssClasses, CssGridSizes defaultSizes, int basicSize) {
        int xsPrevTotalSize = this.xsTotalSize;
        int smPrevTotalSize = this.smTotalSize;
        int mdPrevTotalSize = this.mdTotalSize;
        int lgPrevTotalSize = this.lgTotalSize;
        super.calculateCssClassAndSize(item, cellCssClasses, defaultSizes, basicSize);
        this.xsCurrentFieldSize += this.xsTotalSize - xsPrevTotalSize;
        this.smCurrentFieldSize += this.smTotalSize - smPrevTotalSize;
        this.mdCurrentFieldSize += this.mdTotalSize - mdPrevTotalSize;
        this.lgCurrentFieldSize += this.lgTotalSize - lgPrevTotalSize;
    }

    private Label separateLabel(Field field) {
        field.setLabelLeft(false);
        field.getFieldLabel().addStyleClass("displayWith-" + field.getId());
        if (!field.isRender() && StringUtils.isBlank((String)field.getProgressiveRender())) {
            field.getFieldLabel().setRender(false);
        } else if (!field.isRender() && StringUtils.isNotBlank((String)field.getProgressiveRender())) {
            field.getFieldLabel().setRender(true);
            String prefixStyle = "";
            if (StringUtils.isNotBlank((String)field.getFieldLabel().getStyle())) {
                prefixStyle = field.getFieldLabel().getStyle();
            }
            field.getFieldLabel().setStyle(prefixStyle + ";" + "display: none;");
        }
        Label label = field.getFieldLabel();
        if (field instanceof InputField && field.getRequired() != null && field.getRequired().booleanValue()) {
            label.setRenderRequiredIndicator(true);
        }
        field.setLabelRendered(true);
        return label;
    }

    @BeanTagAttribute
    public String getLabelColumnCssClass() {
        return this.labelColumnCssClass;
    }

    public void setLabelColumnCssClass(String labelColumnCssClass) {
        this.labelColumnCssClass = labelColumnCssClass;
    }

    @BeanTagAttribute
    public int getNumberOfLabelColumns() {
        return this.numberOfLabelColumns;
    }

    public void setNumberOfLabelColumns(int numberOfLabelColumns) {
        this.numberOfLabelColumns = numberOfLabelColumns;
    }

    @BeanTagAttribute(name="labelColumnSizes", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CssGridSizes getLabelColumnSizes() {
        return this.labelColumnSizes;
    }

    public void setLabelColumnSizes(CssGridSizes labelColumnSizes) {
        this.labelColumnSizes = labelColumnSizes;
    }

    @BeanTagAttribute(name="fieldColumnSizes", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CssGridSizes getFieldColumnSizes() {
        return this.fieldColumnSizes;
    }

    public void setFieldColumnSizes(CssGridSizes fieldColumnSizes) {
        this.fieldColumnSizes = fieldColumnSizes;
    }
}

