/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableControlContract;
import org.kuali.rice.core.api.uif.RemotableDatepicker;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableSelectGroup;
import org.kuali.rice.core.api.uif.RemotableTextExpand;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.lookup.LookupInputField;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.LinkGroup;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.container.TabGroup;
import org.kuali.rice.krad.uif.container.TabNavigationGroup;
import org.kuali.rice.krad.uif.container.TreeGroup;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.CheckboxGroupControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.FileControl;
import org.kuali.rice.krad.uif.control.GroupControl;
import org.kuali.rice.krad.uif.control.HiddenControl;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.control.SizedControl;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.control.UserControl;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Iframe;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.element.ValidationMessages;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.GenericField;
import org.kuali.rice.krad.uif.field.ImageField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.UrlInfo;
import org.kuali.rice.krad.uif.view.InquiryView;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.uif.widget.LightBox;
import org.kuali.rice.krad.uif.widget.QuickFinder;

public class ComponentFactory {
    private static Log LOG = LogFactory.getLog(ComponentFactory.class);
    public static final String TEXT_CONTROL = "Uif-TextControl";
    public static final String CHECKBOX_CONTROL = "Uif-CheckboxControl";
    public static final String HIDDEN_CONTROL = "Uif-HiddenControl";
    public static final String TEXTAREA_CONTROL = "Uif-TextAreaControl";
    public static final String SELECT_CONTROL = "Uif-DropdownControl";
    public static final String CHECKBOX_CONVERTED_RADIO_CONTROL = "Uif-CheckboxConvertedRadioControl";
    public static final String CHECKBOX_GROUP_CONTROL = "Uif-VerticalCheckboxesControl";
    public static final String CHECKBOX_GROUP_CONTROL_HORIZONTAL = "Uif-HorizontalCheckboxesControl";
    public static final String RADIO_GROUP_CONTROL = "Uif-VerticalRadioControl";
    public static final String RADIO_GROUP_CONTROL_HORIZONTAL = "Uif-HorizontalRadioControl";
    public static final String FILE_CONTROL = "Uif-FileControl";
    public static final String DATE_CONTROL = "Uif-DateControl";
    public static final String USER_CONTROL = "Uif-KimPersonControl";
    public static final String GROUP_CONTROL = "Uif-KimGroupControl";
    public static final String DATA_FIELD = "Uif-DataField";
    public static final String INPUT_FIELD = "Uif-InputField";
    public static final String LOOKUP_ACTIVE_INPUT_FIELD = "Uif-LookupActiveInputField";
    public static final String LOOKUP_INPUT_FIELD = "Uif-LookupCriteriaInputField";
    public static final String ERRORS_FIELD = "Uif-FieldValidationMessages";
    public static final String ACTION = "Uif-PrimaryActionButton";
    public static final String SECONDARY_ACTION = "Uif-SecondaryActionButton";
    public static final String ACTION_LINK = "Uif-ActionLink";
    public static final String LINK_FIELD = "Uif-LinkField";
    public static final String IFRAME = "Uif-Iframe";
    public static final String IMAGE_FIELD = "Uif-ImageField";
    public static final String SPACE_FIELD = "Uif-SpaceField";
    public static final String GENERIC_FIELD = "Uif-CustomTemplateField";
    public static final String IMAGE = "Uif-Image";
    public static final String LABEL = "Uif-Label";
    public static final String MESSAGE = "Uif-Message";
    public static final String MESSAGE_FIELD = "Uif-MessageField";
    public static final String COLLECTION_GROUPING_FIELD = "Uif-ColGroupingField";
    public static final String FIELD_GROUP = "Uif-VerticalFieldGroup";
    public static final String HORIZONTAL_FIELD_GROUP = "Uif-HorizontalFieldGroup";
    public static final String GROUP = "Uif-GroupBase";
    public static final String VERTICAL_BOX_GROUP = "Uif-VerticalBoxGroup";
    public static final String HORIZONTAL_BOX_GROUP = "Uif-HorizontalBoxGroup";
    public static final String VERTICAL_BOX_SECTION = "Uif-VerticalBoxSection";
    public static final String HORIZONTAL_BOX_SECTION = "Uif-HorizontalBoxSection";
    public static final String PAGE_GROUP = "Uif-Page";
    public static final String GROUP_GRID_LAYOUT = "Uif-GridSection";
    public static final String GROUP_WITH_DISCLOSURE_GRID_LAYOUT = "Uif-Disclosure-GridSection";
    public static final String GROUP_BODY_ONLY = "Uif-BoxGroupBase";
    public static final String GROUP_GRID_BODY_ONLY = "Uif-GridGroup";
    public static final String TAB_GROUP = "Uif-TabSection";
    public static final String NAVIGATION_GROUP = "Uif-NavigationGroupBase";
    public static final String TREE_GROUP = "Uif-TreeSection";
    public static final String LINK_GROUP = "Uif-LinkGroup";
    public static final String DIALOG_GROUP = "Uif-DialogGroup";
    public static final String COLLECTION_GROUP = "Uif-StackedCollectionSection";
    public static final String COLLECTION_WITH_DISCLOSURE_GROUP = "Uif-Disclosure-StackedCollectionSection";
    public static final String COLLECTION_GROUP_TABLE_LAYOUT = "Uif-TableCollectionSection";
    public static final String COLLECTION_WITH_DISCLOSURE_GROUP_TABLE_LAYOUT = "Uif-Disclosure-TableCollectionSection";
    public static final String LIST_GROUP = "Uif-ListCollectionSection";
    public static final String HEADER = "Uif-HeaderFieldBase";
    public static final String FOOTER = "Uif-FooterBase";
    public static final String FOOTER_SAVECLOSECANCEL = "Uif-FormPageFooter";
    public static final String CONSTRAINT_MESSAGE = "Uif-ConstraintMessage";
    public static final String INSTRUCTIONAL_MESSAGE = "Uif-InstructionalMessage";
    public static final String HELP_ACTION = "Uif-HelpAction";
    public static final String IMAGE_CAPTION_HEADER = "Uif-ImageCaptionHeader";
    public static final String IMAGE_CUTLINE_MESSAGE = "Uif-ImageCutineMessage";
    public static final String LIGHTBOX = "Uif-LightBox";
    public static final String QUICKFINDER = "Uif-QuickFinder";
    public static final String INQUIRY = "Uif-Inquiry";
    public static final String ADD_BLANK_LINE_ACTION = "Uif-AddBlankLineAction";
    public static final String ADD_WITH_DIALOG_ACTION = "Uif-AddWithDialogAction";
    public static final String ADD_LINE_DIALOG = "Uif-AddLineDialog";
    public static final String DIALOG_DISMISS_ACTION = "Uif-DialogDismissButton";
    public static final String EDIT_LINE_DIALOG = "Uif-EditLineDialog";
    public static final String EDIT_LINE_IN_DIALOG_ACTION = "Uif-EditLineInDialogAction";
    public static final String EDIT_LINE_IN_DIALOG_SAVE_ACTION = "Uif-EditLineInDialogSaveAction";
    public static final String SESSION_TIMEOUT_WARNING_DIALOG = "Uif-SessionTimeoutWarning-DialogGroup";
    public static final String SESSION_TIMEOUT_DIALOG = "Uif-SessionTimeout-DialogGroup";
    public static final String YES_NO_DIALOG = "Uif-DialogGroup-YesNo";
    public static final String INQUIRY_VIEW = "Uif-InquiryView";
    public static final String LOOKUP_VIEW = "Uif-LookupView";
    public static final String LOOKUP_CRITERIA_FIELD = "Uif-LookupCriteriaInputField";
    public static final String LOOKUP_CRITERIA_ACTIVE_INDICATOR_FIELD = "Uif-LookupActiveInputField";
    public static final String URL_INFO = "Uif-Url";
    private static Map<String, Component> cache = new HashMap<String, Component>();

    public static Component getNewInstanceForRefresh(ViewPostMetadata viewPostMetadata, String id) {
        String baseId = (String)viewPostMetadata.getComponentPostMetadata(id).getData("BASE_ID");
        if (baseId == null) {
            throw new RuntimeException("Cannot create new instance for refresh. Base id not found for component id: " + id);
        }
        Component component = (Component)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean(baseId);
        if (component != null) {
            component = ComponentUtils.copy(component);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getNewComponentInstance(String beanId) {
        Component component;
        if (cache.containsKey(beanId)) {
            component = cache.get(beanId);
        } else {
            component = (Component)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean(beanId);
            component.setId(null);
            ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(component, true);
            Map<String, Component> map = cache;
            synchronized (map) {
                cache.put(beanId, component);
            }
        }
        component = ComponentUtils.copy(component);
        return component;
    }

    public static TextControl getTextControl() {
        return (TextControl)ComponentFactory.getNewComponentInstance(TEXT_CONTROL);
    }

    public static TextAreaControl getTextAreaControl() {
        return (TextAreaControl)ComponentFactory.getNewComponentInstance(TEXTAREA_CONTROL);
    }

    public static CheckboxControl getCheckboxControl() {
        return (CheckboxControl)ComponentFactory.getNewComponentInstance(CHECKBOX_CONTROL);
    }

    public static HiddenControl getHiddenControl() {
        return (HiddenControl)ComponentFactory.getNewComponentInstance(HIDDEN_CONTROL);
    }

    public static SelectControl getSelectControl() {
        return (SelectControl)ComponentFactory.getNewComponentInstance(SELECT_CONTROL);
    }

    public static CheckboxGroupControl getCheckboxGroupControl() {
        return (CheckboxGroupControl)ComponentFactory.getNewComponentInstance(CHECKBOX_GROUP_CONTROL);
    }

    public static CheckboxGroupControl getCheckboxGroupControlHorizontal() {
        return (CheckboxGroupControl)ComponentFactory.getNewComponentInstance(CHECKBOX_GROUP_CONTROL_HORIZONTAL);
    }

    public static RadioGroupControl getRadioGroupControl() {
        return (RadioGroupControl)ComponentFactory.getNewComponentInstance(RADIO_GROUP_CONTROL);
    }

    public static RadioGroupControl getRadioGroupControlHorizontal() {
        return (RadioGroupControl)ComponentFactory.getNewComponentInstance(RADIO_GROUP_CONTROL_HORIZONTAL);
    }

    public static FileControl getFileControl() {
        return (FileControl)ComponentFactory.getNewComponentInstance(FILE_CONTROL);
    }

    public static TextControl getDateControl() {
        return (TextControl)ComponentFactory.getNewComponentInstance(DATE_CONTROL);
    }

    public static UserControl getUserControl() {
        return (UserControl)ComponentFactory.getNewComponentInstance(USER_CONTROL);
    }

    public static GroupControl getGroupControl() {
        return (GroupControl)ComponentFactory.getNewComponentInstance(GROUP_CONTROL);
    }

    public static DataField getDataField() {
        return (DataField)ComponentFactory.getNewComponentInstance(DATA_FIELD);
    }

    public static DataField getDataField(String propertyName, String label) {
        DataField field = (DataField)ComponentFactory.getNewComponentInstance(DATA_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        return field;
    }

    public static InputField getInputField() {
        return (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
    }

    public static InputField getInputField(String propertyName, String label) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        field.setControl(ComponentFactory.getControl(controlType));
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, String defaultValue) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        field.setControl(ComponentFactory.getControl(controlType));
        field.setDefaultValue(defaultValue);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, Class<? extends KeyValuesFinder> optionsFinderClass) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        field.setControl(ComponentFactory.getControl(controlType));
        field.setOptionsFinderClass(optionsFinderClass);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, List<KeyValue> options) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        Control control = ComponentFactory.getControl(controlType);
        if (!(control instanceof MultiValueControl)) {
            throw new RuntimeException("Control is not instance of multi-value control, cannot set options");
        }
        ((MultiValueControl)((Object)control)).setOptions(options);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, int size, int maxLength, int minLength) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        Control control = ComponentFactory.getControl(controlType);
        if (!(control instanceof SizedControl)) {
            throw new RuntimeException("Control does not support the size property");
        }
        ((SizedControl)((Object)control)).setSize(size);
        field.setMaxLength(maxLength);
        field.setMinLength(minLength);
        return field;
    }

    public static InputField translateRemotableField(RemotableAttributeField remotableField) {
        InputField inputField = ComponentFactory.getInputField();
        inputField.setPropertyName(remotableField.getName());
        inputField.setShortLabel(remotableField.getShortLabel());
        inputField.setLabel(remotableField.getLongLabel());
        inputField.setConstraintText(remotableField.getConstraintText());
        inputField.setUppercaseValue(remotableField.isForceUpperCase());
        inputField.setMinLength(remotableField.getMinLength());
        inputField.setMaxLength(remotableField.getMaxLength());
        if (remotableField.getMinValue() != null) {
            inputField.setExclusiveMin(remotableField.getMinValue().toString());
        }
        if (remotableField.getMaxValue() != null) {
            inputField.setInclusiveMax(remotableField.getMaxValue().toString());
        }
        inputField.setRequired(remotableField.isRequired());
        if (remotableField.getDefaultValues() != null && !remotableField.getDefaultValues().isEmpty()) {
            inputField.setDefaultValue(remotableField.getDefaultValues().iterator().next());
        }
        if (StringUtils.isNotBlank((String)remotableField.getRegexConstraint())) {
            ValidCharactersConstraint constraint = new ValidCharactersConstraint();
            constraint.setValue(remotableField.getRegexConstraint());
            inputField.setValidCharactersConstraint(constraint);
        }
        RemotableDatepicker remotableDatepicker = null;
        RemotableTextExpand remotableTextExpand = null;
        RemotableQuickFinder remotableQuickFinder = null;
        for (RemotableAbstractWidget remoteWidget : remotableField.getWidgets()) {
            if (remoteWidget instanceof RemotableDatepicker) {
                remotableDatepicker = (RemotableDatepicker)remoteWidget;
                continue;
            }
            if (remoteWidget instanceof RemotableTextExpand) {
                remotableTextExpand = (RemotableTextExpand)remoteWidget;
                continue;
            }
            if (!(remoteWidget instanceof RemotableQuickFinder)) continue;
            remotableQuickFinder = (RemotableQuickFinder)remoteWidget;
        }
        if (remotableQuickFinder != null) {
            if (inputField.getQuickfinder() == null) {
                inputField.setQuickfinder(ComponentFactory.getQuickFinder());
            }
            inputField.getQuickfinder().setBaseLookupUrl(remotableQuickFinder.getBaseLookupUrl());
            inputField.getQuickfinder().setDataObjectClassName(remotableQuickFinder.getDataObjectClass());
            inputField.getQuickfinder().setLookupParameters(remotableQuickFinder.getLookupParameters());
            inputField.getQuickfinder().setFieldConversions(remotableQuickFinder.getFieldConversions());
        }
        if (remotableField.getControl() != null) {
            Control control = null;
            RemotableControlContract remotableControl = remotableField.getControl();
            if (remotableControl instanceof RemotableHiddenInput) {
                control = ComponentFactory.getHiddenControl();
            } else if (remotableControl instanceof RemotableRadioButtonGroup) {
                RemotableRadioButtonGroup remotableRadioButtonGroup = (RemotableRadioButtonGroup)remotableControl;
                control = ComponentFactory.getRadioGroupControl();
                ((RadioGroupControl)control).setOptions(ComponentFactory.buildKeyValuePairs(remotableRadioButtonGroup.getKeyLabels()));
            } else if (remotableControl instanceof RemotableSelect) {
                RemotableSelect remotableSelect = (RemotableSelect)remotableControl;
                control = ComponentFactory.getSelectControl();
                HashMap<String, String> keyLabels = new HashMap();
                if (remotableSelect.getGroups() != null && !remotableSelect.getGroups().isEmpty()) {
                    for (RemotableSelectGroup remotableSelectGroup : remotableSelect.getGroups()) {
                        keyLabels.putAll(remotableSelectGroup.getKeyLabels());
                    }
                } else {
                    keyLabels = remotableSelect.getKeyLabels();
                }
                ((SelectControl)control).setOptions(ComponentFactory.buildKeyValuePairs(keyLabels));
                if (remotableSelect.getSize() != null) {
                    ((SelectControl)control).setSize(remotableSelect.getSize());
                }
                ((SelectControl)control).setMultiple(remotableSelect.isMultiple());
            } else if (remotableControl instanceof RemotableCheckboxGroup) {
                RemotableCheckboxGroup remotableCheckboxGroup = (RemotableCheckboxGroup)remotableControl;
                control = ComponentFactory.getCheckboxGroupControl();
                ((CheckboxGroupControl)control).setOptions(ComponentFactory.buildKeyValuePairs(remotableCheckboxGroup.getKeyLabels()));
            } else if (remotableControl instanceof RemotableCheckbox) {
                control = ComponentFactory.getCheckboxControl();
            } else if (remotableControl instanceof RemotableTextarea) {
                RemotableTextarea remotableTextarea = (RemotableTextarea)remotableControl;
                control = ComponentFactory.getTextAreaControl();
                if (remotableTextExpand != null) {
                    ((TextAreaControl)control).setTextExpand(true);
                }
                ((TextAreaControl)control).setRows(remotableTextarea.getRows());
                ((TextAreaControl)control).setCols(remotableTextarea.getCols());
                ((TextAreaControl)control).setWatermarkText(remotableTextarea.getWatermark());
            } else if (remotableControl instanceof RemotableTextInput) {
                RemotableTextInput remotableTextInput = (RemotableTextInput)remotableControl;
                control = remotableDatepicker != null ? ComponentFactory.getDateControl() : ComponentFactory.getTextControl();
                if (remotableTextExpand != null) {
                    ((TextAreaControl)control).setTextExpand(true);
                }
                ((TextControl)control).setSize(remotableTextInput.getSize());
                ((TextControl)control).setWatermarkText(remotableTextInput.getWatermark());
            }
            inputField.setControl(control);
        }
        return inputField;
    }

    public static List<InputField> translateRemotableFields(List<RemotableAttributeField> remotableFields) {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (RemotableAttributeField remotableField : remotableFields) {
            inputFields.add(ComponentFactory.translateRemotableField(remotableField));
        }
        return inputFields;
    }

    protected static List<KeyValue> buildKeyValuePairs(Map<String, String> optionsMap) {
        ArrayList<KeyValue> options = new ArrayList<KeyValue>();
        for (Map.Entry<String, String> optionEntry : optionsMap.entrySet()) {
            ConcreteKeyValue keyValue = new ConcreteKeyValue(optionEntry.getKey(), optionEntry.getValue());
            options.add((KeyValue)keyValue);
        }
        return options;
    }

    protected static Control getControl(UifConstants.ControlType controlType) {
        Control control = null;
        switch (controlType) {
            case CHECKBOX: {
                control = ComponentFactory.getCheckboxControl();
                break;
            }
            case CHECKBOXGROUP: {
                control = ComponentFactory.getCheckboxGroupControl();
                break;
            }
            case FILE: {
                control = ComponentFactory.getFileControl();
                break;
            }
            case GROUP: {
                control = ComponentFactory.getGroupControl();
                break;
            }
            case HIDDEN: {
                control = ComponentFactory.getHiddenControl();
                break;
            }
            case RADIOGROUP: {
                control = ComponentFactory.getRadioGroupControl();
                break;
            }
            case SELECT: {
                control = ComponentFactory.getSelectControl();
                break;
            }
            case TEXTAREA: {
                control = ComponentFactory.getTextAreaControl();
                break;
            }
            case TEXT: {
                control = ComponentFactory.getTextControl();
                break;
            }
            case USER: {
                control = ComponentFactory.getUserControl();
            }
        }
        return control;
    }

    public static ValidationMessages getErrorsField() {
        return (ValidationMessages)((Object)ComponentFactory.getNewComponentInstance(ERRORS_FIELD));
    }

    public static Action getAction() {
        return (Action)ComponentFactory.getNewComponentInstance(ACTION);
    }

    public static Action getSecondaryAction() {
        return (Action)ComponentFactory.getNewComponentInstance(SECONDARY_ACTION);
    }

    public static Action getActionLink() {
        return (Action)ComponentFactory.getNewComponentInstance(ACTION_LINK);
    }

    public static LinkField getLinkField() {
        return (LinkField)ComponentFactory.getNewComponentInstance(LINK_FIELD);
    }

    public static Iframe getIframe() {
        return (Iframe)ComponentFactory.getNewComponentInstance(IFRAME);
    }

    public static ImageField getImageField() {
        return (ImageField)ComponentFactory.getNewComponentInstance(IMAGE_FIELD);
    }

    public static Image getImage() {
        return (Image)ComponentFactory.getNewComponentInstance(IMAGE);
    }

    public static SpaceField getSpaceField() {
        return (SpaceField)ComponentFactory.getNewComponentInstance(SPACE_FIELD);
    }

    public static GenericField getGenericField() {
        return (GenericField)ComponentFactory.getNewComponentInstance(GENERIC_FIELD);
    }

    public static Label getLabel() {
        return (Label)ComponentFactory.getNewComponentInstance(LABEL);
    }

    public static Message getMessage() {
        return (Message)ComponentFactory.getNewComponentInstance(MESSAGE);
    }

    public static MessageField getMessageField() {
        return (MessageField)ComponentFactory.getNewComponentInstance(MESSAGE_FIELD);
    }

    public static MessageField getColGroupingField() {
        return (MessageField)ComponentFactory.getNewComponentInstance(COLLECTION_GROUPING_FIELD);
    }

    public static FieldGroup getFieldGroup() {
        return (FieldGroup)ComponentFactory.getNewComponentInstance(FIELD_GROUP);
    }

    public static FieldGroup getHorizontalFieldGroup() {
        return (FieldGroup)ComponentFactory.getNewComponentInstance(HORIZONTAL_FIELD_GROUP);
    }

    public static Group getGroup() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP);
    }

    public static Group getVerticalBoxGroup() {
        return (Group)ComponentFactory.getNewComponentInstance(VERTICAL_BOX_GROUP);
    }

    public static Group getHorizontalBoxGroup() {
        return (Group)ComponentFactory.getNewComponentInstance(HORIZONTAL_BOX_GROUP);
    }

    public static Group getVerticalBoxSection() {
        return (Group)ComponentFactory.getNewComponentInstance(VERTICAL_BOX_SECTION);
    }

    public static Group getHorizontalBoxSection() {
        return (Group)ComponentFactory.getNewComponentInstance(HORIZONTAL_BOX_SECTION);
    }

    public static PageGroup getPageGroup() {
        return (PageGroup)ComponentFactory.getNewComponentInstance(PAGE_GROUP);
    }

    public static Group getGroupGridLayout() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP_GRID_LAYOUT);
    }

    public static Group getGroupWithDisclosureGridLayout() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP_WITH_DISCLOSURE_GRID_LAYOUT);
    }

    public static Group getGroupBodyOnly() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP_BODY_ONLY);
    }

    public static Group getGroupGridBodyOnly() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP_GRID_BODY_ONLY);
    }

    public static TabGroup getTabGroup() {
        return (TabGroup)ComponentFactory.getNewComponentInstance(TAB_GROUP);
    }

    public static TabNavigationGroup getNavigationGroup() {
        return (TabNavigationGroup)ComponentFactory.getNewComponentInstance(NAVIGATION_GROUP);
    }

    public static TreeGroup getTreeGroup() {
        return (TreeGroup)ComponentFactory.getNewComponentInstance(TREE_GROUP);
    }

    public static LinkGroup getLinkGroup() {
        return (LinkGroup)ComponentFactory.getNewComponentInstance(LINK_GROUP);
    }

    public static CollectionGroup getCollectionGroup() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(COLLECTION_GROUP);
    }

    public static CollectionGroup getCollectionWithDisclosureGroup() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(COLLECTION_WITH_DISCLOSURE_GROUP);
    }

    public static CollectionGroup getCollectionGroupTableLayout() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(COLLECTION_GROUP_TABLE_LAYOUT);
    }

    public static CollectionGroup getCollectionWithDisclosureGroupTableLayout() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(COLLECTION_WITH_DISCLOSURE_GROUP_TABLE_LAYOUT);
    }

    public static CollectionGroup getListGroup() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(LIST_GROUP);
    }

    public static Header getHeader() {
        return (Header)ComponentFactory.getNewComponentInstance(HEADER);
    }

    public static Group getFooter() {
        return (Group)ComponentFactory.getNewComponentInstance(FOOTER);
    }

    public static Group getFooterSaveCloseCancel() {
        return (Group)ComponentFactory.getNewComponentInstance(FOOTER_SAVECLOSECANCEL);
    }

    public static Action getHelpAction() {
        return (Action)ComponentFactory.getNewComponentInstance(HELP_ACTION);
    }

    public static Message getConstraintMessage() {
        return (Message)ComponentFactory.getNewComponentInstance(CONSTRAINT_MESSAGE);
    }

    public static Message getInstructionalMessage() {
        return (Message)ComponentFactory.getNewComponentInstance(INSTRUCTIONAL_MESSAGE);
    }

    public static Header getImageCaptionHeader() {
        return (Header)ComponentFactory.getNewComponentInstance(IMAGE_CAPTION_HEADER);
    }

    public static Message getImageCutlineMessage() {
        return (Message)ComponentFactory.getNewComponentInstance(IMAGE_CUTLINE_MESSAGE);
    }

    public static LightBox getLightBox() {
        return (LightBox)ComponentFactory.getNewComponentInstance(LIGHTBOX);
    }

    public static QuickFinder getQuickFinder() {
        return (QuickFinder)ComponentFactory.getNewComponentInstance(QUICKFINDER);
    }

    public static Inquiry getInquiry() {
        return (Inquiry)ComponentFactory.getNewComponentInstance(INQUIRY);
    }

    public static DialogGroup getSessionTimeoutWarningDialog() {
        return (DialogGroup)ComponentFactory.getNewComponentInstance(SESSION_TIMEOUT_WARNING_DIALOG);
    }

    public static DialogGroup getSessionTimeoutDialog() {
        return (DialogGroup)ComponentFactory.getNewComponentInstance(SESSION_TIMEOUT_DIALOG);
    }

    public static DialogGroup getYesNoDialog() {
        return (DialogGroup)ComponentFactory.getNewComponentInstance(YES_NO_DIALOG);
    }

    public static UrlInfo getUrlInfo() {
        return (UrlInfo)((Object)ComponentFactory.getNewComponentInstance(URL_INFO));
    }

    public static InquiryView getInquiryView() {
        return (InquiryView)ComponentFactory.getNewComponentInstance(INQUIRY_VIEW);
    }

    public static LookupView getLookupView() {
        return (LookupView)ComponentFactory.getNewComponentInstance(LOOKUP_VIEW);
    }

    public static LookupInputField getLookupCriteriaInputField() {
        return (LookupInputField)ComponentFactory.getNewComponentInstance("Uif-LookupCriteriaInputField");
    }

    public static LookupInputField getLookupCriteriaActiveIndicatorInputField() {
        return (LookupInputField)ComponentFactory.getNewComponentInstance("Uif-LookupActiveInputField");
    }
}

