/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;

public final class KrmsTypeGenTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<KRMSType xmlns=\"http://rice.kuali.org/krms/v2_0\">\n    <id>ID</id>\n    <name>NAME</name>\n    <namespace>NAMESPACE</namespace>\n    <serviceName></serviceName>\n    <active>true</active>\n</KRMSType>";
    private static final String NAME = "NAME";
    private static final String NAMESPACE = "NAMESPACE";
    private static final String SERVICE_NAME = "SERVICE_NAME";
    private static final String ID = "ID";
    private static final boolean ACTIVE = false;
    private static final Long VERSION_NUMBER = 0L;

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_Builder_create_fail_all_null() {
        KrmsTypeDefinition.Builder.create(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_name_fail_null() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_name_fail_empty() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setName("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_name_fail_whitespace() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setName("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_namespace_fail_null() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setNamespace(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_namespace_fail_empty() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setNamespace("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_namespace_fail_whitespace() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setNamespace("    ");
    }

    @Test
    public void test_KrmsTypeDefinition_set_validation_id_success_null() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_id_fail_empty() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_KrmsTypeDefinition_set_validation_id_fail_whitespace() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId("    ");
    }

    @Test
    public void test_KrmsTypeDefinition_Builder_create() {
        KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
    }

    @Test
    public void test_KrmsTypeDefinition_Builder_create_and_build() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.build();
    }

    @Test
    public void test_KrmsTypeDefinition_xml_marshaling() throws Exception {
        KrmsTypeDefinition krmsTypeDefinition = KrmsTypeGenTest.buildFullKrmsTypeDefinition();
        this.assertXmlMarshaling(krmsTypeDefinition, XML);
    }

    public void assertXmlMarshaling(Object krmsTypeDefinition, String expectedXml) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{KrmsTypeDefinition.class});
        Marshaller marshaller = jc.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(krmsTypeDefinition, (Writer)stringWriter);
        String xml = stringWriter.toString();
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object actual = unmarshaller.unmarshal((Reader)new StringReader(xml));
        Object expected = unmarshaller.unmarshal((Reader)new StringReader(expectedXml));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static KrmsTypeDefinition buildFullKrmsType() {
        return KrmsTypeGenTest.buildFullKrmsTypeDefinition();
    }

    public static KrmsTypeDefinition buildFullKrmsTypeDefinition() {
        KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId(ID);
        KrmsTypeDefinition krmsTypeDefinition = builder.build();
        return krmsTypeDefinition;
    }
}

